
DROP TABLE IF EXISTS `#__action_logs`;
CREATE TABLE IF NOT EXISTS `#__action_logs` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `ip_address` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__action_logs_extensions`;
CREATE TABLE IF NOT EXISTS `#__action_logs_extensions` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO `#__action_logs_extensions` (`id`, `extension`) VALUES
(1, 'com_banners'),
(2, 'com_cache'),
(3, 'com_categories'),
(4, 'com_config'),
(5, 'com_contact'),
(6, 'com_content'),
(7, 'com_installer'),
(8, 'com_media'),
(9, 'com_menus'),
(10, 'com_messages'),
(11, 'com_modules'),
(12, 'com_newsfeeds'),
(13, 'com_plugins'),
(14, 'com_redirect'),
(15, 'com_tags'),
(16, 'com_templates'),
(17, 'com_users'),
(18, 'com_checkin');

DROP TABLE IF EXISTS `#__action_logs_users`;
CREATE TABLE IF NOT EXISTS `#__action_logs_users` (
  `user_id` int(11) UNSIGNED NOT NULL,
  `notify` tinyint(1) UNSIGNED NOT NULL,
  `extensions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__action_log_config`;
CREATE TABLE IF NOT EXISTS `#__action_log_config` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

INSERT INTO `#__action_log_config` (`id`, `type_title`, `type_alias`, `id_holder`, `title_holder`, `table_name`, `text_prefix`) VALUES
(1, 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(2, 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(3, 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
(4, 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
(5, 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(6, 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
(7, 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
(8, 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
(9, 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
(10, 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
(11, 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
(12, 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
(13, 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
(14, 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(15, 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
(16, 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
(17, 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
(18, 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
(19, 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA');

DROP TABLE IF EXISTS `#__acym_action`;
CREATE TABLE IF NOT EXISTS `#__acym_action` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `condition_id` int(11) NOT NULL,
  `actions` longtext,
  `filters` longtext,
  `order` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_#__acym_action1` (`condition_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_automation`;
CREATE TABLE IF NOT EXISTS `#__acym_automation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` longtext,
  `active` tinyint(3) NOT NULL,
  `report` text,
  `tree` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_campaign`;
CREATE TABLE IF NOT EXISTS `#__acym_campaign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sending_date` datetime DEFAULT NULL,
  `draft` tinyint(1) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `mail_id` int(11) DEFAULT NULL,
  `scheduled` tinyint(1) NOT NULL DEFAULT '0',
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_#__acym_campaign_has_mail1` (`mail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_condition`;
CREATE TABLE IF NOT EXISTS `#__acym_condition` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `step_id` int(11) NOT NULL,
  `conditions` longtext,
  PRIMARY KEY (`id`),
  KEY `fk_#__acym_condition1` (`step_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_configuration`;
CREATE TABLE IF NOT EXISTS `#__acym_configuration` (
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acym_configuration` (`name`, `value`) VALUES
('add_names', '1'),
('allowed_files', 'zip,doc,docx,pdf,xls,txt,gzip,rar,jpg,jpeg,gif,xlsx,pps,csv,bmp,ico,odg,odp,ods,odt,png,ppt,swf,xcf,mp3,wma'),
('allow_modif', 'data'),
('allow_visitor', '1'),
('anonymizeold', '0'),
('anonymous_tracking', '0'),
('bounceVersion', '1'),
('bounce_action_lists_maxtry', '1'),
('bounce_email', ''),
('charset', 'UTF-8'),
('confirmation_message', '1'),
('confirm_redirect', ''),
('cron_frequency', '900'),
('cron_fromip', ''),
('cron_fullreport', '1'),
('cron_last', '0'),
('cron_next', '1251990901'),
('cron_report', ''),
('cron_savepath', 'media/com_acym/logs/report{year}_{month}.log'),
('cron_savereport', '2'),
('cron_sendreport', '2'),
('cron_sendto', ''),
('css_backend', ''),
('css_frontend', 'default'),
('daily_hour', '12'),
('daily_minute', '00'),
('editor', 'codemirror'),
('elasticemail_password', ''),
('elasticemail_port', 'rest'),
('elasticemail_username', ''),
('email_checkdomain', '0'),
('embed_files', '1'),
('embed_images', '0'),
('encoding_format', '8bit'),
('Enterprise', '2'),
('Essential', '1'),
('expirationdate', '0'),
('export_excelsecurity', '1'),
('forward', '0'),
('from_as_replyto', '1'),
('from_email', ''),
('from_name', ''),
('gdpr_delete', '0'),
('gdpr_export', '0'),
('generate_name', '1'),
('hostname', ''),
('installcomplete', '1'),
('introjs', '[]'),
('lastlicensecheck', '1552688916'),
('last_import', ''),
('latestversion', '6.1.2'),
('level', 'Starter'),
('mailer_method', 'phpmail'),
('max_execution_time', '0'),
('migration', '1'),
('multiple_part', '1'),
('notification_accept', ''),
('notification_confirm', ''),
('notification_created', ''),
('notification_refuse', ''),
('notification_unsuball', ''),
('numberThumbnail', '2'),
('priority_followup', '2'),
('priority_newsletter', '3'),
('queue_nbmail', '40'),
('queue_nbmail_auto', '70'),
('queue_pause', '120'),
('queue_try', '3'),
('queue_type', 'automan'),
('replyto_email', ''),
('replyto_name', ''),
('require_confirmation', '0'),
('security_key', 'voth8haPdrFH5aXVAOplnBeInHGbyC'),
('sending_platform', 'server'),
('sendmail_path', '/usr/sbin/sendmail'),
('sendorder', 'subid, ASC'),
('smtp_auth', '0'),
('smtp_host', 'localhost'),
('smtp_keepalive', '1'),
('smtp_password', ''),
('smtp_port', '25'),
('smtp_secured', ''),
('smtp_username', ''),
('special_chars', '0'),
('Starter', '0'),
('subscription_message', '1'),
('templates_installed', '1'),
('trackingsystem', 'acymailing'),
('trackingsystemexternalwebsite', '1'),
('unsub_message', '1'),
('unsub_reasons', 'a:2:{i:0;s:21:\"UNSUB_SURVEY_FREQUENT\";i:1;s:21:\"UNSUB_SURVEY_RELEVANT\";}'),
('unsub_redirect', ''),
('uploadfolder', 'media/com_acym/upload'),
('use_https', '0'),
('use_sef', '0'),
('version', '6.1.2'),
('walk_through', '0'),
('website', 'http://joomla/flex_3.6_with-vm/'),
('welcome_message', '1'),
('word_wrapping', '150');

DROP TABLE IF EXISTS `#__acym_field`;
CREATE TABLE IF NOT EXISTS `#__acym_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `value` longtext,
  `active` tinyint(3) NOT NULL,
  `default_value` longtext,
  `required` tinyint(3) DEFAULT NULL,
  `ordering` int(11) NOT NULL,
  `option` longtext,
  `core` tinyint(3) DEFAULT NULL,
  `backend_profile` tinyint(3) DEFAULT NULL,
  `backend_listing` tinyint(3) DEFAULT NULL,
  `backend_filter` tinyint(3) DEFAULT NULL,
  `frontend_form` tinyint(3) DEFAULT NULL,
  `frontend_profile` tinyint(3) DEFAULT NULL,
  `frontend_listing` tinyint(3) DEFAULT NULL,
  `frontend_filter` tinyint(3) DEFAULT NULL,
  `access` varchar(255) DEFAULT NULL,
  `namekey` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `#__acym_field` (`id`, `name`, `type`, `value`, `active`, `default_value`, `required`, `ordering`, `option`, `core`, `backend_profile`, `backend_listing`, `backend_filter`, `frontend_form`, `frontend_profile`, `frontend_listing`, `frontend_filter`, `access`, `namekey`) VALUES
(1, 'ACYM_NAME', 'text', NULL, 1, NULL, 0, 1, '{\"editable_user_creation\":\"1\",\"editable_user_modification\":\"1\",\"error_message\":\"\",\"error_message_invalid\":\"\",\"size\":\"\",\"rows\":\"\",\"columns\":\"\",\"format\":\"\",\"custom_text\":\"\",\"css_class\":\"\",\"authorized_content\":{\"0\":\"all\",\"regex\":\"\"}}', 1, 1, 1, 0, 1, 1, 1, 0, 'all', ''),
(2, 'ACYM_EMAIL', 'text', NULL, 1, NULL, 1, 2, '{\"editable_user_creation\":\"1\",\"editable_user_modification\":\"1\",\"error_message\":\"\",\"error_message_invalid\":\"\",\"size\":\"\",\"rows\":\"\",\"columns\":\"\",\"format\":\"\",\"custom_text\":\"\",\"css_class\":\"\",\"authorized_content\":{\"0\":\"all\",\"regex\":\"\"}}', 1, 1, 1, 0, 1, 1, 1, 0, 'all', '');

DROP TABLE IF EXISTS `#__acym_history`;
CREATE TABLE IF NOT EXISTS `#__acym_history` (
  `user_id` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `ip` varchar(16) DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `data` text,
  `source` text,
  `mail_id` mediumint(9) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_list`;
CREATE TABLE IF NOT EXISTS `#__acym_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `clean` tinyint(1) DEFAULT NULL,
  `color` varchar(30) DEFAULT NULL,
  `creation_date` datetime DEFAULT NULL,
  `welcome_id` int(11) DEFAULT NULL,
  `unsubscribe_id` int(11) DEFAULT NULL,
  `cms_user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_#__acym_list_has_mail1` (`welcome_id`),
  KEY `fk_#__acym_list_has_mail2` (`unsubscribe_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `#__acym_list` (`id`, `name`, `active`, `visible`, `clean`, `color`, `creation_date`, `welcome_id`, `unsubscribe_id`, `cms_user_id`) VALUES
(1, 'Newsletters', 1, 1, 0, '#3366ff', '2019-03-15 22:35:43', NULL, NULL, 537);

DROP TABLE IF EXISTS `#__acym_mail`;
CREATE TABLE IF NOT EXISTS `#__acym_mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `creation_date` datetime NOT NULL,
  `thumbnail` longtext,
  `drag_editor` tinyint(1) DEFAULT NULL,
  `library` tinyint(1) DEFAULT NULL,
  `type` varchar(200) NOT NULL,
  `body` longtext NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `template` tinyint(1) NOT NULL,
  `from_name` varchar(255) DEFAULT NULL,
  `from_email` varchar(255) DEFAULT NULL,
  `reply_to_name` varchar(255) DEFAULT NULL,
  `reply_to_email` varchar(255) DEFAULT NULL,
  `bcc` varchar(255) DEFAULT NULL,
  `settings` text,
  `stylesheet` text,
  `attachments` text,
  `creator_id` int(11) NOT NULL,
  `media_folder` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `#__acym_mail` (`id`, `name`, `creation_date`, `thumbnail`, `drag_editor`, `library`, `type`, `body`, `subject`, `template`, `from_name`, `from_email`, `reply_to_name`, `reply_to_email`, `bcc`, `settings`, `stylesheet`, `attachments`, `creator_id`, `media_folder`) VALUES
(3, 'Notification template', '2019-03-15 22:35:44', NULL, 0, 0, 'standard', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\" style=\"text-align:center\">{readonline}This email contains graphics, so if you don\'t see them, view it in your browser{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width:600px\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\"><img alt=\" - - - \" src=\"media/com_acymailing/templates/newsletter-4/images/top.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"acyeditor_text w520\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: rgb(235, 235, 235);\" width=\"520\"><img alt=\"-\" src=\"media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float:left; margin-right:10px;\" />\r\n				<h3>Topic of your message</h3>\r\n\r\n				<h4>Subtitle for your message</h4>\r\n			</td>\r\n			<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"acyeditor_text w480 pict\" style=\"background-color:#fff; text-align: left;\" width=\"480\">\r\n			<h1>Dear {subtag:name},</h1>\r\n			Your message here...<br />\r\n			</td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color:#ebebeb;\" width=\"600\"><img alt=\" - - - \" src=\"media/com_acymailing/templates/newsletter-4/images/bottom.png\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acyeditor_delete acyeditor_text\" style=\"text-align:center\">Not interested any more? {unsubscribe}Unsubscribe{/unsubscribe}</div>\r\n</div>', '', 1, '', '', '', '', NULL, NULL, 'div,table,p, td{font-family: Verdana, Arial, Helvetica, sans-serif; font-size:12px; text-align:justify; color:#8c8c8c; margin:0px}\r\ndiv.info{text-align:center;padding:10px;font-size:11px;color:#a3a3a3;}\r\n\r\n@media (min-width:10px){\r\n	.w600 { width: 320px !important;}\r\n	.w520 { width: 280px !important;}\r\n	.w480 { width: 260px !important;}\r\n	.w40 { width: 20px !important;}\r\n	.w20 { width: 10px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w480 img {max-width:260px; height:auto !important;}\r\n}\r\n\r\n@media (min-width:480px) {\r\n	.w600 { width: 480px !important;}\r\n	.w520 { width: 440px !important;}\r\n	.w480 { width: 420px !important;}\r\n	.w40 { width: 20px !important;}\r\n	.w20 { width: 10px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w480 img {max-width:420px;  height:auto !important;}\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width: 600px !important;}\r\n	.w520 { width: 520px !important;}\r\n	.w480 { width: 480px !important;}\r\n	.w40 { width40px !important;}\r\n	.w20 { width: 20px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w480 img {max-width:480px;  height:auto !important;}\r\n}\r\nh1{color:#393939 !important; font-size:14px; font-weight:bold; margin:10px 0px;}h2{color: #309fb3 !important; font-size: 14px; font-weight: normal; text-align:left; margin:0px; padding:0px;}h3{color: #393939 !important; font-size: 18px; font-weight: bold; text-align:left; margin:0px; padding-bottom:5px; border-bottom:1px solid #bdbdbd;}h4{color: #309fb3 !important; font-size: 14px; font-weight: bold; text-align:left; margin:0px; padding: 5px 0px 0px 0px;}a{color:#309FB3; text-decoration:none; font-style:italic; cursor:pointer;}.acymailing_readmore{font-size: 12px; color: #fff; background-color:#309fb3; font-weight:bold; padding:3px 5px;}.acymailing_online{color:#a3a3a3; text-decoration:none; font-size:11px;}.acymailing_unsub{color:#a3a3a3; text-decoration:none; font-size:11px;}.acymailing_content{text-align:justify;}', NULL, 537, NULL),
(4, 'Newspaper', '2019-03-15 22:35:44', NULL, 0, 0, 'standard', '<div align=\"center\" style=\"width:100%; background-color:#454545; padding-bottom:20px; color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"margin:auto; background-color:#ffffff; color:#454545;\" width=\"600\">\r\n	<tbody  class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"font-family:Times New Roman, Times, serif; background-color:#ffffff; text-align:left\" width=\"540\">&nbsp;\r\n			<h1><img alt=\"logo\" src=\"media/com_acymailing/templates/newsletter-5/images/logo.png\" style=\"float: right; width: 107px; height: 70px;\" /></h1>\r\n\r\n			<h1>Your title here</h1>\r\n\r\n			<h3>your subtitle</h3>\r\n			</td>\r\n			<td class=\"w30\" style=\"line-height:0px; background-color:#ffffff\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#e4e4e4\" valign=\"top\" width=\"600\"><img alt=\"---\" src=\"media/com_acymailing/templates/newsletter-5/images/header.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#ffffff\" valign=\"top\" width=\"600\"><img alt=\"banner\" src=\"media/com_acymailing/templates/newsletter-5/images/banner.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"line-height:0px;\" valign=\"top\" width=\"600\"><img alt=\"---\" src=\"media/com_acymailing/templates/newsletter-5/images/separator.png\" /></td>\r\n		</tr>\r\n		<tr>\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:justify; color:#575757; font-family:Times New Roman, Times, serif; font-size:13px; background-color:#ffffff\" width=\"540\">\r\n				<div>This issue will present the 5 last articles.<br />\r\n				{tableofcontents}<br />\r\n				{autocontent:|max:5|order:id,DESC|type:intro|link|pict:1}</div>\r\n			</td>\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"background-color:#ffffff\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/newsletter-5/images/footer1.png\" width=\"600\" /></td>\r\n		</tr>\r\n		<tr>\r\n			<td class=\"acyfooter acyeditor_text w600\" colspan=\"3\" height=\"25\" style=\"text-align:center; background-color:#ebebeb;  color:#454545; font-family:Times New Roman, Times, serif; font-size:13px\" width=\"600\"><a href=\"#\">www.mywebsite.com</a> | <a href=\"#\">contact</a> | <a href=\"#\">Facebook</a> | <a href=\"#\">Twitter</a></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"background-color:#454545;\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/newsletter-5/images/footer2.png\" width=\"600\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\">{unsubscribe}If you\'re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>\r\n', '', 1, '', '', '', '', NULL, NULL, '.acyfooter a{\r\n	color:#454545;\r\n}\r\n.dark{\r\n	color:#454545;\r\n	font-weight:bold;\r\n}\r\ndiv,table,p, td{font-family:\"Times New Roman\", Times, serif;font-size:13px;color:#575757;}\r\n\r\n\r\n\r\n@media (min-width:10px){\r\n	.w600 { width:320px !important; }\r\n	.w540 { width:260px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:320px; height:auto !important; }\r\n	.w540 img {max-width:260px; height:auto !important; }\r\n}\r\n\r\n@media (min-width: 480px){\r\n	.w600 { width:480px !important; }\r\n	.w540 { width:420px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:480px; height:auto !important; }\r\n	.w540 img {max-width:420px; height:auto !important; }\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width:600px !important; }\r\n	.w540 { width:540px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img {max-width:600px; height:auto !important; }\r\n	.w540 img {max-width:540px; height:auto !important; }\r\n}\r\nh1{color:#454545 !important; font-size:24px; font-weight:bold; margin:0px;}h2{color:#b20000 !important; font-size:18px; font-weight:bold; margin:0px; margin-bottom:10px; padding-bottom:4px; border-bottom: 1px solid #d6d6d6;}h3{color:#b20101 !important; font-weight:bold; font-size:18px; margin:10px 0px;}h4{color:#e52323 !important; font-weight:bold; margin:0px; padding:0px}a{cursor:pointer; color:#9d0000; text-decoration:none; border:none;}.acymailing_readmore{cursor:pointer; color:#ffffff; background-color:#9d0000; border-top:1px solid #9d0000; border-bottom:1px solid #9d0000; padding:3px 5px; font-size:13px;}.acymailing_online{color:#dddddd; text-decoration:none; font-size:13px; margin:10px; text-align:center; font-family:Times New Roman, Times, serif; padding-bottom:10px;}.acymailing_content{}.acymailing_unsub{color:#dddddd; text-decoration:none; font-size:13px; text-align:center; font-family:Times New Roman, Times, serif; padding-top:10px}', NULL, 537, NULL),
(5, 'Build Bio', '2019-03-15 22:35:44', NULL, 0, 0, 'standard', '<div align=\"center\" style=\"width:100%; background-color:#3c3c3c; padding-bottom:20px; color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"margin:auto; background-color:#ffffff; color:#575757;\" width=\"600\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#eeeeee\" valign=\"bottom\" width=\"600\"><img alt=\"mail\" height=\"41\" src=\"media/com_acymailing/templates/newsletter-6/images/header.png\" width=\"600\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"color:#ffffff;\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"line-height:0px; background-color:#ffffff; text-align:center\" width=\"540\"><img alt=\"\" src=\"media/com_acymailing/templates/newsletter-6/images/banner.png\" style=\"width: 540px; height: 122px;\" /></td>\r\n			<td class=\"w30\" height=\"122\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#b9cf00; color:#ffffff;\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" height=\"25\" style=\"text-align:right; background-color:#b9cf00; color:#ffffff;\" width=\"540\"><span class=\"hide\">Newsletter</span> {date:3}</td>\r\n			<td class=\"w30\" style=\"background-color:#b9cf00; color:#ffffff;\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" height=\"25\" style=\"background-color:#ffffff\" width=\"600\"></td>\r\n		</tr>\r\n		<tr>\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:justify; color:#575757; background-color:#ffffff\" width=\"540\"><span class=\"intro\">Hello {subtag:name},</span><br />\r\n			<br />\r\n			Your introduction text here\r\n			<br />\r\n			<h2>Your title</h2>\r\n			<strong>Your catchphrase</strong><br />\r\n			Your content here <a href=\"#\">with some link</a><br />\r\n			<br />\r\n			More content<br />\r\n			<br />\r\n			<span class=\"acymailing_readmore\">Read More</span>\r\n\r\n			<h2>Another title</h2>\r\n			<img alt=\"picture\" height=\"160\" src=\"media/com_acymailing/templates/newsletter-6/images/picture.png\" style=\"float:left;\" width=\"193\" /> <strong>Another catchphrase</strong> Some content and <a href=\"#\">another link</a><br />\r\n			<br />\r\n			More content<br />\r\n			<br />\r\n			<span class=\"acymailing_readmore\">Read More</span></td>\r\n			<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#efefef;\" valign=\"top\" width=\"600\"><img alt=\"--\" height=\"18\" src=\"media/com_acymailing/templates/newsletter-6/images/footer1.png\" width=\"600\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\" width=\"30\"></td>\r\n			<td class=\"acyfooter acyeditor_text w540\" style=\"text-align:right; background-color:#efefef; color:#575757;\" width=\"540\"><a href=\"#\">www.mywebsite.com</a> | <a href=\"#\">Contact</a><a href=\"#\"><img alt=\"message\" class=\"hide\" src=\"media/com_acymailing/templates/newsletter-6/images/mail.png\" style=\"border: medium none; width: 35px; height: 20px;\" /></a></td>\r\n			<td class=\"w30\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\" width=\"30\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" style=\"background-color:#efefef; line-height:0px;\" valign=\"top\" width=\"600\"><img alt=\"--\" height=\"24\" src=\"media/com_acymailing/templates/newsletter-6/images/footer2.png\" width=\"600\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\" >{unsubscribe}If you\'re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>', '', 1, '', '', '', '', NULL, NULL, 'table, div, p, td{\r\n	font-family: Verdana, Arial, Helvetica, sans-serif;\r\n	font-size:11px;\r\n	color:#575757;\r\n}\r\n.intro{\r\n	font-weight:bold;\r\n	font-size:12px;}\r\n\r\n.acyfooter a{\r\n	color:#575757;}\r\n\r\n@media (min-width: 10px){\r\n	.w600  { width:320px !important; }\r\n	.w540  { width:260px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img{max-width:320px; height:auto !important}\r\n	.w540 img{max-width:260px; height:auto !important}\r\n}\r\n\r\n@media (min-width: 480px){\r\n	.w600  { width:480px !important; }\r\n	.w540  { width:420px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img{max-width:480px; height:auto !important}\r\n	.w540 img{max-width:420px; height:auto !important}\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600  { width:600px !important; }\r\n	.w540  { width:540px !important; }\r\n	.w30 { width:30px !important; }\r\n	.w600 img{max-width:600px; height:auto !important}\r\n	.w540 img{max-width:540px; height:auto !important}\r\n}\r\nh1{font-weight:bold; font-size:14px;color:#3c3c3c !important;margin:0px;}h2{color:#b9cf00 !important; font-size:14px; font-weight:bold; margin-top:20px; border-bottom:1px solid #d6d6d6; padding-bottom:4px;}h3{color:#7e7e7e !important; font-size:14px; font-weight:bold; margin:20px 0px 0px 0px; border-bottom:1px solid #d6d6d6; padding-bottom:0px 0px 4px 0px;}h4{color:#879700 !important; font-size:12px; font-weight:bold; margin:0px; padding:0px;}a{cursor:pointer; color:#a2b500; text-decoration:none; border:none;}.acymailing_online{color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-bottom:10px}.acymailing_unsub{color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-top:10px}.acymailing_readmore{cursor:pointer; color:#ffffff; background-color:#b9cf00; padding:3px 5px;}', NULL, 537, NULL),
(6, 'Technology', '2019-03-15 22:35:44', NULL, 0, 0, 'standard', '<div align=\"center\" style=\"width:100%; background-color:#575757; padding-bottom:20px; color:#999999;\">\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"background-color:#fff; color:#999999; margin:auto\" width=\"600\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_online\">{readonline}If you can\'t see this e-mail properly, <span style=\"text-decoration:underline\">view it online</span>{/readonline}</span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/shadowtop.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/top.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text links w540\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd; text-align:right; color:#ababab\" width=\"540\"><a href=\"#\"><img alt=\"mail\" src=\"media/com_acymailing/templates/technology_resp/images/mail.jpg\" style=\"float:right; border:none\" /></a> Newsletter {mailid} | {date:%B %Y} |&nbsp; <a href=\"#\">www.acyba.com</a> |</td>\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" width=\"540\"><img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic1.jpg\" style=\"float:right\" />\r\n			<h1>Your title !</h1>\r\n\r\n			<h3>Your catchphrase</h3>\r\n			Your introduction content here</td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" src=\"media/com_acymailing/templates/technology_resp/images/separator1.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"background-color:#fafafa; color:#999999\" width=\"540\">\r\n			<h2>Your subtitle</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic2.jpg\" style=\"float:left\" />\r\n			<h3>Your catchphrase</h3>\r\n			Your content here<br />\r\n			<a href=\"#\">Some link</a> and some content<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /><br />\r\n			<br />\r\n			<br />\r\n			<br />\r\n			&nbsp;\r\n			<h2>Another subtitle</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic3.jpg\" style=\"float:right\" />\r\n			<h3>Another catchphrase</h3>\r\n			Other content<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" src=\"media/com_acymailing/templates/technology_resp/images/separator2.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text special w540\" style=\"color:#999999\" width=\"540\">\r\n			<h2>Best product of the month</h2>\r\n\r\n			<h3>Lorem ipsum dolor sit amet.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum doLiget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum dolor sit amesent.<br />\r\n			<br />\r\n			<img alt=\"read more\" src=\"media/com_acymailing/templates/technology_resp/images/readmore.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd; text-align:right; color:#ababab\" valign=\"bottom\" width=\"540\">Follow us | <img alt=\"facebook\" src=\"media/com_acymailing/templates/technology_resp/images/facebook.jpg\" style=\"border:none\" /> <img alt=\"twitter\" src=\"media/com_acymailing/templates/technology_resp/images/twitter.jpg\" style=\"border:none\" /> <img alt=\"pinterest\" src=\"media/com_acymailing/templates/technology_resp/images/pinterest.jpg\" style=\"border:none\" /> <img alt=\"rss\" src=\"media/com_acymailing/templates/technology_resp/images/rss.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/bottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/shadowbottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_unsub\">{unsubscribe}If you don\'t want to receive our news anymore, <span style=\"text-decoration:underline\">unsubscribe</span>{/unsubscribe} </span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n</div>', '', 1, '', '', '', '', NULL, NULL, 'table, div, p , td{\r\n	font-family:Arial, Helvetica, sans-serif;\r\n	font-size:12px;\r\n}\r\np{margin:0px; padding:0px}\r\n\r\n.special h2{font-size:18px;\r\n	margin:0px;\r\n	margin-bottom:15px;\r\n	padding:0px;\r\n	font-weight:bold;\r\n	color:#01bbe5 !important;\r\n	text-transform:none;\r\n	border:none}\r\n\r\n.links a{color:#ababab}\r\n\r\n@media (min-width:10px){\r\n	.w600 { width:320px !important;}\r\n	.w540 { width:260px !important;}\r\n	.w30 { width:30px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w540 img {max-width:260px; height:auto !important}\r\n}\r\n\r\n@media (min-width: 480px){\r\n	.w600 { width:480px !important;}\r\n	.w540 { width:420px !important;}\r\n	.w30 { width:30px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w540 img {max-width:420px; height:auto !important}\r\n}\r\n\r\n@media (min-width:600px){\r\n	.w600 { width:600px !important;}\r\n	.w540 { width:540px !important;}\r\n	.w30 { width:30px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w540 img {max-width:540px; height:auto !important}\r\n}\r\nh1{font-size:20px; margin:0px; margin-bottom:15px; padding:0px; font-weight:bold; color:#01bbe5 !important;}h2{font-size:12px; font-weight:bold; color:#565656 !important; text-transform:uppercase; margin:10px 0px; padding:0px; padding-bottom:5px; border-bottom:1px solid #ddd;}h3{color:#565656 !important; font-weight:bold; font-size:12px; margin:0px; margin-bottom:10px; padding:0px;}h4{}a{cursor:pointer;color:#01bbe5;text-decoration:none;border:none;}.acymailing_online{color:#d2d1d1; cursor:pointer;}.acymailing_unsub{color:#d2d1d1; cursor:pointer;}.acymailing_readmore{cursor:pointer; font-weight:bold; color:#fff; background-color:#01bbe5; padding:2px 5px;}', NULL, 537, NULL),
(7, 'acy_report', '2019-03-15 23:35:48', NULL, 1, 1, 'notification', '<p>{report}</p><p>{detailreport}</p>', 'AcyMailing Cron Report {mainreport}', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 537, NULL),
(8, 'acy_confirm', '2019-03-15 23:35:48', NULL, 1, 1, 'notification', '<div id=\"acym__wysid__template\" class=\"cell\"><table class=\"body\"><tbody><tr><td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 40px 0px;\"><center><table align=\"center\"><tbody><tr><td class=\"acym__wysid__row ui-droppable ui-sortable\" style=\"min-height: 0px; display: table-cell;\"><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\"><tbody style=\"background-color: rgb(218, 218, 218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-size: 24px;\">Hello {subtag:name|ucfirst},</h1>\r\n                    <p>{trans:ACYM_CONFIRM_MESSAGE}</p>\r\n                    <p>{trans:ACYM_CONFIRM_MESSAGE_ACTIVATE}</p>\r\n                    <p style=\"text-align: center;\"><strong>{confirm}{trans:ACYM_CONFIRM_SUBSCRIPTION}{/confirm}</strong></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#dadada\" style=\"position: relative; z-index: 100; top: 0px; left: 0px;\"><tbody style=\"background-color: rgb(218, 218, 218);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table></td></tr></tbody></table></center></td></tr></tbody></table></div>', '{subtag:name|ucfirst}, {trans:ACYM_PLEASE_CONFIRM_SUBSCRIPTION}', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 537, NULL);
INSERT INTO `#__acym_mail` (`id`, `name`, `creation_date`, `thumbnail`, `drag_editor`, `library`, `type`, `body`, `subject`, `template`, `from_name`, `from_email`, `reply_to_name`, `reply_to_email`, `bcc`, `settings`, `stylesheet`, `attachments`, `creator_id`, `media_folder`) VALUES
(9, 'default template', '2019-03-15 23:35:57', 'http://joomla/flex_3.6_with-vm/media/com_acym/images/img_template/default_template.png', 1, 1, 'standard', '<div id=\'acym__wysid__template\' class=\'cell\'>					<table class=\"body\">						<tbody>						<tr>							<td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 40px 0px;\">								<center>									<table align=\"center\">										<tbody>										<tr>											<td class=\"acym__wysid__row ui-droppable ui-sortable\" style=\"min-height: 0px; display: table-cell;\">												<table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th margin_padding_none\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable margin_padding_none\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td margin_padding_none\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 14px; color: rgb(42, 61, 91);\" data-mce-style=\"font-size: 14px; color: #2a3d5b;\"><strong>Sed ut perspiciatis unde omnis magni dolores eos qui ratione voluptatem sequ</strong></span></h1></div><input type=\"hidden\" name=\"mce_7\"><input type=\"hidden\" name=\"mce_7\"></td></tr><tr class=\"acym__wysid__column__element acym__wysid__column__element__separator cursor-pointer ui-draggable margin_padding_none\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td margin_padding_none\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><hr style=\"border-bottom: 1px solid rgb(205, 205, 205); margin-left: 5%; width: 90%; border-top: none; border-left: none; border-right: none;\" class=\"acym__wysid__row__separator\"></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" class=\"\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/default_template_thumbnail.png\" alt=\"IMG_2601.JPG\" data-mce-src=\"../images/IMG_2601.JPG\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"538\" width=\"538\"></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#efefef\"><tbody style=\"background-color: rgb(239, 239, 239);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\">													<tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\">													<tr>														<th class=\"small-12 medium-12 large-12 columns\">															<table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\">																<tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_0\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 30px; color: rgb(255, 7, 16);\" data-mce-style=\"font-size: 30px; color: #ff0710;\"><strong>Sed ut perspiciatis unde omnis</strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space\" style=\"display: block; padding: 0px; margin: 0px; height: 22px;\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_8\" style=\"position: relative;\" spellcheck=\"false\"><h5 data-mce-style=\"font-family: Helvetica; font-size: 28px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" style=\"font-family: Helvetica; font-size: 20px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\"><span style=\"color: rgb(45, 61, 88);\" data-mce-style=\"color: #2d3d58;\"><strong>Sed ut perspiciatis unde omnis</strong></span></h5></div></td></tr></tbody>															</table>														</th>													</tr>													</tbody>												</table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-8 large-8 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"inset: inherit; height: auto; width: 100px; z-index: 100; position: relative;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" class=\"\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/default_template_thumbnail.png\" alt=\"IMG_2601.JPG\" data-mce-src=\"../images/IMG_2601.JPG\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"538\" width=\"538\"></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_8\" style=\"position: relative;\" spellcheck=\"false\"><h5 data-mce-style=\"font-family: Helvetica; font-size: 28px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" style=\"font-family: Helvetica; font-size: 20px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\"><span style=\"font-size: 18px; color: rgb(45, 61, 88);\" data-mce-style=\"font-size: 18px; color: #2d3d58;\"><strong>Sed ut perspiciatis unde omnis</strong></span></h5></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_9\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"color: rgb(128, 128, 128);\" data-mce-style=\"color: #808080;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam in magna in leo volutpat congue vitae eu nibh. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In varius sed ipsum vel egestas.</span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div style=\"text-align: center;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" href=\"#\" style=\"v-text-anchor:middle;\" arcsize=\"25%\" strokecolor=\"rgb(255, 41, 41)\" fillcolor=\"rgb(255, 255, 255)\"><w:anchorlock></w:anchorlock><center style=\"color :rgb(255, 41, 41); word-break:break-all; font-family:Arial; font-size:14px;\">Magni dolo</center></v:roundrect><![endif]--><!--[if !mso]> <!----><a class=\"acym__wysid__column__element__button\" style=\"background-color: rgb(255, 255, 255); color: rgb(255, 41, 41); padding: 25px 30px; max-width: 100%; overflow: hidden; border: 3px solid rgb(255, 41, 41); text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-all; display: inline-block; box-shadow: none; font-family: Arial; font-size: 14px; cursor: pointer; line-height: 0; border-radius: 25px; font-weight: 700;\" href=\"#\">Magni dolo</a><!-- <![endif]--></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_0\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 30px; color: rgb(255, 7, 16);\" data-mce-style=\"font-size: 30px; color: #ff0710;\"><strong>Sed ut perspiciatis unde omnis</strong></span></h1></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-6 large-6 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_8\" style=\"position: relative;\" spellcheck=\"false\"><h5 data-mce-style=\"font-family: Helvetica; font-size: 28px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" style=\"font-family: Helvetica; font-size: 20px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\"><span style=\"font-size: 18px; color: rgb(45, 61, 88);\" data-mce-style=\"font-size: 18px; color: #2d3d58;\"><strong>Sed ut perspiciatis unde omnis</strong></span></h5></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_9\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"color: rgb(128, 128, 128);\" data-mce-style=\"color: #808080;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam in magna in leo volutpat congue vitae eu nibh. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In varius sed ipsum vel egestas.</span></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div style=\"text-align: center;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" href=\"#\" style=\"v-text-anchor:middle;\" arcsize=\"25%\" strokecolor=\"rgb(255, 41, 41)\" fillcolor=\"rgb(255, 255, 255)\"><w:anchorlock></w:anchorlock><center style=\"color :rgb(255, 41, 41); word-break:break-all; font-family:Arial; font-size:14px;\">Sed ut perspiciatis unde</center></v:roundrect><![endif]--><!--[if !mso]> <!----><a class=\"acym__wysid__column__element__button acym__wysid__column__element__button--focus\" style=\"background-color: rgb(255, 255, 255); color: rgb(255, 41, 41); padding: 25px 30px; max-width: 100%; overflow: hidden; border: 3px solid rgb(255, 41, 41); text-overflow: ellipsis; text-align: center; text-decoration: none; word-break: break-all; display: inline-block; box-shadow: none; font-family: Arial; font-size: 14px; cursor: pointer; line-height: 0; border-radius: 25px; font-weight: 700;\" href=\"#\">Sed ut perspiciatis unde</a><!-- <![endif]--></div></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"inset: inherit; height: auto; width: 100px; z-index: 100; position: relative;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" class=\"\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/default_template_thumbnail.png\" alt=\"IMG_2601.JPG\" data-mce-src=\"../images/IMG_2601.JPG\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"538\" width=\"538\"></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"position: relative; z-index: 100; top: 0px; left: 0px;\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_0\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 30px;\" data-mce-style=\"font-size: 30px;\"><strong><span style=\"color: rgb(255, 41, 41);\" data-mce-style=\"color: #ff2929;\">Sed ut perspiciatis unde omnis</span></strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_8\" style=\"position: relative;\" spellcheck=\"false\"><h5 data-mce-style=\"font-family: Helvetica; font-size: 28px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" style=\"font-family: Helvetica; font-size: 20px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\"><span style=\"color: rgb(45, 61, 88);\" data-mce-style=\"color: #2d3d58;\"><strong>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium</strong></span></h5></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-4 large-4 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"inset: inherit; height: auto; width: 100px; z-index: 100; position: relative;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" class=\"\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/default_template_thumbnail.png\" alt=\"IMG_2601.JPG\" data-mce-src=\"../images/IMG_2601.JPG\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"538\" width=\"538\"></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_11\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(45, 61, 88); font-family: Helvetica;\" data-mce-style=\"color: #2d3d58; font-family: Helvetica;\">Sed ut perspiciatis unde omnis</span></p><p style=\"text-align: center; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" data-mce-style=\"text-align: center; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"color: rgb(128, 128, 128);\" data-mce-style=\"color: #808080;\">FRT8790</span></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"inset: inherit; height: auto; width: 100px; z-index: 100; position: relative;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" class=\"\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/default_template_thumbnail.png\" alt=\"IMG_2601.JPG\" data-mce-src=\"../images/IMG_2601.JPG\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"538\" width=\"538\"></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_11\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(45, 61, 88); font-family: Helvetica;\" data-mce-style=\"color: #2d3d58; font-family: Helvetica;\">Sed ut perspiciatis unde omnis</span></p><p style=\"text-align: center; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" data-mce-style=\"text-align: center; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"color: rgb(128, 128, 128);\" data-mce-style=\"color: #808080;\">FRT8790</span></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"inset: inherit; height: auto; width: 100px; z-index: 100; position: relative;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" class=\"\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/default_template_thumbnail.png\" alt=\"IMG_2601.JPG\" data-mce-src=\"../images/IMG_2601.JPG\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"538\" width=\"538\"></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_11\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(45, 61, 88); font-family: Helvetica;\" data-mce-style=\"color: #2d3d58; font-family: Helvetica;\">Sed ut perspiciatis unde omnis</span></p><p style=\"text-align: center; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" data-mce-style=\"text-align: center; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"color: rgb(128, 128, 128);\" data-mce-style=\"color: #808080;\">FRT8790</span></p></div></td></tr></tbody></table></th></tr></tbody></table>											<table class=\"row acym__wysid__row__element\" bgcolor=\"#666666\"><tbody style=\"background-color: rgb(102, 102, 102);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space\" style=\"display: block; padding: 0px; margin: 0px; height: 29px;\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_16\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 24px; color: rgb(255, 255, 255);\" data-mce-style=\"font-size: 24px; color: #ffffff;\"><strong>Sed ut perspiciatis unde omnis iste nateis error siit voluptatem accusantil doloremque laundantium&nbsp;</strong></span></h1></div><input type=\"hidden\" name=\"mce_16\"></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space\" style=\"display: block; padding: 0px; margin: 0px; height: 29px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-4 large-4 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_9\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/img_template/ic-garantie.svg\" alt=\"Statistics\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"100\" width=\"151\"></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_13\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(142, 142, 142);\" data-mce-style=\"color: #8e8e8e;\"><strong>Sed ut perspiciatis unde omnis</strong></span></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_9\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/img_template/ic-garantie.svg\" alt=\"Statistics\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"100\" width=\"151\"></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_13\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(142, 142, 142);\" data-mce-style=\"color: #8e8e8e;\"><strong>Sed ut perspiciatis unde omnis</strong></span></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_9\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/img_template/ic-garantie.svg\" alt=\"Statistics\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"100\" width=\"151\"></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_13\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(142, 142, 142);\" data-mce-style=\"color: #8e8e8e;\"><strong>Sed ut perspiciatis unde omnis</strong></span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#d1d1d1\"><tbody style=\"background-color: rgb(209, 209, 209);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_14\" style=\"position: relative;\" spellcheck=\"false\"><p class=\"p1\" style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(84, 84, 84);\" data-mce-style=\"color: #545454;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla tristique augue eget enim feugiat blandit. Phasellus bibendum ex leo.</span></p><p class=\"p2\" style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><br></p><p class=\"p1\" style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(84, 84, 84);\" data-mce-style=\"color: #545454;\">Sed ut perspiciatis unde omnis</span></p><p class=\"p1\" style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(84, 84, 84);\" data-mce-style=\"color: #545454;\">Sed ut perspiciatis unde omnis</span></p><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><br></p><p class=\"p1\" style=\"text-align: center; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" data-mce-style=\"text-align: center; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"color: rgb(84, 84, 84);\" data-mce-style=\"color: #545454;\">69110 Sainte-Foy-lès-Lyon</span></p></div><input type=\"hidden\" name=\"mce_14\"></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div style=\"text-align: center;\"><p class=\"acym__wysid__column__element__follow\" style=\"text-align: center; cursor: pointer; padding: 0px; margin: 0px; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" href=\"\" style=\"v-text-anchor:middle;\" arcsize=\"0%\" strokecolor=\"rgb(33, 153, 232)\" fillcolor=\"rgba(0, 0, 0, 0)\"><w:anchorlock></w:anchorlock><center style=\"color :rgb(33, 153, 232); word-break:normal; font-family:Helvetica, Arial, sans-serif; font-size:16px;\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/facebook.png\"></center></v:roundrect><![endif]--><!--[if !mso]> <!----><a class=\"acym__wysid__column__element__follow__facebook\" href=\"\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/facebook.png\"></a><!-- <![endif]--><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" href=\"\" style=\"v-text-anchor:middle;\" arcsize=\"0%\" strokecolor=\"rgb(33, 153, 232)\" fillcolor=\"rgba(0, 0, 0, 0)\"><w:anchorlock></w:anchorlock><center style=\"color :rgb(33, 153, 232); word-break:normal; font-family:Helvetica, Arial, sans-serif; font-size:16px;\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/twitter.png\"></center></v:roundrect><![endif]--><!--[if !mso]> <!----><a class=\"acym__wysid__column__element__follow__twitter\" href=\"\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/twitter.png\"></a><!-- <![endif]--><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" href=\"\" style=\"v-text-anchor:middle;\" arcsize=\"0%\" strokecolor=\"rgb(33, 153, 232)\" fillcolor=\"rgba(0, 0, 0, 0)\"><w:anchorlock></w:anchorlock><center style=\"color :rgb(33, 153, 232); word-break:normal; font-family:Helvetica, Arial, sans-serif; font-size:16px;\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/google-plus.png\"></center></v:roundrect><![endif]--><!--[if !mso]> <!----><a class=\"acym__wysid__column__element__follow__googleplus\" href=\"\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/google-plus.png\"></a><!-- <![endif]--></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\"><tbody style=\"background-color: rgb(0, 0, 0);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-6 large-6 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_17\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\"><span class=\"acym_dynamic\" data-dynamic=\"{unsubscribe}Unsubscribe{/unsubscribe}\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><span style=\"color: rgb(153, 153, 153);\" data-mce-style=\"color: #999999;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" href=\"\" style=\"v-text-anchor:middle;\" arcsize=\"0%\" strokecolor=\"rgb(153, 153, 153)\" fillcolor=\"rgba(0, 0, 0, 0)\"><w:anchorlock></w:anchorlock><center style=\"color :rgb(153, 153, 153); word-break:break-all; font-family:Helvetica, Arial, sans-serif; font-size:12px;\"><span class=\"acym_unsubscribe\">Unsubscribe</span></center></v:roundrect><![endif]--><!--[if !mso]> <!----><a style=\"text-decoration: none; color: rgb(153, 153, 153);\" href=\"\" target=\"_blank\" rel=\"noopener\" data-mce-href=\"admin-ajax.php?page=acym_front&amp;ctrl=frontusers&amp;task=unsubscribe&amp;id=&amp;key=&amp;noheader=1&amp;mail_id=0&amp;action=acym_frontrouter&amp;noheader=1\" data-mce-style=\"text-decoration: none; color: #999999;\"><span class=\"acym_unsubscribe\">Unsubscribe</span></a><!-- <![endif]--><em class=\"acym_remove_dynamic material-icons\">close</em></span></span></span></p></div><input type=\"hidden\" name=\"mce_17\"></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_18\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: right;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: right;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" href=\"acyba.com\" style=\"v-text-anchor:middle;\" arcsize=\"0%\" strokecolor=\"rgb(255, 255, 255)\" fillcolor=\"rgba(0, 0, 0, 0)\"><w:anchorlock></w:anchorlock><center style=\"color :rgb(255, 255, 255); word-break:break-all; font-family:Helvetica, Arial, sans-serif; font-size:16px;\">﻿﻿Acyba.com</center></v:roundrect><![endif]--><!--[if !mso]> <!----><a href=\"acyba.com\" data-mce-href=\"acyba.com\" style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">﻿﻿Acyba.com</a><!-- <![endif]--></span></p></div><input type=\"hidden\" name=\"mce_18\"></td></tr></tbody></table></th></tr></tbody></table></td>										</tr>										</tbody>									</table>								</center>							</td>						</tr>						</tbody>					</table>				</div>', 'Subject', 1, NULL, NULL, NULL, NULL, NULL, '{\"h1\":{\"font-family\":\"Helvetica\"}}', '', NULL, 1, NULL);
INSERT INTO `#__acym_mail` (`id`, `name`, `creation_date`, `thumbnail`, `drag_editor`, `library`, `type`, `body`, `subject`, `template`, `from_name`, `from_email`, `reply_to_name`, `reply_to_email`, `bcc`, `settings`, `stylesheet`, `attachments`, `creator_id`, `media_folder`) VALUES
(10, 'default template 2', '2019-03-15 23:35:57', 'http://joomla/flex_3.6_with-vm/media/com_acym/images/img_template/default_template_2.png', 1, 1, 'standard', '<div id=\'acym__wysid__template\' class=\'cell\'>					<table class=\"body\">						<tbody>						<tr>							<td align=\"center\" class=\"center acym__wysid__template__content\" valign=\"top\" style=\"background-color: rgb(239, 239, 239); padding: 40px 0px;\">								<center>									<table align=\"center\">										<tbody>										<tr>											<td class=\"acym__wysid__row ui-droppable ui-sortable\" style=\"min-height: 0px; display: table-cell;\">												<table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th margin_padding_none\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable margin_padding_none\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td margin_padding_none\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 14px; color: rgb(42, 61, 91);\" data-mce-style=\"font-size: 14px; color: #2a3d5b;\"><strong>Sed ut perspiciatis unde omnis magni dolores eos qui ratione voluptatem sequ</strong></span></h1></div><input type=\"hidden\" name=\"mce_7\"><input type=\"hidden\" name=\"mce_7\"><input type=\"hidden\" name=\"mce_7\"></td></tr><tr class=\"acym__wysid__column__element acym__wysid__column__element__separator cursor-pointer ui-draggable margin_padding_none\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td margin_padding_none\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><hr style=\"border-bottom: 1px solid rgb(205, 205, 205); margin-left: 5%; width: 90%; border-top: none; border-left: none; border-right: none;\" class=\"acym__wysid__row__separator\"></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" class=\"\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/default_template_thumbnail.png\" alt=\"IMG_2601.JPG\" data-mce-src=\"../images/IMG_2601.JPG\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"538\" width=\"538\"></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#efefef\"><tbody style=\"background-color: rgb(239, 239, 239);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space\" style=\"display: block; padding: 0px; margin: 0px; height: 10px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\">													<tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\">													<tr>														<th class=\"small-12 medium-12 large-12 columns\">															<table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\">																<tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_0\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 30px; color: rgb(255, 7, 16);\" data-mce-style=\"font-size: 30px; color: #ff0710;\"><strong>Sed ut perspiciatis unde omnis</strong></span></h1></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space\" style=\"display: block; padding: 0px; margin: 0px; height: 22px;\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_8\" style=\"position: relative;\" spellcheck=\"false\"><h5 data-mce-style=\"font-family: Helvetica; font-size: 28px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" style=\"font-family: Helvetica; font-size: 20px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\"><span style=\"color: rgb(45, 61, 88);\" data-mce-style=\"color: #2d3d58;\"><strong>Sed ut perspiciatis unde omnis</strong></span></h5></div></td></tr></tbody>															</table>														</th>													</tr>													</tbody>												</table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-6 large-6 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_8\" style=\"position: relative;\" spellcheck=\"false\"><h5 data-mce-style=\"font-family: Helvetica; font-size: 28px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\" style=\"font-family: Helvetica; font-size: 20px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\"><span style=\"font-size: 18px; color: rgb(45, 61, 88);\" data-mce-style=\"font-size: 18px; color: #2d3d58;\"><strong>Sed ut perspiciatis unde omnis</strong></span></h5></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_9\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"color: rgb(128, 128, 128);\" data-mce-style=\"color: #808080;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam in magna in leo volutpat congue vitae eu nibh. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In varius sed ipsum vel egestas.</span></p></div><input type=\"hidden\" name=\"mce_9\"></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" class=\"\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/default_template_thumbnail.png\" alt=\"IMG_2601.JPG\" data-mce-src=\"../images/IMG_2601.JPG\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"538\" width=\"538\"></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"position: relative; z-index: 100; top: 0px; left: 0px;\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" class=\"\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/default_template_thumbnail.png\" alt=\"IMG_2601.JPG\" data-mce-src=\"../images/IMG_2601.JPG\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"538\" width=\"538\"></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space acy-editor__space--focus\" style=\"display: block; padding: 0px; margin: 0px; height: 20px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\" style=\"position: relative; z-index: 100; top: 0px; left: 0px;\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; inset: inherit; position: relative;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_8\" style=\"position: relative;\" spellcheck=\"false\"><h5 data-mce-style=\"font-family: Helvetica; font-size: 20px; font-weight: normal; font-style: normal; color: #000000; text-align: left;\" style=\"font-family: Helvetica; font-size: 20px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: left;\"><span style=\"font-size: 18px;\" data-mce-style=\"font-size: 18px;\"><em><span style=\"color: rgb(45, 61, 88);\" data-mce-style=\"color: #2d3d58;\"><strong>Sed ut perspiciatis unde omnis</strong></span></em></span></h5></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image\" id=\"mce_7\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" class=\"\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/default_template_thumbnail.png\" alt=\"IMG_2601.JPG\" data-mce-src=\"../images/IMG_2601.JPG\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"538\" width=\"538\"></p></div></td></tr></tbody></table></th></tr></tbody></table>											<table class=\"row acym__wysid__row__element\" bgcolor=\"#666666\"><tbody style=\"background-color: rgb(102, 102, 102);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space\" style=\"display: block; padding: 0px; margin: 0px; height: 29px;\"></span></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_16\" style=\"position: relative;\" spellcheck=\"false\"><h1 style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 34px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"font-size: 24px; color: rgb(255, 255, 255);\" data-mce-style=\"font-size: 24px; color: #ffffff;\"><strong>Sed ut perspiciatis unde omnis iste nateis error siit voluptatem accusantil doloremque laundantium&nbsp;</strong></span></h1></div><input type=\"hidden\" name=\"mce_16\"></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><span class=\"acy-editor__space\" style=\"display: block; padding: 0px; margin: 0px; height: 29px;\"></span></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#ffffff\"><tbody style=\"background-color: rgb(255, 255, 255);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-4 large-4 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_9\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/img_template/ic-garantie.svg\" alt=\"Statistics\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"100\" width=\"151\"></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_13\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(142, 142, 142);\" data-mce-style=\"color: #8e8e8e;\"><strong>Sed ut perspiciatis unde omnis</strong></span></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_9\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/img_template/ic-garantie.svg\" alt=\"Statistics\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"100\" width=\"151\"></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_13\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(142, 142, 142);\" data-mce-style=\"color: #8e8e8e;\"><strong>Sed ut perspiciatis unde omnis</strong></span></p></div></td></tr></tbody></table></th><th class=\"small-12 medium-4 large-4 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--image mce-content-body\" id=\"mce_9\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\"><img class=\"\" style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/img_template/ic-garantie.svg\" alt=\"Statistics\" data-mce-style=\"max-width: 100%; height: auto; box-sizing: border-box; padding: 0 5px; display: block; margin-left: auto; margin-right: auto;\" height=\"100\" width=\"151\"></p></div></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"height: auto; width: 100px; z-index: 100; position: relative; inset: inherit;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_13\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(142, 142, 142);\" data-mce-style=\"color: #8e8e8e;\"><strong>Sed ut perspiciatis unde omnis</strong></span></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#d1d1d1\"><tbody style=\"background-color: rgb(209, 209, 209);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-12 large-12 columns acym__wysid__row__element__th\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_14\" style=\"position: relative;\" spellcheck=\"false\"><p class=\"p1\" style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(84, 84, 84);\" data-mce-style=\"color: #545454;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla tristique augue eget enim feugiat blandit. Phasellus bibendum ex leo.</span></p><p class=\"p2\" style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><br></p><p class=\"p1\" style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(84, 84, 84);\" data-mce-style=\"color: #545454;\">Sed ut perspiciatis unde omnis</span></p><p class=\"p1\" style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><span style=\"color: rgb(84, 84, 84);\" data-mce-style=\"color: #545454;\">Sed ut perspiciatis unde omnis</span></p><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: center;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: center;\"><br></p><p class=\"p1\" style=\"text-align: center; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\" data-mce-style=\"text-align: center; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\"><span style=\"color: rgb(84, 84, 84);\" data-mce-style=\"color: #545454;\">69110 Sainte-Foy-lès-Lyon</span></p></div><input type=\"hidden\" name=\"mce_14\"></td></tr><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div style=\"text-align: center;\"><p class=\"acym__wysid__column__element__follow\" style=\"text-align: center; cursor: pointer; padding: 0px; margin: 0px; font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0);\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" href=\"\" style=\"v-text-anchor:middle;\" arcsize=\"0%\" strokecolor=\"rgb(33, 153, 232)\" fillcolor=\"rgba(0, 0, 0, 0)\"><w:anchorlock></w:anchorlock><center style=\"color :rgb(33, 153, 232); word-break:normal; font-family:Helvetica, Arial, sans-serif; font-size:16px;\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/facebook.png\"></center></v:roundrect><![endif]--><!--[if !mso]> <!----><a class=\"acym__wysid__column__element__follow__facebook\" href=\"\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/facebook.png\"></a><!-- <![endif]--><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" href=\"\" style=\"v-text-anchor:middle;\" arcsize=\"0%\" strokecolor=\"rgb(33, 153, 232)\" fillcolor=\"rgba(0, 0, 0, 0)\"><w:anchorlock></w:anchorlock><center style=\"color :rgb(33, 153, 232); word-break:normal; font-family:Helvetica, Arial, sans-serif; font-size:16px;\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/twitter.png\"></center></v:roundrect><![endif]--><!--[if !mso]> <!----><a class=\"acym__wysid__column__element__follow__twitter\" href=\"\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/twitter.png\"></a><!-- <![endif]--><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" href=\"\" style=\"v-text-anchor:middle;\" arcsize=\"0%\" strokecolor=\"rgb(33, 153, 232)\" fillcolor=\"rgba(0, 0, 0, 0)\"><w:anchorlock></w:anchorlock><center style=\"color :rgb(33, 153, 232); word-break:normal; font-family:Helvetica, Arial, sans-serif; font-size:16px;\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/google-plus.png\"></center></v:roundrect><![endif]--><!--[if !mso]> <!----><a class=\"acym__wysid__column__element__follow__googleplus\" href=\"\"><img style=\"display: inline-block; max-width: 100%; height: auto;  box-sizing: border-box; width: 40px; padding: 3px;\" src=\"http://joomla/flex_3.6_with-vm/media/com_acym/images/logo/google-plus.png\"></a><!-- <![endif]--></p></div></td></tr></tbody></table></th></tr></tbody></table><table class=\"row acym__wysid__row__element\" bgcolor=\"#000000\"><tbody style=\"background-color: rgb(0, 0, 0);\" bgcolor=\"#ffffff\"><tr><th class=\"small-12 medium-6 large-6 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_17\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000;\">&nbsp;<br></p></div><input type=\"hidden\" name=\"mce_17\"></td></tr></tbody></table></th><th class=\"small-12 medium-6 large-6 columns\" style=\"word-break: break-all;\"><table class=\"acym__wysid__column\" style=\"min-height: 0px; display: table;\"><tbody class=\"ui-sortable\" style=\"min-height: 0px; display: table-row-group;\"><tr class=\"acym__wysid__column__element ui-draggable\" style=\"position: relative; top: inherit; left: inherit; right: inherit; bottom: inherit; height: auto;\"><td class=\"large-12 acym__wysid__column__element__td\" style=\"outline: rgb(0, 163, 254) dashed 0px; outline-offset: -1px;\"><div class=\"acym__wysid__tinymce--text mce-content-body\" id=\"mce_18\" style=\"position: relative;\" spellcheck=\"false\"><p style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: rgb(0, 0, 0); text-align: right;\" data-mce-style=\"font-family: Helvetica; font-size: 16px; font-weight: normal; font-style: normal; color: #000000; text-align: right;\"><span style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\"><!--[if mso]><v:roundrect xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" href=\"acyba.com\" style=\"v-text-anchor:middle;\" arcsize=\"0%\" strokecolor=\"rgb(255, 255, 255)\" fillcolor=\"rgba(0, 0, 0, 0)\"><w:anchorlock></w:anchorlock><center style=\"color :rgb(255, 255, 255); word-break:break-all; font-family:Helvetica, Arial, sans-serif; font-size:16px;\">﻿﻿Acyba.com</center></v:roundrect><![endif]--><!--[if !mso]> <!----><a href=\"acyba.com\" data-mce-href=\"acyba.com\" style=\"color: rgb(255, 255, 255);\" data-mce-style=\"color: #ffffff;\">﻿﻿Acyba.com</a><!-- <![endif]--></span></p></div><input type=\"hidden\" name=\"mce_18\"></td></tr></tbody></table></th></tr></tbody></table></td>										</tr>										</tbody>									</table>								</center>							</td>						</tr>						</tbody>					</table>				</div>', 'Subject', 1, NULL, NULL, NULL, NULL, NULL, '{\"h1\":{\"font-family\":\"Helvetica\"}}', '', NULL, 1, NULL);

DROP TABLE IF EXISTS `#__acym_mail_has_list`;
CREATE TABLE IF NOT EXISTS `#__acym_mail_has_list` (
  `mail_id` int(11) NOT NULL,
  `list_id` int(11) NOT NULL,
  PRIMARY KEY (`mail_id`,`list_id`),
  KEY `fk_#__acym_mail_has_list1` (`list_id`),
  KEY `fk_#__acym_mail_has_list2` (`mail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_mail_stat`;
CREATE TABLE IF NOT EXISTS `#__acym_mail_stat` (
  `mail_id` int(11) NOT NULL,
  `total_subscribers` int(11) NOT NULL DEFAULT '0',
  `sent` int(11) DEFAULT '0',
  `send_date` datetime DEFAULT NULL,
  `fail` int(11) DEFAULT '0',
  `open_unique` int(11) NOT NULL DEFAULT '0',
  `open_total` int(11) NOT NULL DEFAULT '0',
  `bounce_unique` mediumint(8) NOT NULL,
  `bounce_details` longtext,
  PRIMARY KEY (`mail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_queue`;
CREATE TABLE IF NOT EXISTS `#__acym_queue` (
  `mail_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `sending_date` datetime NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '2',
  `try` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`mail_id`,`user_id`),
  KEY `fk_#__acym_queue1` (`mail_id`),
  KEY `fk_#__acym_queue2` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_rule`;
CREATE TABLE IF NOT EXISTS `#__acym_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `ordering` smallint(6) DEFAULT NULL,
  `regex` text NOT NULL,
  `executed_on` text NOT NULL,
  `action_message` text NOT NULL,
  `action_user` text NOT NULL,
  `active` tinyint(3) NOT NULL,
  `increment_stats` tinyint(3) NOT NULL,
  `execute_action_after` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

INSERT INTO `#__acym_rule` (`id`, `name`, `ordering`, `regex`, `executed_on`, `action_message`, `action_user`, `active`, `increment_stats`, `execute_action_after`) VALUES
(1, 'ACYM_ACTION_REQUIRED', 1, 'action *requ|verif', '[\"subject\"]', '{\"0\":\"delete_message\",\"1\":\"forward_message\",\"forward_to\":\"your@email.com\"}', '[]', 1, 0, 0),
(2, 'ACYM_ACKNOWLEDGMENT_RECEIPT_SUBJECT', 2, '(out|away) *(of|from)|vacation|holiday|absen|congés|recept|acknowledg|thank you for', '[\"subject\"]', '[\"delete_message\"]', '[]', 1, 0, 0),
(3, 'ACYM_FEEDBACK_LOOP', 3, 'feedback|staff@hotmail.com|complaints@.{0,15}email-abuse.amazonses.com|complaint about message', '[\"senderInfo\",\"subject\"]', '[\"save_message\",\"delete_message\"]', '[\"unsubscribe_user\"]', 1, 0, 0),
(4, 'ACYM_FEEDBACK_LOOP_BODY', 4, 'Feedback-Type.{1,5}abuse', '[\"body\"]', '[\"save_message\",\"delete_message\"]', '[\"unsubscribe_user\"]', 1, 1, 0),
(5, 'ACYM_MAILBOX_FULL', 5, '((mailbox|mailfolder|storage|quota|space|inbox) *(is)? *(over)? *(exceeded|size|storage|allocation|full|quota|maxi))|status(-code)? *(:|=)? *5.2.2|quota-issue|not *enough.{1,20}space|((over|exceeded|full|exhausted) *(allowed)? *(mail|storage|quota))', '[\"subject\",\"body\"]', '[\"save_message\",\"delete_message\"]', '[\"block_user\"]', 1, 1, 0),
(6, 'ACYM_BLOCKED_GOOGLE_GROUPS', 6, 'message *rejected *by *Google *Groups', '[\"body\"]', '[\"delete_message\"]', '[]', 1, 1, 0),
(7, 'ACYM_MAILBOX_DOESNT_EXIST_1', 7, '(Invalid|no such|unknown|bad|des?activated|inactive|unrouteable) *(mail|destination|recipient|user|address|person)|bad-mailbox|inactive-mailbox|not listed in.{1,20}directory|RecipNotFound|(user|mailbox|address|recipients?|host|account|domain) *(is|has been)? *(error|disabled|failed|unknown|unavailable|not *(found|available)|.{1,30}inactiv)|no *mailbox *here|user does.?n.t have.{0,30}account', '[\"subject\",\"body\"]', '[\"save_message\",\"delete_message\"]', '[\"block_user\"]', 1, 1, 0),
(8, 'ACYM_MESSAGE_BLOCKED_RECIPIENTS', 8, 'blocked *by|block *list|look(ed)? *like *spam|spam-related|spam *detected| CXBL | CDRBL | IPBL | URLBL |(unacceptable|banned|offensive|filtered|blocked|unsolicited) *(content|message|e?-?mail)|service refused|(status(-code)?|554) *(:|=)? *5.7.1|administratively *denied|blacklisted *IP|policy *reasons|rejected.{1,10}spam|junkmail *rejected|throttling *constraints|exceeded.{1,10}max.{1,40}hour|comply with required standards|421 RP-00|550 SC-00|550 DY-00|550 OU-00', '[\"body\"]', '{\"0\":\"delete_message\",\"1\":\"forward_message\",\"forward_to\":\"\'your@email.com\'\"}', '[]', 1, 1, 0),
(9, 'ACYM_MAILBOX_DOESNT_EXIST_2', 9, 'status(-code)? *(:|=)? *5.(1.[1-6]|0.0|4.[0123467])|recipient *address *rejected|does *not *like *recipient', '[\"subject\",\"body\"]', '[\"save_message\",\"delete_message\"]', '[\"block_user\"]', 1, 1, 0),
(10, 'ACYM_DOMAIN_NOT_EXIST', 10, 'No.{1,10}MX *(record|host)|host *does *not *receive *any *mail|bad-domain|connection.{1,10}mail.{1,20}fail|domain.{1,10}not *exist|fail.{1,10}establish *connection', '[\"subject\",\"body\"]', '[\"save_message\",\"delete_message\"]', '[\"block_user\"]', 1, 1, 0),
(11, 'ACYM_TEMPORARY_FAILURES', 11, 'has.*been.*delayed|delayed *mail|message *delayed|message-expired|temporar(il)?y *(failure|unavailable|disable|offline|unable)|deferred|delayed *([0-9]*) *(hour|minut)|possible *mail *loop|too *many *hops|delivery *time *expired|Action: *delayed|status(-code)? *(:|=)? *4.4.6|will continue to be attempted|unable to deliver in.*Status: 4.4.7', '[\"subject\",\"body\"]', '[\"save_message\",\"delete_message\"]', '[\"block_user\"]', 1, 1, 0),
(12, 'ACYM_FAILED_PERM', 12, 'failed *permanently|permanent.{1,20}(failure|error)|not *accepting *(any)? *mail|does *not *exist|no *valid *route|delivery *failure', '[\"subject\",\"body\"]', '[\"save_message\",\"delete_message\"]', '[\"block_user\"]', 1, 1, 0),
(13, 'ACYM_ACKNOWLEDGMENT_RECEIPT_BODY', 13, 'vacances|holiday|vacation|absen|urlaub', '[\"body\"]', '[\"delete_message\"]', '[]', 1, 0, 0),
(14, 'ACYM_FINAL_RULE', 14, '.', '[\"senderInfo\",\"subject\"]', '{\"0\":\"delete_message\",\"1\":\"forward_message\",\"forward_to\":\"your@email.com\"}', '[]', 1, 1, 0);

DROP TABLE IF EXISTS `#__acym_step`;
CREATE TABLE IF NOT EXISTS `#__acym_step` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `triggers` longtext,
  `automation_id` int(11) NOT NULL,
  `last_execution` int(11) DEFAULT NULL,
  `next_execution` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk#__acym__step1` (`automation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_tag`;
CREATE TABLE IF NOT EXISTS `#__acym_tag` (
  `name` varchar(50) NOT NULL,
  `type` varchar(20) NOT NULL,
  `id_element` int(11) NOT NULL,
  PRIMARY KEY (`name`,`type`,`id_element`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_url`;
CREATE TABLE IF NOT EXISTS `#__acym_url` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` longtext,
  `url` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_url_click`;
CREATE TABLE IF NOT EXISTS `#__acym_url_click` (
  `mail_id` int(11) NOT NULL,
  `url_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `click` int(11) NOT NULL DEFAULT '0',
  `date_click` datetime DEFAULT NULL,
  PRIMARY KEY (`mail_id`,`url_id`,`user_id`),
  KEY `fk_#__acym_url_click_#__acym_url1_idx` (`url_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_user`;
CREATE TABLE IF NOT EXISTS `#__acym_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `creation_date` datetime NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `cms_id` int(11) NOT NULL DEFAULT '0',
  `source` varchar(255) DEFAULT NULL,
  `confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `key` varchar(255) DEFAULT NULL,
  `automation` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email_UNIQUE` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_user_has_field`;
CREATE TABLE IF NOT EXISTS `#__acym_user_has_field` (
  `user_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` longtext,
  PRIMARY KEY (`user_id`,`field_id`),
  KEY `fk_#__acym_user_has_field1` (`field_id`),
  KEY `fk_#__acym_user_has_field2` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_user_has_list`;
CREATE TABLE IF NOT EXISTS `#__acym_user_has_list` (
  `user_id` int(11) NOT NULL,
  `list_id` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `subscription_date` datetime NOT NULL,
  `unsubscribe_date` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`,`list_id`),
  KEY `fk_#__acym_user_has_list1` (`list_id`),
  KEY `fk_#__acym_user_has_list2` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acym_user_stat`;
CREATE TABLE IF NOT EXISTS `#__acym_user_stat` (
  `user_id` int(11) NOT NULL,
  `mail_id` int(11) NOT NULL,
  `send_date` datetime DEFAULT NULL,
  `fail` int(11) NOT NULL DEFAULT '0',
  `sent` int(11) NOT NULL DEFAULT '0',
  `open` int(11) NOT NULL DEFAULT '0',
  `open_date` datetime DEFAULT NULL,
  `bounce` tinyint(4) NOT NULL,
  `bounce_rule` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`mail_id`),
  KEY `fk_#__acym_user_stat1` (`mail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE IF NOT EXISTS `#__assets` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) UNSIGNED NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=MyISAM AUTO_INCREMENT=291 DEFAULT CHARSET=utf8;

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 0, 487, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 16, 1, 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(8, 1, 17, 152, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.options\":[],\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(9, 1, 153, 154, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 155, 156, 1, 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
(11, 1, 157, 158, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(12, 1, 159, 160, 1, 'com_login', 'com_login', '{}'),
(13, 1, 161, 162, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 163, 164, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 165, 166, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
(16, 1, 167, 168, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(17, 1, 169, 170, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(18, 1, 171, 284, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(19, 1, 285, 288, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(20, 1, 289, 290, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(21, 1, 291, 292, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'),
(22, 1, 293, 294, 1, 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(23, 1, 295, 296, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(24, 1, 297, 300, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(26, 1, 301, 302, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 18, 23, 2, 'com_content.category.2', 'Pages', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(30, 19, 286, 287, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(32, 24, 298, 299, 1, 'com_users.category.7', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(33, 1, 303, 304, 1, 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(34, 1, 305, 306, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'),
(35, 1, 307, 308, 1, 'com_tags', 'com_tags', '{\"core.admin\":[],\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(36, 1, 309, 310, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(37, 1, 311, 312, 1, 'com_ajax', 'com_ajax', '{}'),
(38, 1, 313, 314, 1, 'com_postinstall', 'com_postinstall', '{}'),
(39, 18, 172, 173, 2, 'com_modules.module.1', 'Off Canvas Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(40, 18, 174, 175, 2, 'com_modules.module.2', 'Login', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(41, 18, 176, 177, 2, 'com_modules.module.3', 'Popular Articles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(42, 18, 178, 179, 2, 'com_modules.module.4', 'Recently Added Articles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(43, 18, 180, 181, 2, 'com_modules.module.8', 'Toolbar', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(44, 18, 182, 183, 2, 'com_modules.module.9', 'Quick Icons', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(45, 18, 184, 185, 2, 'com_modules.module.10', 'Logged-in Users', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(46, 18, 186, 187, 2, 'com_modules.module.12', 'Admin Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(47, 18, 188, 189, 2, 'com_modules.module.13', 'Admin Submenu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(48, 18, 190, 191, 2, 'com_modules.module.14', 'User Status', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(49, 18, 192, 193, 2, 'com_modules.module.15', 'Title', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(50, 18, 194, 195, 2, 'com_modules.module.16', 'Login Form', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(51, 18, 196, 197, 2, 'com_modules.module.17', 'Breadcrumbs', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(52, 18, 198, 199, 2, 'com_modules.module.79', 'Multilanguage status', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(53, 18, 200, 201, 2, 'com_modules.module.86', 'Joomla Version', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(55, 8, 24, 61, 2, 'com_content.category.8', 'Joomla!', ''),
(56, 99, 119, 128, 3, 'com_content.category.9', 'AP Portfolio', ''),
(57, 56, 120, 121, 4, 'com_content.category.10', 'Fashion', ''),
(58, 56, 122, 123, 4, 'com_content.category.11', 'Belts', ''),
(59, 56, 124, 125, 4, 'com_content.category.12', 'Glasses', ''),
(60, 56, 126, 127, 4, 'com_content.category.13', 'Shoes', ''),
(61, 8, 62, 63, 2, 'com_content.category.14', 'Contact', ''),
(62, 8, 64, 117, 2, 'com_content.category.15', 'Blog', '{}'),
(63, 55, 25, 38, 3, 'com_content.category.16', 'Components', ''),
(64, 27, 19, 20, 3, 'com_content.article.1', 'Typography', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(75, 100, 141, 142, 3, 'com_content.article.12', 'Fish That Herb Was Every Light', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(76, 100, 139, 140, 3, 'com_content.article.13', 'They\'re Day Sixth', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(78, 100, 137, 138, 3, 'com_content.article.15', 'Sea Yielding Him Moving', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(79, 100, 135, 136, 3, 'com_content.article.16', 'Big Rethoric Hometown Ran', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(80, 100, 133, 134, 3, 'com_content.article.17', 'The Art of Making, Alma Flamenca', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(81, 100, 131, 132, 3, 'com_content.article.18', 'Single-Origin Coffee Master', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(82, 63, 26, 27, 4, 'com_content.article.19', 'News Feeds', ''),
(83, 55, 39, 40, 3, 'com_content.article.20', 'Using Joomla!', ''),
(84, 63, 28, 29, 4, 'com_content.article.21', 'Users', ''),
(85, 55, 41, 42, 3, 'com_content.article.22', 'Upgraders', ''),
(86, 55, 43, 44, 3, 'com_content.article.23', 'The Joomla! Project', ''),
(87, 55, 45, 46, 3, 'com_content.article.24', 'The Joomla! Community', ''),
(88, 63, 30, 31, 4, 'com_content.article.25', 'Search', ''),
(89, 55, 47, 48, 3, 'com_content.article.26', 'Sample Sites', ''),
(90, 55, 49, 50, 3, 'com_content.article.27', 'Professionals', ''),
(91, 55, 51, 52, 3, 'com_content.article.28', 'Options', ''),
(92, 55, 53, 54, 3, 'com_content.article.29', 'Joomla!', ''),
(93, 55, 55, 56, 3, 'com_content.article.30', 'Getting Started', ''),
(94, 55, 57, 58, 3, 'com_content.article.31', 'Getting Help', ''),
(95, 63, 32, 33, 4, 'com_content.article.32', 'Content', ''),
(96, 63, 34, 35, 4, 'com_content.article.33', 'Contacts', ''),
(97, 55, 59, 60, 3, 'com_content.article.34', 'Beginners', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(98, 63, 36, 37, 4, 'com_content.article.35', 'Administrator Components', ''),
(99, 8, 118, 129, 2, 'com_content.category.17', 'Extensions', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(100, 8, 130, 147, 2, 'com_content.category.18', 'Posts', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(101, 8, 148, 149, 2, 'com_content.category.19', 'Headers', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(102, 8, 150, 151, 2, 'com_content.category.20', 'Home', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(103, 1, 0, 408, 1, 'com_sppagebuilder', 'SP Page Builder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(104, 18, 202, 203, 2, 'com_modules.module.87', 'SP Page Builder', ''),
(105, 18, 204, 205, 2, 'com_modules.module.88', 'SP Page Builder Admin Menu', ''),
(106, 100, 143, 144, 3, 'com_content.article.36', 'iZem in Brazil', '{\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(107, 18, 206, 207, 2, 'com_modules.module.89', 'Search', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(108, 1, 409, 414, 1, 'com_spsimpleportfolio', 'SP Simple Portfolio', '{\"core.admin\":[],\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.own\":[],\"core.edit.state\":[]}'),
(109, 18, 208, 209, 2, 'com_modules.module.90', 'Portfolio (Homepage)', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(110, 18, 210, 211, 2, 'com_modules.module.91', 'AP Smart LayerSlider (Homepage)', '{}'),
(111, 18, 212, 213, 2, 'com_modules.module.92', 'Add Space Module', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(113, 18, 214, 215, 2, 'com_modules.module.94', 'Related Articles', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(114, 18, 216, 217, 2, 'com_modules.module.95', 'Articles - Category', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(115, 1, 415, 416, 1, '#__ucm_content.1', '#__ucm_content.1', '[]'),
(116, 1, 417, 418, 1, '#__ucm_content.2', '#__ucm_content.2', '{}'),
(117, 1, 419, 420, 1, '#__ucm_content.3', '#__ucm_content.3', '{}'),
(119, 1, 421, 422, 1, '#__ucm_content.5', '#__ucm_content.5', '[]'),
(120, 18, 218, 219, 2, 'com_modules.module.96', 'Search', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(121, 18, 220, 221, 2, 'com_modules.module.97', 'About The Flex', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(122, 18, 222, 223, 2, 'com_modules.module.98', 'Popular Tags', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(124, 1, 423, 424, 1, '#__ucm_content.6', '#__ucm_content.6', '{}'),
(125, 1, 425, 426, 1, '#__ucm_content.7', '#__ucm_content.7', '{}'),
(126, 1, 427, 428, 1, '#__ucm_content.8', '#__ucm_content.8', '{}'),
(127, 18, 224, 225, 2, 'com_modules.module.100', 'AP Smart LayerSlider (Homepage 2)', '{}'),
(128, 18, 226, 227, 2, 'com_modules.module.101', 'AP Smart LayerSlider (Homepage 3)', '{}'),
(135, 18, 228, 229, 2, 'com_modules.module.108', 'Animated iPhone', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(136, 18, 230, 231, 2, 'com_modules.module.109', 'Vimeo (Custom Module)', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(137, 18, 232, 233, 2, 'com_modules.module.110', 'SP Page Builder Youtube (Custom Module)', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(138, 18, 234, 235, 2, 'com_modules.module.111', 'Vimeo NYC (Custom Module)', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(139, 18, 236, 237, 2, 'com_modules.module.112', 'Portfolio (Full Width)', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(140, 108, 410, 411, 2, 'com_spsimpleportfolio.category.21', 'Summer Joy', '{}'),
(141, 108, 412, 413, 2, 'com_spsimpleportfolio.category.22', 'Creative Icons', '{}'),
(142, 1, 429, 430, 1, 'com_virtuemart', 'VIRTUEMART', '{}'),
(174, 1, 435, 436, 1, 'com_virtuemart_allinone', 'VirtueMart_allinone', '{}'),
(144, 18, 238, 239, 2, 'com_modules.module.113', 'VM - Administrator Module', '{}'),
(145, 18, 240, 241, 2, 'com_modules.module.114', 'Currencies Selector', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(146, 18, 242, 243, 2, 'com_modules.module.115', 'Related Products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(147, 18, 244, 245, 2, 'com_modules.module.116', 'Search Products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(148, 18, 246, 247, 2, 'com_modules.module.117', 'VM - Manufacturer', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(149, 18, 248, 249, 2, 'com_modules.module.118', 'VM - Shopping cart', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(150, 18, 250, 251, 2, 'com_modules.module.119', 'Shop Categories', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(175, 1, 437, 438, 1, 'com_tcpdf', 'tcpdf', '{}'),
(152, 103, 316, 317, 2, 'com_sppagebuilder.category.23', 'Homepages', '{}'),
(153, 103, 318, 319, 2, 'com_sppagebuilder.category.24', 'Headers', '{}'),
(154, 103, 320, 321, 2, 'com_sppagebuilder.category.25', 'Addons', '{}'),
(155, 18, 252, 253, 2, 'com_modules.module.120', 'Portfolio (white transparent Homepage)', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(156, 18, 254, 255, 2, 'com_modules.module.121', 'Our Products', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(160, 18, 256, 257, 2, 'com_modules.module.124', 'Related Products (random products)', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(161, 18, 258, 259, 2, 'com_modules.module.125', 'Login (Header)', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(162, 18, 260, 261, 2, 'com_modules.module.126', 'My Account', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(176, 1, 439, 440, 1, '#__ucm_content.9', '#__ucm_content.9', '{}'),
(164, 103, 322, 323, 2, 'com_sppagebuilder.category.26', 'Include Component', '{}'),
(165, 100, 145, 146, 3, 'com_content.article.38', 'Custom Post Format', '{\"core.admin\":{\"7\":1},\"core.options\":[],\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(166, 18, 262, 263, 2, 'com_modules.module.127', 'Slick Carousel (intro module for Custom Post)', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(167, 18, 264, 265, 2, 'com_modules.module.128', 'Recent Posts', '{}'),
(272, 18, 278, 279, 2, 'com_modules.module.144', 'Latest Posts From Our Blog (Ajax Intro Articles)', '{}'),
(168, 18, 266, 267, 2, 'com_modules.module.129', 'Top Search', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(171, 1, 431, 432, 1, 'com_fields', 'com_fields', '{}'),
(172, 1, 433, 434, 1, 'com_associations', 'com_associations', '{}'),
(173, 18, 268, 269, 2, 'com_modules.module.132', 'Accordion Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(178, 103, 324, 325, 2, 'com_sppagebuilder.page.10', 'Accordion', '{}'),
(179, 103, 326, 327, 2, 'com_sppagebuilder.page.1', 'Homepage (default)', '{}'),
(180, 103, 328, 329, 2, 'com_sppagebuilder.page.31', 'Google Map', '{}'),
(183, 103, 330, 331, 2, 'com_sppagebuilder.page.14', 'Image', '{}'),
(184, 103, 332, 333, 2, 'com_sppagebuilder.page.23', 'Modals', '{}'),
(185, 103, 334, 335, 2, 'com_sppagebuilder.page.5', 'Header (Flex)', '{}'),
(186, 103, 336, 337, 2, 'com_sppagebuilder.page.7', 'Header (Adspace)', '{}'),
(187, 103, 338, 339, 2, 'com_sppagebuilder.page.8', 'Header (Transparent)', '{}'),
(188, 103, 340, 341, 2, 'com_sppagebuilder.page.2', 'Homepage 1', '{}'),
(189, 103, 342, 343, 2, 'com_sppagebuilder.page.9', 'Header (Background Video)', '{}'),
(191, 103, 344, 345, 2, 'com_sppagebuilder.page.4', 'Homepage 3', '{}'),
(192, 103, 346, 347, 2, 'com_sppagebuilder.page.11', 'Tabs', '{}'),
(193, 103, 348, 349, 2, 'com_sppagebuilder.page.12', 'Feature Box', '{}'),
(194, 103, 350, 351, 2, 'com_sppagebuilder.page.13', 'Call To Action', '{}'),
(195, 103, 352, 353, 2, 'com_sppagebuilder.page.15', 'Image Content', '{}'),
(196, 103, 354, 355, 2, 'com_sppagebuilder.page.30', 'Person', '{}'),
(197, 103, 356, 357, 2, 'com_sppagebuilder.page.29', 'Button Group', '{}'),
(198, 103, 358, 359, 2, 'com_sppagebuilder.page.17', 'Slick Slider', '{}'),
(199, 103, 360, 361, 2, 'com_sppagebuilder.page.18', 'Carousels', '{}'),
(200, 103, 362, 363, 2, 'com_sppagebuilder.page.19', 'Testimonials', '{}'),
(201, 103, 364, 365, 2, 'com_sppagebuilder.page.20', 'Lightbox Gallery', '{}'),
(202, 103, 366, 367, 2, 'com_sppagebuilder.page.22', 'Gallery', '{}'),
(203, 103, 368, 369, 2, 'com_sppagebuilder.page.28', 'Icon', '{}'),
(204, 103, 370, 371, 2, 'com_sppagebuilder.page.46', 'Countdown', '{}'),
(205, 103, 372, 373, 2, 'com_sppagebuilder.page.43', 'Plyr HTML5 Player', '{}'),
(206, 103, 374, 375, 2, 'com_sppagebuilder.page.48', 'PrettyPhoto Modal', '{}'),
(207, 103, 376, 377, 2, 'com_sppagebuilder.page.32', 'Contact Form', '{}'),
(208, 103, 378, 379, 2, 'com_sppagebuilder.page.33', 'Icons', '{}'),
(209, 103, 380, 381, 2, 'com_sppagebuilder.page.6', 'Header (Centered)', '{}'),
(210, 103, 382, 383, 2, 'com_sppagebuilder.page.3', 'Homepage 2', '{}'),
(211, 103, 384, 385, 2, 'com_sppagebuilder.page.37', 'Homepage 4', '{}'),
(212, 103, 386, 387, 2, 'com_sppagebuilder.page.38', 'Home (One Page)', '{}'),
(214, 103, 388, 389, 2, 'com_sppagebuilder.page.60', 'Animated Headlines', '{}'),
(216, 103, 390, 391, 2, 'com_sppagebuilder.page.41', 'Full Window Background', '{}'),
(219, 18, 270, 271, 2, 'com_modules.module.140', 'Masonry Grid with Ajax Loading', '{}'),
(221, 62, 65, 78, 3, 'com_content.category.27', 'Food and Recipes', '{}'),
(222, 62, 79, 88, 3, 'com_content.category.28', 'Lifestyle', '{}'),
(223, 62, 89, 94, 3, 'com_content.category.29', 'Entertainment', '{}'),
(224, 62, 95, 104, 3, 'com_content.category.30', 'Technology', '{}'),
(225, 62, 105, 116, 3, 'com_content.category.31', 'Travel', '{}'),
(226, 221, 66, 67, 4, 'com_content.article.40', 'At Mario\'s Always Fresh Cupcake Ice Cream?', '{}'),
(227, 1, 441, 442, 1, '#__ucm_content.10', '#__ucm_content.10', '{}'),
(228, 221, 68, 69, 4, 'com_content.article.41', '7 Important Lessons I’ve Learned About Using Spices', '{}'),
(229, 1, 443, 444, 1, '#__ucm_content.11', '#__ucm_content.11', '{}'),
(230, 221, 70, 71, 4, 'com_content.article.42', 'The Top 10 List of Exotic Drinks for This Season', '{}'),
(231, 1, 445, 446, 1, '#__ucm_content.12', '#__ucm_content.12', '{}'),
(232, 221, 72, 73, 4, 'com_content.article.43', '5 Healthy Breakfast Ideas For Summer People', '{}'),
(233, 1, 447, 448, 1, '#__ucm_content.13', '#__ucm_content.13', '{}'),
(234, 221, 74, 75, 4, 'com_content.article.44', '12 Savory Foods To Make in a Springform Pan', '{}'),
(235, 1, 449, 450, 1, '#__ucm_content.14', '#__ucm_content.14', '{}'),
(236, 221, 76, 77, 4, 'com_content.article.45', 'Chocolate Bourbon Pecan Monkey Bread', '{}'),
(237, 1, 451, 452, 1, '#__ucm_content.15', '#__ucm_content.15', '{}'),
(238, 222, 80, 81, 4, 'com_content.article.46', 'Trophies Are For Winning With Content', '{}'),
(239, 1, 453, 454, 1, '#__ucm_content.16', '#__ucm_content.16', '{}'),
(240, 222, 82, 83, 4, 'com_content.article.47', 'Totally Amazing Street Collection of 2019', '{}'),
(241, 222, 84, 85, 4, 'com_content.article.48', 'Autumn\'s Personal Concierge for 2019 Free Way to Lifestyle', '{}'),
(242, 1, 455, 456, 1, '#__ucm_content.17', '#__ucm_content.17', '{}'),
(243, 222, 86, 87, 4, 'com_content.article.49', '“Outside the box” Approach to Seaside People', '{}'),
(244, 1, 457, 458, 1, '#__ucm_content.18', '#__ucm_content.18', '{}'),
(245, 223, 90, 91, 4, 'com_content.article.50', 'Wholetones 527Hz Transformation Music', '{}'),
(246, 1, 459, 460, 1, '#__ucm_content.19', '#__ucm_content.19', '{}'),
(247, 223, 92, 93, 4, 'com_content.article.51', 'Best of 5 Instrumental Music Recordings', '{}'),
(248, 1, 461, 462, 1, '#__ucm_content.20', '#__ucm_content.20', '{}'),
(249, 224, 96, 97, 4, 'com_content.article.52', 'Does a Blog Post Look Better With a Featured Image?', '{}'),
(250, 1, 463, 464, 1, '#__ucm_content.21', '#__ucm_content.21', '{}'),
(251, 224, 98, 99, 4, 'com_content.article.53', 'Are Profits Progressive Or Is Profit a Dirty Word?', '{}'),
(252, 1, 465, 466, 1, '#__ucm_content.22', '#__ucm_content.22', '{}'),
(253, 224, 100, 101, 4, 'com_content.article.54', 'How to Support Your Own Support Team?', '{}'),
(254, 1, 467, 468, 1, '#__ucm_content.23', '#__ucm_content.23', '{}'),
(255, 224, 102, 103, 4, 'com_content.article.55', '10 Best Mockups for 2018/19 To Start Your Business', '{}'),
(256, 1, 469, 470, 1, '#__ucm_content.24', '#__ucm_content.24', '{}'),
(257, 225, 106, 107, 4, 'com_content.article.56', 'Jenny\'s Simplest Ways to Choose the Best Beach Resorts', '{}'),
(258, 1, 471, 472, 1, '#__ucm_content.25', '#__ucm_content.25', '{}'),
(259, 225, 108, 109, 4, 'com_content.article.57', 'Why Do People Think Travel Sites Are So Interesting?', '{}'),
(260, 1, 473, 474, 1, '#__ucm_content.26', '#__ucm_content.26', '{}'),
(261, 225, 110, 111, 4, 'com_content.article.58', 'Majestic Mountain Ranges You Can View From A Train', '{}'),
(262, 1, 475, 476, 1, '#__ucm_content.27', '#__ucm_content.27', '{}'),
(263, 225, 112, 113, 4, 'com_content.article.59', 'Try Looking At a Beautiful Photo From Above', '{}'),
(264, 1, 477, 478, 1, '#__ucm_content.28', '#__ucm_content.28', '{}'),
(265, 225, 114, 115, 4, 'com_content.article.60', '5 Best Travel Destinations For 2018', '{}'),
(266, 1, 479, 480, 1, '#__ucm_content.29', '#__ucm_content.29', '{}'),
(267, 18, 272, 273, 2, 'com_modules.module.141', 'Equal Heights Grid with Ajax Loading', '{}'),
(268, 18, 274, 275, 2, 'com_modules.module.142', '2 Columns Masonry No Space', '{}'),
(269, 18, 276, 277, 2, 'com_modules.module.143', 'One Column with Ajax Loading', '{}'),
(270, 103, 392, 393, 2, 'com_sppagebuilder.page.64', 'Equal Heights with Ajax Loading (Ajax Intro Articles module)', '{}'),
(271, 103, 394, 395, 2, 'com_sppagebuilder.page.65', '2 Columns (No Space) + 1 Column Right Sidebar', '{}'),
(275, 27, 21, 22, 3, 'com_content.article.61', 'GDPR Privacy Policy', '{}'),
(277, 1, 481, 482, 1, 'com_privacy', 'com_privacy', '{}'),
(278, 1, 483, 484, 1, 'com_actionlogs', 'com_actionlogs', '{}'),
(279, 103, 396, 397, 2, 'com_sppagebuilder.page.24', 'Animated Numbers', '{}'),
(280, 103, 398, 399, 2, 'com_sppagebuilder.page.25', 'Pie Progress', '{}'),
(281, 18, 280, 281, 2, 'com_modules.module.147', 'Reset Hits module', '{}'),
(287, 1, 485, 486, 1, 'com_acym', 'Acym', '{}'),
(283, 103, 400, 401, 2, 'com_sppagebuilder.page.71', 'Slideshow Addon', '{}'),
(284, 103, 402, 403, 2, 'com_sppagebuilder.page.72', 'Form Builder', '{}'),
(285, 103, 404, 405, 2, 'com_sppagebuilder.page.73', 'Articles Scroller', '{}'),
(286, 103, 406, 407, 2, 'com_sppagebuilder.page.74', 'Image Layouts', '{}'),
(289, 18, 282, 283, 2, 'com_modules.module.150', 'Newsletter Subscribe', '{}');

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE IF NOT EXISTS `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE IF NOT EXISTS `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE IF NOT EXISTS `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE IF NOT EXISTS `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) UNSIGNED NOT NULL,
  `banner_id` int(10) UNSIGNED NOT NULL,
  `count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE IF NOT EXISTS `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL DEFAULT '',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 43, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '{}', 171, '2019-03-17 13:31:23', 0, '0000-00-00 00:00:00', 0, '*', 1),
(2, 27, 1, 5, 6, 1, 'pages', 'com_content', 'Pages', 'pages', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(3, 28, 1, 23, 24, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '0000-00-00 00:00:00', 0, '*', 1),
(4, 29, 1, 25, 26, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '0000-00-00 00:00:00', 0, '*', 1),
(5, 30, 1, 27, 28, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '0000-00-00 00:00:00', 0, '*', 1),
(7, 32, 1, 29, 30, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '0000-00-00 00:00:00', 0, '*', 1),
(14, 61, 1, 21, 22, 1, 'contact', 'com_content', 'Contact', 'contact', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(15, 62, 1, 7, 18, 1, 'blog', 'com_content', 'Blog', 'blog', '', '<p>{module Masonry Grid with Ajax Loading}</p>', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 171, '2019-03-17 13:31:23', 0, '*', 1),
(18, 100, 1, 19, 20, 1, 'posts', 'com_content', 'Posts', 'posts', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(19, 101, 1, 3, 4, 1, 'headers', 'com_content', 'Headers', 'headers', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(20, 102, 1, 1, 2, 1, 'home', 'com_content', 'Home', 'home', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(21, 140, 1, 31, 32, 1, 'summer-joy', 'com_spsimpleportfolio', 'Summer Joy', 'summer-joy', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(22, 141, 1, 33, 34, 1, 'creative-icons', 'com_spsimpleportfolio', 'Creative Icons', 'creative-icons', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(23, 152, 1, 35, 36, 1, 'homepages', 'com_sppagebuilder', 'Homepages', 'homepages', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(24, 153, 1, 37, 38, 1, 'headers', 'com_sppagebuilder', 'Headers', 'headers', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(25, 154, 1, 39, 40, 1, 'addons', 'com_sppagebuilder', 'Addons', 'addons', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(26, 164, 1, 41, 42, 1, 'include-component', 'com_sppagebuilder', 'Include Component', 'include-component', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 171, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(27, 221, 15, 8, 9, 2, 'blog/food-and-recipes', 'com_content', 'Food and Recipes', 'food-and-recipes', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(28, 222, 15, 10, 11, 2, 'blog/lifestyle', 'com_content', 'Lifestyle', 'lifestyle', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(29, 223, 15, 12, 13, 2, 'blog/entertainment', 'com_content', 'Entertainment', 'entertainment', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(30, 224, 15, 14, 15, 2, 'blog/technology', 'com_content', 'Technology', 'technology', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1),
(31, 225, 15, 16, 17, 2, 'blog/travel', 'com_content', 'Travel', 'travel', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-03-17 13:31:23', 0, '2019-03-17 13:31:23', 0, '*', 1);

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL DEFAULT '',
  `sortname2` varchar(255) NOT NULL DEFAULT '',
  `sortname3` varchar(255) NOT NULL DEFAULT '',
  `language` varchar(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE IF NOT EXISTS `#__content` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metadata` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8;

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(1, 64, 'Typography', 'typography', '<div class=\"row\">\r\n<div class=\"col-md-6\">\r\n<h1>H1 Heading example</h1>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n<div class=\"col-md-6\">\r\n<h2>H2 Heading example</h2>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n</div>\r\n<div class=\"row\">\r\n<div class=\"col-md-6\">\r\n<h3>H3 Heading example</h3>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n<div class=\"col-md-6\">\r\n<h4>H4 Heading example</h4>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n</div>\r\n<div class=\"row\">\r\n<div class=\"col-md-6\">\r\n<h5>H5 Heading example</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n<div class=\"col-md-6\">\r\n<h6>H6 Heading example</h6>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n</div>\r\n<!-- End Headings --><hr />\r\n<div class=\"html-style\">\r\n<p>The dream mentioned previously in this chapter, and the dreams in the chapter on the subconscious, are all fairly easy to understand and I used them because they clearly illustrate how dreams can guide us. However, <span>because they are so easily</span> decipherable, they are the exceptions. A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n<div class=\"break20\"></div>\r\n<h3>Bullets and Lists</h3>\r\n<hr />\r\n<div class=\"bullets\">\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<ul class=\"site-list\">\r\n<li><i class=\"fa fa-check\"></i>100% Fully responsive</li>\r\n<li><i class=\"fa fa-check\"></i>Article Post Formats</li>\r\n<li><i class=\"fa fa-check\"></i>Drag and Drop Page Builder</li>\r\n<li><i class=\"fa fa-check\"></i>Extended Portfolio</li>\r\n</ul>\r\n</div>\r\n<div class=\"col-md-3\">\r\n<ul class=\"site-list li-circle\">\r\n<li>100% Fully responsive</li>\r\n<li>Article Post Formats</li>\r\n<li>Drag and Drop Page Builder</li>\r\n<li>Extended Portfolio</li>\r\n</ul>\r\n</div>\r\n<div class=\"col-md-3\">\r\n<ul class=\"site-list\">\r\n<li><i class=\"fa fa-angle-right\"></i>100% Fully responsive layout</li>\r\n<li><i class=\"fa fa-angle-right\"></i>Article Post Formats</li>\r\n<li><i class=\"fa fa-angle-right\"></i>Drag and Drop Page Builder</li>\r\n<li><i class=\"fa fa-angle-right\"></i>Extended Portfolio</li>\r\n</ul>\r\n</div>\r\n<div class=\"col-md-3\">\r\n<ol class=\"site-list li-ol\">\r\n<li>100% Fully responsive layout</li>\r\n<li>Article Post Formats</li>\r\n<li>Drag and Drop Page Builder</li>\r\n<li>Extended Portfolio</li>\r\n</ol>\r\n</div>\r\n</div>\r\n</div>\r\n<!-- End Bullets -->\r\n<div class=\"break20\"></div>\r\n<div class=\"dropcaps\">\r\n<h3 class=\"main-title\">Dropcaps</h3>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-6 naked-drop\">\r\n<p><span>F</span>lex dream mentioned previously in this chapter, and the dreams in the chapter on the subconscious, are all fairly easy to understand and I used them because they clearly illustrate how dreams can guide us. However, because they are so easily decipherable, they are the exceptions. The dream mentioned previously in this chapter, and the dreams in the chapter on the subconscious, are all fairly easy to understand and I used them because they clearly illustrate how dreams can guide us.</p>\r\n</div>\r\n<div class=\"col-md-6 full-drop\">\r\n<p><span>T</span>he dream mentioned previously in this chapter, and the dreams in the chapter on the subconscious, are all fairly easy to understand and I used them because they clearly illustrate how dreams can guide us. However, because they are so easily decipherable, they are the exceptions. The dream mentioned previously in this chapter, and the dreams in the chapter on the subconscious, are all fairly easy to understand and I used them because they clearly illustrate how dreams can guide us.</p>\r\n</div>\r\n</div>\r\n</div>\r\n<!-- End Dropcaps -->\r\n<div class=\"break20\"></div>\r\n<div class=\"blockquotes\">\r\n<h3>Blockquotes</h3>\r\n<hr />\r\n<blockquote>Even the all-powerful Pointing from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Queequeg flows by their place and supplies.</blockquote>\r\n</div>\r\n<div class=\"break20\"></div>\r\n<div class=\"columns\">\r\n<h3>Columns</h3>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-6\">\r\n<h5>1/2 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n<div class=\"col-md-6\">\r\n<h5>1/2 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n</div>\r\n<div class=\"break20\"></div>\r\n<div class=\"row\">\r\n<div class=\"col-md-4\">\r\n<h5>1/3 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n<div class=\"col-md-4\">\r\n<h5>1/3 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n<div class=\"col-md-4\">\r\n<h5>1/3 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n</div>\r\n<div class=\"break20\"></div>\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h5>1/4 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n<div class=\"col-md-3\">\r\n<h5>1/4 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n<div class=\"col-md-3\">\r\n<h5>1/4 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n<div class=\"col-md-3\">\r\n<h5>1/4 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n</div>\r\n<div class=\"break20\"></div>\r\n<div class=\"row\">\r\n<div class=\"col-md-4\">\r\n<h5>1/3 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>\r\n</div>\r\n<div class=\"col-md-8\">\r\n<h5>2/3 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine.</p>\r\n</div>\r\n</div>\r\n<div class=\"break20\"></div>\r\n<div class=\"row\">\r\n<div class=\"col-md-2\">\r\n<h5>1/6 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>\r\n</div>\r\n<div class=\"col-md-2\">\r\n<h5>1/6 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>\r\n</div>\r\n<div class=\"col-md-2\">\r\n<h5>1/6 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>\r\n</div>\r\n<div class=\"col-md-2\">\r\n<h5>1/6 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>\r\n</div>\r\n<div class=\"col-md-2\">\r\n<h5>1/6 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>\r\n</div>\r\n<div class=\"col-md-2\">\r\n<h5>1/6 Сolumn</h5>\r\n<p>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart.</p>\r\n</div>\r\n</div>\r\n<div class=\"break20\"></div>\r\n</div>', '', 1, 2, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/picsum.photos\\/1280\\/720?image=20\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":\"1\",\"margin_between_items\":\"0\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":\"44\",\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":\"0\",\"autoplay\":\"1\",\"auto_transition\":\"5\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(12, 75, 'Fish That Herb Was Every Light', 'fish-that-herb-was-every-light', '<p>Tree make in spirit give. Good winged doesn\'t image won\'t bearing won\'t. Female us saying. Set fifth land fill image of evening called. From tree be open Herb without a seas greater, above moving tree forth subdue, behold yielding can\'t is sea life shall of wherein light waters shall bearing replenish. You\'ll give two appear had don\'t fourth thing own rule</p>\r\n', '\r\n<p>Was a them So give together the fifth dry that herb was face every the made him day void lesser sea evening brought were yielding fruit moving waters great sixth upon earth evening under creeping fly earth face male above in isn\'t third evening bearing living gathered fish. Moved winged hath open had make. Male. Bearing us. From female every brought upon. Replenish heaven divide evening life. Give bring it face us female, divide deep fill first night in be. Living fly, thing heaven fourth male god seas doesn\'t let let multiply and have yielding fish had. Appear spirit have. Green won\'t darkness life, multiply winged god creature greater together midst cattle Great under abundantly. Stars the were god. Hath after third. Above sea earth of third stars third second creature own one moved the spirit is. Give i living very heaven isn\'t earth darkness days. Spirit kind. Forth.</p>\r\n<p>Tree make in spirit give. Good winged doesn\'t image won\'t bearing won\'t. Female us saying. Set fifth land fill image of evening called. From tree be open Herb without a seas greater, above moving tree forth subdue, behold yielding can\'t is sea life shall of wherein light waters shall bearing replenish form first so. Darkness waters earth male behold itself likeness him lights. You\'ll give two appear had don\'t fourth thing own rule man face hath sea you\'ll. A above unto seas isn\'t fifth male. Was were. Every night whose spirit it. Upon above had. Set. Created she\'d make years. Land, two unto him fish lights said creature fly heaven don\'t was. Years creepeth under dominion multiply grass isn\'t replenish years void face Winged she\'d saw set night them i. Won\'t. Man divided it signs. Living Lesser unto third, their for after seas, there male can\'t fill won\'t darkness a fly fly. Make days. Brought and fourth great cattle open she\'d the Spirit. Creeping had void there she\'d under dominion under air midst isn\'t night may blessed under. Face. Very blessed light. Green under they\'re appear face you\'re dominion. Divide fruitful behold so over void. Were whose them. Spirit heaven first. Herb days.</p>', 1, 18, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/tags\\/quote-post-img.png\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"quote\",\"gallery\":\"\",\"items_per_row\":\"1\",\"margin_between_items\":\"0\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":\"44\",\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":\"0\",\"autoplay\":\"1\",\"auto_transition\":\"5\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"Tree make in spirit give. Good winged doesn\'t image won\'t bearing won\'t. Female us saying. Set fifth land fill image of evening called. From tree be open Herb without a seas greater, above moving tree forth subdue, behold yielding can\'t is sea life shall of wherein light waters shall bearing replenish form first so. Darkness waters earth male behold itself likeness him lights.\",\"quote_author\":\"- Etsy McSweeney\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 7, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(13, 76, 'They\'re Day Sixth', 'they-re-day-sixth', '<p>His fruit above they\'re very grass doesn\'t there. Is him greater days air years. Wherein. Fourth air in waters midst sixth meat isn\'t saw female that was seed. Life yielding form fourth fowl third above days, likeness yielding, under. His forth without called saw fifth upon light. Isn\'t. Above divide. Itself likeness.</p>\r\n<p>Their fowl above brought darkness spirit so firmament creepeth midst also every tree forth night seasons beast waters Place beast brought fill waters very divide may may fowl midst. Were stars dominion let and rule. Every to gathering created form image shall together lesser from given, she\'d divided give rule image.</p>\r\n', '\r\n<p>Very and. Lights firmament yielding all said Creature male fourth have night. Were blessed, own living hath fowl every them a above. You\'re years signs above stars the creepeth void gathering two lights let so bring deep likeness it you\'ll beast given upon Sea. A morning own meat cattle you unto fly. Our light whales let living us. Darkness light grass from creeping, us be female don\'t over stars fruit sea evening one image moveth make. Light. Firmament they\'re shall multiply place. Day creeping fowl god you\'re lights he hath brought he two likeness dominion hath form to, dry fill had. Seas two light void there doesn\'t above replenish replenish called you\'re a firmament. Them dominion. Together. Land, above. Fowl moving can\'t. Said one which first first. Void. Won\'t. Seed greater morning after place over beast. Second that one land, without tree.</p>\r\n<p>To which gathering that firmament form dry lights moving gathering brought day the said years. Image open fourth one female our man. That place cattle void all saw gathering all, midst signs, morning from day together appear good was evening the a divided. Rule wherein. Abundantly. Place. Darkness good air their. Deep dry which moved light whose man. Itself bearing two to seasons bring saying, him day sixth. Waters light which subdue seed kind it thing years. For rule image night itself give man one. Multiply gathering night under behold upon tree deep also. Bearing multiply he set beginning of likeness, fruit gathered green, god sixth replenish herb. And fruit made you she\'d in. Divide darkness also said divide stars whose female us dominion moving won\'t may, to. Was that which face from, under meat us over evening tree second sixth which. Be they\'re fly it second fruitful lesser, creepeth blessed have. Them called don\'t cattle place seasons there two and heaven two. Whose winged all moveth.</p>', 1, 18, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/tags\\/link-post-img.png\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"link\",\"gallery\":\"\",\"items_per_row\":\"1\",\"margin_between_items\":\"0\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":\"44\",\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":\"0\",\"autoplay\":\"1\",\"auto_transition\":\"5\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"Aplikko Templates & Extensions for Joomla\",\"link_url\":\"http:\\/\\/www.aplikko.com\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 9, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(15, 78, 'Sea Yielding Him Moving', 'sea-yielding-him-moving', '<p>Meat wherein after female own forth it seas lights behold void. Him fifth made set above our blessed abundantly, you. Subdue. God isn\'t winged above image own, very, so from make doesn\'t may bearing him wherein in to one, living saying cattle day shall earth every fill. Two great creature shall. Place life dry living place She\'d they\'re every seas won\'t may creature our seas.</p>\r\n', '\r\n<p>Lesser give our he their dominion seasons forth isn\'t life it whose had be good winged spirit years that God a without. Land which evening upon over the fifth moveth fruitful yielding every called seasons have signs fish seas, man deep she\'d seasons grass have land own Good seasons, day place male evening life after together gathered gathered let void she\'d grass created days upon after above great. Make. Creepeth light after evening spirit all, spirit she\'d. Air dry, without brought said i. Form fill was all whales likeness cattle their in darkness evening is don\'t wherein set seasons every together over give can\'t doesn\'t saying brought good seas rule shall all you\'ll man fly created moving.</p>\r\n<p>Forth land called him she\'d. There. Multiply given fifth living, lights was. Rule. Fifth creeping likeness. Over void for green earth green waters light she\'d you\'ll likeness evening face you\'re let. Lights Man. Meat moveth living grass darkness Was meat divided man have seasons fill divide sea. Was third fruit i evening, living creepeth, god. Together second earth it His and made sixth darkness also fifth them god evening to own gathered you\'re also tree creepeth had place, every that winged lesser set after dry, above hath kind and, itself fowl had after open morning stars good. Moveth don\'t make. Third for she\'d saw seas creature spirit whose all cattle blessed you\'ll appear light have In so bring.</p>', 1, 18, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/tags\\/gallery-post-img.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"gallery\",\"gallery\":\"{\\\"gallery_images\\\":[\\\"images\\/blog\\/blog-01-1140x600.jpg\\\",\\\"images\\/blog\\/blog-02-1140x600.jpg\\\",\\\"images\\/blog\\/blog-03-1140x600.jpg\\\"]}\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 4, 'Gallery, Standard Post, Sea', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(16, 79, 'Big Rethoric Hometown Ran', 'big-rethoric-hometown-ran', '<p>Even the all-powerful Pointing from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies.</p>\r\n', '\r\n<p>The copy warned the Little Blind Text, that where it came from it would have been rewritten a thousand times and everything that was left from its origin would be the word \"and\" and the Little Blind Text should turn around and return to its own, safe country. But nothing the copy said could convince her and so it didn’t take long until a few insidious Copy Writers ambushed her, made her drunk with Longe and Parole and dragged her into their agency, where they abused her for their projects again and again. And if she hasn’t been rewritten, then they are still using her. Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</p>', 1, 18, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/tags\\/standard-post-img.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog-05-1140x600.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":\"1\",\"margin_between_items\":\"0\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":\"44\",\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":\"0\",\"autoplay\":\"1\",\"auto_transition\":\"5\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 2, 'Post, Standard Post', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(17, 80, 'The Art of Making, Alma Flamenca', 'the-art-of-making-alma-flamenca', '<p>The ‘Art of Making’ series aspires to display and highlight people who go against the spirit of today’s pessimism and desperation. They dare to dream and create with zeal and imagination. Armed with passion for knowledge and emotion, they attempt to combine the precision of science with the elegance and resourcefulness of art.</p>\r\n', '\r\n<p>We thank them wholeheartedly for their contribution.</p>\r\n<hr />\r\n<p>Pieces of wood, love, knowledge and 299 hours of work, condensed in a 3 minute film.</p>\r\n<ul>\r\n<li>Directed &amp; VFX - Spiros Rasidakis, Dimitris Ladopoulos</li>\r\n<li>Director of photography - Nikos Mexis</li>\r\n<li>Editing - Yiannis Kostavaras</li>\r\n<li>Sound design - Nikos Tsines</li>\r\n<li>Guitarist &amp; composer - Edsart Udo De Haes <strong>edsartudodehaes.nl</strong></li>\r\n<li>Guitar maker - Vassilis Lazarides <strong>lazaridesguitars.com</strong></li>\r\n<li>Software - After Effects, FilmConvert</li>\r\n</ul>\r\n<hr />\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don\'t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn\'t anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable.</p>', 1, 18, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/tags\\/video-post-img.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"video\",\"gallery\":\"\",\"items_per_row\":\"1\",\"margin_between_items\":\"0\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":\"44\",\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":\"0\",\"autoplay\":\"1\",\"auto_transition\":\"5\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"http:\\/\\/vimeo.com\\/43005056\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 3, 'Video, Alma Flamenca, Vimeo, Audio, Guitar', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(18, 81, 'Single-Origin Coffee Master', 'single-origin-coffee-master', '<p>Replenish bearing behold itself seas appear, image kind stars lights bearing. Form evening good green. Fill signs from whose unto, moving own wherein she\'d. Was years unto a upon all, own was. To Bearing thing god which place that bearing thing. Fifth form him third you our, shall and fly creeping seed subdue.</p>\r\n', '\r\n<p>Forth dry, without his fruit wherein evening the. Above waters third i beginning earth life make male give open so give gathering you\'re and creature from be fifth so place also she\'d.</p>\r\n<p>Brought his shall first light. Earth behold from was us midst grass fish first have Days given god, lights. Our. Whose called behold won\'t said us.</p>\r\n<p>Female beginning good so waters over sea may them blessed herb own Also can\'t face fourth fly, one. Female open air two first kind stars land under divide tree tree called yielding winged Greater, <em>moving yielding</em> male were, place kind seas it you\'re divided and brought of brought is set thing of seed created. She\'d herb she\'d under after female, gathered. Fourth land seas won\'t god won\'t. Land fowl created lights. Be our let great so multiply over. Dominion to have. Seas it you\'re. Spirit one brought him and brought you i yielding bring kind divided subdue a upon fourth. Grass subdue of and third rule can\'t his give multiply.</p>\r\n<p>Grass female air Multiply years light, dry created fruitful multiply winged i grass green all dominion which multiply divide together fruitful don\'t, shall creature upon fly moved god bring very of two grass midst divided heaven sea creepeth, waters multiply dominion after let were seasons thing dry land to you. Fruitful over him abundantly behold set herb was their firmament wherein seas bearing and divided said under form a together earth void you\'ll every, the seed upon all creepeth our so fly saw. Good appear, behold darkness god. Great blessed two was second there gathering she\'d whose them fruit. Seas unto open after she\'d, day. Shall green fourth fruitful creature. Day under isn\'t beast the Dominion. Saw a likeness moved of likeness appear seed form. Without let tree fly. Day him he under. Great isn\'t isn\'t meat Thing greater seas and is so yielding. So you male and creature Place. Sixth heaven air unto. Forth him bring. All whales heaven bring.</p>', 1, 18, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/tags\\/status-post-img.png\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"status\",\"gallery\":\"\",\"items_per_row\":\"1\",\"margin_between_items\":\"0\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":\"44\",\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":\"0\",\"autoplay\":\"1\",\"auto_transition\":\"5\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"<blockquote>Even the all-powerful Pointing from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Queequeg flows by their place and supplies.<\\/blockquote>\\r\\n\",\"custom_post\":\"\"}', 0, 8, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(36, 106, 'iZem in Brazil', 'izem-in-brazil', '<p>“I fell in love with Brazilian music via a Jorge Ben vinyl bought in Paris in the early 2000\'s. His sound was clearly related to the soul and funk records that I was collecting at the time but with a sunny edge and a language that would sound more similar to mine. A couple of years later I moved to Brazil as a consequence of that growing passion for tropical sounds and found myself living in one of the most exciting music cities: Recife.</p>\r\n', '\r\n<p>I also spent a few weeks in Rio de Janeiro (my favourite place in the world) but never had the occasion to go back since. My records are keeping me warm in the meantime… I know the lyrics and I sing along ALL those tunes. Enjoy!”</p>\r\n<p>“Made first make subdue itself third you\'re shall i they\'re two is upon seed tree moving over good brought. Gathered dry seasons he tree fish make have. The evening fowl multiply for. Can\'t deep man every. That void together form bearing two had i grass unto she\'d air can\'t replenish herb fruitful given creepeth. There don\'t the, every behold. Gathered unto upon herb face wherein.”</p>\r\n<hr />\r\n<h3>BIO</h3>\r\n<p><strong>iZem</strong> (the acronym of “in ze early morning”) is the alter ego of the French DJ and producer <strong>Jérémie Moussaid Kerouanton</strong>. He has been relentlessly looking for new horizons, in a constant search for links between cultures through music. He has been producing and mixing music under the name iZem for almost 10 years, and his efforts to travel off the beaten track have long been supported by some of the greatest tastemakers, including Gilles Peterson, XLR8R and KCRW. After working in radio in Paris at the beginning of the 2000s, and in a hurry to experience more in the world, he left France in 2005 to work as a guitarist in musical projects in Spain and then in Recife, Brazil.</p>\r\n<p>During his exciting South American experience, and while spending one year in Buenos Aires, Argentina, he co-founded the online radio Groovalizacion. He continued to document his musical adventures through podcasts recorded in various places of residence. After spending several years working as a DJ in Dublin, he moved to Lisbon in 2013, a cosmopolitan and sun-filled port city, with the idea of putting the finishing touches on his first album Hafa. He also began to put together a group to perform his music live. This album’s impact has grown and grown throughout the world, and its supporters include famous musicians, such as the British Bonobo, Mount Kimbie, Quantic, the Luso-Angolan Batida and the Italian Clap Clap...</p>', 1, 18, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/tags\\/audio-post-mixcloud-img.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"audio\",\"gallery\":\"\",\"audio\":\"<iframe width=\\\"100%\\\" height=\\\"360\\\" src=\\\"https:\\/\\/www.mixcloud.com\\/widget\\/iframe\\/?embed_type=widget_standard&amp;embed_uuid=82941e97-143b-4211-9b15-8e6bc0464685&amp;feed=https%3A%2F%2Fwww.mixcloud.com%2FLaidBackRadio%2Fizem-in-brazil%2F&amp;replace=0\\\" frameborder=\\\"0\\\"><\\/iframe>\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 5, 'Audio, iZem in Brazil, Mixcloud, Audio', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(38, 165, 'Custom Post Format', 'custom-post-format', '<p>Flex is now with <strong>8 post formats</strong> built-in for blogging: standard, video, gallery, audio, link, quote, status and new <strong>“Custom”</strong> post format. With a bit of a code, you can insert module, iframe, HTML, <span>“Custom Fields” (new in Joomla 3.7), </span>or “Shortcode” into your blog. Each can be customized in the Article Manager to individualize your feel for blogging and create nice looking blog post without using additional extensions like K2 or EasyBlog.</p>\r\n', '\r\n<h4 style=\"margin: 25px 0;\">New “Custom Post Format\" is here!</h4>\r\n<p>Flex is now with <strong>8 post formats</strong> built-in for blogging: standard, video, gallery, audio, link, quote, status and new <strong>“Custom”</strong> post format. With a bit of a code, you can insert module, iframe, HTML, <span>“Custom Fields” (new in Joomla 3.7) </span><span>or “Shortcode” into your blog</span>. Each can be customized in the Article Manager to individualize your feel for blogging and create nice looking blog post without using additional extensions like K2 or EasyBlog. </p>\r\n<p style=\"margin: 25px 0;\"><img class=\"img-responsive\" src=\"images/posts/custom-post-format.png\" alt=\"Custom Post Format\" /></p>\r\n<p>Also, in Flex template\'s admin, at the “Blog” section, you have now options to choose custom icons for Blog formats. If you leave the fields empty, it will show default (predefined) icons.</p>\r\n<p style=\"margin: 25px 0;\"><img class=\"img-responsive\" src=\"images/posts/post-formats-icons.png\" alt=\"Custom Post Format icon\" /></p>', 1, 18, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/tags\\/custom-post-img.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"custom\",\"gallery\":\"\",\"items_per_row\":\"1\",\"margin_between_items\":\"0\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":\"44\",\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":\"0\",\"autoplay\":\"1\",\"auto_transition\":\"5\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"{module 127}\"}', 0, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(39, 77, '‘Patio’ - Outstanding Flamenco Guitar', 'patio-outstanding-flamenco-guitar', '<p>Following has meticulously recorded six different acoustic instruments: a steel-string guitar, twelve-string, nylon string, ukulele, mandolin, and guitalele, and presents them in astonishing detail. It features both plectrum and finger picking, and Blumlein stereo recordings alongside the piezo pickup perspective.</p>\r\n', '\r\n<p>Thousands of samples across more than a dozen articulations were recorded for each instrument, including sustains, mutes, releases, legatos, hammer-ons and pull-offs, slides, harmonics, and effects. Acou6tics also features virtual room control with adjustable mic distance and sympathetic resonance.</p>\r\n<p>Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your north. Even the all-powerful Pointing has no control about the blind texts it is a far World of Grammar.</p>\r\n<p>Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \"de Finibus Bonorum et Malorum\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \"Lorem ipsum dolor sit amet..\", comes from a line in section 1.10.32.</p>\r\n<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don\'t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn\'t anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable.</p>', 1, 18, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/tags\\/audio-post-soundcloud-img.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"audio\",\"gallery\":\"\",\"audio\":\"<iframe width=\\\"100%\\\" height=\\\"400\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A%2F%2Fapi.soundcloud.com%2Ftracks%2F151140679&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\"><\\/iframe>\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 10, 'Audio, Flamenco Guitar, Soundcloud, Audio, Guitar', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(40, 226, 'At Mario\'s Always Fresh Cupcake Ice Cream?', 'at-mario-s-always-fresh-cupcake-ice-cream', '<p>Veggies food taste better when cooked, proinde vos postulo essum magis kohlrabi welsh onion daikon amaranth tatsoi tomatillo melon azuki bean garlic.</p>\r\n<p>Gumbo beet greens corn soko endive gumbo gourd. Parsley shallot courgette tatsoi pea sprouts fava bean collard greens dandelion okra wakame tomato. Dandelion cucumber earthnut pea peanut soko zucchini. Bonbon muffin fruitcake cupcake icing cookie donut chocolate powder. Sweet jelly beans powder tart tart icing. Cookie topping marshmallow biscuit tiramisu. Jujubes powder croissant candy chups cheesecake danish chupa chups cupcake. Chocolate bar croissant halvah marzipan bear claw. Caramels candy tiramisu wafer wafer sweet roll. Sesame snaps pastry chocolate bar. Pudding jelly beans danish liquorice lemon drops. Cake oat cake wafer danish. Bear claw powder bear claw. Cake cupcake cookie bonbon chocolate topping. Pastry toffee carrot cake danish dessert gummies icing lollipop. Tootsie roll cupcake sesame snaps oat cake icing.</p>\r\n', '\r\n<div class=\"break20\"></div>\r\n<div class=\"bullets row-fluid\">\r\n<div class=\"col-md-3\">\r\n<ul class=\"site-list\">\r\n<li><i class=\"fa fa-check\"></i>Yummy</li>\r\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\r\n<li><i class=\"fa fa-check\"></i>Sweetened sliced strawberries</li>\r\n<li><i class=\"fa fa-check\"></i>Thawed</li>\r\n<li><i class=\"fa fa-check\"></i>2 liters lemon-lime soda.</li>\r\n<li><i class=\"fa fa-check\"></i><span>Marzipan fruitcake cupcake</span></li>\r\n<li><i class=\"fa fa-check\"></i>Pour into a large pitcher.</li>\r\n<li><i class=\"fa fa-check\"></i>Few sprigs of fresh mint</li>\r\n</ul>\r\n</div>\r\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"280\" frameborder=\"0\" src=\"//www.dailymotion.com/embed/video/x5hvq9t\" allowfullscreen=\"allowfullscreen\" allow=\"autoplay\"></iframe></div>\r\n<div class=\"col-md-4\">\r\n<ul class=\"site-list li-circle\">\r\n<li>Jujubes dragée</li>\r\n<li>Seltzer water</li>\r\n<li>1-1/4 cups: 215 calories</li>\r\n<li>0 fat (0 saturated fat)</li>\r\n<li>0 cholesterol</li>\r\n<li>31mg sodium</li>\r\n<li>56g carbohydrate (53g sugars, 1g fiber)</li>\r\n<li>0 protein</li>\r\n</ul>\r\n</div>\r\n</div>\r\n<div class=\"break20\"></div>\r\n<hr />\r\n<div class=\"row-fluid clearfix\">\r\n<p>Danish danish cake caramels. Sweet roll marshmallow soufflé bonbon chocolate bar cupcake liquorice. Cake powder pastry cotton candy. Macaroon candy canes danish dessert jelly-o biscuit chocolate cake. Wafer biscuit sweet roll biscuit wafer marshmallow jujubes. Chupa chups tiramisu gummies toffee marshmallow soufflé. Chocolate caramels cotton candy. Halvah caramels sweet. Soufflé chocolate cake pie cotton candy cupcake. Brownie cheesecake gingerbread. Fruitcake dragée dragée jelly-o jujubes. Sugar plum gingerbread muffin chocolate bar halvah. Sesame snaps cake chocolate cake pudding macaroon marzipan brownie jujubes.</p>\r\n</div>\r\n<div class=\"break20\"></div>\r\n<div class=\"blockquotes\">\r\n<h3>Mix up your marshmallow soufflé chocolate bar cupcake recipes you\'ll want to make every night of the week!</h3>\r\n<hr />\r\n<blockquote>Turnip greens yarrow ricebean rutabaga endive cauliflower sea lettuce kohlrabi amaranth water spinach avocado daikon napa cabbage asparagus winter purslane kale. Celery potato scallion desert raisin horseradish spinach carrot soko. Lotus root water spinach fennel kombu maize bamboo shoot green bean swiss chard seakale pumpkin onion chickpea gram corn pea. Brussels sprout coriander water chestnut gourd swiss chard wakame kohlrabi beetroot carrot watercress. Corn amaranth salsify bunya nuts nori azuki bean chickweed potato bell pepper artichoke.</blockquote>\r\n</div>\r\n<div class=\"dropcaps\">\r\n<div class=\"naked-drop\">\r\n<figure style=\"margin: 6px 30px 10px 0;\" class=\"pull-left\"><img class=\"img-responsive img-rounded\" src=\"https://picsum.photos/740/490?image=493\" alt=\"Toffee gluten-free\" width=\"370\" height=\"245\" />\r\n<figcaption style=\"font-size: 12px;\" class=\"centered\">Toffee gluten-free icing cake</figcaption>\r\n</figure>\r\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 10px 5px 0; text-align: center;\">G</span><strong>ently spread chocolate portion</strong> over top beet greens fava bean potato quandong celery. Cook and stir over medium heat until thickened and bubbly. In a large bowl, cream butter and brown sugar until well blended. Add eggs, one at a time, beating well after each addition. Beat in applesauce and 1/2 cup coffee. Combine the flour, 1/4 cup baking cocoa, cinnamon, baking soda, allspice, salt and cloves; gradually beat into creamed mixture until blended. Fold in raisins and walnuts. chicory celtuce parsley jícama salsify. Cookie gingerbread marshmallow carrot cake. Lemon drops candy canes cake cupcake ice cream bear claw. Halvah bonbon brownie croissant fruitcake macaroon sweet roll topping danish. Candy chocolate bar cupcake muffin cookie oat cake sugar plum. Add cream of tartar, extract and salt to egg whites; beat on medium speed until soft peaks form. Gradually add sugar, 1 tablespoon at a time, beating on high after each addition until sugar is dissolved. Continue beating until soft glossy peaks form. Gradually fold in flour mixture, about 1/2 cup at a time.. Jujubes chocolate gummi bears candy canes candy canes topping gummies gingerbread. Chocolate bar jujubes pastry cookie caramels powder candy. Pudding marshmallow ice cream powder dragée jelly-o macaroon. Macaroon lemon drops carrot cake icing gummi bears carrot cake brownie. Toffee icing cake carrot cake dessert gingerbread soufflé toffee. Toffee soufflé apple pie soufflé donut bear claw brownie jelly-o. Candy canes caramels soufflé sesame snaps macaroon sweet roll.</p>\r\n<p>Celery quandong swiss chard chicory earthnut pea potato. Salsify taro catsear garlic gram celery bitterleaf wattle seed collard greens nori. Grape wattle seed kombu beetroot horseradish carrot squash brussels sprout chard. Mixtape food truck leggings, irony locavore terry richardson gluten-free cred. Single-origin coffee keffiyeh organic tattooed next level tumblr wes anderson, etsy butcher blog shoreditch fanny pack biodiesel terry richardson. Raw denim mlkshk whatever Austin. 3 wolf moon gluten-free before they sold out.</p>\r\n</div>\r\n</div>\r\n<div class=\"break20\"></div>\r\n<hr />\r\n<div class=\"break20\"></div>\r\n<div class=\"row-fluid\">\r\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person8.jpg\" alt=\"Mario Manicureaux\" /><br /><br /></div>\r\n<p>For filling, in a small heavy saucepan, mix sugar and cornstarch. Whisk in eggnog. Caramels candy tiramisu wafer wafer sweet roll. Cook and stir over medium heat until thickened and bubbly. Reduce heat to low; cook and stir 2 minutes longer. Remove from heat. I’m also in a small bowl, whisk cocoa and remaining water until blended; stir into half of the eggnog mixture. Stir rum extract into the remaining half. Refrigerate both mixtures, covered, until partially set.</p>\r\n<h5>Mario Cuisineaux</h5>\r\n</div>', 1, 27, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/ajax-articles\\/marios-restaurant-thumb.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/ajax-articles\\/marios-restaurant-large.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":\"1\",\"margin_between_items\":\"0\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":\"44\",\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":\"0\",\"autoplay\":\"1\",\"auto_transition\":\"5\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 6, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(41, 228, '7 Important Lessons I’ve Learned About Using Spices', '7-important-lessons-i-ve-learned-about-using-spices', '<p>From tall, frosted layer cakes to simple and delicious Bundts, our top-rated chocolate cakes are all here. Grab a glass of milk and get ready to meet (and eat!) your new favorite recipe. Topping dessert tart marshmallow candy canes macaroon. Sweet sugar plum beans biscuit soufflé ice cream cake. Cake tart marshmallow marzipan ice cream. Chocolate croissant donut biscuit jelly-o tart tiramisu pastry. Jelly beans cotton candy soufflé gingerbread apple pie cream.</p>\r\n', '\r\n<p>Preheat oven to 350°. Pour boiling water over chocolate and butter; stir until smooth. Cool slightly. Whisk in sugar, buttermilk, egg and extracts. Combine flour, baking soda and salt; whisk into chocolate mixture just until blended.</p>\r\n<p>Transfer to a 9-in. round baking pan coated with cooking spray. Bake until a toothpick inserted in center comes out clean, 18-22 minutes. Cool 10 minutes before removing from pan to a wire rack to cool completely. Place rack on a waxed paper-lined baking sheet.For ganache, bring cream just to a boil in a small saucepan. Pour over chocolate; whisk until smooth. Cool until slightly thickened, about 10 minutes. Slowly pour over cake, allowing some ganache to drape over sides.</p>\r\n<p>1 slice: 179 calories, 7g fat (4g saturated fat), 26mg cholesterol, 236mg sodium, 28g carbohydrate (18g sugars, 1g fiber), 3g protein. Diabetic Exchanges: 2 starch, 1 fat. Refrigerate until serving. If desired, sprinkle with raspberries, confectioners\' sugar and cocoa. Cut into wedges. Yield: 12 servings.Chupa chups oat cake lemon drops fruitcake toffee chocolate jelly beans. Sugar plum biscuit candy donut. Gummies topping powder pudding caramels marshmallow donut fruitcake.</p>', 1, 27, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/ajax-articles\\/food-03.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"gallery\",\"gallery\":\"{\\\"gallery_images\\\":[\\\"images\\/2018\\/04\\/27\\/food-01.jpg\\\",\\\"images\\/2018\\/04\\/27\\/food-02.jpg\\\",\\\"images\\/2018\\/04\\/27\\/food-03.jpg\\\"]}\",\"items_per_row\":\"2\",\"margin_between_items\":\"10\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":\"44\",\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":\"1\",\"autoplay\":\"1\",\"auto_transition\":\"5\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 5, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(42, 230, 'The Top 10 List of Exotic Drinks for This Season', 'top-10-list-of-exotic-drinks-for-this-season', '<p>The toppings you may chose for that TV dinner pizza slice when you forgot to shop for foods, the paint you may slap on your face to impress the new boss is your business. But what about your daily bread? Design comps, layouts, wireframes—will your clients accept that you go about things the facile way? Authorities in our business will tell in no uncertain terms that Lorem Ipsum is that huge, huge no no to forswear forever. Not so fast, I\'d say, there are some redeeming factors in favor of greeking text, as its use is merely the symptom of a worse problem to take into consideration.</p>', '<p>Your tiramisu jelly beans dessert apple pie dessert wafer tart. Wafer marzipan lollipop gingerbread pastry cake. Sweet croissant lollipop. Muffin topping lemon drops cotton candy gummies. Jelly candy canes sweet roll oat cake cotton candy lollipop croissant sugar plum cotton candy. Candy jelly-o donut macaroon donut ice cream lemon drops chocolate ice cream. Cotton candy pie sweet. Jelly beans muffin sugar plum donut sweet biscuit fruitcake jelly-o. Cotton candy jujubes dragée cupcake cookie jelly beans apple pie cake danish. Chocolate cotton candy biscuit. Sesame snaps tiramisu icing powder halvah pudding jelly sugar plum. Jelly gummies jelly gummi bears cupcake jujubes sugar plum. Cake apple pie sesame snaps cake. Donut halvah chupa chups sesame snaps muffin.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">You\'ve got to try these tart n\' yummy strawberry spritzers!</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 10px 5px; text-align: center;\">S</span><strong>trawberry spritzers</strong> mentioned previously in this chapter, and the dreams in the chapter on the subconscious. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good! Three simple ingredients are all you need to create this fresh and fruity summer beverage. It\'s bound to become a warm-weather favorite.</p>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>Yummy</li>\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-check\"></i>Frozen sweetened sliced strawberries</li>\n<li><i class=\"fa fa-check\"></i>Thawed</li>\n<li><i class=\"fa fa-check\"></i>2 liters lemon-lime soda.</li>\n<li><i class=\"fa fa-check\"></i>Frozen pink lemonade concentrate</li>\n<li><i class=\"fa fa-check\"></i>Pour into a large pitcher.</li>\n<li><i class=\"fa fa-check\"></i>Few sprigs of fresh mint</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Jujubes dragée</li>\n<li>Seltzer water</li>\n<li>1-1/4 cups: 215 calories</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n<li>31mg sodium</li>\n<li>56g carbohydrate (53g sugars, 1g fiber)</li>\n<li>0 protein</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"300\" src=\"//www.dailymotion.com/embed/video/x5s6rwf\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3>The Sweet Strawberry Drink To Make Before Summer Ends</h3>\n<hr />\n<blockquote>The Sweet Strawberry Drink To Make Before Summer Ends. Three simple ingredients are all you need to create this fresh and fruity summer beverage. It\'s bound to become a warm-weather favorite. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good!</blockquote>\n</div>\n<p>Soufflé pastry candy canes candy canes jelly beans biscuit oat cake marzipan macaroon. Gingerbread jelly-o jelly-o soufflé. Cake apple pie tootsie roll muffin wafer chocolate cake tiramisu chupa chups. Cotton candy apple pie tootsie roll. Bonbon cake apple pie gummies. Tootsie roll liquorice sesame snaps macaroon tiramisu. Candy powder apple pie danish dragée. Toffee candy canes tart liquorice sesame snaps candy topping tiramisu. Sesame snaps chupa chups gummi bears chocolate cake ice cream pudding pastry. Sesame snaps marshmallow gummi bears marshmallow. Tart topping macaroon sweet cake apple pie bonbon. Donut gummi bears cake biscuit carrot cake jelly beans.</p>\n<p>Sweet croissant brownie marshmallow. Bear claw ice cream toffee dessert candy cookie croissant tart pie. Wafer tootsie roll dragée pastry jelly. Sweet bear claw dragée marzipan soufflé croissant. Candy canes bear claw tart cupcake liquorice icing cake. Cake jujubes chocolate bar. Lemon drops dessert sesame snaps carrot cake chupa chups. Cheesecake cake candy dessert lemon drops. Pastry sweet roll pastry liquorice chupa chups cupcake toffee. Cookie liquorice tootsie roll gummies caramels. Tiramisu lollipop sweet roll chocolate cake donut jelly beans toffee. Tiramisu biscuit topping jelly.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person7.jpg\" alt=\"Janie Awesome\" /><br /><br /></div>\n<p>For filling, in a small heavy saucepan, mix sugar and cornstarch. Whisk in eggnog. Caramels candy tiramisu wafer wafer sweet roll. Cook and stir over medium heat until thickened and bubbly. Reduce heat to low; cook and stir 2 minutes longer. Remove from heat. I’m also in a small bowl, whisk cocoa and remaining water until blended; stir into half of the eggnog mixture. Stir rum extract into the remaining half. Refrigerate both mixtures, covered, until partially set.</p>\n<h5>Janie Awesome</h5>\n</div>', 1, 27, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/ajax-articles\\/summer-drink-thumb.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/ajax-articles\\/summer-drink.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 4, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(43, 232, '5 Healthy Breakfast Ideas For Summer People', '5-healthy-breakfast-ideas-for-summer-people', '<p>The toppings you may chose for that TV dinner pizza slice when you forgot to shop for foods, the paint you may slap on your face to impress the new boss is your business. But what about your daily bread? Design comps, layouts, wireframes—will your clients accept that you go about things the facile way? Authorities in our business will tell in no uncertain terms that Lorem Ipsum is that huge, huge no no to forswear forever. Not so fast, I\'d say, there are some redeeming factors in favor of greeking text, as its use is merely the symptom of a worse problem to take into consideration.</p>', '<p>Your tiramisu jelly beans dessert apple pie dessert wafer tart. Wafer marzipan lollipop gingerbread pastry cake. Sweet croissant lollipop. Muffin topping lemon drops cotton candy gummies. Jelly candy canes sweet roll oat cake cotton candy lollipop croissant sugar plum cotton candy. Candy jelly-o donut macaroon donut ice cream lemon drops chocolate ice cream. Cotton candy pie sweet. Jelly beans muffin sugar plum donut sweet biscuit fruitcake jelly-o. Cotton candy jujubes dragée cupcake cookie jelly beans apple pie cake danish. Chocolate cotton candy biscuit. Sesame snaps tiramisu icing powder halvah pudding jelly sugar plum. Jelly gummies jelly gummi bears cupcake jujubes sugar plum. Cake apple pie sesame snaps cake. Donut halvah chupa chups sesame snaps muffin.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">If you\'re a fan of ice cream, bananas, and all things sweet, you\'re going to want to watch up whip up this satisfying dessert!</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 10px 5px; text-align: center;\">S</span><strong>undaes Gone Bananas</strong> mentioned previously in this chapter, and the dreams in the chapter on the subconscious. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good! Three simple ingredients are all you need to create this fresh and fruity summer beverage. It\'s bound to become a warm-weather favorite.</p>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>Yummy</li>\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-check\"></i>Frozen sweetened sliced strawberries</li>\n<li><i class=\"fa fa-check\"></i>Thawed</li>\n<li><i class=\"fa fa-check\"></i>2 liters lemon-lime soda.</li>\n<li><i class=\"fa fa-check\"></i>Frozen pink lemonade concentrate</li>\n<li><i class=\"fa fa-check\"></i>Pour into a large pitcher.</li>\n<li><i class=\"fa fa-check\"></i>Few sprigs of fresh mint</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Jujubes dragée</li>\n<li>Seltzer water</li>\n<li>1-1/4 cups: 215 calories</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n<li>31mg sodium</li>\n<li>56g carbohydrate (53g sugars, 1g fiber)</li>\n<li>0 protein</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"300\" src=\"//www.dailymotion.com/embed/video/x6cp0f7\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3>The Sweet Banana Drink To Make Before Summer Ends</h3>\n<hr />\n<blockquote>The Sweet Banana Drink To Make Before Summer Ends. If you\'re a fan of ice cream, bananas, and all things sweet, you\'re going to want to watch up whip up this satisfying dessert! You\'ve got to try these tart n\' yummy banana spritzers... we promise they\'re berry good!</blockquote>\n</div>\n<p>Soufflé pastry candy canes candy canes jelly beans biscuit oat cake marzipan macaroon. Gingerbread jelly-o jelly-o soufflé. Cake apple pie tootsie roll muffin wafer chocolate cake tiramisu chupa chups. Cotton candy apple pie tootsie roll. Bonbon cake apple pie gummies. Tootsie roll liquorice sesame snaps macaroon tiramisu. Candy powder apple pie danish dragée. Toffee candy canes tart liquorice sesame snaps candy topping tiramisu. Sesame snaps chupa chups gummi bears chocolate cake ice cream pudding pastry. Sesame snaps marshmallow gummi bears marshmallow. Tart topping macaroon sweet cake apple pie bonbon. Donut gummi bears cake biscuit carrot cake jelly beans.</p>\n<p>Sweet croissant brownie marshmallow. Bear claw ice cream toffee dessert candy cookie croissant tart pie. Wafer tootsie roll dragée pastry jelly. Sweet bear claw dragée marzipan soufflé croissant. Candy canes bear claw tart cupcake liquorice icing cake. Cake jujubes chocolate bar. Lemon drops dessert sesame snaps carrot cake chupa chups. Cheesecake cake candy dessert lemon drops. Pastry sweet roll pastry liquorice chupa chups cupcake toffee. Cookie liquorice tootsie roll gummies caramels. Tiramisu lollipop sweet roll chocolate cake donut jelly beans toffee. Tiramisu biscuit topping jelly.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person9.jpg\" alt=\"Capuciné Sébastien Claudereux Brownie\" /><br /><br /></div>\n<p>I\'ve enjoyed what you think how bout the other way around? Sweet croissant brownie marshmallow. To be successful you’ve got to work hard, to make history, simple, you’ve got to make it. We the best. Special cloth alert. They never said winning was easy. Some people can’t handle success, I can. They don’t want us to win. They don’t want us to eat. It’s on you how you want to live your life. Everyone has a choice. I pick my choice, squeaky clean.</p>\n<h5>Capuciné Brownie</h5>\n</div>', 1, 27, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/ajax-articles\\/fruit-3-thumb.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/ajax-articles\\/fruit-3.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(44, 234, '12 Savory Foods To Make in a Springform Pan', '12-savory-foods-to-make-in-a-springform-pan', '<p>The toppings you may chose for that TV dinner pizza slice when you forgot to shop for foods, the paint you may slap on your face to impress the new boss is your business. But what about your daily bread? Design comps, layouts, wireframes—will your clients accept that you go about things the facile way? Authorities in our business will tell in no uncertain terms that Lorem Ipsum is that huge, huge no no to forswear forever. Not so fast, I\'d say, there are some redeeming factors in favor of greeking text, as its use is merely the symptom of a worse problem to take into consideration.</p>', '<p>Your tiramisu jelly beans dessert apple pie dessert wafer tart. Wafer marzipan lollipop gingerbread pastry cake. Sweet croissant lollipop. Muffin topping lemon drops cotton candy gummies. Jelly candy canes sweet roll oat cake cotton candy lollipop croissant sugar plum cotton candy. Candy jelly-o donut macaroon donut ice cream lemon drops chocolate ice cream. Cotton candy pie sweet. Jelly beans muffin sugar plum donut sweet biscuit fruitcake jelly-o. Cotton candy jujubes dragée cupcake cookie jelly beans apple pie cake danish. Chocolate cotton candy biscuit. Sesame snaps tiramisu icing powder halvah pudding jelly sugar plum. Jelly gummies jelly gummi bears cupcake jujubes sugar plum. Cake apple pie sesame snaps cake. Donut halvah chupa chups sesame snaps muffin.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">Think beyond the cheesecake for gorgeous savory appetizers, layered dinners, brunch dishes and more!</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 10px 5px; text-align: center;\">12</span><strong> Savory Foods To Make in a Springform Pan</strong> mentioned previously in this chapter, and the dreams in the chapter on the subconscious. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good! Three simple ingredients are all you need to create this fresh and fruity summer beverage. It\'s bound to become a warm-weather favorite.</p>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>Yummy</li>\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-check\"></i>Frozen sweetened sliced strawberries</li>\n<li><i class=\"fa fa-check\"></i>Thawed</li>\n<li><i class=\"fa fa-check\"></i>2 liters lemon-lime soda.</li>\n<li><i class=\"fa fa-check\"></i>Frozen pink lemonade concentrate<i class=\"fa fa-check\"></i></li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Jujubes dragée</li>\n<li>Seltzer water</li>\n<li>1-1/4 cups: 215 calories</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n<li>56g carbohydrate (53g sugars, 1g fiber)</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"300\" src=\"//www.dailymotion.com/embed/video/x5vx1oz\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3>The Sweet Orange Drink To Make Before Summer Ends</h3>\n<hr />\n<blockquote>The Sweet Orange Drink To Make Before Summer Ends. If you\'re a fan of ice cream, bananas, and all things sweet, you\'re going to want to watch up whip up this satisfying dessert! You\'ve got to try these tart n\' yummy banana spritzers... we promise they\'re berry good!</blockquote>\n</div>\n<p>Soufflé pastry candy canes candy canes jelly beans biscuit oat cake marzipan macaroon. Gingerbread jelly-o jelly-o soufflé. Cake apple pie tootsie roll muffin wafer chocolate cake tiramisu chupa chups. Cotton candy apple pie tootsie roll. Bonbon cake apple pie gummies. Tootsie roll liquorice sesame snaps macaroon tiramisu. Candy powder apple pie danish dragée. Toffee candy canes tart liquorice sesame snaps candy topping tiramisu. Sesame snaps chupa chups gummi bears chocolate cake ice cream pudding pastry. Sesame snaps marshmallow gummi bears marshmallow. Tart topping macaroon sweet cake apple pie bonbon. Donut gummi bears cake biscuit carrot cake jelly beans.</p>\n<p>Sweet croissant brownie marshmallow. Bear claw ice cream toffee dessert candy cookie croissant tart pie. Wafer tootsie roll dragée pastry jelly. Sweet bear claw dragée marzipan soufflé croissant. Candy canes bear claw tart cupcake liquorice icing cake. Cake jujubes chocolate bar. Lemon drops dessert sesame snaps carrot cake chupa chups. Cheesecake cake candy dessert lemon drops. Pastry sweet roll pastry liquorice chupa chups cupcake toffee. Cookie liquorice tootsie roll gummies caramels. Tiramisu lollipop sweet roll chocolate cake donut jelly beans toffee. Tiramisu biscuit topping jelly.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person7.jpg\" alt=\"Janie Awesome\" /><br /><br /></div>\n<p>My husband really enjoys this delightful cake. Eye-catching enough for a special occasion, this is so good you’ll want it any day of the week, mix sugar and cornstarch. Whisk in eggnog. Caramels candy tiramisu. Cook and stir over medium heat until thickened and bubbly. Reduce heat to low; cook and stir 2 minutes longer. Remove from heat. I’m also in a small bowl, whisk cocoa and remaining water until blended; stir into half of the eggnog mixture. Stir rum extract into the remaining half. Refrigerate both mixtures, covered, until partially set.</p>\n<h5>Janie Awesome</h5>\n</div>', 1, 27, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/ajax-articles\\/food-07-thumb.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/ajax-articles\\/food-07.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(45, 236, 'Chocolate Bourbon Pecan Monkey Bread', 'chocolate-bourbon-pecan-monkey-bread', '<p><span>Time to give rum cake a little competition! If this boozy take on monkey bread is too strong for your taste, cut back on the bourbon or use milk as a non-alcoholic substitute</span>. Not so fast, I\'d say, there are some redeeming factors in favor of greeking text, as its use is merely the symptom of a worse problem to take into consideration.</p>', '<p>Your tiramisu jelly beans dessert apple pie dessert wafer tart. Wafer marzipan lollipop gingerbread pastry cake. Sweet croissant lollipop. Muffin topping lemon drops cotton candy gummies. Jelly candy canes sweet roll oat cake cotton candy lollipop croissant sugar plum cotton candy. Candy jelly-o donut macaroon donut ice cream lemon drops chocolate ice cream. Cotton candy pie sweet. Jelly beans muffin sugar plum donut sweet biscuit fruitcake jelly-o. Cotton candy jujubes dragée cupcake cookie jelly beans apple pie cake danish. Chocolate cotton candy biscuit. Sesame snaps tiramisu icing powder halvah pudding jelly sugar plum. Jelly gummies jelly gummi bears cupcake jujubes sugar plum. Cake apple pie sesame snaps cake. Donut halvah chupa chups sesame snaps muffin.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">Chocolate Bourbon Pecan for gorgeous savory appetizers, layered dinners, brunch dishes and more!</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 10px 5px; text-align: center;\">M</span><strong>icrowave 1/4 cup butter</strong> until melted. Dissolve yeast in warm water and milk; let stand until foamy, about 10 minutes. In another bowl, combine eggs, bourbon and melted butter; stir in 2 cups flour, 1/4 cup sugar, salt and yeast mixture. Beat on medium speed 3 minutes. Stir in enough remaining flour to form a soft dough! It\'s bound to become a warm-weather favorite.</p>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>Yummy</li>\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-check\"></i>Frozen sweetened sliced strawberries</li>\n<li><i class=\"fa fa-check\"></i>Thawed</li>\n<li><i class=\"fa fa-check\"></i>Frozen pink lemonade concentrate</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Jujubes dragée</li>\n<li>1-1/4 cups: 215 calories</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n<li>56g carbohydrate (53g sugars, 1g fiber)</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"300\" src=\"https://www.youtube.com/embed/LFpYhgs-mos\" frameborder=\"0\" allow=\"autoplay\" allowfullscreen=\"allowfullscreen\"></iframe></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3>Capuciné Brownie Use Milk Onto a Foured Surface</h3>\n<hr />\n<blockquote>Time to give rum cake a little competition! If this boozy take on monkey bread is too strong for your taste, cut back on the bourbon or use milk as a non-alcoholic substitute. You\'ve got to try these tart n\' yummy banana spritzers... we promise they\'re berry good!</blockquote>\n</div>\n<p>Turn dough onto a floured surface; knead until smooth and elastic, about 6-8 minutes. Place in a greased bowl, turning once to grease the top. Cover with plastic. Refrigerate overnight.Punch down dough. Turn onto a lightly floured surface; divide and shape into 36 rolls. Flatten rolls into circles; place 1 chocolate piece in center of each. Fold dough over filling; pinch edges well to seal. Melt remaining butter; pour into a shallow bowl. Place remaining sugar in another shallow bowl. Dip balls in butter, allowing excess to drip off, then roll in sugar.</p>\n<p>Sweet croissant brownie marshmallow. Bear claw ice cream toffee dessert candy cookie croissant tart pie. Wafer tootsie roll dragée pastry jelly. Sweet bear claw dragée marzipan soufflé croissant. Candy canes bear claw tart cupcake liquorice icing cake. Cake jujubes chocolate bar. Lemon drops dessert sesame snaps carrot cake chupa chups. Cheesecake cake candy dessert lemon drops. Cool in pan 10 minutes before inverting onto a serving plate. Meanwhile, for bourbon chocolate glaze, melt chocolate in a small heavy saucepan over medium-low heat. Remove from heat; stir in bourbon until smooth. Drizzle glaze over warm bread.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person9.jpg\" alt=\"Capuciné Sébastien Claudereux Brownie\" /><br /><br /></div>\n<p>I\'ve enjoyed what you think how bout the other way around? Sweet croissant brownie marshmallow. To be successful you’ve got to work hard, to make history, simple, you’ve got to make it. We the best. Special cloth alert. They never said winning was easy. Some people can’t handle success, I can. They don’t want us to win. They don’t want us to eat. It’s on you how you want to live your life. Everyone has a choice. I pick my choice, squeaky clean.</p>\n<h5>Capuciné Brownie</h5>\n</div>', 1, 27, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/i.ytimg.com\\/vi\\/j4S4N2pIXNE\\/maxresdefault.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"video\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"https:\\/\\/www.youtube.com\\/embed\\/hyuplTXUZ4A\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(46, 238, 'Trophies Are For Winning With Content', 'trophies-are-for-winning-with-content', '<p><span>We can create a brand that stands out and truly reflects your business and the message you want to convey</span>.<span>Using the outcomes from the Company Analysis, we will put together a plan for the most effective marketing strategy to get the best results for your business</span>, as its use is merely the symptom of a worse problem to take into consideration.</p>', '<p><span>We have a number of different teams within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way of doing things that worked 10 years, 5 years or even a year ago. You begin with a text, you sculpt information, you chisel away what\'s not needed, you come to the point, make things clear, add value, you\'re a content person, you like words. Design is no afterthought, far from it, but it comes in a deserved second. Anyway, you still use Lorem Ipsum and rightly so, as it will always have a place in the web workers toolbox, as things happen, not always the way you like it, not always in the preferred order. Even if your less into design and more into content strategy you may find some redeeming value with, wait for it, dummy copy, no less.</span></p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">It was found by Richard McBlintock, a philologist, director of publications at Hampsten-Sydney College in Virginia;</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 10px 5px; text-align: center;\">I</span><strong>n 1985 Flex Corporation</strong> until melted. Dissolve yeast in warm water and milk; let stand until foamy. In another bowl, combine eggs, bourbon and melted butter; Both contained the variant lorem ipsum most common today. Laura Flex, then art director with Aldus, modified prior versions of Lorem Ipsum text from typographical specimens; in the 1960s and 1970s it appeared often in lettering catalogs by Letraset.</p>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>Yummy</li>\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-check\"></i>Frozen sweetened sliced strawberries</li>\n<li><i class=\"fa fa-check\"></i>Thawed</li>\n<li><i class=\"fa fa-check\"></i>Frozen pink lemonade concentrate</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Jujubes dragée</li>\n<li>1-1/4 cups: 215 calories</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n<li>56g carbohydrate (53g sugars, 1g fiber)</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"300\" src=\"https://www.youtube.com/embed/4E0LaFRt19E\" frameborder=\"0\" allow=\"autoplay\" allowfullscreen=\"allowfullscreen\"></iframe></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3>Both contained the variant from typographical specimens.</h3>\n<hr />\n<blockquote>Vous pouvez continuer à remplir les exigences de cette licence est nécessaire pour permettre au destinataire de distribuer votre travail à la fois une limite de distribution géographique explicite à l\'exclusion de ces pays!</blockquote>\n</div>\n<p><span>We have a number of different teams within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way of doing things that worked 10 years, 5 years or even a year ago.</span></p>\n<p><span>However, reviewers tend to be distracted by comprehensible content, say, a random text copied from a newspaper or the internet. We can create a brand that stands out and truly reflects your business and the message you want to convey. The are likely to focus on the text, disregarding the layout and its elements. Besides, random text risks to be unintendedly humorous or offensive, an unacceptable risk in corporate environments. </span><strong>Flex Smooth and Elastic</strong><span> and its many variants have been employed since the early 1960ies, and quite likely since the sixteenth century</span>.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person9.jpg\" alt=\"Margaux Sébastien Écrire\" /><br /><br /></div>\n<p>J\'ai aimé ce que vous pensez de l\'autre côté? Toujours avoir une place dans la boîte à outils des travailleurs sur le web, que les choses se passent, pas toujours comme vous l\'aimez, pas toujours dans l\'ordre préféré. Ils n\'ont jamais dit que gagner était facile. Certaines personnes ne peuvent pas gérer le succès, je peux. Ils ne veulent pas que nous gagnions. C\'est sur vous comment vous voulez vivre votre vie. Tout le monde a le choix. Je choisis mon choix, parfaitement propre.</p>\n<h5>Margaux Écrire</h5>\n</div>', 1, 28, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/i.ytimg.com\\/vi\\/4E0LaFRt19E\\/maxresdefault.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"quote\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"https:\\/\\/www.youtube.com\\/embed\\/hyuplTXUZ4A\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"Professional context it often happens that private or corporate clients corder a publication to be made and presented with the actual content still not being ready. Think of a news blog that\'s filled with content hourly on the day of going live. We can create a brand that stands out and truly reflects your business and the message you want to convey.\",\"quote_author\":\"Margaux \\u00c9crire\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(47, 240, 'Totally Amazing Street Collection of 2019', 'totally-amazing-street-collection-of-2019', '<p>Street service for content person or to include weekends or 2018/19 holidays then we have packages and with every to see a selection of my designs and sketches, which is how all my best designs start, take a look at my portfolio page. To see who I have worked with see my client list and stockists.. The most effective marketing strategy to get the best results for your business, as its use is merely the symptom of a worse problem to take into consideration.</p>', '<figure style=\"margin: 7px 20px 0 0;\" class=\"pull-left\"><img class=\"img-responsive img-rounded\" src=\"https://picsum.photos/400/650?image=299\" alt=\"New York Public Relations\" width=\"210\" height=\"300\" />\n<figcaption style=\"font-size: 12px;\" class=\"centered\">New York Public Relations</figcaption>\n</figure>\n<p>We have a number of content persons within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way of doing things that worked 10 years, to see a selection of my designs and sketches, which is how all my best designs start, take a look at my portfolio page. To see who I have worked with see my client list and stockists. Make things clear, add value, you\'re a content person, you like words. Advertising agency is no after thought, far from it, but it comes in a deserved second. Anyway, you still use Lorem Ipsum and rightly so, as it will always have a place in the web workers toolbox, as things happen, not always the way you like it, not always in the preferred order. Even if your less into design and more into content strategy you may find some redeeming value with, wait for it, dummy copy, no less.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">A big department store in New York of public relations in 2018/19</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-sm-7 col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 5px 5px; text-align: center;\">T</span><strong>his is the place</strong> to come to escape day to day life, sit back, have a cuppa or refreshing mineral water and let us pamper you. We offer a range of treatments and therapies including massage, facials, manicures, holistic treatments and treatments just for men. We have been selling stuff for years. You can visit us at our shop in the town, every day apart from fashion. If you don’t want to leave to comfort of your own home, why not have a look at our online store. We have some great new lines and also some fantastic seasonal offers on many of our ranges with up to 75% off if you’re lucky before stocks run out. We also offer pamper packages for that special birthday, hen party or even (if you’re brave enough) stag do!</p>\n<div class=\"break20\"></div>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-id-badge\"></i>Lettering catalogs</li>\n<li><i class=\"fa fa-handshake-o\"></i>Fashion Protection</li>\n<li><i class=\"fa fa-balance-scale\"></i>Balance Scale</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Investments and Pensions</li>\n<li>24/7</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-sm-5 col-md-5\"><img class=\"img-responsive img-rounded\" src=\"images/blog/ajax-articles/girl-filming-thumb.jpg\" alt=\"Flex Fashion\" /></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3><i style=\"font-size: 130%; line-height: 1.2; vertical-align: middle; margin: -8px 8px 0 0;\" class=\"pe pe-7s-light major_color\"></i> Fashion Wedding Dress Creator – embroidery design and lace selection.</h3>\n<hr />\n<blockquote>We are a friendly firm of Financial Advisors <span>from an advertising agency </span>who are happy to meet with you face to face or liaise with you via the phone or email to provide a service that’s right for you. Our Services included offering advice and solutions on Mortgages, Insurance, Financial Protection, Investments and Pensions. Our aim is to leave you worry free about your finances because you know they are in safe hands!</blockquote>\n</div>\n<p><img style=\"margin: 5px 0 12px 12px;\" class=\"img-rounded pull-right\" src=\"https://picsum.photos/340/460?image=376\" alt=\"NY 2018/19\" width=\"170\" height=\"240\" />We have a number of different teams within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way, 5 years or even a year ago.</p>\n<p>However, reviewers tend to be distracted by comprehensible content, say, a random text copied from a newspaper or the internet. We can create a brand that stands out and truly reflects your business and the message you want to convey. The are likely to focus on the text, disregarding the layout and its elements. We will then put together a plan including our recommendations. This plan will include our fees so you can see upfront. If you are happy with the plan and the fees we will then put the plan into action. <strong>We will fashion review</strong> how things are going in line with the review schedule in the plan. Flex Smooth and Elastic and its many variants have been employed since the early 1960ies, and quite likely since the sixteenth century.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person2.jpg\" alt=\"Gloria MacIntosh\" /><br /><br /></div>\n<p>I’m a freelance fashion designer who specialises in print designs and combining fabrics. My designs have been sold all over Europe and the USA and I have worked with some of the biggest designers in the industry. I’m also currently working with a big supermarket to develop a gorgeous, yet affordable, range of beautifully printed key pieces that no women’s wardrobe should be without!</p>\n<h5>Gloria Manicureaux</h5>\n</div>', 1, 28, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/ajax-articles\\/walking-girl-thumb.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/ajax-articles\\/walking-girl-large.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"{\\\"gallery_images\\\":[]}\",\"items_per_row\":3,\"margin_between_items\":12,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"fontawesome-angle\",\"arrow_size\":50,\"arrows_color\":\"\",\"arrows_bg\":\"rgba(0,0,0,0)\",\"show_pager\":1,\"autoplay\":1,\"auto_transition\":7,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(48, 241, 'Autumn\'s Personal Concierge for 2019 Free Way to Lifestyle', 'autumn-s-personal-concierge-for-2019-free-way-to-lifestyle', '<p>Autumn lifestyle for content person or to include weekends or 2018/19/20 vacations then we have packages and with every to see a selection of my designs and sketches, which is how all my best designs start, take a look at my portfolio page. To see who I have worked with see my client list and stockists.. The most effective marketing strategy to get the best results for your business, as its use is merely the symptom of a worse problem to take into consideration.</p>', '<figure style=\"margin: 7px 20px 0 0;\" class=\"pull-left\"><img class=\"img-responsive img-rounded\" src=\"https://picsum.photos/700/500?image=868\" alt=\"Autumn Public Relations\" width=\"350\" height=\"250\" />\n<figcaption style=\"font-size: 12px;\" class=\"centered\">Autumn Public Relations</figcaption>\n</figure>\n<p>We have a number of content persons within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way of doing things that worked 10 years, to see a selection of my designs and sketches, which is how all my best designs start, take a look at my portfolio page. To see who I have worked with see my client list and stockists. Make things clear, add value, you\'re a content person, you like words. Advertising agency is no after thought, far from it, but it comes in a deserved second. Anyway, you still use Lorem Ipsum and rightly so, as it will always have a place in the web workers toolbox, as things happen, not always the way you like it, not always in the preferred order. Even if your less into design and more into content strategy you may find some redeeming value with, wait for it, dummy copy, no less.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">A big stocks in Autumn of public relations for 2018/19</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-sm-7 col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 5px 5px; text-align: center;\">T</span><strong>his is the place</strong> to come to escape day to day life, sit back, have a cuppa or refreshing mineral water and let us pamper you. We offer a range of treatments and therapies including massage, facials, manicures, holistic treatments and treatments just for men. We have been selling stuff for years. You can visit us at our shop in the town, every day apart from fashion. If you don’t want to leave to comfort of your own home, why not have a look at our online store. We have some great new lines and also some fantastic seasonal offers on many of our ranges with up to 75% off if you’re lucky before stocks run out. We also offer pamper packages for that special birthday, hen party or even (if you’re brave enough) stag do. If you are a family of four and you book by the end of the month then one child goes absolutely free! If this deal isn’t right for you then don’t worry, we have loads of amazing online prices including 4* holidays starting from as little as $350, now that’s a bargain!</p>\n<div class=\"break20\"></div>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-id-badge\"></i>Lettering catalogs</li>\n<li><i class=\"fa fa-handshake-o\"></i>Fashion Protection</li>\n<li><i class=\"fa fa-balance-scale\"></i>Balance Scale</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Investments and Pensions</li>\n<li>24/7</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-sm-5 col-md-5\"><img class=\"img-responsive img-rounded\" src=\"https://picsum.photos/700/400?image=646\" alt=\"Flex\'s adventure\" /></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3><i style=\"font-size: 130%; line-height: 1.2; vertical-align: middle; margin: -8px 8px 0 0;\" class=\"pe pe-7s-light major_color\"></i>Autumn Creator – local design and lace selection.</h3>\n<hr />\n<blockquote>We are a friendly firm of Autumn lovers <span>from an advertising agency </span>who are happy to meet with you face to face or liaise with you via the phone or email to provide a service that’s right for you. Our Services included offering advice and solutions on Beauty, Lifestyle Protection, Investments and Pensions. Our aim is to leave you worry free about your finances because you know they are in safe hands!</blockquote>\n</div>\n<p><img style=\"margin: 5px 0 12px 12px;\" class=\"img-rounded pull-right\" src=\"https://picsum.photos/400/460?image=864\" alt=\"Autumn 2018/19\" width=\"200\" height=\"240\" />We have a number of different teams within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way, 5 years or even a year ago.</p>\n<p>However, reviewers tend to be distracted by comprehensible content, say, a random text copied from a newspaper or the internet. We can create a brand that stands out and truly reflects your business and the message you want to convey. The are likely to focus on the text, disregarding the layout and its elements. We will then put together a plan including our recommendations. This plan will include our fees so you can see upfront. If you are happy with the plan and the fees we will then put the plan into action. <strong>We will autumn review</strong> how things are going in line with the review schedule in the plan. Flex Smooth and Elastic and its many variants have been employed since the early 1960ies, and quite likely since the sixteenth century.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person3.jpg\" alt=\"Autumn Manicureaux\" /><br /><br /></div>\n<p>I’m a freelance fashion designer who specialises in print designs and combining fabrics. My designs have been sold all over Europe and the USA and I have worked with some of the biggest designers in the industry. I’m also currently working with a big supermarket to develop a gorgeous, yet affordable, range of beautifully printed key pieces that no women’s wardrobe should be without!</p>\n<h5>Autumn Manicureaux</h5>\n</div>', 1, 28, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/picsum.photos\\/720\\/380?image=776\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"https:\\/\\/picsum.photos\\/1280\\/500?image=776\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(49, 243, '“Outside the box” Approach to Seaside People', 'outside-the-box-approach-to-seaside-people', '<p>Credibly empower enterprise wide mindshare for excellent “outside the box” thinking. Proactively scape day meta services rather than enterprise results. Professionally generate end-to-end human capital holistic networks. Authoritatively customize cross-media imperatives rather than client focused schemas. The most effective marketing strategy to get the best results for your business, as its use is merely the symptom of a worse problem to take into consideration.</p>', '<figure style=\"margin: 7px 20px 0 0;\" class=\"pull-left\"><img class=\"img-responsive img-rounded\" src=\"https://picsum.photos/740/500?image=633\" alt=\"Beauty Public Relations\" width=\"370\" height=\"250\" />\n<figcaption style=\"font-size: 12px;\" class=\"centered\">Beauty Focused Relations</figcaption>\n</figure>\n<p>We have a number of content persons within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way of doing things that worked 10 years, to see a selection of my designs and sketches, which is how all my best designs start, take a look at my portfolio page. To see who I have worked with see my client list and stockists. Make things clear, add value, you\'re a content person, you like words. Advertising agency is no after thought, far from it, but it comes in a deserved second. Anyway, you still use Lorem Ipsum and rightly so, as it will always have a place in the web workers toolbox, as things happen, not always the way you like it, not always in the preferred order. Even if your less into design and more into content strategy you may find some redeeming value with, wait for it, dummy copy, no less.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">“Outside the box” public relations for 2018/19</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-sm-7 col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 5px 5px; text-align: center;\">E</span><strong>scape day</strong> to day life, sit back, have a cuppa or refreshing mineral water and let us pamper you. We offer a range of treatments and therapies including massage, facials, manicures, pedicures, waxing, holistic treatments and treatments just for men. We also offer pamper packages for that special birthday, hen party or even (if you’re brave enough) stag do! To come to escape day to day life, sit back, have a cuppa or refreshing mineral water and let us pamper you. We offer a range of treatments and therapies including massage, facials, manicures, holistic treatments and treatments just for men. We have been selling stuff for years. You can visit us at our shop in the town, every day apart from fashion. If you don’t want to leave to comfort of your own home, why not have a look at our online store. If you are a family of four and you book by the end of the month then one child goes absolutely free! If this deal isn’t right for you then don’t worry, now that’s a bargain!</p>\n<div class=\"break20\"></div>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-id-badge\"></i>Lettering catalogs</li>\n<li><i class=\"fa fa-handshake-o\"></i>Fashion Protection</li>\n<li><i class=\"fa fa-balance-scale\"></i>Balance Scale</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Investments and Pensions</li>\n<li>24/7</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-sm-5 col-md-5\"><img class=\"img-responsive img-rounded\" src=\"https://picsum.photos/700/420?image=550\" alt=\"Autumn\'s adventure\" /></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3><i style=\"font-size: 130%; line-height: 1.2; vertical-align: middle; margin: -8px 8px 0 0;\" class=\"pe pe-7s-light major_color\"></i>Beauty Information Centre – local design and lace selection.</h3>\n<hr />\n<blockquote>We are a friends of Beauty Lifestyle<span>from an advertising agency </span>who are happy to meet with you face to face or liaise with you via the phone or email to provide a service that’s right for you. Our Services included offering advice and solutions on Beauty, Lifestyle Protection, Investments and Pensions. Our aim is to leave you worry free about your finances because you know they are in safe hands!</blockquote>\n</div>\n<p><img style=\"margin: 5px 0 12px 12px;\" class=\"img-rounded pull-right\" src=\"https://picsum.photos/400/460?image=596\" alt=\"Autumn 2018/19\" width=\"200\" height=\"240\" />We have a number of different teams within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way, 5 years or even a year ago.</p>\n<p>However, reviewers tend to be distracted by comprehensible content, say, a random text copied from a newspaper or the internet. We can create a brand that stands out and truly reflects your business and the message you want to convey. The are likely to focus on the text, disregarding the layout and its elements. We will then put together a plan including our recommendations. This plan will include our fees so you can see upfront. If you are happy with the plan and the fees we will then put the plan into action. <strong>We will beauty review</strong> how things are going in line with the review schedule in the plan. Flex Smooth and Elastic and its many variants have been employed since the early 1970ies, and quite likely since the sixteenth century.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person9.jpg\" alt=\"Gigi “Outside the box” Devaureaux\" /><br /><br /></div>\n<p>I’m a freelance fashion designer who specialises in print designs and combining fabrics. My designs have been sold all over Europe and the USA and I have worked with some of the biggest designers in the industry. I’m also currently working with a big supermarket to develop a gorgeous, yet affordable, range of beautifully printed key pieces that no women’s wardrobe should be without!</p>\n<h5>Gigi “Outside the box” Devaureaux</h5>\n</div>', 1, 28, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/picsum.photos\\/720\\/420?image=1065\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"https:\\/\\/picsum.photos\\/1280\\/620?image=1065\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(50, 245, 'Wholetones 527Hz Transformation Music', 'wholetones-527hz-transformation', '<p><span>The frequencies have been handed down from ancient, Biblical times and are believed to have been used by King David to soothe Saul in his desperate time of need for healing. Now you too can have this blessed collection of modern music with ancient healing powers. </span>It features both plectrum and finger picking, and Blumlein stereo recordings alongside the piezo pickup perspective.</p>', '<p><span>Listeners report that Little Bird removes stress, soothes anxiety and may even help to relieve pain. Word of this incredible collection of divinely inspired music has spread around the world like wildfire! Composer Michael S. Tyrrell was given a very special and powerful gift one night in Israel. After nearly 2 decades, he’s finally discovered a way to share these amazing healing frequencies with you and everyone who listens. The frequencies have been handed down from ancient, Biblical times and are believed to have been used by King David to soothe Saul in his desperate time of need for healing. Now you too can have this blessed collection of modern music with ancient healing powers. 7 songs, nearly 3 hours of blissful healing for the soul. Included is Michael’s new book Wholetones: The Sound of Healing so you can experience the incredible story of how Wholetones came to be.</span></p>\n<p>Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \"de Finibus Bonorum et Malorum\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \"Lorem ipsum dolor sit amet..\", comes from a line in section 1.10.32.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">The Healing Frequency Music Project Song!</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 10px 5px; text-align: center;\">M</span><strong>usic packages in a range of subject</strong> on where to travel in 2022 mentioned previously in this chapter, and the dreams in the chapter on the subconscious. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good! Thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way..</p>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>Adaptable</li>\n<li><i class=\"fa fa-check\"></i>Ajax Compatible</li>\n<li><i class=\"fa fa-check\"></i>100% Fully responsive</li>\n<li><i class=\"fa fa-check\"></i>Article Post Formats</li>\n<li><i class=\"fa fa-check\"></i>Drag and Drop Page Builder</li>\n<li><i class=\"fa fa-check\"></i>Extended Portfolio</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Exclusive</li>\n<li>Degaré Compliment Slips</li>\n<li>Steadfast availability</li>\n<li>Business cards</li>\n<li>Flyers &amp; Mailers</li>\n<li>Industry Awards</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"360\" src=\"https://www.youtube.com/embed/nGuiwddZNBk\" frameborder=\"0\" allow=\"autoplay\" allowfullscreen=\"allowfullscreen\"></iframe></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3>The wise man therefore always holds in these matters.</h3>\n<hr />\n<blockquote>In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services or the DIY route. It\'s bound to become a warm-weather favorite. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good!</blockquote>\n</div>\n<p><span>These cases are perfectly simple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted. The wise man therefore always holds in these matters to this principle of selection: he rejects pleasures to secure other greater pleasures, or else he endures pains to avoid worse pains</span>!</p>\n<p><em><strong>Flex Scheduling:</strong></em> In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services or the DIY route.</p>\n<p>Think of your travel agent as your Expert Personal Concierge: Beyond handling the logistics (such as knowing up-to-date visa requirement and the best restaurants to make a romantic dinner reservation,) travel agents have spent their entire careers’ studying the travel industry and gaining expert insider knowledge and local hook-ups that will make your trip unforgettable (and stress-free!)</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person2.jpg\" alt=\"Claire Sébastien Claudereux\" /><br /><br /></div>\n<p>I\'ve enjoyed what you think how bout the other way around? In today’s working world, time off is becoming increasingly valuable. To be successful you’ve got to work hard, to make history, simple, you’ve got to make it. We the best. Special cloth alert. They never said winning was easy. Some people can’t handle success, I can. They don’t want us to win. They don’t want us to eat. It’s on you how you want to live your life. Everyone has a choice. I pick my choice, squeaky clean.</p>\n<h5>Claire Claudereux</h5>\n</div>', 1, 29, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/i1.sndcdn.com\\/artworks-000263312543-3pwdq9-t500x500.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"audio\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"<iframe width=\\\"100%\\\" height=\\\"300\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" allow=\\\"autoplay\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/363078791&color=%23ff5500&auto_play=false&hide_related=true&show_comments=false&show_user=false&show_reposts=false&show_teaser=false&visual=true\\\"><\\/iframe>\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 1, 'Audio, Flamenco Guitar, Soundcloud, Audio, Guitar', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(51, 247, 'Best of 5 Instrumental Music Recordings', 'best-of-5-instrumental-music-recordings', '<p><span>If you have enough people wanting to attend the same course then we can run one just for you. If you prefer to study in your own time and at your own speed then one of our e learning packages may be right up your street. There is a third option, which is you like the sound of both but perhaps can’t attend all training sessions, this is when blended learning comes into its own.</span></p>', '<p>Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of \"de Finibus Bonorum et Malorum\" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, \"Lorem ipsum dolor sit amet..\", comes from a line in section 1.10.32.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">The Healing Frequency Music Project Song!</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 10px 5px; text-align: center;\">M</span><strong>usic packages in a marks of subject</strong> on where to travel in 2022 mentioned previously in this chapter, and the dreams in the chapter on the subconscious. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good! Thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way..</p>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>Adaptable</li>\n<li><i class=\"fa fa-check\"></i>Ajax Compatible</li>\n<li><i class=\"fa fa-check\"></i>100% Fully responsive</li>\n<li><i class=\"fa fa-check\"></i>Article Post Formats</li>\n<li><i class=\"fa fa-check\"></i>Drag and Drop Page Builder</li>\n<li><i class=\"fa fa-check\"></i>Extended Portfolio</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Exclusive</li>\n<li>Degaré Compliment Slips</li>\n<li>Steadfast availability</li>\n<li>Business cards</li>\n<li>Flyers &amp; Mailers</li>\n<li>Industry Awards</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"360\" src=\"https://www.youtube.com/embed/nGuiwddZNBk\" frameborder=\"0\" allow=\"autoplay\" allowfullscreen=\"allowfullscreen\"></iframe></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3>The wise man therefore always holds in these matters.</h3>\n<hr />\n<blockquote>In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services or the DIY route. It\'s bound to become a warm-weather favorite. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good!</blockquote>\n</div>\n<p><span>These cases are perfectly simple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted. The wise man therefore always holds in these matters to this principle of selection: he rejects pleasures to secure other greater pleasures, or else he endures pains to avoid worse pains</span>!</p>\n<p><em><strong>Flex Scheduling:</strong></em> In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services or the DIY route.</p>\n<p>Think of your travel agent as your Expert Personal Concierge: Beyond handling the logistics (such as knowing up-to-date visa requirement and the best restaurants to make a romantic dinner reservation,) travel agents have spent their entire careers’ studying the travel industry and gaining expert insider knowledge and local hook-ups that will make your trip unforgettable (and stress-free!)</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person2.jpg\" alt=\"Claire Sébastien Claudereux\" /><br /><br /></div>\n<p>I\'ve enjoyed what you think how bout the other way around? In today’s working world, time off is becoming increasingly valuable. To be successful you’ve got to work hard, to make history, simple, you’ve got to make it. We the best. Special cloth alert. They never said winning was easy. Some people can’t handle success, I can. They don’t want us to win. They don’t want us to eat. It’s on you how you want to live your life. Everyone has a choice. I pick my choice, squeaky clean.</p>\n<h5>Claire Claudereux</h5>\n</div>', 1, 29, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/thumbnailer.mixcloud.com\\/unsafe\\/600x600\\/extaudio\\/5\\/5\\/4\\/8\\/cbcd-39f2-4d70-8e1a-30da77b2e6d7\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"audio\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"<iframe width=\\\"100%\\\" height=\\\"320\\\" src=\\\"https:\\/\\/www.mixcloud.com\\/widget\\/iframe\\/?light=1&feed=%2FMaster_of_Instrumental%2Fbest-of-instrumental%2F\\\" frameborder=\\\"0\\\" ><\\/iframe>\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 0, 'Audio, Flamenco Guitar, Soundcloud, Audio, Guitar', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(52, 249, 'Does a Blog Post Look Better With a Featured Image?', 'does-a-blog-post-look-better-with-a-featured-image', '<p><span>We offer a range of training packages in a range of subject areas and can offer blended learning opportunities to best meet your needs. If sitting in a room with a trainer and having the opportunity for discussion with other learners sounds good to you then we can offer this. If you have enough people wanting to attend the same course then we can run one just for you. If you prefer to study in your own time and at your own speed then one of our e learning packages may be right up your street. There is a third option, which is like the sound of both but perhaps can’t attend all training sessions, this is when blended learning comes into its own.</span></p>\r\n', '\r\n<p>The copy warned the <span>own speed</span> Text, that where it came from it would have been rewritten a thousand times and everything that was left from its origin would be the word \"and\" and the Little Blind Text should turn around and return to its own, safe country. But nothing the copy said could convince her and so it didn’t take long until a few insidious Copy Writers ambushed her, made her drunk with Longe and Parole and dragged her into their agency, where they abused her for their projects again and again.</p>\r\n<p><span>We offer a range of training packages in a range of subject areas and can offer blended learning opportunities to best meet your needs. If sitting in a room with a trainer and having the opportunity for discussion with other learners sounds good to you then we can offer this. If you have enough people wanting to attend the same course then we can run one just for you. If you prefer to study in your own time and at your own speed then one of our e learning packages may be right up your street. There is a third option, which is you like the sound of both but perhaps can’t attend all training sessions, this is when blended learning comes into its own.</span>!</p>\r\n<div class=\"break20\"></div>\r\n<hr />\r\n<div class=\"dropcaps\">\r\n<h3 class=\"main-title\">It is a paradisematic country, in which roasted parts!</h3>\r\n<hr />\r\n<div class=\"break20\"></div>\r\n<div class=\"row\">\r\n<div class=\"col-md-7 naked-drop\">\r\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 10px 5px; text-align: center;\">T</span><strong>raining packages in a range of subject</strong> on where to travel in 2018 mentioned previously in this chapter, and the dreams in the chapter on the subconscious. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good! Thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way..</p>\r\n<div class=\"bullets\">\r\n<div class=\"col-md-6\">\r\n<ul class=\"site-list\">\r\n<li><i class=\"fa fa-check\"></i>Adaptable</li>\r\n<li><i class=\"fa fa-check\"></i>Ajax Compatible</li>\r\n<li><i class=\"fa fa-check\"></i>100% Fully responsive</li>\r\n<li><i class=\"fa fa-check\"></i>Article Post Formats</li>\r\n<li><i class=\"fa fa-check\"></i>Drag and Drop Page Builder</li>\r\n<li><i class=\"fa fa-check\"></i>Extended Portfolio</li>\r\n</ul>\r\n</div>\r\n<div class=\"col-md-6\">\r\n<ul class=\"site-list li-circle\">\r\n<li>Exclusive</li>\r\n<li>Degaré Compliment Slips</li>\r\n<li>Steadfast availability</li>\r\n<li>Business cards</li>\r\n<li>Flyers &amp; Mailers</li>\r\n<li>Industry Awards</li>\r\n</ul>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"300\" src=\"https://www.youtube.com/embed/2ah25IXK0SA\" frameborder=\"0\" allow=\"autoplay\" allowfullscreen=\"allowfullscreen\"></iframe></div>\r\n</div>\r\n</div>\r\n<div class=\"break20\"></div>\r\n<div class=\"break20\"></div>\r\n<div class=\"blockquotes\">\r\n<h3>Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</h3>\r\n<hr />\r\n<blockquote>In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services or the DIY route. It\'s bound to become a warm-weather favorite. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good!</blockquote>\r\n</div>\r\n<p><span>These cases are perfectly simple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted. The wise man therefore always holds in these matters to this principle of selection: he rejects pleasures to secure other greater pleasures, or else he endures pains to avoid worse pains</span>!</p>\r\n<p><em><strong>Flex Scheduling:</strong></em> In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services or the DIY route.</p>\r\n<p>Think of your travel agent as your Expert Personal Concierge: Beyond handling the logistics (such as knowing up-to-date visa requirement and the best restaurants to make a romantic dinner reservation,) travel agents have spent their entire careers’ studying the travel industry and gaining expert insider knowledge and local hook-ups that will make your trip unforgettable (and stress-free!)</p>\r\n<div class=\"break20\"></div>\r\n<hr />\r\n<div class=\"break20\"></div>\r\n<div class=\"row-fluid\">\r\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person1.jpg\" alt=\"Antoine Devereux\" /><br /><br /></div>\r\n<p>I\'ve enjoyed what you think how bout the other way around? In today’s working world, time off is becoming increasingly valuable. To be successful you’ve got to work hard, to make history, simple, you’ve got to make it. We the best. Special cloth alert. They never said winning was easy. Some people can’t handle success, I can. They don’t want us to win. They don’t want us to eat. It’s on you how you want to live your life. Everyone has a choice. I pick my choice, squeaky clean.</p>\r\n<h5>Antoine Devereux</h5>\r\n</div>', 1, 30, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/ajax-articles\\/flex-iwatch.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/ajax-articles\\/flex-iwatch.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":\"1\",\"margin_between_items\":\"0\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":\"44\",\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":\"0\",\"autoplay\":\"1\",\"auto_transition\":\"5\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"https:\\/\\/www.youtube.com\\/embed\\/GRFQ8jrrf9o\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(53, 251, 'Are Profits Progressive Or Is Profit a Dirty Word?', 'are-profits-progressive-or-is-profit-a-dirty-word', '<p>Would the world be better off without them? Or are profits progressive -- the only thing that can move potatoes from Idaho to Manhattan and medicine from America to Africa? Professor and economist Walter William Shakespeareaux II explains. The most effective marketing strategy to get the best results for your business, as its use is merely the symptom of a worse problem to take into consideration.</p>', '<p>We have a number of different teams within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way of doing things that worked 10 years, 5 years or even a year ago. You begin with a text, you sculpt information, you chisel away what\'s not needed, you come to the point, make things clear, add value, you\'re a content person, you like words. A<span>dvertising agency</span> is no after thought, far from it, but it comes in a deserved second. Anyway, you still use Lorem Ipsum and rightly so, as it will always have a place in the web workers toolbox, as things happen, not always the way you like it, not always in the preferred order. Even if your less into design and more into content strategy you may find some redeeming value with, wait for it, dummy copy, no less.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">”Profits Are Progressive“ says director of publications at Flex College in Virginia;</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 5px 5px; text-align: center;\">P</span><strong>rofit a dirty word?</strong> Would the world be better off without them? Or are profits progressive - the only thing that can move potatoes from Idaho to Manhattan and medicine from America to Africa? Professor and economist Walter Flex Williams explains. Flex, then art director with Aldus, modified prior versions of Lorem Ipsum text from typographical specimens; in lettering catalogs by Beaunauheaux LaVaurnieaux.</p>\n<div class=\"break20\"></div>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-money\"></i>Lettering catalogs</li>\n<li><i class=\"fa fa-check-square-o\"></i>Insurance &amp; Financial Protection</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Investments and Pensions</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"260\" src=\"https://www.youtube.com/embed/lyIOPmldKfQ\" frameborder=\"0\" allow=\"autoplay\" allowfullscreen=\"allowfullscreen\"></iframe></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3><i style=\"font-size: 130%; line-height: 1.5; vertical-align: middle; margin: -5px 8px 0 0;\" class=\"pe pe-7s-cash major_color\"></i> Financial Advisors Who are Happy to Meet.</h3>\n<hr />\n<blockquote>We are a friendly firm of Financial Advisors <span>from an advertising agency </span>who are happy to meet with you face to face or liaise with you via the phone or email to provide a service that’s right for you. Our Services included offering advice and solutions on Mortgages, Insurance, Financial Protection, Investments and Pensions. Our aim is to leave you worry free about your finances because you know they are in safe hands!</blockquote>\n</div>\n<p>We have a number of different teams within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way of doing things that worked 10 years, 5 years or even a year ago.</p>\n<p>However, reviewers tend to be distracted by comprehensible content, say, a random text copied from a newspaper or the internet. We can create a brand that stands out and truly reflects your business and the message you want to convey. The are likely to focus on the text, disregarding the layout and its elements. We will then put together a plan including our recommendations. This plan will include our fees so you can see upfront what you will need to pay. If you are happy with the plan and the fees we will then put the plan into action. <strong>We will regularly review</strong> how things are going in line with the review schedule in the plan. Flex Smooth and Elastic<span> and its many variants have been employed since the early 1960ies, and quite likely since the sixteenth century</span>.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person6.jpg\" alt=\"Richard MacIntosh\" /><br /><br /></div>\n<p>If you run a business and want a professional first point of contact or just need a hand with some of the day to day to business tasks because things are getting a bit busy, then we can help. Whatever the level of support you require, we are sure that we will have a package that meets your needs. All of our virtual professionals are highly experienced in the areas in which they work and have been through a thorough recruitment process to ensure they deliver to the high standard that you would want for your business.</p>\n<h5>Richard MacIntosh</h5>\n</div>\n<div class=\"break20\"></div>', 1, 30, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/i.ytimg.com\\/vi\\/tdHwewUuXBg\\/hqdefault.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"video\",\"gallery\":\"\",\"items_per_row\":2,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"https:\\/\\/www.youtube.com\\/embed\\/tdHwewUuXBg\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(54, 253, 'How to Support Your Own Support Team?', 'how-to-support-your-own-support-team', '<p>Service for extended hours or to include weekends or bank holidays cost up to $80.</p>\r\n', '\r\n<figure style=\"margin: 7px 20px 0 0;\" class=\"pull-left\"><img class=\"img-responsive img-rounded\" src=\"images/blog/ajax-articles/girl-eating-large.jpg\" alt=\"Support is Awesome\" width=\"204\" height=\"216\" />\r\n<figcaption style=\"font-size: 12px;\" class=\"centered\">Support is Awesome!</figcaption>\r\n</figure>\r\n<p>We have a number of different teams within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Then we have packages that cost up to $80 and with every package you can add additional options such as voicemail services for a small additional charge. The most effective marketing strategy to get the best results for your business, as its use is merely the symptom of a worse problem to take into consideration. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way of doing things that worked 10 years, 5 years or even a year ago. You begin with a text, you sculpt information, you chisel away what\'s not needed, you come to the point, make things clear, add value, you\'re a content person, you like words. Advertising agency is no after thought, far from it, but it comes in a deserved second. Anyway, you still use Lorem Ipsum and rightly so, as it will always have a place in the web workers toolbox, as things happen, not always the way you like it, not always in the preferred order. Even if your less into design and more into content strategy you may find some redeeming value with, wait for it, dummy copy, no less.</p>\r\n<div class=\"break20\"></div>\r\n<hr />\r\n<div class=\"dropcaps\">\r\n<h3 class=\"main-title\">”Support is refreshing“ says director of public relations at Flex College in Virginia;</h3>\r\n<hr />\r\n<div class=\"break20\"></div>\r\n<div class=\"row\">\r\n<div class=\"col-md-7 naked-drop\">\r\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 5px 5px; text-align: center;\">S</span><strong>upport is Supported?</strong> Would the world be better off without them? Or are support issues progressive - the only thing that can move potatoes from Idaho to Manhattan and medicine from America to Africa? Professor and economist Walter Flex Williams explains. Flex, then art director with Aldus, modified prior versions of Lorem Ipsum text from typographical specimens; in lettering catalogs by Beaunauheaux LaSuppornieaux.</p>\r\n<div class=\"break20\"></div>\r\n<div class=\"bullets\">\r\n<div class=\"col-md-6\">\r\n<ul class=\"site-list\">\r\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\r\n<li><i class=\"fa fa-id-badge\"></i>Lettering catalogs</li>\r\n<li><i class=\"fa fa-handshake-o\"></i>Insurance &amp; Financial Protection</li>\r\n<li><i class=\"fa fa-balance-scale\"></i>Balance Scale</li>\r\n</ul>\r\n</div>\r\n<div class=\"col-md-6\">\r\n<ul class=\"site-list li-circle\">\r\n<li>Investments and Pensions</li>\r\n<li>24/7</li>\r\n<li>0 fat (0 saturated fat)</li>\r\n<li>0 cholesterol</li>\r\n</ul>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"col-md-5\"><img class=\"img-responsive img-rounded\" src=\"images/blog/ajax-articles/flex-stationery.jpg\" alt=\"Support\" /></div>\r\n</div>\r\n</div>\r\n<div class=\"break20\"></div>\r\n<div class=\"break20\"></div>\r\n<div class=\"blockquotes\">\r\n<h3><i style=\"font-size: 130%; line-height: 1.2; vertical-align: middle; margin: -8px 8px 0 0;\" class=\"pe pe-7s-coffee major_color\"></i> Financial Advisors Who are Happy to Meet.</h3>\r\n<hr />\r\n<blockquote>We are a friendly firm of Financial Advisors <span>from an advertising agency </span>who are happy to meet with you face to face or liaise with you via the phone or email to provide a service that’s right for you. Our Services included offering advice and solutions on Mortgages, Insurance, Financial Protection, Investments and Pensions. Our aim is to leave you worry free about your finances because you know they are in safe hands!</blockquote>\r\n</div>\r\n<p>We have a number of different teams within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, not someone who is relying on the same way of doing things that worked 10 years, 5 years or even a year ago.</p>\r\n<p>However, reviewers tend to be distracted by comprehensible content, say, a random text copied from a newspaper or the internet. We can create a brand that stands out and truly reflects your business and the message you want to convey. The are likely to focus on the text, disregarding the layout and its elements. We will then put together a plan including our recommendations. This plan will include our fees so you can see upfront what you will need to pay. If you are happy with the plan and the fees we will then put the plan into action. <strong>We will regularly review</strong> how things are going in line with the review schedule in the plan. Flex Smooth and Elastic<span> and its many variants have been employed since the early 1960ies, and quite likely since the sixteenth century</span>.</p>\r\n<div class=\"break20\"></div>\r\n<hr />\r\n<div class=\"break20\"></div>\r\n<div class=\"row-fluid\">\r\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person6.jpg\" alt=\"Richard MacIntosh\" /><br /><br /></div>\r\n<p>If you run a business and want a professional first point of contact or just need a hand with some of the day to day to business tasks because things are getting a bit busy, then we can help. Whatever the level of support you require, we are sure that we will have a package that meets your needs. All of our virtual professionals are highly experienced in the areas in which they work and have been through a thorough recruitment process to ensure they deliver to the high standard that you would want for your business.</p>\r\n<h5>Richard MacIntosh</h5>\r\n</div>', 1, 30, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/image.freepik.com\\/free-vector\\/support-team_1212-35.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"gallery\",\"gallery\":\"{\\\"gallery_images\\\":[\\\"images\\/2018\\/04\\/27\\/person1.jpg\\\",\\\"images\\/2018\\/04\\/27\\/person7.jpg\\\",\\\"images\\/2018\\/04\\/27\\/person5.jpg\\\",\\\"images\\/2018\\/04\\/27\\/person8.jpg\\\",\\\"images\\/2018\\/04\\/27\\/person10.jpg\\\",\\\"images\\/2018\\/04\\/27\\/person11.jpg\\\"]}\",\"items_per_row\":\"3\",\"margin_between_items\":\"12\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"fontawesome-angle\",\"arrow_size\":\"50\",\"arrows_color\":\"\",\"arrows_bg\":\"rgba(0,0,0,0)\",\"show_pager\":\"1\",\"autoplay\":\"1\",\"auto_transition\":\"7\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(55, 255, '10 Best Mockups for 2018/19 To Start Your Business', '10-best-mockups-for-2018-19-to-start-your-business', '<p>Ross has over 10 years experience in the industry. He is our Creative Director, digital designer, web designer and front-end developer. He is also pretty good with a sketchbook. Before starting the company Ross worked as a designer and studio manager for a design house who boasted a number of big name clients. Ross has brought his vast experience from this role to the work he does now.</p>', '<figure style=\"margin: 7px 20px 0 0;\" class=\"pull-left\"><img class=\"img-responsive img-rounded\" src=\"https://picsum.photos/420/300?image=180\" alt=\"New York Public Relations\" width=\"210\" height=\"150\" />\n<figcaption style=\"font-size: 12px;\" class=\"centered\">Flex Mockup Design Relations</figcaption>\n</figure>\n<p>Flex has over 10 years experience in the industry. He is our Creative Director, digital designer, web designer and front-end developer. He is also pretty good with a sketchbook. Before starting the company Ross worked as a designer and studio manager for a design house who boasted a number of big name clients. Ross has brought his vast experience from this role to the work he does now. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry and that’s what you want from an advertising agency, doing things that worked 10 years, to see a selection of my designs and sketches, which is how all my best designs start, take a look at my portfolio page. To see who I have worked with see my client list and stockists. Make things clear, add value, you\'re a content person, you like words. Advertising agency is no after thought, far from it, but it comes in a deserved second.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">Creative director, digital designer, web designer and front-end developer in 2018/19</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-sm-6 col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 5px 5px; text-align: center;\">M</span><strong>ockups are about to</strong> come to escape day to day life, focus on bringing new business to the company. They have won a number of big clients recently and both also have qualifications in project management to ensure that the projects run smoothly from start to finish. We offer a range of mockup designs and projects just for you. We have been selling stuff for years. If you don’t want to leave to comfort of your own home, why not have a look at our online store. We have some great new lines and also some fantastic seasonal offers on many of our ranges with up to 75%!</p>\n<div class=\"break20\"></div>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-id-badge\"></i>Lettering catalogs</li>\n<li><i class=\"fa fa-handshake-o\"></i>Fashion Protection</li>\n<li><i class=\"fa fa-balance-scale\"></i>Balance Scale</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Investments and Pensions</li>\n<li>24/7</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-sm-6 col-md-5\"><img class=\"img-responsive img-rounded\" src=\"images/blog/ajax-articles/flex-stationery.jpg\" alt=\"Flex Mockups\" /></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3><i style=\"font-size: 130%; line-height: 1.2; vertical-align: middle; margin: -8px 8px 0 0;\" class=\"pe pe-7s-light major_color\"></i>Flex\'s Mockup Design Creator – embroidery design and front-end developing selection.</h3>\n<hr />\n<blockquote>Art Director and specialises in graphic and print design from an advertising agency who are happy to meet with you face to face or liaise with you via the phone or email to provide a service that’s right for you. Our Services included offering advice and solutions on Financial Protection, Investments and Web-design. Our aim is to leave you worry free about your finances because you know they are in safe hands!</blockquote>\n</div>\n<p><img style=\"margin: 5px 0 10px 10px;\" class=\"img-rounded pull-right\" src=\"https://picsum.photos/480/340?image=532\" alt=\"Mockups 2018/19\" width=\"240\" height=\"170\" />We have a number of different teams within our agency that specialise in different areas of business so you can be sure that you won’t receive a generic service and although we can’t boast years and years of service we can ensure you that is a good thing in this industry. Our teams are up to date with the latest technologies, media trends and are keen to prove themselves in this industry</p>\n<p>However, reviewers tend to be distracted by comprehensible content, say, a random text copied from a newspaper or the internet. We can create a brand that stands out and truly reflects your business and the message you want to convey. The are likely to focus on the text, disregarding the layout and its elements. We will then put together a plan including our recommendations. This plan will include our fees so you can see upfront. If you are happy with the plan and the fees we will then put the plan into action. <strong>We will design review</strong> how things are going in line with the review schedule in the plan. Flex Smooth and Elastic and its many variants have been employed since the early 1960ies, and quite likely since the sixteenth century.</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person1.jpg\" alt=\"Novak Lavernieaux\" /><br /><br /></div>\n<p>Monica is Ross’ sister, our Art Director and specialises in graphic and print design. She has also worked with some big names and her designs have won her a number of industry awards. Rachel and Chandler are our Junior Designers. Rachel is a web designer with knowledge of HTML and CSS and supports Ross on projects. Chandler has just finished his Graphic Design degree and enjoys continuing to learn from Monica and building his experience.</p>\n<h5>Novak Lavernieaux</h5>\n</div>', 1, 30, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/ajax-articles\\/flex-coffee-cup.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/ajax-articles\\/flex-coffee-cup.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"{\\\"gallery_images\\\":[]}\",\"items_per_row\":3,\"margin_between_items\":12,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"fontawesome-angle\",\"arrow_size\":50,\"arrows_color\":\"\",\"arrows_bg\":\"rgba(0,0,0,0)\",\"show_pager\":1,\"autoplay\":1,\"auto_transition\":7,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(56, 257, 'Jenny\'s Simplest Ways to Choose the Best Beach Resorts', 'jenny-s-simplest-ways-to-choose-the-best-beach-resorts', '<p><span>I\'ve enjoyed what you think how bout the other way around? How can you evaluate content without vacation? No colors, no layout, no styles, allowing you to find the best hotel prices from the top travel sites in one simple search, go beyond the mere textual, hierarchies of information, weight, emphasis, oblique stresses, priorities, all those subtle cues that also have visual and emotional appeal to the reader, but then designers might want to ask them to provide style sheets with the copy decks they supply that are in tune with the design direction they require</span>.</p>', '<p>Leave me alone. Biff, stop it. Biff, you\'re breaking his arm. Biff, stop. What the hell is this? Well, it will just happen. Like the way I met your father. Alright, alright, okay McFly, get a grip on yourself. It\'s all a dream. Just a very intense dream. Woh, hey, listen, you gotta help me. Oh, thank you, thank you. Okay now, we run some industrial strength electrical cable from the top of the clocktower down to spreading it over the street between two lamp posts. Meanwhile, we out-fitted the vehicle with this big pole and hook which runs directly into the flux-capacitor. At the calculated moment, you start off from down the street driving toward the cable execrating to eighty-eight miles per hour. According to the flyer, at !0:04 pm lightning will strike the clocktower sending one point twenty-one gigawatts into the flux-capacitor, sending you back to 1985. Alright now, watch this. You wind up the car and release it, I\'ll simulate the lightening. Ready, set, release. Huhh. Huh? Yeah, who are you? I know, and all I could say is I\'m sorry. It works, ha ha ha ha, it works. I finally invent something that works.</p>\n<p>Don\'t worry. As long as you hit that wire with the connecting hook at precisely 88 miles per hour, the instance the lightning strikes the tower, everything will be fine. Yeah well, you shouldn\'t drink. Doc, you gotta help me. you were the only one who knows how your time machine works. Oh, oh Marty, here\'s you keys. You\'re all waxed up, ready for tonight. Uh, yeah.</p>\n<p>Something that really cooks. Alright, alright this is an oldie, but uh, it\'s an oldie where I come from. Alright guys, let\'s do some blues riff in b, watch me for the changes, and uh, try and keep up, okay. Yeah, gimme a Tab. You too. Of course, the Enchantment Under The Sea Dance they\'re supposed to go to this, that\'s where they kiss for the first time. Thank god I found you. Listen, can you meet me at Twin Pines Mall tonight at 1:15? I\'ve made a major breakthrough, I\'ll need your assistance.</p>', 1, 31, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/ajax-articles\\/jenny-blog-adventures-thumb.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/ajax-articles\\/jenny-blog-adventures.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 5, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`, `note`) VALUES
(57, 259, 'Why Do People Think Travel Sites Are So Interesting?', 'why-do-people-think-travel-sites-are-so-interesting', '<p><span>The dream mentioned previously in this chapter, and the dreams in the chapter on the subconscious, are all fairly easy to understand and I used them because they clearly illustrate how dreams can guide us. However, <span class=\"html-tag\">&lt;span&gt;</span>because they are so easily<span class=\"html-tag\">&lt;/span&gt;</span> decipherable, they are the exceptions. A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine, all those subtle cues that also have visual and emotional appeal to the reader, but then designers might want to ask them to provide style sheets with the copy decks they supply that are in tune with the design direction they require</span>.</p>', '<p><span>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine</span>. At the calculated moment, you start off from down the street driving toward the cable execrating to eighty-eight miles per hour. According to the flyer, at !0:04 pm lightning will strike the clocktower sending one point twenty-one gigawatts into the flux-capacitor, sending you back to 1985. Alright now, watch this. You wind up the car and release it, I\'ll simulate the lightening. Ready, set, release. Huhh. Huh? Yeah, who are you? I know, and all I could say is I\'m sorry. It works, ha ha ha ha, it works. I finally invent something that works.</p>\n<p>Don\'t worry. As long as you hit that wire with the connecting hook at precisely 88 miles per hour, the instance the lightning strikes the tower, everything will be fine. Yeah well, you shouldn\'t drink. Doc, you gotta help me. you were the only one who knows how your time machine works. Oh, oh Marty, here\'s you keys. You\'re all waxed up, ready for tonight. Uh, yeah.</p>\n<p>You do know, you do know that they don’t want you to have lunch. I’m keeping it real with you, so what you going do is have lunch. To succeed you must believe. When you believe, you will succeed. Cloth talk. Watch your back, but more importantly when you get out the shower, dry your back, it’s a cold world out there. It’s important to use cocoa butter. It’s the key to more success, why not live smooth? Why live rough? Stay focused. I’m up to something. I told you all this before, when you have a swimming pool, do not use chlorine, use salt water, the healing, salt water is the healing.</p>\n<p>Something that really cooks. Alright, alright this is an oldie, but uh, it\'s an oldie where I come from. Alright guys, let\'s do some blues riff in b, watch me for the changes, and uh, try and keep up, okay. Yeah, gimme a Tab. You too. Of course, the Enchantment Under The Sea Dance they\'re supposed to go to this, that\'s where they kiss for the first time. Thank god I found you. Listen, can you meet me at Twin Pines Mall tonight at 1:15? I\'ve made a major breakthrough, I\'ll need your assistance.</p>', 1, 31, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/picsum.photos\\/720\\/480?image=395\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"https:\\/\\/picsum.photos\\/1280\\/600?image=395\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 4, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(58, 261, 'Majestic Mountain Ranges You Can View From A Train', 'majestic-mountain-ranges-you-can-view-from-a-train', '<p><span>A wonderful serenity has taken possession of my luggage, like these sweet mornings of spring which I enjoy with my whole heart. I almost forgot my luggage. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine. At the calculated moment, you start off from down the street driving toward the cable execrating to eighty-eight miles per hour. However, <span class=\"html-tag\">&lt;span&gt;</span>because they are so easily<span class=\"html-tag\">&lt;/span&gt;</span> decipherable, they are the exceptions. A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine, all those subtle cues that also have visual and emotional appeal to the reader, but then designers might want to ask them to provide style sheets with the copy decks they supply that are in tune with the design direction they require</span>.</p>', '<p><span>A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. I am alone, and feel the charm of existence in this spot, which was created for the bliss of souls like mine</span>. At the calculated moment, you start off from down the street driving toward the cable execrating to eighty-eight miles per hour. According to the flyer, at !0:04 pm lightning will strike the clocktower sending one point twenty-one gigawatts into the flux-capacitor, sending you back to 1985. Alright now, watch this. You wind up the car and release it, I\'ll simulate the lightening. Ready, set, release. Huhh. Huh? Yeah, who are you? I know, and all I could say is I\'m sorry. It works, ha ha ha ha, it works. I finally invent something that works.</p>\n<p>Don\'t worry. As long as you hit that wire with the connecting hook at precisely 88 miles per hour, the instance the lightning strikes the tower, everything will be fine. Yeah well, you shouldn\'t drink. Doc, you gotta help me. you were the only one who knows how your time machine works. Oh, oh Marty, here\'s you keys. You\'re all waxed up, ready for tonight. Uh, yeah.</p>\n<p>You do know, you do know that they don’t want you to have lunch. I’m keeping it real with you, so what you going do is have lunch. To succeed you must believe. When you believe, you will succeed. Cloth talk. Watch your back, but more importantly when you get out the shower, dry your back, it’s a cold world out there. It’s important to use cocoa butter. It’s the key to more success, why not live smooth? Why live rough? Stay focused. I’m up to something. I told you all this before, when you have a swimming pool, do not use chlorine, use salt water, the healing, salt water is the healing.</p>\n<p>Something that really cooks. Alright, alright this is an oldie, but uh, it\'s an oldie where I come from. Alright guys, let\'s do some blues riff in b, watch me for the changes, and uh, try and keep up, okay. Yeah, gimme a Tab. You too. Of course, the Enchantment Under The Sea Dance they\'re supposed to go to this, that\'s where they kiss for the first time. Thank god I found you. Listen, can you meet me at Twin Pines Mall tonight at 1:15? I\'ve made a major breakthrough, I\'ll need your assistance.</p>', 1, 31, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/picsum.photos\\/720\\/460?image=204\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"https:\\/\\/picsum.photos\\/1280\\/540?image=204\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 2, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(59, 263, 'Try Looking At a Beautiful Photo From Above', 'try-looking-at-a-beautiful-photo-from-above', '<p>Travel professionals and experts manage countless relationships with hotel brands, airlines, and other travel services which can, in turn, score you upgrades, perks, and preferred service without racking up additional fees. Flex Scheduling: In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services or the DIY route.</p>\n<p>Think of your travel agent as your Expert Personal Concierge: Beyond handling the logistics (such as knowing up-to-date visa requirement and the best restaurants to make a romantic dinner reservation,) travel agents have spent their entire careers’ studying the travel industry and gaining expert insider knowledge and local hook-ups that will make your trip unforgettable (and stress-free!).</p>', '<p>Finally, travel agents allow you to have Peace of Mind. (Just take a listen to this Flex Travel voicemail to hear what we’re talking about -- you’ll never be in better hands!) From natural disasters to flight cancellations to sudden illnesses and everything in between, travel agents take the stress out of emergencies by handling all the last-minute changes in arrangements.</p>\n<p>We recommend using a travel agency, like Flex Travel, that matches you with experts in your desired destination’s niche to connect with the perfect travel agent for your needs. Have you ever used a travel agent before? If you’d like to be featured in an upcoming video, just ‘Like’ us on Facebook and share your travel professional experiences: You might be Travel Flex TV’s next guest!</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">Try looking at a beautiful photo from above!</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 10px 5px; text-align: center;\">B</span><strong>eautiful photo from above</strong> mentioned previously in this chapter, and the dreams in the chapter on the subconscious. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good! Three simple ingredients are all you need to create this fresh and fruity summer beverage. It\'s bound to become a warm-weather favorite.</p>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>Yummy</li>\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-check\"></i>Frozen sweetened sliced bananas</li>\n<li><i class=\"fa fa-check\"></i>2 liters lemon-lime soda.</li>\n<li><i class=\"fa fa-check\"></i>Frozen pink lemonade concentrate</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Jujubes dragée</li>\n<li>Seltzer water</li>\n<li>1-1/4 cups: 215 calories</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"300\" src=\"//www.dailymotion.com/embed/video/x2rmzd2\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3>Sift Through the Thousands of Vacation Packages Before Summer Ends</h3>\n<hr />\n<blockquote>In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services or the DIY route. It\'s bound to become a warm-weather favorite. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good!</blockquote>\n</div>\n<p>Finally, travel agents allow you to have Peace of Mind. (Just take a listen to this Flex Travel voicemail to hear what we’re talking about -- you’ll never be in better hands!) From natural disasters to flight cancellations to sudden illnesses and everything in between, travel agents take the stress out of emergencies by handling all the last-minute changes in arrangements. We recommend using a travel agency, like Flex Travel, that matches you with experts in your desired destination’s niche to connect with the perfect travel agent for your needs. Have you ever used a travel agent before? If you’d like to be featured in an upcoming video, just ‘Like’ us on Facebook and share your travel professional experiences: You might be Travel Flex TV’s next guest!</p>\n<p><em><strong>Flex Scheduling:</strong></em> In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services or the DIY route.</p>\n<p>Think of your travel agent as your Expert Personal Concierge: Beyond handling the logistics (such as knowing up-to-date visa requirement and the best restaurants to make a romantic dinner reservation,) travel agents have spent their entire careers’ studying the travel industry and gaining expert insider knowledge and local hook-ups that will make your trip unforgettable (and stress-free!)</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img style=\"border-radius: 50%; width: 120px; height: 110px;\" src=\"images/blog/ajax-articles/jenny-awesome.jpg\" alt=\"Jenny Awesome\" /><br /><br /></div>\n<p>I\'ve enjoyed what you think how bout the other way around? How can you evaluate content without design? No typography, no colors, no layout, no styles, all those things that convey the important signals that go beyond the mere textual, hierarchies of information, weight, emphasis, oblique stresses, priorities, all those subtle cues that also have visual and emotional appeal to the reader, but then designers might want to ask them to provide style sheets with the copy decks they supply that are in tune with the design direction they require.</p>\n<h5>Jenny Awesome</h5>\n</div>', 1, 31, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/portfolio\\/sea-sun\\/thumbs\\/sea-sun-03.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/portfolio\\/sea-sun\\/sea-sun-03.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"custom\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"<iframe frameborder=\\\"0\\\" width=\\\"100%\\\" height=\\\"320\\\" src=\\\"\\/\\/www.dailymotion.com\\/embed\\/video\\/x5jzdmj\\\" allowfullscreen=\\\"\\\" allow=\\\"autoplay\\\"><\\/iframe>\"}', 0, 3, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(60, 265, '5 Best Travel Destinations For 2018', '5-best-travel-destinations-for-2018', '<p><span>Here\'s our pick for the 5 best destinations to visit in 2018. From beautiful beaches to stunning mountain ranges and exciting city breaks, this list has everything you need for an incredible year of travel. We hope this video can inspire you on where to travel in 2018!</span></p>\n<p>Think of your travel agent as your Expert Personal Concierge: Beyond handling the logistics (such as knowing up-to-date visa requirement and the best restaurants to make a romantic dinner reservation,) travel agents have spent their entire careers’ studying the travel industry and gaining expert insider knowledge and local hook-ups that will make your trip unforgettable (and stress-free!).</p>', '<p>Finally, travel agents allow you to have Peace of Mind. (Just take a listen to this Flex Travel voicemail to hear what we’re talking about -- you’ll never be in better hands!) From natural disasters to flight cancellations to sudden illnesses and everything in between, travel agents take the stress out of emergencies by handling all the last-minute changes in arrangements.</p>\n<p>We recommend using a travel agency, like Flex Travel, that matches you with experts in your desired destination’s niche to connect with the perfect travel agent for your needs. Have you ever used a travel agent before? If you’d like to be featured in an upcoming video, just ‘Like’ us on Facebook and share your travel professional experiences: You might be Travel Flex TV’s next guest!</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"dropcaps\">\n<h3 class=\"main-title\">From Beautiful Beaches to Stunning Mountain Ranges!</h3>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row\">\n<div class=\"col-md-7 naked-drop\">\n<p><span style=\"font-size: 78px; line-height: 68px; padding: 0 10px 5px; text-align: center;\">W</span><strong>e hope this video can inspire you</strong> on where to travel in 2018 mentioned previously in this chapter, and the dreams in the chapter on the subconscious. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good! Three simple ingredients are all you need to create this fresh and fruity summer beverage. It\'s bound to become a warm-weather favorite.</p>\n<div class=\"bullets\">\n<div class=\"col-md-6\">\n<ul class=\"site-list\">\n<li><i class=\"fa fa-check\"></i>Yummy</li>\n<li><i class=\"fa fa-check\"></i>So refreshing!</li>\n<li><i class=\"fa fa-check\"></i>Frozen sweetened sliced bananas</li>\n<li><i class=\"fa fa-check\"></i>2 liters lemon-lime soda.</li>\n<li><i class=\"fa fa-check\"></i>Frozen pink lemonade concentrate</li>\n</ul>\n</div>\n<div class=\"col-md-6\">\n<ul class=\"site-list li-circle\">\n<li>Jujubes dragée</li>\n<li>Seltzer water</li>\n<li>1-1/4 cups: 215 calories</li>\n<li>0 fat (0 saturated fat)</li>\n<li>0 cholesterol</li>\n</ul>\n</div>\n</div>\n</div>\n<div class=\"col-md-5\"><iframe width=\"100%\" height=\"300\" src=\"https://www.youtube.com/embed/2ah25IXK0SA\" frameborder=\"0\" allow=\"autoplay\" allowfullscreen=\"allowfullscreen\"></iframe></div>\n</div>\n</div>\n<div class=\"break20\"></div>\n<div class=\"break20\"></div>\n<div class=\"blockquotes\">\n<h3>Sift Through the Thousands of Vacation Packages Before Summer Ends</h3>\n<hr />\n<blockquote>In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services or the DIY route. It\'s bound to become a warm-weather favorite. You\'ve got to try these tart n\' yummy strawberry spritzers... we promise they\'re berry good!</blockquote>\n</div>\n<p>Finally, travel agents allow you to have Peace of Mind. (Just take a listen to this Flex Travel voicemail to hear what we’re talking about -- you’ll never be in better hands!) From natural disasters to flight cancellations to sudden illnesses and everything in between, travel agents take the stress out of emergencies by handling all the last-minute changes in arrangements. We recommend using a travel agency, like Flex Travel, that matches you with experts in your desired destination’s niche to connect with the perfect travel agent for your needs. Have you ever used a travel agent before? If you’d like to be featured in an upcoming video, just ‘Like’ us on Facebook and share your travel professional experiences: You might be Travel Flex TV’s next guest!</p>\n<p><em><strong>Flex Scheduling:</strong></em> In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services or the DIY route.</p>\n<p>Think of your travel agent as your Expert Personal Concierge: Beyond handling the logistics (such as knowing up-to-date visa requirement and the best restaurants to make a romantic dinner reservation,) travel agents have spent their entire careers’ studying the travel industry and gaining expert insider knowledge and local hook-ups that will make your trip unforgettable (and stress-free!)</p>\n<div class=\"break20\"></div>\n<hr />\n<div class=\"break20\"></div>\n<div class=\"row-fluid\">\n<div style=\"margin-top: 10px;\" class=\"pull-left\"><img class=\"img-circle\" src=\"images/pagebuilder/testimonials/120x120/person3.jpg\" alt=\"Valérie Soufflé\" /><br /><br /></div>\n<p>I\'ve enjoyed what you think how bout the other way around? In today’s working world, time off is becoming increasingly valuable. Travel agents will plan your trip in an intelligent, time-saving, efficient manner unparalleled by online services to the reader, but then designers might want to ask them to handling the logistics (such as knowing up-to-date visa requirement and the best restaurants to make a romantic dinner reservation,) travel agents have spent their entire careers’ studying the travel industry and gaining expert insider knowledge.</p>\n<h5>Valérie Soufflé</h5>\n</div>', 1, 31, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/portfolio\\/sea-sun\\/thumbs\\/sea-sun-12.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/portfolio\\/sea-sun\\/sea-sun-12.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":0,\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"video\",\"gallery\":\"\",\"items_per_row\":1,\"margin_between_items\":0,\"transition_effect\":\"slide\",\"transition_duration\":700,\"show_arrows\":1,\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":44,\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":0,\"autoplay\":1,\"auto_transition\":5,\"ltr_rtl\":1,\"audio\":\"\",\"video\":\"https:\\/\\/www.youtube.com\\/embed\\/GRFQ8jrrf9o\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 1, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', ''),
(61, 275, 'GDPR Privacy Policy', 'gdpr-privacy-policy', '', '', 1, 2, '2019-03-17 13:31:23', 171, '', '2019-03-17 13:31:23', 171, 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', '{\"image_intro\":\"https:\\/\\/picsum.photos\\/640\\/380?image=341\",\"float_intro\":\"\",\"image_intro_alt\":\"GDPR Privacy Policy\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"0\",\"link_titles\":\"0\",\"show_tags\":\"0\",\"show_intro\":\"0\",\"info_block_position\":\"1\",\"info_block_show_title\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_vote\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"spfeatured_image\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"items_per_row\":\"1\",\"margin_between_items\":\"0\",\"transition_effect\":\"slide\",\"transition_duration\":\"700\",\"show_arrows\":\"1\",\"arrow_icons\":\"pixeden-angle\",\"arrow_size\":\"44\",\"arrows_color\":\"\",\"arrows_bg\":\"\",\"show_pager\":\"0\",\"autoplay\":\"1\",\"auto_transition\":\"5\",\"ltr_rtl\":\"1\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\",\"custom_post\":\"\"}', 0, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '', '');

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE IF NOT EXISTS `#__contentitem_tag_map` (
  `type_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Maps items from content tables to tags';

INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES
('com_content.article', 7, 12, 9, '2019-03-17 12:31:23', 1),
('com_content.article', 8, 13, 6, '2019-03-17 12:31:23', 1),
('com_content.article', 5, 15, 7, '2019-03-17 12:31:23', 1),
('com_content.article', 5, 15, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 2, 16, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 3, 17, 5, '2019-03-17 12:31:23', 1),
('com_content.article', 6, 18, 8, '2019-03-17 12:31:23', 1),
('com_content.article', 1, 36, 4, '2019-03-17 12:31:23', 1),
('com_content.article', 9, 38, 10, '2019-03-17 12:31:23', 1),
('com_content.article', 10, 40, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 11, 41, 10, '2019-03-17 12:31:23', 1),
('com_content.article', 11, 41, 7, '2019-03-17 12:31:23', 1),
('com_content.article', 12, 42, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 13, 43, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 13, 43, 6, '2019-03-17 12:31:23', 1),
('com_content.article', 14, 44, 5, '2019-03-17 12:31:23', 1),
('com_content.article', 14, 44, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 15, 45, 5, '2019-03-17 12:31:23', 1),
('com_content.article', 16, 46, 9, '2019-03-17 12:31:23', 1),
('com_content.article', 17, 48, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 18, 49, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 19, 50, 4, '2019-03-17 12:31:23', 1),
('com_content.article', 20, 51, 4, '2019-03-17 12:31:23', 1),
('com_content.article', 21, 52, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 22, 53, 5, '2019-03-17 12:31:23', 1),
('com_content.article', 23, 54, 7, '2019-03-17 12:31:23', 1),
('com_content.article', 24, 55, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 25, 56, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 26, 57, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 26, 57, 10, '2019-03-17 12:31:23', 1),
('com_content.article', 27, 58, 3, '2019-03-17 12:31:23', 1),
('com_content.article', 27, 58, 10, '2019-03-17 12:31:23', 1),
('com_content.article', 28, 59, 10, '2019-03-17 12:31:23', 1),
('com_content.article', 29, 60, 5, '2019-03-17 12:31:23', 1);

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(22, 1),
(27, 2),
(29, 3),
(34, 4);

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `rating_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__content_rating` (`content_id`, `rating_sum`, `rating_count`, `lastip`) VALUES
(1, 8, 2, '::1'),
(13, 9, 2, '::1'),
(16, 8, 2, '::1'),
(17, 9, 2, '::1'),
(22, 8, 2, '::1'),
(36, 8, 2, '::1'),
(37, 5, 1, '::1'),
(38, 5, 1, '::1'),
(41, 5, 1, '::1'),
(50, 5, 1, '::1'),
(51, 4, 1, '::1'),
(52, 5, 1, '::1'),
(53, 4, 1, '::1'),
(54, 5, 1, '::1'),
(56, 5, 1, '::1'),
(57, 5, 1, '::1');

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE IF NOT EXISTS `#__content_types` (
  `type_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"Content\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(2, 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"Contact\",\"prefix\":\"ContactTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
(3, 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"Newsfeed\",\"prefix\":\"NewsfeedsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(4, 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerdate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', 'UsersHelperRoute::getUserRoute', ''),
(5, 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(6, 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(7, 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(8, 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"Tag\",\"prefix\":\"TagsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(9, 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"Banner\",\"prefix\":\"BannersTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(10, 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(11, 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"Client\",\"prefix\":\"BannersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
(12, 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"Note\",\"prefix\":\"UsersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(13, 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE IF NOT EXISTS `#__core_log_searches` (
  `search_term` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE IF NOT EXISTS `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_data` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10197 DEFAULT CHARSET=utf8;

INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 0, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mailto\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 0, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 0, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 0, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 0, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 0, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 0, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 0, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"allow_vcard_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_category_crumb\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 0, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_jed_info\":\"1\",\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 0, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 0, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 0, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS,mp4\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 0, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 0, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 0, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 0, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 0, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 0, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"2\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 0, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"1\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_tags\":\"1\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"captcha\":\"0\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"1\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"list_show_votes\":\"0\",\"list_show_ratings\":\"0\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"0\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_advanced\":0,\"sef_ids\":0,\"custom_fields_enable\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 0, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 0, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 0, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"1\",\"useractivation\":\"1\",\"mail_to_admin\":\"0\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"minimum_length\":\"4\",\"minimum_integers\":\"0\",\"minimum_symbols\":\"0\",\"minimum_uppercase\":\"0\",\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 0, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"snowball\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.2\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 0, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"show_tag_num_items\":\"1\",\"tag_list_orderby\":\"match_count\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"1\",\"tag_list_show_item_description\":\"1\",\"tag_list_item_maximum_characters\":-1,\"min_term_length\":\"3\",\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 0, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 1, '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(33, 0, 'com_fields', 'component', 'com_fields', '', 1, 1, 1, 0, '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(34, 0, 'com_associations', 'component', 'com_associations', '', 1, 1, 1, 0, '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(456, 0, 'PLG_INSTALLER_FOLDERINSTALLER', 'plugin', 'folderinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"PLG_INSTALLER_FOLDERINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(457, 0, 'PLG_INSTALLER_URLINSTALLER', 'plugin', 'urlinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"PLG_INSTALLER_URLINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(102, 0, 'LIB_PHPUTF8', 'library', 'phputf8', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPUTF8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phputf8\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 0, 'LIB_JOOMLA', 'library', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"LIB_JOOMLA\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"e26bc66ffb13d60dd9e7870f368c97a8\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 0, 'LIB_IDNA', 'library', 'idna_convert', '', 0, 1, 1, 1, '{\"name\":\"LIB_IDNA\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"phlyLabs\",\"copyright\":\"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de\",\"authorEmail\":\"phlymail@phlylabs.de\",\"authorUrl\":\"http:\\/\\/phlylabs.de\",\"version\":\"0.8.0\",\"description\":\"LIB_IDNA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"idna_convert\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 0, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2015-04-22 13:15:32\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2015 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.4.3\",\"description\":\"LIB_FOF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fof\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 0, 'LIB_PHPASS', 'library', 'phpass', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPASS\",\"type\":\"library\",\"creationDate\":\"2004-2006\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"http:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 0, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 0, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 0, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 0, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 0, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 0, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 0, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_search\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 0, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 0, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 0, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 0, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 0, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 0, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 0, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 0, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 0, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 0, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_status\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 0, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 0, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 0, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(400, 0, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"gmail\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 0, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"January 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}', '{\"style\":\"none\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 0, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"http:\\/\\/codemirror.net\\/\",\"version\":\"5.40.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 0, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"September 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2018\",\"author\":\"Ephox Corporation\",\"copyright\":\"Ephox Corporation\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"http:\\/\\/www.tinymce.com\",\"version\":\"4.5.9\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}', '{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"formatselect\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styleselect\",\"|\",\"formatselect\",\"fontselect\",\"fontsizeselect\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"template\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"*,[*],b,em,i,span,figure\",\"extended_elements\":\"strong,b,em,i,span,figure\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"span,i,p,a\",\"extended_elements\":\"span,i,p,a\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"*[*]\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 0, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 0, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 0, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 0, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}', '{\"detect_browser\":\"0\",\"automatic_change\":\"1\",\"item_associations\":\"1\",\"alternate_meta\":\"1\",\"xdefault\":\"1\",\"xdefault_language\":\"default\",\"remove_default_prefix\":\"0\",\"lang_cookie\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 0, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"p3p\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 0, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(425, 0, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 0, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 0, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(429, 0, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(430, 0, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 0, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{\"register-require_address1\":0,\"register-require_address2\":0,\"register-require_city\":0,\"register-require_region\":0,\"register-require_country\":1,\"register-require_postal_code\":0,\"register-require_phone\":0,\"register-require_website\":0,\"register-require_favoritebook\":0,\"register-require_aboutme\":0,\"register-require_tos\":0,\"register_tos_article\":61,\"register-require_dob\":1,\"profile-require_address1\":0,\"profile-require_address2\":0,\"profile-require_city\":0,\"profile-require_region\":0,\"profile-require_country\":0,\"profile-require_postal_code\":0,\"profile-require_phone\":0,\"profile-require_website\":0,\"profile-require_favoritebook\":0,\"profile-require_aboutme\":0,\"profile-require_dob\":0}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(441, 0, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 0, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 0, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 0, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 0, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"March 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(503, 0, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{\"name\":\"beez3\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"3.1.0\",\"description\":\"TPL_BEEZ3_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 0, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"3.0.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(506, 0, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{\"name\":\"protostar\",\"type\":\"template\",\"creationDate\":\"4\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_PROTOSTAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(507, 0, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{\"name\":\"isis\",\"type\":\"template\",\"creationDate\":\"3\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ISIS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 802, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"March 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.4\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 802, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"March 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.4\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 0, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"March 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.4\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10012, 0, 'Helix3 - Ajax', 'plugin', 'helix3', 'ajax', 0, 1, 1, 0, '{\"name\":\"Helix3 - Ajax\",\"type\":\"plugin\",\"creationDate\":\"December 2018\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.5.6\",\"description\":\"Helix3 Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helix3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10013, 0, 'System - Helix3 Framework', 'plugin', 'helix3', 'system', 0, 1, 1, 0, '{\"name\":\"System - Helix3 Framework\",\"type\":\"plugin\",\"creationDate\":\"December 2018\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.5.6\",\"description\":\"Helix3 Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helix3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10014, 0, 'Flex', 'template', 'flex', '', 0, 1, 1, 0, '{\"name\":\"Flex\",\"type\":\"template\",\"creationDate\":\"March 2019\",\"author\":\"Aplikko.com\",\"copyright\":\"Copyright (C) 2019 Aplikko.com. All rights reserved.\",\"authorEmail\":\"aplikko@gmail.com\",\"authorUrl\":\"http:\\/\\/www.aplikko.com\",\"version\":\"3.6\",\"description\":\"Flex - Multipurpose Template from Aplikko. Version 3.6\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"sticky_header\":\"1\",\"boxed_layout\":\"0\",\"boxed_layout_width\":\"1170px\",\"logo_type\":\"image\",\"logo_position\":\"logo\",\"body_bg_repeat\":\"inherit\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"body_bg_position\":\"0 0\",\"enabled_copyright\":\"1\",\"copyright_position\":\"footer1\",\"copyright\":\"\\u00a9 2017 Your Company. All Rights Reserved. Designed By Aplikko\",\"show_social_icons\":\"1\",\"social_position\":\"top1\",\"facebook\":\"https:\\/\\/www.facebook.com\\/joomshaper\",\"twitter\":\"https:\\/\\/twitter.com\\/joomshaper\",\"enable_contactinfo\":\"1\",\"contact_position\":\"top2\",\"contact_phone\":\"+228 872 4444\",\"contact_email\":\"contact@email.com\",\"comingsoon_mode\":\"0\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_date\":\"5-10-2018\",\"comingsoon_content\":\"Coming soon content\",\"preset\":\"preset1\",\"preset1_bg\":\"#ffffff\",\"preset1_text\":\"#000000\",\"preset1_major\":\"#f14833\",\"preset2_bg\":\"#ffffff\",\"preset2_text\":\"#000000\",\"preset2_major\":\"#fca224\",\"preset3_bg\":\"#ffffff\",\"preset3_text\":\"#000000\",\"preset3_major\":\"#f0e95b\",\"preset4_bg\":\"#ffffff\",\"preset4_text\":\"#000000\",\"preset4_major\":\"#22a9e1\",\"preset5_bg\":\"#ffffff\",\"preset5_text\":\"#000000\",\"preset5_major\":\"#16b99a\",\"preset6_bg\":\"#ffffff\",\"preset6_text\":\"#000000\",\"preset6_major\":\"#cc8b60\",\"menu\":\"mainmenu\",\"menu_type\":\"mega_offcanvas\",\"menu_animation\":\"menu-fade\",\"enable_body_font\":\"1\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h4_font\":\"1\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h5_font\":\"1\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h6_font\":\"1\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_navigation_font\":\"0\",\"enable_custom_font\":\"0\",\"compress_css\":\"0\",\"compress_js\":\"0\",\"lessoption\":\"0\",\"show_post_format\":\"1\",\"commenting_engine\":\"disabled\",\"disqus_devmode\":\"0\",\"intensedebate_acc\":\"\",\"fb_width\":\"500\",\"fb_cpp\":\"10\",\"comments_count\":\"0\",\"social_share\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10015, 0, 'SP Page Builder', 'component', 'com_sppagebuilder', '', 1, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright @ 2010 - 2019 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"https:\\/\\/www.joomshaper.com\",\"version\":\"3.4.5\",\"description\":\"\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{\"production_mode\":\"0\",\"addcontainer\":\"0\",\"gmap_api\":\"\",\"fontawesome\":\"0\",\"disableanimatecss\":\"0\",\"disablecss\":\"0\",\"disable_og\":\"0\",\"fb_app_id\":\"\",\"disable_tc\":\"0\",\"joomshaper_email\":\"\",\"joomshaper_license_key\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10016, 0, 'mod_sppagebuilder_icons', 'module', 'mod_sppagebuilder_icons', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_icons\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"MOD_SPPAGEBUILDER_ICONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_icons\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10017, 0, 'mod_sppagebuilder_admin_menu', 'module', 'mod_sppagebuilder_admin_menu', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_admin_menu\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"MOD_SPPAGEBUILDER_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_admin_menu\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10019, 0, 'RokPad', 'plugin', 'rokpad', 'editors', 0, 1, 1, 0, '{\"name\":\"RokPad\",\"type\":\"plugin\",\"creationDate\":\"July 24, 2018\",\"author\":\"RocketTheme, LLC\",\"copyright\":\"(C) 2005 - 2018 RocketTheme, LLC. All rights reserved.\",\"authorEmail\":\"support@rockettheme.com\",\"authorUrl\":\"http:\\/\\/www.rockettheme.com\",\"version\":\"2.1.10\",\"description\":\"\\n        <div class=\\\"rokpad-description\\\">\\n        <img src=\\\"..\\/plugins\\/editors\\/rokpad\\/assets\\/admin\\/images\\/rokpad.jpg\\\" class=\\\"img-padding\\\" \\/><h1>RokPad<\\/h1>\\n        <h2>The Power of Desktop Text Editor in a Joomla!<\\/h2>\\n        <p>Ever wished you could use a powerful desktop text editor such as Textmate, SublimeText, or UltraEdit directly on a Joomla! web site?  Now with RokPad we provide many features and capabilities that traditionally would only be found in a powerful desktop editor.  RokPad provides advanced functions such as an Ajax saving action, syntax highlighting, configurable themes, multiple cursors and selections, shortcut keys, multiple language support, and many other incredible features.<\\/p>\\n\\n        <h2>Key Features:<\\/h2>\\n        <ul class=\\\"features\\\">\\n\\t\\t\\t<li>Code Highlighter built on the great ACE Editor<\\/li>\\n\\t        <li>Support for CSS, HTML, JavaScript, JSON, LESS, Markdown, PHP, SQL, Plain Text, Textile, XML and more...<\\/li>\\n\\t        <li>Ajax save and Automatic Save options. You\'ll never loose your content again, nor wait until the page has finished reloading after a save!<\\/li>\\n\\t        <li>Save, Undo, Redo, Goto line, Advanced Search and Search &amp; Replace, Full Screen. Settings like Themes, Font Size, Code Folding, Wrap Mode, Invisible Characters, Print Margin, Highlight of selected word<\\/li>\\n\\t        <li>26 Themes to choose from<\\/li>\\n\\t        <li>Resizable Editor by dragging the Statusbar<\\/li>\\n\\t        <li>Keyboard shortcuts<\\/li>\\n\\t        <li>Brackets match<\\/li>\\n\\t        <li>Multiple cursors and selections<\\/li>\\n\\t        <li>Vertical Selection<\\/li>\\n\\t        <li>Ability to insert at multiple locations xtd-buttons shortcodes, all at once.<\\/li>\\n\\t        <li>Shortcodes and Universal Tag Insertion<\\/li>\\n\\t        <li>Drag &amp; Drop of text from external applications such as other Browser Tabs\\/windows or Native Applications (Supported on Firefox, Chrome, IE10 and Safari)<\\/li>\\n\\t        <li>Import local files by Drag &amp; Drop directly from your desktop! (Supported on Firefox, Chrome, IE10 and Safari 6+)<\\/li>\\n\\t        <li>And much more!<\\/li>\\n        <\\/ul>\\n        <\\/div>\\n        \",\"group\":\"\",\"filename\":\"rokpad\"}', '{\"autosave-enabled\":\"0\",\"autosave-time\":\"5\",\"theme\":\"fluidvision\",\"font-size\":\"12px\",\"fold-style\":\"markbeginend\",\"use-wrap-mode\":\"free\",\"selection-style\":\"1\",\"highlight-active-line\":\"1\",\"highlight-selected-word\":\"1\",\"show-invisibles\":\"0\",\"show-gutter\":\"1\",\"show-print-margin\":\"1\",\"fade-fold-widgets\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10020, 0, 'SP Simple Portfolio', 'component', 'com_spsimpleportfolio', '', 1, 1, 0, 0, '{\"name\":\"SP Simple Portfolio\",\"type\":\"component\",\"creationDate\":\"December 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010- 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"1.6\",\"description\":\"Simple Portfolio Component for Joomla 3.3+\",\"group\":\"\",\"filename\":\"spsimpleportfolio\"}', '{\"square\":\"600x600\",\"rectangle\":\"900x500\",\"tower\":\"600x800\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10021, 0, 'SP Simple Portfolio Module', 'module', 'mod_spsimpleportfolio', '', 0, 1, 0, 0, '{\"name\":\"SP Simple Portfolio Module\",\"type\":\"module\",\"creationDate\":\"December 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.6\",\"description\":\"Module to display latest item from SP Simple Portfolio\",\"group\":\"\",\"filename\":\"mod_spsimpleportfolio\"}', '{\"show_filter\":\"1\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10022, 0, 'AP Smart LayerSlider', 'module', 'mod_ap_smart_layerslider', '', 0, 1, 0, 0, '{\"name\":\"AP Smart LayerSlider\",\"type\":\"module\",\"creationDate\":\"August 2018\",\"author\":\"Aplikko.com\",\"copyright\":\"Copyright @ 2018 Aplikko.com. All rights reserved.\",\"authorEmail\":\"contact@aplikko.com\",\"authorUrl\":\"http:\\/\\/www.aplikko.com\",\"version\":\"3.5\",\"description\":\"\",\"group\":\"\",\"filename\":\"mod_ap_smart_layerslider\"}', '{\"display_form\":\"folder_image\",\"catid\":\"\",\"k2catid\":\"\",\"sort_order_field\":\"order\",\"count\":\"5\",\"theme\":\"1\",\"image_width\":\"1170\",\"image_height\":\"400\",\"mainimage_mode\":\"crop\",\"use_ratio\":\"1\",\"forceSize\":\"none\",\"visibleSize\":\"auto\",\"slideDistance\":\"10\",\"responsive\":\"1\",\"imageScaleMode\":\"cover\",\"autoHeight\":\"0\",\"autoScaleLayers\":\"1\",\"waitForLayers\":\"0\",\"orientation\":\"horizontal\",\"loop\":\"1\",\"shuffle\":\"0\",\"fullScreen\":\"0\",\"fullscreen_button_color\":\"#000000\",\"fadeEffect\":\"0\",\"fadeOutPreviousSlide\":\"1\",\"fadeDuration\":\"500\",\"autoplay\":\"0\",\"autoplayDelay\":\"5000\",\"autoplayOnHover\":\"pause\",\"show_thumbnails\":\"0\",\"thumbnailWidth\":\"120\",\"thumbnailHeight\":\"80\",\"thumbnailtxt_align\":\"left\",\"show_thumbnail_description\":\"1\",\"thumbnail_description_max_chars\":\"50\",\"selected_thumbnail_txt_color\":\"\",\"selected_thumbnail_backg_color\":\"\",\"thumbnailsPosition\":\"bottom\",\"thumbnailPointer\":\"0\",\"thumbnailPointer_color\":\"\",\"thumbnailArrows\":\"0\",\"show_arrows\":\"1\",\"arrows_size\":\"50\",\"arrows_backg_color\":\"\",\"arrows_color\":\"\",\"show_buttons\":\"1\",\"buttons_color\":\"\",\"display_caption\":\"0\",\"captiontxt_align\":\"center\",\"description_max_chars\":\"70\",\"load_videojs\":\"0\",\"reachVideoAction\":\"none\",\"leaveVideoAction\":\"pauseVideo\",\"playVideoAction\":\"stopAutoplay\",\"pauseVideoAction\":\"none\",\"endVideoAction\":\"none\",\"load_js\":\"customtag\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10026, 0, 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.5\",\"description\":\"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10027, 0, 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Page Builder Pro Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.1\",\"description\":\"SP Page Builder Pro Updater Plugin\",\"group\":\"\",\"filename\":\"sppagebuilderproupdater\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10028, 0, 'VIRTUEMART', 'component', 'com_virtuemart', '', 1, 1, 0, 0, '{\"name\":\"VIRTUEMART\",\"type\":\"component\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"\",\"group\":\"\",\"filename\":\"virtuemart\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10108, 0, 'VirtueMart_allinone', 'component', 'com_virtuemart_allinone', '', 1, 0, 0, 0, '{\"name\":\"VirtueMart_allinone\",\"type\":\"component\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10030, 0, 'VM Payment - Standard', 'plugin', 'standard', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"Standard\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"Standard payment plugin\",\"group\":\"\",\"filename\":\"standard\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10031, 0, 'VM Payment - Klarna', 'plugin', 'klarna', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Klarna\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"Klarna VirtueMart Payment Plugin\",\"group\":\"\",\"filename\":\"klarna\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10032, 0, 'VM Payment - KlarnaCheckout', 'plugin', 'klarnacheckout', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Klarna Checkout\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"\",\"group\":\"\",\"filename\":\"klarnacheckout\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10033, 0, 'VM Payment - Sofort Banking/Überweisung', 'plugin', 'sofort', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Sofort\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"<a href=\\\"http:\\/www.sofort.com\\\" target=\\\"_blank\\\">Sofort<\\/a> is a popular\\n\\tpayment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"sofort\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10034, 0, 'VM Payment - PayPal', 'plugin', 'paypal', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"PayPal\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"PayPal\",\"group\":\"\",\"filename\":\"paypal\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10035, 0, 'VM Payment - Heidelpay', 'plugin', 'heidelpay', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Heidelpay\",\"type\":\"plugin\",\"creationDate\":\"12-Sep-2012\",\"author\":\"Heidelberger Payment GmbH\",\"copyright\":\"Copyright Heidelberger Payment GmbH\",\"authorEmail\":\"info@heidelpay.de\",\"authorUrl\":\"http:\\/\\/www.heidelpay.de\",\"version\":\"16.11.07\",\"description\":\"\\n        <h2>Virtuemart Plugin von:<\\/h2><p><a href=\\\"https:\\/\\/www.Heidelpay.de\\\" target=\\\"_blank\\\"><img src=\\\"https:\\/\\/www.heidelpay.de\\/gfx\\/logo.gif\\\" style=\\\"margin-right:20px;\\\"\\/><\\/a><\\/p> \",\"group\":\"\",\"filename\":\"heidelpay\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(10036, 0, 'VM Payment - Paybox', 'plugin', 'paybox', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"VM Payment - Paybox\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"<a href=\\\"http:\\/\\/paybox.com\\\" target=\\\"_blank\\\">Paybox<\\/a> \\n    \",\"group\":\"\",\"filename\":\"paybox\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(10037, 0, 'VM Payment - Pay with Amazon', 'plugin', 'amazon', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"AMAZON\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"AMAZON PAY plugin\",\"group\":\"\",\"filename\":\"amazon\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10038, 0, 'System - Pay with Amazon', 'plugin', 'amazon', 'system', 0, 0, 1, 0, '{\"name\":\"AMAZON\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"AMAZON payment SYSTEM plugin\",\"group\":\"\",\"filename\":\"amazon\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10039, 0, 'VM Payment - Realex HPP & API', 'plugin', 'realex_hpp_api', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"realex_hpp_api\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"Realex HPP and API\",\"group\":\"\",\"filename\":\"realex_hpp_api\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10040, 0, 'VM UserField - Realex HPP & API', 'plugin', 'realex_hpp_api', 'vmuserfield', 0, 0, 1, 0, '{\"name\":\"Realex_hpp_api\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"Card storage plugin for Realex\",\"group\":\"\",\"filename\":\"realex_hpp_api\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10041, 0, 'VM Payment - Skrill', 'plugin', 'skrill', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Skrill\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"Skrill Holdings Limited\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.skrill.com\",\"version\":\"3.4.2\",\"description\":\"<a href=\\\"http:\\/\\/www.skrill.com\\\" target=\\\"_blank\\\">skrill<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    \",\"group\":\"\",\"filename\":\"skrill\"}', '', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(10042, 0, 'VM Payment - Authorize.net', 'plugin', 'authorizenet', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Authorize.net AIM\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"Authorize.net AIM\",\"group\":\"\",\"filename\":\"authorizenet\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10043, 0, 'VM Payment - Sofort iDeal', 'plugin', 'sofort_ideal', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Sofort Ideal\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"<a href=\\\"http:\\/www.sofort.com\\\" target=\\\"_blank\\\">Sofort<\\/a> is a popular\\n\\tpayment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"sofort\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10044, 0, 'VM Payment - Klikandpay', 'plugin', 'klikandpay', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"VM Payment - klikandpay\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"<a href=\\\"http:\\/\\/klikandpay.com\\\" target=\\\"_blank\\\">klikandpay<\\/a> \\n    \",\"group\":\"\",\"filename\":\"klikandpay\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10045, 0, 'VM Shipment - By weight, ZIP and countries', 'plugin', 'weight_countries', 'vmshipment', 0, 1, 1, 0, '{\"name\":\"By weight, ZIP and countries\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"VMSHIPMENT_WEIGHT_COUNTRIES_PLUGIN_DESC\",\"group\":\"\",\"filename\":\"weight_countries\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10046, 0, 'VM Custom - Customer text input', 'plugin', 'textinput', 'vmcustom', 0, 1, 1, 0, '{\"name\":\"VMCustom - textinput\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2014 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"text input plugin for product\",\"group\":\"\",\"filename\":\"textinput\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10047, 0, 'VM Custom - Product specification', 'plugin', 'specification', 'vmcustom', 0, 1, 1, 0, '{\"name\":\"plgvm_specification\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2014 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"VMCustom - specification; text input plugin for product\",\"group\":\"\",\"filename\":\"specification\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10048, 0, 'VM Calculation - Avalara Tax', 'plugin', 'avalara', 'vmcalculation', 0, 0, 1, 0, '{\"name\":\"VM - Calculation Avalara Tax\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"Max Milbers\",\"copyright\":\"Copyright (C) 2013 iStraxx UG (haftungsbeschr\\u00e4nkt). All rights reserved\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"VM - Calculation Avalara Tax; On demand tax calculation for whole U.S.A.\",\"group\":\"\",\"filename\":\"avalara\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10049, 0, 'VirtueMart Product', 'plugin', 'virtuemart', 'search', 0, 0, 1, 0, '{\"name\":\"Search - VirtueMart\",\"type\":\"plugin\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"PLG_SEARCH_VIRTUEMART_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"virtuemart\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10050, 0, 'mod_vmmenu', 'module', 'mod_vmmenu', '', 1, 1, 3, 0, '{\"name\":\"VirtueMart Administrator Menu\",\"type\":\"module\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2013 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"MOD_VMMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_vmmenu\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10051, 0, 'mod_virtuemart_currencies', 'module', 'mod_virtuemart_currencies', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_currencies\",\"type\":\"module\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"MOD_VIRTUEMART_CURRENCIES_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_currencies\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10052, 0, 'mod_virtuemart_product', 'module', 'mod_virtuemart_product', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_product\",\"type\":\"module\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"MOD_VIRTUEMART_PRODUCT_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_product\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10053, 0, 'mod_virtuemart_search', 'module', 'mod_virtuemart_search', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_search\",\"type\":\"module\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"MOD_VIRTUEMART_SEARCH_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_search\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10054, 0, 'mod_virtuemart_manufacturer', 'module', 'mod_virtuemart_manufacturer', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_manufacturer\",\"type\":\"module\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"MOD_VIRTUEMART_MANUFACTURER_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_manufacturer\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(10055, 0, 'mod_virtuemart_cart', 'module', 'mod_virtuemart_cart', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_cart\",\"type\":\"module\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"MOD_VIRTUEMART_CART_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_cart\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10056, 0, 'mod_virtuemart_category', 'module', 'mod_virtuemart_category', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_category\",\"type\":\"module\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"MOD_VIRTUEMART_CATEGORY_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_category\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10109, 0, 'tcpdf', 'component', 'com_tcpdf', '', 1, 0, 0, 0, '{\"name\":\"tcpdf\",\"type\":\"component\",\"creationDate\":\"June 2018\",\"author\":\"Nicola Asuni, The VirtueMart Development Team\",\"copyright\":\"Copyright (c) 2001-2013 Nicola Asuni - Tecnick.com LTD - Tutti i diritti riservati - All Rights Reserved. 2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"1.0.5\",\"description\":\"TCPDF 6.2.12 by Nicola Asuni. Joomla Installer by the VirtueMart Team\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10194, 0, 'AcyMailing subscription form', 'module', 'mod_acym', '', 0, 1, 0, 0, '{\"name\":\"AcyMailing subscription form\",\"type\":\"module\",\"creationDate\":\"August 2018\",\"author\":\"Acyba\",\"copyright\":\"Copyright (C) 2009-2019 ACYBA SAS - All rights reserved..\",\"authorEmail\":\"dev@acyba.com\",\"authorUrl\":\"https:\\/\\/www.acyba.com\",\"version\":\"1.0.0\",\"description\":\"Subscribe to \\/ Unsubscribe from AcyMailing lists\",\"group\":\"\",\"filename\":\"mod_acym\"}', '{\"help\":\"module\",\"mode\":\"tableless\",\"hiddenlists\":\"All\",\"displists\":\"None\",\"listschecked\":\"All\",\"listposition\":\"before\",\"fields\":\"1\",\"textmode\":\"0\",\"subtext\":\"\",\"subtextlogged\":\"\",\"termscontent\":\"0\",\"privacypolicy\":\"0\",\"articlepopup\":\"1\",\"unsub\":\"0\",\"unsubtext\":\"\",\"unsubredirect\":\"\",\"redirect\":\"\",\"introtext\":\"\",\"posttext\":\"\",\"userinfo\":\"1\",\"formclass\":\"\",\"alignment\":\"none\",\"source\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10076, 0, 'VM Payment - 2Checkout', 'plugin', 'tco', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"2Checkout\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Craig Christenson\",\"copyright\":\"Copyright (C) 2004-2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.2checkout.com\",\"version\":\"3.4.2\",\"description\":\"<a href=\\\"https:\\/\\/www.2checkout.com\\/referral?r=virtuemart\\\" target=\\\"_blank\\\">2Checkout<\\/a> is a popular payment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"tco\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', 0, 0, 1, 0, '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"May 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}', '{\"lastrun\":1552829504}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(454, 0, 'plg_system_stats', 'plugin', 'stats', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}', 'null', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"March 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.4.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10081, 0, 'plg_installer_webinstaller', 'plugin', 'webinstaller', 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"28 April 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2013-2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.1.1\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"webinstaller\"}', '{\"tab_position\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10082, 0, 'System - SP PageBuilder', 'plugin', 'sppagebuilder', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP PageBuilder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10083, 0, 'SP Page Builder', 'module', 'mod_sppagebuilder', '', 0, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.2\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10196, 0, 'Content - SP Page Builder', 'plugin', 'sppagebuilder', 'content', 0, 1, 1, 0, '{\"name\":\"Content - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.6\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(461, 0, 'plg_system_fields', 'plugin', 'fields', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(464, 0, 'plg_fields_color', 'plugin', 'color', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(468, 0, 'plg_fields_list', 'plugin', 'list', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(469, 0, 'plg_fields_media', 'plugin', 'media', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(472, 0, 'plg_fields_text', 'plugin', 'text', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(474, 0, 'plg_fields_url', 'plugin', 'url', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(475, 0, 'plg_fields_user', 'plugin', 'user', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"October 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(477, 0, 'plg_content_fields', 'plugin', 'fields', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10188, 0, 'Regular Labs Library', 'library', 'regularlabs', '', 0, 1, 1, 0, '{\"name\":\"Regular Labs Library\",\"type\":\"library\",\"creationDate\":\"December 2018\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2018 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/www.regularlabs.com\",\"version\":\"18.12.19593\",\"description\":\"\",\"group\":\"\",\"filename\":\"regularlabs\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10112, 0, 'plg_system_regularlabs', 'plugin', 'regularlabs', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_regularlabs\",\"type\":\"plugin\",\"creationDate\":\"December 2018\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2018 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/www.regularlabs.com\",\"version\":\"18.12.19593\",\"description\":\"PLG_SYSTEM_REGULARLABS_DESC\",\"group\":\"\",\"filename\":\"regularlabs\"}', '{\"combine_admin_menu\":\"0\",\"show_help_menu\":\"1\",\"max_list_count\":\"2500\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10113, 0, 'plg_editors-xtd_modulesanywhere', 'plugin', 'modulesanywhere', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_modulesanywhere\",\"type\":\"plugin\",\"creationDate\":\"December 2018\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2018 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/www.regularlabs.com\",\"version\":\"7.8.0\",\"description\":\"PLG_EDITORS-XTD_MODULESANYWHERE_DESC\",\"group\":\"\",\"filename\":\"modulesanywhere\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10114, 0, 'plg_system_modulesanywhere', 'plugin', 'modulesanywhere', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_modulesanywhere\",\"type\":\"plugin\",\"creationDate\":\"December 2018\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2018 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/www.regularlabs.com\",\"version\":\"7.8.0\",\"description\":\"PLG_SYSTEM_MODULESANYWHERE_DESC\",\"group\":\"\",\"filename\":\"modulesanywhere\"}', '{\"style\":\"none\",\"styles\":\"none,division,tabs,well\",\"override_style\":\"1\",\"@notice_override_settings\":\"RL_ONLY_AVAILABLE_IN_PRO\",\"ignore_access\":\"0\",\"ignore_state\":\"0\",\"ignore_assignments\":\"1\",\"ignore_caching\":\"0\",\"@notice_show_edit\":\"RL_ONLY_AVAILABLE_IN_PRO\",\"fix_html\":\"1\",\"place_comments\":\"1\",\"@notice_articles\":\"RL_ONLY_AVAILABLE_IN_PRO\",\"@notice_components\":\"RL_ONLY_AVAILABLE_IN_PRO\",\"@notice_otherareas\":\"RL_ONLY_AVAILABLE_IN_PRO\",\"button_text\":\"Module\",\"enable_frontend\":\"1\",\"showtitle\":\"\",\"module_tag\":\"module\",\"modulepos_tag\":\"modulepos\",\"tag_characters\":\"{.}\",\"activate_jumper\":\"0\",\"handle_core_tags\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10130, 0, 'VM Framework Loader during Plugin Updates', 'plugin', 'vmLoaderPluginUpdate', 'system', 0, 1, 1, 0, '{\"name\":\"VM Framework Loader during Plugin Updates\",\"type\":\"plugin\",\"creationDate\":\"2017-08-06\",\"author\":\"Reinhold Kainhofer\",\"copyright\":\"Copyright (C) 2017 Reinhold Kainhofer.\",\"authorEmail\":\"office@open-tools.net\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\\/\",\"version\":\"1.0\",\"description\":\"Makes sure the VirtueMart framework is loaded during automatic plugin updates using Joomla\'s plugin updater.\",\"group\":\"\",\"filename\":\"vmLoaderPluginUpdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', '', 1, 1, 1, 0, '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', 'sampledata', 0, 1, 1, 0, '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10148, 0, 'plg_finder_sppagebuilder', 'plugin', 'sppagebuilder', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"March 2018\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2010 - 2019 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.6\",\"description\":\"PLG_FINDER_SP_PAGEBUILDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(480, 0, 'plg_system_sessiongc', 'plugin', 'sessiongc', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sessiongc\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10149, 0, 'Ajax Intro Articles Module', 'module', 'mod_ajax_intro_articles', '', 0, 1, 0, 0, '{\"name\":\"Ajax Intro Articles Module\",\"type\":\"module\",\"creationDate\":\"April 2018\",\"author\":\"Aplikko\",\"copyright\":\"Copyright (C) 2018 Aplikko. All rights reserved.\",\"authorEmail\":\"aplikko@gmail.com\",\"authorUrl\":\"http:\\/\\/www.aplikko.com\",\"version\":\"1.0\",\"description\":\"Ajax Intro Articles Module shows a list of the most recently published and current Articles in Masonry Grid with Ajax Loading of the new Articles.\",\"group\":\"\",\"filename\":\"mod_ajax_intro_articles\"}', '{\"catid\":\"\",\"count\":\"3\",\"ajax_limit\":\"3\",\"show_featured\":\"\",\"ordering\":\"published\",\"user_id\":\"0\",\"columns\":\"3\",\"intro_alignment\":\"intro-center\",\"intro_width\":\"50\",\"cols_spacing\":\"15\",\"inner_spacing\":\"0\",\"equal_heights\":\"0\",\"rtl_enable\":\"0\",\"intro_format\":\"1\",\"image_intro_link\":\"0\",\"loadmore_effect\":\"appear-in\",\"loadmore_button\":\"default\",\"article_style\":\"1\",\"overlay_effects\":\"\",\"overlay_color\":\"\",\"show_title\":\"1\",\"title_size\":\"22\",\"show_introtext\":\"1\",\"limit_words\":\"25\",\"strip_tags\":\"1\",\"introtext_size\":\"15\",\"show_author\":\"0\",\"show_category\":\"0\",\"show_date\":\"0\",\"show_date_format\":\"DATE_FORMAT_LC3\",\"show_hits\":\"0\",\"show_rating\":\"0\",\"show_readmore\":\"0\",\"readmore_button\":\"default\",\"align_readmore_button\":\"left\",\"show_social_share\":\"0\",\"show_tags\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10167, 0, 'System - SP Cookie Consent', 'plugin', 'spcookieconsent', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Cookie Consent\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"SP Cookie Consent - A plugin to display cookie notice to the website visitors.\",\"group\":\"\",\"filename\":\"spcookieconsent\"}', '{\"cookie_content\":\"We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies. Read more about our <a href=\\\"index.php?option=com_content&amp;view=article&amp;id=61&amp;catid=2\\\">Privacy Policy<\\/a>.\",\"button_text\":\"I accept\",\"bg_color\":\"#e34c35\",\"text_color\":\"#ffffff\",\"link_color\":\"#f5f5f5\",\"button_bg_color\":\"#ffffff\",\"button_text_color\":\"#333333\",\"display_position\":\"bottom_right\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(35, 0, 'com_privacy', 'component', 'com_privacy', '', 1, 1, 1, 1, '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(482, 0, 'plg_content_confirmconsent', 'plugin', 'confirmconsent', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"confirmconsent\"}', '{\"consentbox_text\":\"\",\"privacy_article\":61}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(36, 0, 'com_actionlogs', 'component', 'com_actionlogs', '', 1, 1, 1, 1, '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(483, 0, 'PLG_SYSTEM_ACTIONLOGS', 'plugin', 'actionlogs', 'system', 0, 0, 1, 0, '{\"name\":\"PLG_SYSTEM_ACTIONLOGS\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(484, 0, 'PLG_ACTIONLOG_JOOMLA', 'plugin', 'joomla', 'actionlog', 0, 1, 1, 0, '{\"name\":\"PLG_ACTIONLOG_JOOMLA\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(481, 0, 'plg_fields_repeatable', 'plugin', 'repeatable', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_repeatable\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_FIELDS_REPEATABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"repeatable\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(319, 0, 'mod_latestactions', 'module', 'mod_latestactions', '', 1, 1, 1, 0, '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latestactions\"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0),
(485, 0, 'plg_system_privacyconsent', 'plugin', 'privacyconsent', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacyconsent\"}', '{\"privacy_note\":\"\",\"privacy_article\":61,\"messageOnRedirect\":\"\",\"enabled\":0,\"cachetimeout\":30,\"consentexpiration\":360,\"remind\":30,\"lastrun\":0}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(486, 0, 'plg_system_logrotation', 'plugin', 'logrotation', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logrotation\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logrotation\"}', '{\"lastrun\":1552658425}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(487, 0, 'plg_privacy_user', 'plugin', 'user', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(320, 0, 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0),
(488, 0, 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacycheck\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(489, 0, 'plg_user_terms', 'plugin', 'terms', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"terms\"}', '{\"terms_note\":\"\",\"terms_article\":61}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(490, 0, 'plg_privacy_contact', 'plugin', 'contact', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(491, 0, 'plg_privacy_content', 'plugin', 'content', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(492, 0, 'plg_privacy_message', 'plugin', 'message', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"message\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(493, 0, 'plg_privacy_actionlogs', 'plugin', 'actionlogs', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(494, 0, 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"November 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha_invisible\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(495, 0, 'plg_privacy_consents', 'plugin', 'consents', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"consents\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10191, 0, 'Acym', 'component', 'com_acym', '', 1, 1, 0, 0, '{\"name\":\"Acym\",\"type\":\"component\",\"creationDate\":\"March 2019\",\"author\":\"Acyba\",\"copyright\":\"Copyright (C) 2009-2019 ACYBA SAS - All rights reserved.\",\"authorEmail\":\"dev@acyba.com\",\"authorUrl\":\"http:\\/\\/www.acyba.com\",\"version\":\"6.1.2\",\"description\":\"Manage your Mailing lists and e-mail marketing campaigns\",\"group\":\"\",\"filename\":\"acym\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10193, 0, 'AcyMailing v6 JCE integration', 'plugin', 'jceacym', 'system', 0, 1, 1, 0, '{\"name\":\"AcyMailing v6 JCE integration\",\"type\":\"plugin\",\"creationDate\":\"12\\/2018\",\"author\":\"Acyba\",\"copyright\":\"Copyright (C) 2009-2018 ACYBA SAS - All rights reserved..\",\"authorEmail\":\"dev@acyba.com\",\"authorUrl\":\"http:\\/\\/www.acyba.com\",\"version\":\"1.0.0\",\"description\":\"This plugin enables you to use the JCE editor with AcyMailing v6\",\"group\":\"\",\"filename\":\"jceacym\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE IF NOT EXISTS `#__fields` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE IF NOT EXISTS `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE IF NOT EXISTS `#__fields_groups` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE IF NOT EXISTS `#__fields_values` (
  `field_id` int(10) UNSIGNED NOT NULL,
  `item_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_filters`;
CREATE TABLE IF NOT EXISTS `#__finder_filters` (
  `filter_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8mb4 NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL,
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `data` mediumtext CHARACTER SET utf8mb4 NOT NULL,
  `params` longtext CHARACTER SET utf8mb4,
  PRIMARY KEY (`filter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links`;
CREATE TABLE IF NOT EXISTS `#__finder_links` (
  `link_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `url` varchar(255) CHARACTER SET utf8mb4 NOT NULL,
  `route` varchar(255) CHARACTER SET utf8mb4 NOT NULL,
  `title` varchar(400) CHARACTER SET utf8mb4 DEFAULT NULL,
  `description` text,
  `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `md5sum` varchar(32) CHARACTER SET utf8mb4 DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `state` int(5) DEFAULT '1',
  `access` int(5) DEFAULT '0',
  `language` varchar(8) CHARACTER SET utf8mb4 NOT NULL,
  `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `list_price` double UNSIGNED NOT NULL DEFAULT '0',
  `sale_price` double UNSIGNED NOT NULL DEFAULT '0',
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`),
  KEY `idx_title` (`title`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms0`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms0` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms1`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms1` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms2`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms2` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms3`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms3` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms4`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms4` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms5`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms5` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms6`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms6` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms7`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms7` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms8`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms8` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms9`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms9` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsa`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsa` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsb`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsb` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsc`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsc` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsd`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsd` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termse`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termse` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsf`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsf` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_taxonomy`;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 NOT NULL,
  `state` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `access` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `state` (`state`),
  KEY `ordering` (`ordering`),
  KEY `access` (`access`),
  KEY `idx_parent_published` (`parent_id`,`state`,`access`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `#__finder_taxonomy` (`id`, `parent_id`, `title`, `state`, `access`, `ordering`) VALUES
(1, 0, 'ROOT', 0, 0, 0);

DROP TABLE IF EXISTS `#__finder_taxonomy_map`;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy_map` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `node_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`node_id`),
  KEY `link_id` (`link_id`),
  KEY `node_id` (`node_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_terms`;
CREATE TABLE IF NOT EXISTS `#__finder_terms` (
  `term_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `term` varchar(75) CHARACTER SET utf8mb4 NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 NOT NULL,
  `common` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `phrase` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `weight` float UNSIGNED NOT NULL DEFAULT '0',
  `soundex` varchar(75) CHARACTER SET utf8mb4 NOT NULL,
  `links` int(10) NOT NULL DEFAULT '0',
  `language` char(3) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `idx_term` (`term`),
  KEY `idx_term_phrase` (`term`,`phrase`),
  KEY `idx_stem_phrase` (`stem`,`phrase`),
  KEY `idx_soundex_phrase` (`soundex`,`phrase`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_terms_common`;
CREATE TABLE IF NOT EXISTS `#__finder_terms_common` (
  `term` varchar(75) CHARACTER SET utf8mb4 NOT NULL,
  `language` varchar(3) CHARACTER SET utf8mb4 NOT NULL,
  KEY `idx_word_lang` (`term`,`language`),
  KEY `idx_lang` (`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__finder_terms_common` (`term`, `language`) VALUES
('a', 'en'),
('about', 'en'),
('after', 'en'),
('ago', 'en'),
('all', 'en'),
('am', 'en'),
('an', 'en'),
('and', 'en'),
('ani', 'en'),
('any', 'en'),
('are', 'en'),
('aren\'t', 'en'),
('as', 'en'),
('at', 'en'),
('be', 'en'),
('but', 'en'),
('by', 'en'),
('for', 'en'),
('from', 'en'),
('get', 'en'),
('go', 'en'),
('how', 'en'),
('if', 'en'),
('in', 'en'),
('into', 'en'),
('is', 'en'),
('isn\'t', 'en'),
('it', 'en'),
('its', 'en'),
('me', 'en'),
('more', 'en'),
('most', 'en'),
('must', 'en'),
('my', 'en'),
('new', 'en'),
('no', 'en'),
('none', 'en'),
('not', 'en'),
('noth', 'en'),
('nothing', 'en'),
('of', 'en'),
('off', 'en'),
('often', 'en'),
('old', 'en'),
('on', 'en'),
('onc', 'en'),
('once', 'en'),
('onli', 'en'),
('only', 'en'),
('or', 'en'),
('other', 'en'),
('our', 'en'),
('ours', 'en'),
('out', 'en'),
('over', 'en'),
('page', 'en'),
('she', 'en'),
('should', 'en'),
('small', 'en'),
('so', 'en'),
('some', 'en'),
('than', 'en'),
('thank', 'en'),
('that', 'en'),
('the', 'en'),
('their', 'en'),
('theirs', 'en'),
('them', 'en'),
('then', 'en'),
('there', 'en'),
('these', 'en'),
('they', 'en'),
('this', 'en'),
('those', 'en'),
('thus', 'en'),
('time', 'en'),
('times', 'en'),
('to', 'en'),
('too', 'en'),
('true', 'en'),
('under', 'en'),
('until', 'en'),
('up', 'en'),
('upon', 'en'),
('use', 'en'),
('user', 'en'),
('users', 'en'),
('veri', 'en'),
('version', 'en'),
('very', 'en'),
('via', 'en'),
('want', 'en'),
('was', 'en'),
('way', 'en'),
('were', 'en'),
('what', 'en'),
('when', 'en'),
('where', 'en'),
('whi', 'en'),
('which', 'en'),
('who', 'en'),
('whom', 'en'),
('whose', 'en'),
('why', 'en'),
('wide', 'en'),
('will', 'en'),
('with', 'en'),
('within', 'en'),
('without', 'en'),
('would', 'en'),
('yes', 'en'),
('yet', 'en'),
('you', 'en'),
('your', 'en'),
('yours', 'en');

DROP TABLE IF EXISTS `#__finder_tokens`;
CREATE TABLE IF NOT EXISTS `#__finder_tokens` (
  `term` varchar(75) CHARACTER SET utf8mb4 NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 NOT NULL,
  `common` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `phrase` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `weight` float UNSIGNED NOT NULL DEFAULT '1',
  `context` tinyint(1) UNSIGNED NOT NULL DEFAULT '2',
  `language` char(3) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  KEY `idx_word` (`term`),
  KEY `idx_context` (`context`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_tokens_aggregate`;
CREATE TABLE IF NOT EXISTS `#__finder_tokens_aggregate` (
  `term_id` int(10) UNSIGNED NOT NULL,
  `map_suffix` char(1) CHARACTER SET utf8mb4 NOT NULL,
  `term` varchar(75) CHARACTER SET utf8mb4 NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 NOT NULL,
  `common` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `phrase` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `term_weight` float UNSIGNED NOT NULL,
  `context` tinyint(1) UNSIGNED NOT NULL DEFAULT '2',
  `context_weight` float UNSIGNED NOT NULL,
  `total_weight` float UNSIGNED NOT NULL,
  `language` char(3) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  KEY `token` (`term`),
  KEY `keyword_id` (`term_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_types`;
CREATE TABLE IF NOT EXISTS `#__finder_types` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(100) CHARACTER SET utf8mb4 NOT NULL,
  `mime` varchar(100) CHARACTER SET utf8mb4 NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE IF NOT EXISTS `#__languages` (
  `lang_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 0, 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', 1, 1, 1);

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE IF NOT EXISTS `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100))
) ENGINE=MyISAM AUTO_INCREMENT=703 DEFAULT CHARSET=utf8;

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 341, 0, '*', 0),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 1, 10, 0, '*', 1),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 2, 3, 0, '*', 1),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 1, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 4, 5, 0, '*', 1),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 6, 7, 0, '*', 1),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 8, 9, 0, '*', 1),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 229, 234, 0, '*', 1),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 1, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 230, 231, 0, '*', 1),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 1, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 232, 233, 0, '*', 1),
(10, 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 1, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 235, 238, 0, '*', 1),
(11, 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 1, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 236, 237, 0, '*', 1),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 239, 244, 0, '*', 1),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 240, 241, 0, '*', 1),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 242, 243, 0, '*', 1),
(16, 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 1, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 245, 246, 0, '*', 1),
(17, 'main', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 247, 248, 0, '*', 1),
(18, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 249, 250, 0, '*', 1),
(301, 'main', 'com_joomlaupdate', 'com-joomlaupdate', '', 'com-joomlaupdate', 'index.php?option=com_joomlaupdate', 'component', 1, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 1, 'class:joomlaupdate', 0, '{}', 281, 282, 0, '', 1),
(20, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', 1, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 251, 252, 0, '', 1),
(21, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 1, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 253, 254, 0, '*', 1),
(22, 'main', 'com_associations', 'Multilingual Associations', '', 'Multilingual Associations', 'index.php?option=com_associations', 'component', 1, 1, 1, 34, 0, '0000-00-00 00:00:00', 0, 0, 'class:associations', 0, '', 185, 186, 0, '*', 1),
(101, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_sppagebuilder&view=page&id=1', 'component', 1, 1, 1, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":200,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"101\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 11, 24, 1, '*', 0),
(106, 'mainmenu', 'Headers', 'headers', '', 'headers', 'index.php?option=com_sppagebuilder&view=page&id=5', 'component', 1, 1, 1, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":280,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"106\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"#a3a3a3\",\"page_title_bg_image\":\"images\\/svg\\/section-background-zags-glow.svg\"}', 25, 34, 0, '*', 0),
(107, 'mainmenu', 'Pages', 'pages', '', 'pages', '', 'heading', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":550,\\\"menuItem\\\":2,\\\"menuAlign\\\":\\\"center\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":6,\\\"menuParentId\\\":\\\"582\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":6,\\\"menuParentId\\\":\\\"583\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"1\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"1\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/link-post-1.jpg\",\"page_title_bg_image_repeat\":\"no-repeat\",\"page_title_bg_image_size\":\"cover\",\"page_title_bg_image_attachment\":\"fixed\",\"page_title_bg_image_hor_position\":\"50\",\"page_title_bg_image_vert_position\":\"50\"}', 187, 208, 0, '*', 0),
(108, 'mainmenu', 'Portfolio', 'portfolio', '', 'portfolio', '', 'heading', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 15, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":720,\\\"menuItem\\\":3,\\\"menuAlign\\\":\\\"center\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"126\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"127\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":4,\\\"menuParentId\\\":\\\"131\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"1\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 111, 184, 0, '*', 0),
(109, 'mainmenu', 'Posts', 'posts', '', 'posts', 'index.php?option=com_content&view=category&layout=blog&id=18', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"\",\"multi_column_order\":\"1\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"order\",\"order_date\":\"published\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":254,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"center\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"109\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"Post Formats\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/standard-post-10.jpg\"}', 209, 228, 0, '*', 0),
(110, 'mainmenu', 'Page Builder', 'page-builder', '', 'page-builder', '', 'heading', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":900,\\\"menuItem\\\":4,\\\"menuAlign\\\":\\\"full\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"183\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"184\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"185\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"418\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"1\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 35, 110, 0, '*', 0),
(112, 'mainmenu', 'Standard Post Format', 'standard-post-format', '', 'posts/standard-post-format', 'index.php?option=com_content&view=article&id=16', 'component', 1, 109, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"fa-edit\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/quotes-post-3.jpg\"}', 210, 211, 0, '*', 0),
(113, 'mainmenu', 'Gallery Post Format', 'gallery-post-format', '', 'posts/gallery-post-format', 'index.php?option=com_content&view=article&id=15', 'component', 1, 109, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"fa-picture-o\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"left\",\"page_title_size\":\"34\",\"page_title_height\":\"220\",\"enable_page_title_parallax\":\"1\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/standard-post-17.jpg\"}', 212, 213, 0, '*', 0),
(114, 'mainmenu', 'Video Post Format', 'video-post-format', '', 'posts/video-post-format', 'index.php?option=com_content&view=article&id=17', 'component', 1, 109, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"fa-video-camera\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/video-post-2.jpg\"}', 214, 215, 0, '*', 0),
(115, 'mainmenu', 'Link Post Format', 'link-post-format', '', 'posts/link-post-format', 'index.php?option=com_content&view=article&id=13', 'component', 1, 109, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"fa-link\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/link-post-1.jpg\"}', 220, 221, 0, '*', 0),
(116, 'mainmenu', 'Quote Post Format', 'quote-post-format', '', 'posts/quote-post-format', 'index.php?option=com_content&view=article&id=12', 'component', 1, 109, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"fa-quote-left\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"left\",\"page_title_size\":\"30\",\"page_title_height\":\"150\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"~ Commercial publishing platforms and content management systems ~\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/standard-post-18.jpg\"}', 224, 225, 0, '*', 0),
(117, 'mainmenu', 'Status Post Format', 'status-post-format', '', 'posts/status-post-format', 'index.php?option=com_content&view=article&id=18', 'component', 1, 109, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"fa-comment-o\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"left\",\"page_title_size\":\"30\",\"page_title_height\":\"200\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/status-post-2.jpg\"}', 222, 223, 0, '*', 0),
(118, 'mainmenu', 'Audio Post (Soundcloud)', 'audio-post-soundcloud', '', 'posts/audio-post-soundcloud', 'index.php?option=com_content&view=article&id=39', 'component', 1, 109, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"fa-soundcloud\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"center\",\"page_title_size\":\"33\",\"page_title_height\":\"220\",\"enable_page_title_parallax\":\"1\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"Post Format: Audio (Soundcloud)\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/standard-post-3.jpg\"}', 216, 217, 0, '*', 0),
(119, 'mainmenu', 'Audio Format (Mixcloud)', 'audio-format-mixcloud', '', 'posts/audio-format-mixcloud', 'index.php?option=com_content&view=article&id=36', 'component', 1, 109, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"fa-mixcloud\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"center\",\"page_title_size\":\"34\",\"page_title_height\":\"220\",\"enable_page_title_parallax\":\"1\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"Post Format: Audio (Mixcloud)\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/audio-post-1.jpg\"}', 218, 219, 0, '*', 0),
(120, 'mainmenu', 'Typography', 'typography', '', 'pages/various/typography', 'index.php?option=com_content&view=article&id=1', 'component', 1, 583, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-news-paper\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 199, 200, 0, '*', 0),
(121, 'mainmenu', 'Coming Soon', 'coming-soon', '', 'pages/various/coming-soon', '?tmpl=comingsoon', 'url', 1, 583, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-timer\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 201, 202, 0, '*', 0),
(122, 'mainmenu', '404 Page', '404-page', '', 'pages/various/404-page', 'index.php?option=com_404', 'url', 1, 583, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-less\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 203, 204, 0, '*', 0),
(125, 'mainmenu', '2 Columns - Default', '2-columns-default', '', 'portfolio/masonry/2-columns-default', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 126, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"default\",\"columns\":\"2\",\"thumbnail_type\":\"masonry\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"flex\",\"show_all_txt\":\"\",\"filter_divider\":\"\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"1\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 113, 114, 0, '*', 0),
(126, 'mainmenu', 'Masonry', 'masonry', '', 'portfolio/masonry', '', 'heading', 1, 108, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 112, 135, 0, '*', 0),
(127, 'mainmenu', 'Square', 'square', '', 'portfolio/square', '', 'heading', 1, 108, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 136, 159, 0, '*', 0),
(128, 'mainmenu', 'Header (Centered)', 'header-centered', '', 'headers/header-centered', 'index.php?option=com_sppagebuilder&view=page&id=6', 'component', 1, 106, 2, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 10, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 26, 27, 0, '*', 0),
(129, 'mainmenu', 'Header (Adspace)', 'header-adspace', '', 'headers/header-adspace', 'index.php?option=com_sppagebuilder&view=page&id=7', 'component', 1, 106, 2, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 11, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/svg\\/section-background-zags-glow.svg\"}', 28, 29, 0, '*', 0),
(131, 'mainmenu', 'Rectangular', 'rectangular', '', 'portfolio/rectangular', '', 'heading', 1, 108, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 160, 183, 0, '*', 0),
(133, 'mainmenu', '3 Columns - Default', '3-columns-default', '', 'portfolio/masonry/3-columns-default', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 126, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"flex\",\"show_all_txt\":\"<i class=\'fa fa-diamond\'><\\/i>\",\"filter_divider\":\"\",\"filter_margin\":\"\",\"show_zoom_button\":\"0\",\"show_view_button\":\"1\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 115, 116, 0, '*', 0),
(134, 'mainmenu', '4 Columns - Default', '4-columns-default', '', 'portfolio/masonry/4-columns-default', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 126, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"default\",\"columns\":\"4\",\"thumbnail_type\":\"masonry\",\"column_bg\":\"\",\"limit\":\"8\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"All\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 117, 118, 0, '*', 0),
(135, 'mainmenu', '2 Columns - Gallery', '2-columns-gallery', '', 'portfolio/masonry/2-columns-gallery', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 126, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_space\",\"columns\":\"2\",\"thumbnail_type\":\"masonry\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"flex\",\"show_all_txt\":\"<i class=\'fa fa-diamond\'><\\/i>\",\"filter_divider\":\"\",\"filter_margin\":\"6\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"900\",\"video_height\":\"504\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 121, 122, 0, '*', 0),
(136, 'mainmenu', '3 Columns - Gallery', '3-columns-gallery', '', 'portfolio/masonry/3-columns-gallery', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 126, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_space\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"column_bg\":\"\",\"limit\":\"12\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"All\",\"filter_divider\":\"<i style=\'vertical-align:baseline;\' class=\'fa fa-compress\'><\\/i>\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"900\",\"video_height\":\"504\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 123, 124, 0, '*', 0),
(137, 'mainmenu', '4 Columns - Gallery', '4-columns-gallery', '', 'portfolio/masonry/4-columns-gallery', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 126, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_space\",\"columns\":\"4\",\"thumbnail_type\":\"masonry\",\"column_bg\":\"\",\"limit\":\"12\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'fa fa-diamond\'><\\/i>\",\"filter_divider\":\"*\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 125, 126, 0, '*', 0),
(138, 'mainmenu', 'Divider', 'divider', '', 'portfolio/masonry/divider', '', 'separator', 1, 126, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"0\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 119, 120, 0, '*', 0),
(139, 'mainmenu', 'Text separator (2)', 'text-separator-2', '', 'portfolio/masonry/text-separator-2', '', 'separator', 1, 126, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"0\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 127, 128, 0, '*', 0),
(140, 'mainmenu', '2 Columns - Gallery No Space', '2-columns-gallery-no-space', '', 'portfolio/masonry/2-columns-gallery-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 126, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_nospace\",\"columns\":\"2\",\"thumbnail_type\":\"masonry\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"flex\",\"show_all_txt\":\"<i class=\'fa fa-clone\'><\\/i>\",\"filter_divider\":\"|\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"1\",\"show_tags\":\"1\",\"video_width\":\"900\",\"video_height\":\"504\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 129, 130, 0, '*', 0),
(141, 'mainmenu', '3 Columns - Gallery No Space ', '3-columns-gallery-no-space', '', 'portfolio/masonry/3-columns-gallery-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 126, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_nospace\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 131, 132, 0, '*', 0),
(142, 'mainmenu', '4 Columns - Gallery No Space ', '4-columns-gallery-no-space', '', 'portfolio/masonry/4-columns-gallery-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 126, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"masonry\",\"column_bg\":\"\",\"limit\":\"12\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'fa fa-clone\'><\\/i>\",\"filter_divider\":\"~\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 133, 134, 0, '*', 0),
(143, 'mainmenu', '2 Columns - Default', '2-columns-default', '', 'portfolio/square/2-columns-default', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 127, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"22\",\"layout_type\":\"default\",\"columns\":\"2\",\"thumbnail_type\":\"square\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'fa fa-clone\'><\\/i>\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"1\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 137, 138, 0, '*', 0),
(144, 'mainmenu', '3 Columns - Default', '3-columns-default', '', 'portfolio/square/3-columns-default', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 127, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"22\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"All\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 139, 140, 0, '*', 0),
(145, 'mainmenu', '4 Columns - Default', '4-columns-default', '', 'portfolio/square/4-columns-default', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 127, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"22\",\"layout_type\":\"default\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"column_bg\":\"\",\"limit\":\"8\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'fa fa-clone\'><\\/i>\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 141, 142, 0, '*', 0),
(146, 'mainmenu', 'Text separator', 'text-separator', '', 'portfolio/square/text-separator', '', 'separator', 1, 127, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"0\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 143, 144, 0, '*', 0),
(147, 'mainmenu', '2 Columns - Gallery', '2-columns-gallery', '', 'portfolio/square/2-columns-gallery', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 127, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"22\",\"layout_type\":\"gallery_space\",\"columns\":\"2\",\"thumbnail_type\":\"square\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"flex\",\"show_all_txt\":\"<i class=\'fa fa-clone\'><\\/i>\",\"filter_divider\":\"\",\"filter_margin\":\"7\",\"show_zoom_button\":\"1\",\"show_view_button\":\"1\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 145, 146, 0, '*', 0),
(148, 'mainmenu', '3 Columns - Gallery', '3-columns-gallery', '', 'portfolio/square/3-columns-gallery', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 127, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"22\",\"layout_type\":\"gallery_space\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'fa fa-clone\'><\\/i>\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 147, 148, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(149, 'mainmenu', '4 Columns - Gallery', '4-columns-gallery', '', 'portfolio/square/4-columns-gallery', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 127, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"22\",\"layout_type\":\"gallery_space\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"column_bg\":\"\",\"limit\":\"8\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"All\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 149, 150, 0, '*', 0),
(150, 'mainmenu', 'Text separator (2)', 'text-separator-2', '', 'portfolio/square/text-separator-2', '', 'separator', 1, 127, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"0\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 151, 152, 0, '*', 0),
(151, 'mainmenu', '2 Columns - Gallery No Space', '2-columns-gallery-no-space', '', 'portfolio/square/2-columns-gallery-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 127, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"22\",\"layout_type\":\"gallery_nospace\",\"columns\":\"2\",\"thumbnail_type\":\"square\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"flex\",\"show_all_txt\":\"<i class=\'fa fa-clone\'><\\/i>\",\"filter_divider\":\"\",\"filter_margin\":\"7\",\"show_zoom_button\":\"1\",\"show_view_button\":\"1\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 153, 154, 0, '*', 0),
(152, 'mainmenu', '3 Columns - Gallery No Space ', '3-columns-gallery-no-space', '', 'portfolio/square/3-columns-gallery-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 127, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"22\",\"layout_type\":\"gallery_nospace\",\"columns\":\"3\",\"thumbnail_type\":\"square\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"All\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 155, 156, 0, '*', 0),
(153, 'mainmenu', '4 Columns - Gallery No Space ', '4-columns-gallery-no-space', '', 'portfolio/square/4-columns-gallery-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 127, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"22\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"column_bg\":\"\",\"limit\":\"8\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'fa fa-clone\'><\\/i>\",\"filter_divider\":\"|\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 157, 158, 0, '*', 0),
(154, 'mainmenu', '2 Columns - Default', '2-columns-default', '', 'portfolio/rectangular/2-columns-default', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 131, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"default\",\"columns\":\"2\",\"thumbnail_type\":\"rectangular\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"flex\",\"show_all_txt\":\"All\",\"filter_divider\":\"\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"1\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 161, 162, 0, '*', 0),
(155, 'mainmenu', '3 Columns - Default', '3-columns-default', '', 'portfolio/rectangular/3-columns-default', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 131, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"rectangular\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"All\",\"filter_divider\":\"\\\\\",\"filter_margin\":\"\",\"show_zoom_button\":\"0\",\"show_view_button\":\"1\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 163, 164, 0, '*', 0),
(156, 'mainmenu', '4 Columns - Default', '4-columns-default', '', 'portfolio/rectangular/4-columns-default', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 131, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"default\",\"columns\":\"4\",\"thumbnail_type\":\"rectangular\",\"column_bg\":\"\",\"limit\":\"12\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'pe pe-7s-albums\'><\\/i>\",\"filter_divider\":\"\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"900\",\"video_height\":\"504\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 165, 166, 0, '*', 0),
(157, 'mainmenu', 'Text separator', 'text-separator', '', 'portfolio/rectangular/text-separator', '', 'separator', 1, 131, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"0\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 167, 168, 0, '*', 0),
(158, 'mainmenu', '2 Columns - Gallery', '2-columns-gallery', '', 'portfolio/rectangular/2-columns-gallery', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 131, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_space\",\"columns\":\"2\",\"thumbnail_type\":\"rectangular\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"flex\",\"show_all_txt\":\"All\",\"filter_divider\":\"\",\"filter_margin\":\"6\",\"show_zoom_button\":\"1\",\"show_view_button\":\"1\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 169, 170, 0, '*', 0),
(159, 'mainmenu', '3 Columns - Gallery', '3-columns-gallery', '', 'portfolio/rectangular/3-columns-gallery', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 131, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_space\",\"columns\":\"3\",\"thumbnail_type\":\"rectangular\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'fa fa-diamond\'><\\/i>\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 171, 172, 0, '*', 0),
(160, 'mainmenu', '4 Columns - Gallery', '4-columns-gallery', '', 'portfolio/rectangular/4-columns-gallery', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 131, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_space\",\"columns\":\"4\",\"thumbnail_type\":\"rectangular\",\"column_bg\":\"\",\"limit\":\"12\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"All\",\"filter_divider\":\"\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 173, 174, 0, '*', 0),
(161, 'mainmenu', 'Text separator (2)', 'text-separator-2', '', 'portfolio/rectangular/text-separator-2', '', 'separator', 1, 131, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"0\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 175, 176, 0, '*', 0),
(162, 'mainmenu', '2 Columns - Gallery No Space', '2-columns-gallery-no-space', '', 'portfolio/rectangular/2-columns-gallery-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 131, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_nospace\",\"columns\":\"2\",\"thumbnail_type\":\"rectangular\",\"column_bg\":\"\",\"limit\":\"6\",\"show_filter\":\"1\",\"filter_style\":\"flex\",\"show_all_txt\":\"<i class=\'fa fa-diamond\'><\\/i>\",\"filter_divider\":\"\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"1\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 177, 178, 0, '*', 0),
(163, 'mainmenu', '3 Columns - Gallery No Space ', '3-columns-gallery-no-space', '', 'portfolio/rectangular/3-columns-gallery-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 131, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_nospace\",\"columns\":\"3\",\"thumbnail_type\":\"rectangular\",\"column_bg\":\"\",\"limit\":\"9\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'fa fa-diamond\'><\\/i>\",\"filter_divider\":\"\\/\\/\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"900\",\"video_height\":\"504\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 179, 180, 0, '*', 0),
(164, 'mainmenu', '4 Columns - Gallery No Space ', '4-columns-gallery-no-space', '', 'portfolio/rectangular/4-columns-gallery-no-space', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 131, 3, 10020, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"catid\":\"21\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"rectangular\",\"column_bg\":\"\",\"limit\":\"12\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'pe pe-7s-albums\'><\\/i>\",\"filter_divider\":\"\\\\\\\\\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 181, 182, 0, '*', 0),
(165, 'mainmenu', 'Home Version 2', 'home-version-2', '', 'home/home-version-2', 'index.php?option=com_sppagebuilder&view=page&id=3', 'component', 1, 101, 2, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 14, 15, 0, '*', 0),
(166, 'mainmenu', 'Home Version 3', 'home-version-3', '', 'home/home-version-3', 'index.php?option=com_sppagebuilder&view=page&id=4', 'component', 1, 101, 2, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 16, 17, 0, '*', 0),
(167, 'mainmenu', 'Header (Transparent)', 'header-transparent', '', 'headers/header-transparent', 'index.php?option=com_sppagebuilder&view=page&id=8', 'component', 1, 106, 2, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 12, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 30, 31, 0, '*', 0),
(169, 'mainmenu', 'Header (Video Background)', 'header-video-background', '', 'headers/header-video-background', 'index.php?option=com_sppagebuilder&view=page&id=9', 'component', 1, 106, 2, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 12, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 32, 33, 0, '*', 0),
(170, 'mainmenu', 'Accordion', 'accordion', '', 'page-builder/addons-list-1/accordion', 'index.php?option=com_sppagebuilder&view=page&id=10', 'component', 1, 183, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/accordion.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 39, 40, 0, '*', 0),
(171, 'mainmenu', 'Tabs', 'tabs', '', 'page-builder/addons-list-1/tabs', 'index.php?option=com_sppagebuilder&view=page&id=11', 'component', 1, 183, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/tabs.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 41, 42, 0, '*', 0),
(172, 'mainmenu', 'Feature Box', 'feature-box', '', 'page-builder/addons-list-1/feature-box', 'index.php?option=com_sppagebuilder&view=page&id=12', 'component', 1, 183, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/feature-box.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 45, 46, 0, '*', 0),
(173, 'mainmenu', 'Call To Action', 'call-to-action', '', 'page-builder/addons-list-4/call-to-action', 'index.php?option=com_sppagebuilder&view=page&id=13', 'component', 1, 418, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/cta.png\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 103, 104, 0, '*', 0),
(174, 'mainmenu', 'Image', 'image', '', 'page-builder/addons-list-1/image', 'index.php?option=com_sppagebuilder&view=page&id=14', 'component', 1, 183, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/image.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 47, 48, 0, '*', 0),
(175, 'mainmenu', 'Image Content', 'image-content', '', 'page-builder/addons-list-1/image-content', 'index.php?option=com_sppagebuilder&view=page&id=15', 'component', 1, 183, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/image-content.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 49, 50, 0, '*', 0),
(176, 'mainmenu', 'Text Block', 'text-block', '', 'page-builder/addons-list-4/text-block', 'index.php?option=com_sppagebuilder&view=page&id=16', 'component', -2, 418, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/text-block.png\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 107, 108, 0, '*', 0),
(177, 'mainmenu', 'Slick Slider', 'slick-slider', '', 'page-builder/addons-list-2/slick-slider', 'index.php?option=com_sppagebuilder&view=page&id=17', 'component', 1, 184, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/slick-carousel.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 57, 58, 0, '*', 0),
(178, 'mainmenu', 'Carousels', 'carousels', '', 'page-builder/addons-list-2/carousels', 'index.php?option=com_sppagebuilder&view=page&id=18', 'component', 1, 184, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/carousel.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 59, 60, 0, '*', 0),
(179, 'mainmenu', 'Testimonials', 'testimonials', '', 'page-builder/addons-list-4/testimonials', 'index.php?option=com_sppagebuilder&view=page&id=19', 'component', 1, 418, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/testimonial-flex.png\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 101, 102, 0, '*', 0),
(180, 'mainmenu', 'Lightbox Gallery', 'lightbox-gallery', '', 'page-builder/addons-list-2/lightbox-gallery', 'index.php?option=com_sppagebuilder&view=page&id=20', 'component', 1, 184, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/image-lightbox.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 61, 62, 0, '*', 0),
(181, 'mainmenu', 'Flickr Gallery', 'flickr-gallery', '', 'page-builder/addons-list-2/flickr-gallery', 'index.php?option=com_sppagebuilder&view=page&id=21', 'component', 1, 184, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/flickr.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 63, 64, 0, '*', 0),
(182, 'mainmenu', 'Gallery', 'gallery', '', 'page-builder/addons-list-2/gallery', 'index.php?option=com_sppagebuilder&view=page&id=22', 'component', 1, 184, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/gallery.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 65, 66, 0, '*', 0),
(183, 'mainmenu', 'Addons List 1', 'addons-list-1', '', 'page-builder/addons-list-1', '', 'heading', 1, 110, 2, 0, 0, '2017-04-08 02:55:08', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 36, 53, 0, '*', 0),
(184, 'mainmenu', 'Addons List 2', 'addons-list-2', '', 'page-builder/addons-list-2', '', 'heading', 1, 110, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 54, 71, 0, '*', 0),
(185, 'mainmenu', 'Addons List 3', 'addons-list-3', '', 'page-builder/addons-list-3', '', 'heading', 1, 110, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 72, 89, 0, '*', 0),
(186, 'mainmenu', 'Modals', 'modals', '', 'page-builder/addons-list-2/modals', 'index.php?option=com_sppagebuilder&view=page&id=23', 'component', 1, 184, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/bootstrap-modal.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 67, 68, 0, '*', 0),
(187, 'mainmenu', 'Animated Numbers', 'animated-numbers', '', 'page-builder/addons-list-3/animated-numbers', 'index.php?option=com_sppagebuilder&view=page&id=24', 'component', 1, 185, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/animated-number.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 77, 78, 0, '*', 0),
(188, 'mainmenu', 'Pie Progress', 'pie-progress', '', 'page-builder/addons-list-3/pie-progress', 'index.php?option=com_sppagebuilder&view=page&id=25', 'component', 1, 185, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/pie-progress.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 79, 80, 0, '*', 0),
(189, 'mainmenu', 'Progress Bar', 'progress-bar', '', 'page-builder/addons-list-3/progress-bar', 'index.php?option=com_sppagebuilder&view=page&id=26', 'component', 1, 185, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/progress-bar.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 81, 82, 0, '*', 0),
(190, 'mainmenu', 'Pricing Table', 'pricing-table', '', 'page-builder/addons-list-4/pricing-table', 'index.php?option=com_sppagebuilder&view=page&id=27', 'component', 1, 418, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/pricing.png\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 97, 98, 0, '*', 0),
(191, 'mainmenu', 'Animated Headlines', 'animated-headlines', '', 'page-builder/addons-list-1/animated-headlines', 'index.php?option=com_sppagebuilder&view=page&id=60', 'component', 1, 183, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/animated-headlines.png\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 43, 44, 0, '*', 0),
(192, 'mainmenu', 'Button Group', 'button-group', '', 'page-builder/addons-list-4/button-group', 'index.php?option=com_sppagebuilder&view=page&id=29', 'component', 1, 418, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/button-group.png\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 105, 106, 0, '*', 0),
(193, 'mainmenu', 'Person', 'person', '', 'page-builder/addons-list-4/person', 'index.php?option=com_sppagebuilder&view=page&id=30', 'component', 1, 418, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/person.png\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 99, 100, 0, '*', 0),
(194, 'mainmenu', 'Google Map', 'google-map', '', 'page-builder/addons-list-3/google-map', 'index.php?option=com_sppagebuilder&view=page&id=31', 'component', 1, 185, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/gmap.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 85, 86, 0, '*', 0),
(195, 'mainmenu', 'Contact Form', 'contact-form', '', 'page-builder/addons-list-3/contact-form', 'index.php?option=com_sppagebuilder&view=page&id=32', 'component', 1, 185, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/ajax-contact.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 87, 88, 0, '*', 0),
(196, 'mainmenu', 'Icons', 'icons', '', 'page-builder/addons-list-1/icons', 'index.php?option=com_sppagebuilder&view=page&id=33', 'component', 1, 183, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/icons.png\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 51, 52, 0, '*', 0),
(215, 'mainmenu', 'Shop', 'shop', '', 'shop', 'index.php?option=com_virtuemart&view=virtuemart&productsublayout=0', 'component', 1, 1, 1, 10028, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":620,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"center\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"215\\\",\\\"moduleId\\\":\\\"121\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 255, 262, 0, '*', 0),
(217, 'mainmenu', 'Home Version 1', 'home-version-1', '', 'home/home-version-1', 'index.php?option=com_sppagebuilder&view=page&id=2', 'component', 1, 101, 2, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 13, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 12, 13, 0, '*', 0),
(218, 'mainmenu', 'Category', 'category', '', 'shop/category', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=2&virtuemart_manufacturer_id=0', 'component', 1, 215, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":0,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-folder\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"Category - Full Width\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"categorylayout\":\"default\",\"showcategory\":\"1\",\"showproducts\":\"1\",\"productsublayout\":\"0\"}', 256, 257, 0, '*', 0),
(219, 'mainmenu', 'Product Details', 'product-details', '', 'shop/product-details', 'index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=14', 'component', 1, 215, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-note2\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 258, 259, 0, '*', 0),
(220, 'mainmenu', 'Shopping Cart', 'shopping-cart', '', 'shop/shopping-cart', 'index.php?option=com_virtuemart&view=cart', 'component', 1, 215, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-cart\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 260, 261, 0, '*', 0),
(702, 'main', 'ACYM_CONFIGURATION', 'acym-configuration', '', 'com-acym/acym-configuration', 'index.php?option=com_acym&ctrl=configuration', 'component', 1, 692, 2, 10191, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 338, 339, 0, '', 1),
(238, 'mainmenu', 'Home Version 4', 'home-version-4', '', 'home/home-version-4', 'index.php?option=com_sppagebuilder&view=page&id=37', 'component', 1, 101, 2, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"200\",\"enable_page_title_parallax\":\"1\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"WELCOME TO OUR SHOP\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/audio-post-1.jpg\"}', 18, 19, 0, '*', 0),
(671, 'main', 'VirtueMart AIO', 'virtuemart-aio', '', 'virtuemart-aio', 'index.php?option=com_virtuemart_allinone', 'component', 1, 1, 1, 10108, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 313, 314, 0, '', 1),
(419, 'mainmenu', 'Timeline', 'timeline', '', 'page-builder/addons-list-4/timeline', 'index.php?option=com_sppagebuilder&view=page&id=49', 'component', 1, 418, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/timeline.png\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 95, 96, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(256, 'usermenu', 'My Profile', 'my-profile', '', 'my-profile', 'index.php?option=com_users&view=profile', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"256\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"fa-address-book-o\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 263, 264, 0, '*', 0),
(257, 'usermenu', 'My Orders', 'my-orders', '', 'my-orders', 'index.php?option=com_virtuemart&view=orders&layout=list', 'component', 1, 1, 1, 10028, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"257\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-note2\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 265, 266, 0, '*', 0),
(258, 'usermenu', 'Logout', 'logout', '', 'logout', 'index.php?option=com_users&view=login&layout=logout&task=user.menulogout', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"logout\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"258\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-delete-user\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 267, 268, 0, '*', 0),
(259, 'mainmenu', 'Login Form', 'login-form', '', 'pages/various/login-form', 'index.php?option=com_users&view=login', 'component', 1, 583, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"login_redirect_url\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logout_redirect_url\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"1\",\"page_heading\":\"Login Form\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-key\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 205, 206, 0, '*', 0),
(278, 'one-page-menu', 'Home', 'home-onepage', '', 'home-onepage', '#home-wrapper', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"278\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 269, 270, 0, '*', 0),
(279, 'mainmenu', 'Onepage', 'onepage', '', 'home/onepage', 'index.php?option=com_sppagebuilder&view=page&id=38', 'component', 1, 101, 2, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 14, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 22, 23, 0, '*', 0),
(280, 'one-page-menu', 'About', '2016-04-24-16-22-05', '', '2016-04-24-16-22-05', '#about', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 16, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"280\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 271, 272, 0, '*', 0),
(281, 'one-page-menu', 'Portfolio', '2016-04-24-16-22-41', '', '2016-04-24-16-22-41', '#portfolio', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 16, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 273, 274, 0, '*', 0),
(282, 'one-page-menu', 'Services', '2016-04-24-16-28-38', '', '2016-04-24-16-28-38', '#services', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 16, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"282\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 275, 276, 0, '*', 0),
(283, 'one-page-menu', 'Shop', 'shop-onepage', '', 'shop-onepage', '#shop', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 16, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"283\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 277, 278, 0, '*', 0),
(284, 'one-page-menu', 'Contact', 'contact-us', '', 'contact-us', '#contact', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 279, 280, 0, '*', 0),
(424, 'mainmenu', 'Full Window Background', 'full-window-background', '', 'home/full-window-background', 'index.php?option=com_sppagebuilder&view=page&id=41', 'component', 1, 101, 2, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 18, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 20, 21, 0, '*', 0),
(672, 'main', 'TCPDF', 'tcpdf', '', 'tcpdf', 'index.php?option=com_tcpdf', 'component', 1, 1, 1, 10109, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 315, 316, 0, '', 1),
(298, 'mainmenu', 'Custom Post Format', 'custom-post-format', '', 'posts/custom-post-format', 'index.php?option=com_content&view=article&id=38', 'component', 1, 109, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"0\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-share\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"center\",\"page_title_size\":\"33\",\"page_title_height\":\"220\",\"enable_page_title_parallax\":\"1\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/posts\\/status-post-1.jpg\"}', 226, 227, 0, '*', 0),
(300, 'mainmenu', 'Plyr HTML5 Player', 'plyr-html5-player', '', 'page-builder/addons-list-3/plyr-html5-player', 'index.php?option=com_sppagebuilder&view=page&id=43', 'component', 1, 185, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/plyr.png\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 75, 76, 0, '*', 0),
(418, 'mainmenu', 'Addons List 4', 'addons-list-4', '', 'page-builder/addons-list-4', '', 'heading', 1, 110, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 90, 109, 0, '*', 0),
(347, 'mainmenu', 'Countdown', 'countdown', '', 'page-builder/addons-list-3/countdown', 'index.php?option=com_sppagebuilder&view=page&id=46', 'component', 1, 185, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/countdown.png\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 83, 84, 0, '*', 0),
(348, 'mainmenu', 'PrettyPhoto Modal', 'prettyphoto-modal', '', 'page-builder/addons-list-2/prettyphoto-modal', 'index.php?option=com_sppagebuilder&view=page&id=48', 'component', 1, 184, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/prettyphoto-modal.png\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 69, 70, 0, '*', 0),
(670, 'main', 'COM_VIRTUEMART_MENU_CONFIGURATION', 'com-virtuemart-menu-configuration', '', 'com-virtuemart/com-virtuemart-menu-configuration', 'index.php?option=com_virtuemart&view=config', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-config.png', 0, '{}', 310, 311, 0, '', 1),
(420, 'mainmenu', 'Flip Box', 'flip-box', '', 'page-builder/addons-list-4/flip-box', 'index.php?option=com_sppagebuilder&view=page&id=50', 'component', 1, 418, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"images\\/pagebuilder\\/icons\\/flipbox.png\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 93, 94, 0, '*', 0),
(669, 'main', 'COM_VIRTUEMART_MENU_PAYMENTMETHODS', 'com-virtuemart-menu-paymentmethods', '', 'com-virtuemart/com-virtuemart-menu-paymentmethods', 'index.php?option=com_virtuemart&view=paymentmethod', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-paymentmethods.png', 0, '{}', 308, 309, 0, '', 1),
(668, 'main', 'COM_VIRTUEMART_MENU_SHIPMENTMETHODS', 'com-virtuemart-menu-shipmentmethods', '', 'com-virtuemart/com-virtuemart-menu-shipmentmethods', 'index.php?option=com_virtuemart&view=shipmentmethod', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shipmentmethods.png', 0, '{}', 306, 307, 0, '', 1),
(667, 'main', 'COM_VIRTUEMART_MENU_MEDIAFILES', 'com-virtuemart-menu-mediafiles', '', 'com-virtuemart/com-virtuemart-menu-mediafiles', 'index.php?option=com_virtuemart&view=media', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-media.png', 0, '{}', 304, 305, 0, '', 1),
(666, 'main', 'COM_VIRTUEMART_MENU_STORE', 'com-virtuemart-menu-store', '', 'com-virtuemart/com-virtuemart-menu-store', 'index.php?option=com_virtuemart&view=user&task=editshop', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shop.png', 0, '{}', 302, 303, 0, '', 1),
(665, 'main', 'COM_VIRTUEMART_MENU_MANUFACTURERS', 'com-virtuemart-menu-manufacturers', '', 'com-virtuemart/com-virtuemart-menu-manufacturers', 'index.php?option=com_virtuemart&view=manufacturer', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-manufacturers.png', 0, '{}', 300, 301, 0, '', 1),
(664, 'main', 'COM_VIRTUEMART_MENU_USERS', 'com-virtuemart-menu-users', '', 'com-virtuemart/com-virtuemart-menu-users', 'index.php?option=com_virtuemart&view=user', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shoppers.png', 0, '{}', 298, 299, 0, '', 1),
(663, 'main', 'COM_VIRTUEMART_MENU_REPORT', 'com-virtuemart-menu-report', '', 'com-virtuemart/com-virtuemart-menu-report', 'index.php?option=com_virtuemart&view=report', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-report.png', 0, '{}', 296, 297, 0, '', 1),
(662, 'main', 'COM_VIRTUEMART_MENU_ORDERS', 'com-virtuemart-menu-orders', '', 'com-virtuemart/com-virtuemart-menu-orders', 'index.php?option=com_virtuemart&view=orders', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-orders.png', 0, '{}', 294, 295, 0, '', 1),
(676, 'main', 'COM_SPPAGEBUILDER', 'com-sppagebuilder', '', 'com-sppagebuilder', 'index.php?option=com_sppagebuilder', 'component', 1, 1, 1, 10015, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 317, 318, 0, '', 1),
(661, 'main', 'COM_VIRTUEMART_MENU_CUSTOMS', 'com-virtuemart-menu-customs', '', 'com-virtuemart/com-virtuemart-menu-customs', 'index.php?option=com_virtuemart&view=custom', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-document_move.png', 0, '{}', 292, 293, 0, '', 1),
(659, 'main', 'COM_VIRTUEMART_MENU_CATEGORIES', 'com-virtuemart-menu-categories', '', 'com-virtuemart/com-virtuemart-menu-categories', 'index.php?option=com_virtuemart&view=category', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-categories.png', 0, '{}', 288, 289, 0, '', 1),
(553, 'main', 'COM_SPSIMPLEPORTFOLIO', 'com-spsimpleportfolio', '', 'com-spsimpleportfolio', 'index.php?option=com_spsimpleportfolio', 'component', 1, 1, 1, 10020, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 283, 284, 0, '', 1),
(582, 'mainmenu', 'Blog', 'blog', '', 'pages/blog', '', 'heading', 1, 107, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-note\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"page_title_bg_image_repeat\":\"no-repeat\",\"page_title_bg_image_size\":\"cover\",\"page_title_bg_image_attachment\":\"fixed\",\"page_title_bg_image_hor_position\":\"50\",\"page_title_bg_image_vert_position\":\"50\"}', 188, 195, 0, '*', 0),
(583, 'mainmenu', 'Various', 'various', '', 'pages/various', '', 'heading', 1, 107, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-ribbon\",\"icon\":\"\",\"class\":\"separator\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"page_title_bg_image_repeat\":\"no-repeat\",\"page_title_bg_image_size\":\"cover\",\"page_title_bg_image_attachment\":\"fixed\",\"page_title_bg_image_hor_position\":\"50\",\"page_title_bg_image_vert_position\":\"50\"}', 196, 207, 0, '*', 0),
(584, 'mainmenu', 'Masonry with Ajax Loading', 'masonry-with-ajax-loading', '', 'pages/blog/masonry-with-ajax-loading', 'index.php?option=com_content&view=category&layout=blog&id=15', 'component', 1, 582, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"0\",\"show_category_title\":\"0\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"0\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"0\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"0\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"3\",\"num_columns\":\"3\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"220\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"0\",\"page_title_alt\":\"Masonry Grid with Ajax Loading\",\"page_subtitle\":\"~ Ajax Intro Articles Module with Post Formats ~\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/blog\\/ajax-articles\\/walking-girl-page-title.jpg\",\"page_title_bg_image_repeat\":\"no-repeat\",\"page_title_bg_image_size\":\"cover\",\"page_title_bg_image_attachment\":\"fixed\",\"page_title_bg_image_hor_position\":\"50\",\"page_title_bg_image_vert_position\":\"30\"}', 189, 190, 0, '*', 0),
(585, 'mainmenu', 'Equal Heights with Ajax Loading', 'equal-heights-with-ajax-loading', '', 'pages/blog/equal-heights-with-ajax-loading', 'index.php?option=com_sppagebuilder&view=page&id=64', 'component', 1, 582, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"236\",\"enable_page_title_parallax\":\"1\",\"include_breadcrumbs\":\"0\",\"page_title_alt\":\"Equal Heights Grid with Ajax Loading\",\"page_subtitle\":\"~ Ajax Intro Articles Module with \\u201cIntro Images\\u201d (4 Columns) ~\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/blog\\/ajax-articles\\/flex-coffee-cup.jpg\",\"page_title_bg_image_repeat\":\"no-repeat\",\"page_title_bg_image_size\":\"cover\",\"page_title_bg_image_attachment\":\"fixed\",\"page_title_bg_image_hor_position\":\"50\",\"page_title_bg_image_vert_position\":\"30\"}', 191, 192, 0, '*', 0),
(586, 'mainmenu', '2 Columns + 1 Column Sidebar', '2-columns-1-column-sidebar', '', 'pages/blog/2-columns-1-column-sidebar', 'index.php?option=com_sppagebuilder&view=page&id=65', 'component', 1, 582, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"220\",\"enable_page_title_parallax\":\"1\",\"include_breadcrumbs\":\"0\",\"page_title_alt\":\"2 Columns (No Space) + 1 Column Sidebar\",\"page_subtitle\":\"~ Ajax Intro Articles Modules with \\u201cIntro Images\\u201d (2 Columns + 1 Column) ~\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"https:\\/\\/picsum.photos\\/1280\\/740?image=675\",\"page_title_bg_image_repeat\":\"no-repeat\",\"page_title_bg_image_size\":\"cover\",\"page_title_bg_image_attachment\":\"fixed\",\"page_title_bg_image_hor_position\":\"50\",\"page_title_bg_image_vert_position\":\"50\"}', 193, 194, 0, '*', 0),
(588, 'mainmenu', 'GDPR Privacy Policy', 'gdpr-privacy-policy', '', 'pages/various/gdpr-privacy-policy', 'index.php?option=com_content&view=article&id=61', 'component', 1, 583, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"0\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_tags\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-unlock\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"page_title_bg_image_repeat\":\"no-repeat\",\"page_title_bg_image_size\":\"cover\",\"page_title_bg_image_attachment\":\"fixed\",\"page_title_bg_image_hor_position\":\"50\",\"page_title_bg_image_vert_position\":\"50\"}', 197, 198, 0, '*', 0),
(660, 'main', 'COM_VIRTUEMART_MENU_PRODUCTS', 'com-virtuemart-menu-products', '', 'com-virtuemart/com-virtuemart-menu-products', 'index.php?option=com_virtuemart&view=product', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-products.png', 0, '{}', 290, 291, 0, '', 1),
(657, 'main', 'COM_VIRTUEMART', 'com-virtuemart', '', 'com-virtuemart', 'index.php?option=com_virtuemart', 'component', 1, 1, 1, 10028, 0, '0000-00-00 00:00:00', 0, 1, '../components/com_virtuemart/assets/images/vmgeneral/menu_icon.png', 0, '{}', 285, 312, 0, '', 1),
(658, 'main', 'COM_VIRTUEMART_CONTROL_PANEL', 'com-virtuemart-control-panel', '', 'com-virtuemart/com-virtuemart-control-panel', 'index.php?option=com_virtuemart&view=virtuemart', 'component', 1, 657, 2, 10028, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-report.png', 0, '{}', 286, 287, 0, '', 1),
(677, 'mainmenu', 'Slideshow', 'slideshow', '', 'page-builder/addons-list-2/slideshow', 'index.php?option=com_sppagebuilder&view=page&id=71', 'component', 1, 184, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-repeat\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_text_color\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"page_title_bg_image_repeat\":\"no-repeat\",\"page_title_bg_image_size\":\"cover\",\"page_title_bg_image_attachment\":\"fixed\",\"page_title_bg_image_hor_position\":\"50\",\"page_title_bg_image_vert_position\":\"50\"}', 55, 56, 0, '*', 0),
(678, 'mainmenu', 'Form Builder', 'form-builder', '', 'page-builder/addons-list-3/form-builder', 'index.php?option=com_sppagebuilder&view=page&id=72', 'component', 1, 185, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-note2\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_text_color\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"page_title_bg_image_repeat\":\"no-repeat\",\"page_title_bg_image_size\":\"cover\",\"page_title_bg_image_attachment\":\"fixed\",\"page_title_bg_image_hor_position\":\"50\",\"page_title_bg_image_vert_position\":\"50\"}', 73, 74, 0, '*', 0),
(679, 'mainmenu', 'Image Layouts', 'image-layouts', '', 'page-builder/addons-list-4/image-layouts', 'index.php?option=com_sppagebuilder&view=page&id=74', 'component', 1, 418, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-photo\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_text_color\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"page_title_bg_image_repeat\":\"no-repeat\",\"page_title_bg_image_size\":\"cover\",\"page_title_bg_image_attachment\":\"fixed\",\"page_title_bg_image_hor_position\":\"50\",\"page_title_bg_image_vert_position\":\"50\"}', 91, 92, 0, '*', 0),
(680, 'mainmenu', 'Articles Scroller', 'articles-scroller', '', 'page-builder/addons-list-1/articles-scroller', 'index.php?option=com_sppagebuilder&view=page&id=73', 'component', 1, 183, 3, 10015, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"peicon\":\"pe-7s-news-paper\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_align\":\"left\",\"page_title_size\":\"32\",\"page_title_height\":\"170\",\"enable_page_title_parallax\":\"0\",\"include_breadcrumbs\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_text_color\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\",\"page_title_bg_image_repeat\":\"no-repeat\",\"page_title_bg_image_size\":\"cover\",\"page_title_bg_image_attachment\":\"fixed\",\"page_title_bg_image_hor_position\":\"50\",\"page_title_bg_image_vert_position\":\"50\"}', 37, 38, 0, '*', 0),
(701, 'main', 'ACYM_BOUNCE_HANDLING', 'acym-bounce-handling', '', 'com-acym/acym-bounce-handling', 'index.php?option=com_acym&ctrl=bounces', 'component', 1, 692, 2, 10191, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 336, 337, 0, '', 1),
(700, 'main', 'ACYM_STATISTICS', 'acym-statistics', '', 'com-acym/acym-statistics', 'index.php?option=com_acym&ctrl=stats', 'component', 1, 692, 2, 10191, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 334, 335, 0, '', 1),
(699, 'main', 'ACYM_QUEUE', 'acym-queue', '', 'com-acym/acym-queue', 'index.php?option=com_acym&ctrl=queue', 'component', 1, 692, 2, 10191, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 332, 333, 0, '', 1),
(698, 'main', 'ACYM_AUTOMATION', 'acym-automation', '', 'com-acym/acym-automation', 'index.php?option=com_acym&ctrl=automation', 'component', 1, 692, 2, 10191, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 330, 331, 0, '', 1),
(697, 'main', 'ACYM_TEMPLATES', 'acym-templates', '', 'com-acym/acym-templates', 'index.php?option=com_acym&ctrl=mails', 'component', 1, 692, 2, 10191, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 328, 329, 0, '', 1),
(696, 'main', 'ACYM_CAMPAIGNS', 'acym-campaigns', '', 'com-acym/acym-campaigns', 'index.php?option=com_acym&ctrl=campaigns', 'component', 1, 692, 2, 10191, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 326, 327, 0, '', 1),
(695, 'main', 'ACYM_LISTS', 'acym-lists', '', 'com-acym/acym-lists', 'index.php?option=com_acym&ctrl=lists', 'component', 1, 692, 2, 10191, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 324, 325, 0, '', 1),
(694, 'main', 'ACYM_CUSTOM_FIELDS', 'acym-custom-fields', '', 'com-acym/acym-custom-fields', 'index.php?option=com_acym&ctrl=fields', 'component', 1, 692, 2, 10191, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 322, 323, 0, '', 1),
(693, 'main', 'ACYM_USERS', 'acym-users', '', 'com-acym/acym-users', 'index.php?option=com_acym&ctrl=users', 'component', 1, 692, 2, 10191, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 320, 321, 0, '', 1),
(692, 'main', 'COM_ACYM', 'com-acym', '', 'com-acym', 'index.php?option=com_acym', 'component', 1, 1, 1, 10191, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acym/images/icons/logo_acym.png', 0, '{}', 319, 340, 0, '', 1);

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE IF NOT EXISTS `#__menu_types` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `menutype` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES
(1, 0, 'mainmenu', 'Main Menu', 'The main menu for the site', 0),
(2, 0, 'usermenu', 'User Menu', '', 0),
(3, 0, 'one-page-menu', 'One Page Menu', '', 0);

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE IF NOT EXISTS `#__messages` (
  `message_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id_to` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE IF NOT EXISTS `#__messages_cfg` (
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE IF NOT EXISTS `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=MyISAM AUTO_INCREMENT=152 DEFAULT CHARSET=utf8;

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(1, 39, 'Off Canvas Menu', 'This is Off Canvas Menu, mobile menu for “offcanvas” position.', '', 2, 'offcanvas', 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"mainmenu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"flex:accordion\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(2, 40, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 41, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(4, 42, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(8, 43, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 44, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 45, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(12, 46, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', 1, '*'),
(13, 47, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 48, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_status', 3, 1, '', 1, '*'),
(15, 49, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(16, 50, 'Login Form', '', '', 14, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_login', 1, 1, '{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"usesecure\":\"0\",\"usetext\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(17, 51, 'Breadcrumbs', '', '', 1, 'breadcrumb', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 0, '{\"showHere\":\"1\",\"showHome\":\"1\",\"homeText\":\"\",\"showLast\":\"1\",\"separator\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(79, 52, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(86, 53, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(87, 104, 'SP Page Builder', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_icons', 1, 1, '', 1, '*'),
(88, 105, 'SP Page Builder Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_admin_menu', 1, 1, '', 1, '*'),
(89, 107, 'Search', '', '', 1, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 0, '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(90, 109, 'Portfolio (Homepage)', '', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_spsimpleportfolio', 1, 1, '{\"category_id\":\"21\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"rectangular\",\"limit\":\"9\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'fa fa-diamond\'><\\/i>\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_view_button\":\"0\",\"video_width\":\"900\",\"video_height\":\"502\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(91, 110, 'AP Smart LayerSlider (Homepage)', '', '', 1, 'slider', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_ap_smart_layerslider', 1, 0, '{\"display_form\":\"folder_image\",\"catid\":[\"\"],\"sort_order_field\":\"order\",\"count\":\"5\",\"path_folder\":{\"folder\":\"images\\/ap-smart-layerslider\\/homepage\",\"images\":\"{\\\"slide-4-2340x850\\\":{\\\"name\\\":\\\"slide-4-2340x850\\\",\\\"position\\\":0,\\\"imagesrc\\\":\\\"\\/images\\/ap-smart-layerslider\\/homepage\\/slide-4-2340x850.jpg\\\",\\\"caption\\\":\\\"\\\",\\\"title\\\":\\\"\\\",\\\"description\\\":\\\"<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topLeft\\\\\\\"\\\\ndata-width=\\\\\\\"60%\\\\\\\"\\\\ndata-horizontal=\\\\\\\"200\\\\\\\"\\\\ndata-vertical=\\\\\\\"100\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1000\\\\\\\"\\\\ndata-show-delay=\\\\\\\"2400\\\\\\\">\\\\n<h1 style=\\\\\\\"font-size:620%;font-weight:200;text-shadow:2px 4px 10px #222;\\\\\\\">A professional design based<br \\/>on vibrancy and elegance<\\/h1>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomLeft\\\\\\\"\\\\ndata-width=\\\\\\\"45%\\\\\\\"\\\\ndata-horizontal=\\\\\\\"205\\\\\\\"\\\\ndata-vertical=\\\\\\\"300\\\\\\\"\\\\ndata-show-transition=\\\\\\\"right\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1300\\\\\\\"\\\\ndata-show-delay=\\\\\\\"2800\\\\\\\">\\\\n<p style=\\\\\\\"font-size:32px;line-height:1.8;color:#DEDEDE;text-shadow:1px 2px 5px #222;\\\\\\\">\\\\nFlex is an exquisite design bursting with sharpness and bold, but complementary visuals; within a rich framework of emphasized typography and iconography.\\\\n<\\/p>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomLeft\\\\\\\"\\\\ndata-width=\\\\\\\"45%\\\\\\\"\\\\ndata-horizontal=\\\\\\\"205\\\\\\\"\\\\ndata-vertical=\\\\\\\"165\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1300\\\\\\\"\\\\ndata-show-delay=\\\\\\\"3000\\\\\\\">\\\\n<a style=\\\\\\\"margin-right:25px;\\\\\\\" href=\\\\\\\"index.php?option=com_sppagebuilder&view=page&id=2&Itemid=217\\\\\\\" class=\\\\\\\"btn btn-light\\\\\\\"><i style=\\\\\\\"margin-left:-5px;margin-right:15px;\\\\\\\" class=\\\\\\\"fa fa-eye major_color\\\\\\\"><\\/i>Retina Perfect<\\/a>\\\\n<a href=\\\\\\\"index.php?option=com_sppagebuilder&view=page&id=8&Itemid=167\\\\\\\" class=\\\\\\\"btn btn-light\\\\\\\">Flex It More! <i style=\\\\\\\"margin-left:15px;margin-right:-4px\\\\\\\" class=\\\\\\\"fa fa-diamond major_color\\\\\\\"><\\/i><\\/a>\\\\n<\\/div>\\\\n\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomRight\\\\\\\"\\\\ndata-width=\\\\\\\"550\\\\\\\"\\\\ndata-height=\\\\\\\"505\\\\\\\"\\\\ndata-horizontal=\\\\\\\"355\\\\\\\"\\\\ndata-show-offset=\\\\\\\"0\\\\\\\"\\\\ndata-vertical=\\\\\\\"120\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1000\\\\\\\"\\\\ndata-show-delay=\\\\\\\"800\\\\\\\">\\\\n<img src=\\\\\\\"images\\/ap-smart-layerslider\\/homepage\\/layers\\/flex-iphone6-screen.png\\\\\\\" \\/>\\\\n<\\/div>\\\",\\\"image\\\":\\\"slide-4-2340x850.jpg\\\"},\\\"black-234x85-1\\\":{\\\"title\\\":\\\"\\\",\\\"caption\\\":\\\"\\\",\\\"description\\\":\\\"<div class=\\\\\\\"sp-layer\\\\\\\" data-horizontal=\\\\\\\"0\\\\\\\" data-vertical=\\\\\\\"0\\\\\\\" data-show-duration=\\\\\\\"800\\\\\\\" data-show-delay=\\\\\\\"300\\\\\\\">\\\\n<video class=\\\\\\\"sp-video\\\\\\\" poster=\\\\\\\"images\\/ap-smart-layerslider\\/homepage\\/layers\\/transparent-234x85.png\\\\\\\" width=\\\\\\\"2340\\\\\\\" height=\\\\\\\"980\\\\\\\" preload=\\\\\\\"none\\\\\\\" autoplay muted>\\\\n    <source src=\\\\\\\"images\\/videos\\/Explore.mp4\\\\\\\" type=\\\\\\\"video\\/mp4\\\\\\\"\\/>\\\\n<\\/video>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topRight\\\\\\\"\\\\ndata-show-offset=\\\\\\\"50\\\\\\\"\\\\ndata-horizontal=\\\\\\\"532\\\\\\\"\\\\ndata-vertical=\\\\\\\"-100\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"2500\\\\\\\"\\\\ndata-show-delay=\\\\\\\"700\\\\\\\">\\\\n<h5 style=\\\\\\\"font-size:4800%;color:rgba(142,121,106,.22);\\\\\\\">S<\\/h5>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-width=\\\\\\\"40%\\\\\\\"\\\\ndata-position=\\\\\\\"topRight\\\\\\\"\\\\ndata-show-offset=\\\\\\\"120\\\\\\\"\\\\ndata-horizontal=\\\\\\\"250\\\\\\\"\\\\ndata-vertical=\\\\\\\"36\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"2000\\\\\\\"\\\\ndata-show-delay=\\\\\\\"900\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\"\\\\ndata-hide-duration=\\\\\\\"1500\\\\\\\">\\\\n<h2 style=\\\\\\\"font-size:800%;text-align:right;color:#7B412E;\\\\\\\">Sync <span style=\\\\\\\"color:#fff;\\\\\\\">up.<\\/span><\\/h2>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-width=\\\\\\\"40%\\\\\\\"\\\\ndata-position=\\\\\\\"topRight\\\\\\\"\\\\ndata-show-offset=\\\\\\\"120\\\\\\\"\\\\ndata-horizontal=\\\\\\\"114\\\\\\\"\\\\ndata-vertical=\\\\\\\"145\\\\\\\"\\\\ndata-show-transition=\\\\\\\"down\\\\\\\"\\\\ndata-show-duration=\\\\\\\"2000\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1000\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"up\\\\\\\"\\\\ndata-hide-duration=\\\\\\\"1500\\\\\\\">\\\\n<h2 style=\\\\\\\"font-size:800%;text-align:right;color:rgba(169,113,43,.9);text-shadow:1px 0 30px rgba(255,255,255,.1);\\\\\\\">Stay <span style=\\\\\\\"color:#fff;\\\\\\\">!nspired.<\\/span><\\/h2>\\\\n<\\/div>\\\",\\\"name\\\":\\\"black-234x85-1\\\",\\\"position\\\":1,\\\"imagesrc\\\":\\\"\\/images\\/ap-smart-layerslider\\/homepage\\/black-234x85-1.png\\\",\\\"image\\\":\\\"black-234x85-1.png\\\"},\\\"slide-3-2340x850\\\":{\\\"name\\\":\\\"slide-3-2340x850\\\",\\\"position\\\":2,\\\"imagesrc\\\":\\\"\\/images\\/ap-smart-layerslider\\/homepage\\/slide-3-2340x850.jpg\\\",\\\"caption\\\":\\\"\\\",\\\"title\\\":\\\"\\\",\\\"description\\\":\\\"<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topLeft\\\\\\\"\\\\ndata-width=\\\\\\\"70%\\\\\\\"\\\\ndata-show-offset=\\\\\\\"20\\\\\\\"\\\\ndata-horizontal=\\\\\\\"350\\\\\\\"\\\\ndata-vertical=\\\\\\\"152\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"900\\\\\\\"\\\\ndata-show-delay=\\\\\\\"700\\\\\\\">\\\\n<h1 style=\\\\\\\"font-size:700%;color:#fff;text-align:center;text-shadow:2px 3px 14px #222;\\\\\\\">This is Flex, a highly user friendly interface template.<\\/h1>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomLeft\\\\\\\"\\\\ndata-width=\\\\\\\"40%\\\\\\\"\\\\ndata-horizontal=\\\\\\\"405\\\\\\\"\\\\ndata-vertical=\\\\\\\"280\\\\\\\"\\\\ndata-show-transition=\\\\\\\"down\\\\\\\"\\\\ndata-show-duration=\\\\\\\"900\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1300\\\\\\\">\\\\n<p style=\\\\\\\"font-size:32px;line-height:1.6;text-align:right;color:#d9d9d9;text-shadow:1px 2px 4px rgba(0,0,0,.2);border-right:1px solid rgba(255,255,255,.5);padding:3px 35px 5px 0;\\\\\\\">\\\\nEasily configure complex layouts with the Drag & Drop<br \\/>interface for the whole site or specific pages.\\\\n<\\/p>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomCenter\\\\\\\"\\\\ndata-horizontal=\\\\\\\"784\\\\\\\"\\\\ndata-show-offset=\\\\\\\"100\\\\\\\"\\\\ndata-vertical=\\\\\\\"302\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1500\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\">\\\\n<a style=\\\\\\\"border:1px solid rgba(255,255,255,.5)\\\\\\\" href=\\\\\\\"#\\\\\\\" class=\\\\\\\"btn btn-light\\\\\\\"><i style=\\\\\\\"margin-left:-3px;margin-right:15px;\\\\\\\" class=\\\\\\\"fa fa-hand-o-right\\\\\\\"><\\/i>Show Features<\\/a>\\\\n<\\/div>\\\",\\\"image\\\":\\\"slide-3-2340x850.jpg\\\"},\\\"slide-11-2340x850\\\":{\\\"name\\\":\\\"slide-11-2340x850\\\",\\\"position\\\":3,\\\"imagesrc\\\":\\\"\\/images\\/ap-smart-layerslider\\/homepage\\/slide-11-2340x850.jpg\\\",\\\"caption\\\":\\\"\\\",\\\"title\\\":\\\"\\\",\\\"description\\\":\\\"<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topLeft\\\\\\\"\\\\ndata-width=\\\\\\\"40%\\\\\\\"\\\\ndata-horizontal=\\\\\\\"250\\\\\\\"\\\\ndata-vertical=\\\\\\\"150\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1000\\\\\\\"\\\\ndata-show-delay=\\\\\\\"700\\\\\\\">\\\\n<h1 style=\\\\\\\"font-size:600%;color:#fff;text-shadow:2px 3px 10px #222;\\\\\\\">Drag & Drop<\\/h1>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topLeft\\\\\\\"\\\\ndata-width=\\\\\\\"40%\\\\\\\"\\\\ndata-horizontal=\\\\\\\"250\\\\\\\"\\\\ndata-vertical=\\\\\\\"230\\\\\\\"\\\\ndata-show-transition=\\\\\\\"right\\\\\\\"\\\\ndata-show-duration=\\\\\\\"2200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1000\\\\\\\">\\\\n<h2 style=\\\\\\\"font-size:800%;line-height:1.5;color:#fff;text-shadow:2px 3px 15px #222;\\\\\\\">Layout Builder<\\/h2>\\\\n<hr \\/>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomLeft\\\\\\\"\\\\ndata-width=\\\\\\\"40%\\\\\\\"\\\\ndata-horizontal=\\\\\\\"260\\\\\\\"\\\\ndata-vertical=\\\\\\\"220\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1300\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1300\\\\\\\">\\\\n<p style=\\\\\\\"font-size:36px;line-height:1.7;color:#fff;text-shadow:1px 2px 5px #222;\\\\\\\">\\\\nUnlimited positions, with drag and drop add, delete, move and resize capabilities.\\\\n<\\/p>\\\\n<\\/div>\\\",\\\"image\\\":\\\"slide-11-2340x850.jpg\\\"},\\\"slide-1-2340x850\\\":{\\\"name\\\":\\\"slide-1-2340x850\\\",\\\"position\\\":4,\\\"imagesrc\\\":\\\"\\/images\\/ap-smart-layerslider\\/homepage\\/slide-1-2340x850.jpg\\\",\\\"caption\\\":\\\"\\\",\\\"title\\\":\\\"\\\",\\\"description\\\":\\\"<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"280\\\\\\\"\\\\ndata-width=\\\\\\\"550\\\\\\\"\\\\ndata-show-offset=\\\\\\\"180\\\\\\\"\\\\ndata-vertical=\\\\\\\"-10\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1000\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\">\\\\n<img src=\\\\\\\"images\\/ap-smart-layerslider\\/homepage\\/layers\\/iPhone6_mockup_front.png\\\\\\\" \\/>\\\\n<\\/div>\\\\n\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topRight\\\\\\\"\\\\ndata-width=\\\\\\\"50%\\\\\\\"\\\\ndata-horizontal=\\\\\\\"255\\\\\\\"\\\\ndata-show-offset=\\\\\\\"60\\\\\\\"\\\\ndata-vertical=\\\\\\\"160\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"900\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1000\\\\\\\">\\\\n<div class=\\\\\\\"sppb-addon\\\\\\\">\\\\n<h3 class=\\\\\\\"sppb-addon-title\\\\\\\" style=\\\\\\\"font-size:500%;text-shadow:0 0 40px rgba(255,255,255,.5);\\\\\\\">Creative, adaptive<br \\/>and ever-ready to serve you.<\\/h3><\\/div>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomRight\\\\\\\"\\\\ndata-width=\\\\\\\"45%\\\\\\\"\\\\ndata-show-offset=\\\\\\\"80\\\\\\\"\\\\ndata-horizontal=\\\\\\\"368\\\\\\\"\\\\ndata-vertical=\\\\\\\"250\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"900\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1300\\\\\\\">\\\\n<p style=\\\\\\\"font-size:32px;line-height:1.7;\\\\\\\">\\\\nGood seasons, day place male evening life after together gathered let void she\'d grass created days upon after above great. Seasons earth face seasons so for called have fly seasons of one waters.<\\/p>\\\\n<\\/div>\\\\n\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomRight\\\\\\\"\\\\ndata-horizontal=\\\\\\\"252\\\\\\\"\\\\ndata-width=\\\\\\\"50%\\\\\\\"\\\\ndata-show-offset=\\\\\\\"100\\\\\\\"\\\\ndata-vertical=\\\\\\\"130\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1600\\\\\\\">\\\\n<a href=\\\\\\\"#\\\\\\\" class=\\\\\\\"btn btn-readmore\\\\\\\"><i style=\\\\\\\"margin-left:-4px;margin-right:12px;\\\\\\\" class=\\\\\\\"fa fa-cloud-download\\\\\\\"><\\/i>Download<\\/a> <a href=\\\\\\\"#\\\\\\\" class=\\\\\\\"btn btn-dark\\\\\\\">Learn More <i style=\\\\\\\"margin-left:7px;margin-right:-2px;\\\\\\\" class=\\\\\\\"fa fa-connectdevelop\\\\\\\"><\\/i><\\/a><a href=\\\\\\\"#\\\\\\\" class=\\\\\\\"btn sppb-btn-default\\\\\\\">Exercise<i style=\\\\\\\"margin-left:10px;\\\\\\\" class=\\\\\\\"fa fa-leanpub\\\\\\\"><\\/i><\\/a>\\\\n<\\/div>\\\\n\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"centerLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"422\\\\\\\"\\\\ndata-show-offset=\\\\\\\"60\\\\\\\"\\\\ndata-vertical=\\\\\\\"60\\\\\\\"\\\\ndata-show-transition=\\\\\\\"down\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1500\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\">\\\\n<h3 style=\\\\\\\"text-align:center;font-size:14px;letter-spacing: 1px;color:#b0b0b0;\\\\\\\">MOST <span style=\\\\\\\"color:#f75846;\\\\\\\">FLEXIBLE<\\/span> JOOMLA TEMPLATE<\\/h3>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"376\\\\\\\"\\\\ndata-show-offset=\\\\\\\"100\\\\\\\"\\\\ndata-vertical=\\\\\\\"65\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"2500\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\">\\\\n<div style=\\\\\\\"width:370px;white-space: pre-wrap;text-align:center;\\\\\\\">\\\\n<h4 style=\\\\\\\"font-size:30px;line-height:25px;letter-spacing: 1px;color:#aaa;margin:0 auto;\\\\\\\">Pursue your passion.<\\/h4>\\\\n<p style=\\\\\\\"font-size:18px;color:#707070;margin:0 auto 2px;\\\\\\\">With continuous heart rate readings, surge keeps you in the zone.<\\/p>\\\\n<a href=\\\\\\\"#\\\\\\\" class=\\\\\\\"btn btn-light\\\\\\\"><i style=\\\\\\\"color:#f75846;margin-left:-5px;margin-right:10px;\\\\\\\" class=\\\\\\\"fa fa-heartbeat\\\\\\\"><\\/i>Heart Rate<\\/a>\\\\n<\\/div>\\\\n<\\/div>\\\",\\\"image\\\":\\\"slide-1-2340x850.jpg\\\"}}\"},\"theme\":\"4\",\"image_width\":\"2340\",\"image_height\":\"850\",\"mainimage_mode\":\"none\",\"use_ratio\":\"1\",\"forceSize\":\"fullWidth\",\"visibleSize\":\"auto\",\"slideDistance\":\"0\",\"responsive\":\"1\",\"imageScaleMode\":\"contain\",\"autoHeight\":\"0\",\"autoScaleLayers\":\"1\",\"waitForLayers\":\"0\",\"orientation\":\"horizontal\",\"loop\":\"1\",\"shuffle\":\"0\",\"fullScreen\":\"0\",\"fullscreen_button_color\":\"#000000\",\"fadeEffect\":\"1\",\"fadeOutPreviousSlide\":\"0\",\"fadeDuration\":\"700\",\"autoplay\":\"0\",\"autoplayDelay\":\"5000\",\"autoplayOnHover\":\"pause\",\"show_thumbnails\":\"0\",\"thumbnailWidth\":\"290\",\"thumbnailHeight\":\"105\",\"thumbnailtxt_align\":\"left\",\"show_thumbnail_description\":\"0\",\"thumbnail_description_max_chars\":\"50\",\"selected_thumbnail_txt_color\":\"\",\"thumbnailsPosition\":\"right\",\"thumbnailPointer\":\"1\",\"thumbnailPointer_color\":\"\",\"thumbnailArrows\":\"1\",\"show_arrows\":\"1\",\"arrows_size\":\"50\",\"show_buttons\":\"1\",\"buttons_color\":\"rgba(255,93,93,1)\",\"display_caption\":\"0\",\"captiontxt_align\":\"center\",\"description_max_chars\":\"70\",\"load_videojs\":\"0\",\"reachVideoAction\":\"playVideo\",\"leaveVideoAction\":\"stopVideo\",\"playVideoAction\":\"none\",\"pauseVideoAction\":\"none\",\"endVideoAction\":\"replayVideo\",\"load_js\":\"head\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(92, 111, 'Add Space Module', 'This is “AddSpace” module with banner like image', '<img class=\"img-rounded\" src=\"images/banners/flex-banner-1.png\" alt=\"Flex Banner\" />', 1, 'addspace', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"Flex-sp_xhtml\"}', 0, '*'),
(94, 113, 'Related Articles', '', '', 8, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_related_items', 1, 1, '{\"showDate\":\"1\",\"maximum\":\"5\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(95, 114, 'Articles - Category', '', '', 7, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_category', 1, 1, '{\"mode\":\"normal\",\"show_on_article_page\":\"1\",\"count\":\"3\",\"show_front\":\"show\",\"category_filtering_type\":\"1\",\"catid\":[\"18\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"author_filtering_type\":\"1\",\"created_by\":[\"\"],\"author_alias_filtering_type\":\"1\",\"created_by_alias\":[\"\"],\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":\"30\",\"article_ordering\":\"a.title\",\"article_ordering_direction\":\"ASC\",\"article_grouping\":\"none\",\"article_grouping_direction\":\"ksort\",\"month_year_format\":\"F Y\",\"link_titles\":\"1\",\"show_date\":\"1\",\"show_date_field\":\"created\",\"show_date_format\":\"d F Y\",\"show_category\":\"1\",\"show_hits\":\"1\",\"show_author\":\"0\",\"show_introtext\":\"1\",\"introtext_limit\":\"70\",\"show_readmore\":\"0\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"15\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(96, 120, 'Search', '', '', 1, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 0, '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(97, 121, 'About The Flex', '', '<p>Good seasons, day place male evening life after together gathered let void she\'d grass created days upon after above great. Creative, prolific and ever-ready to serve you.</p>\r\n<hr />\r\n<div class=\"flex-video vimeo\"><iframe width=\"300\" height=\"150\" src=\"https://player.vimeo.com/video/99722811?title=0&amp;byline=0&amp;portrait=0&amp;color=f14833\"></iframe></div>', 4, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(98, 122, 'Popular Tags', '', '', 6, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tags_popular', 1, 1, '{\"maximum\":\"6\",\"timeframe\":\"alltime\",\"order_value\":\"count\",\"order_direction\":\"1\",\"display_count\":1,\"no_results_text\":\"1\",\"minsize\":1,\"maxsize\":2,\"layout\":\"_:cloud\",\"moduleclass_sfx\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(100, 127, 'AP Smart LayerSlider (Homepage 2)', '', '', 1, 'slider', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_ap_smart_layerslider', 1, 0, '{\"display_form\":\"folder_image\",\"catid\":[\"\"],\"sort_order_field\":\"order\",\"count\":\"5\",\"path_folder\":{\"folder\":\"images\\/ap-smart-layerslider\\/homepage2\",\"images\":\"{\\\"slide-3-2340x850\\\":{\\\"name\\\":\\\"slide-3-2340x850\\\",\\\"position\\\":0,\\\"imagesrc\\\":\\\"\\/images\\/ap-smart-layerslider\\/homepage2\\/slide-3-2340x850.jpg\\\",\\\"caption\\\":\\\"\\\",\\\"title\\\":\\\"\\\",\\\"description\\\":\\\"<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomCenter\\\\\\\"\\\\ndata-width=\\\\\\\"200\\\\\\\"\\\\ndata-height=\\\\\\\"70\\\\\\\"\\\\ndata-horizontal=\\\\\\\"-220\\\\\\\"\\\\ndata-show-offset=\\\\\\\"100\\\\\\\"\\\\ndata-vertical=\\\\\\\"180\\\\\\\"\\\\ndata-show-transition=\\\\\\\"down\\\\\\\"\\\\ndata-show-duration=\\\\\\\"2700\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1500\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\">\\\\n<a style=\\\\\\\"border-width:3px;color:#fff;font-size:280%;padding:12px 70px;line-height:1.6;letter-spacing:3px;\\\\\\\" href=\\\\\\\"#ap-smart-layerslider-mod_100\\/1\\\\\\\" class=\\\\\\\"btn btn-flex text-shadow\\\\\\\"><i style=\\\\\\\"margin-left:-10px;margin-right:20px;font-size:150%;font-weight:400;vertical-align:middle;margin-top:-15px;\\\\\\\" class=\\\\\\\"pe-7s-compass\\\\\\\"><\\/i>EXPLORE<\\/a>\\\\n<\\/div>\\\",\\\"image\\\":\\\"slide-3-2340x850.jpg\\\"},\\\"black-234x85-1\\\":{\\\"title\\\":\\\"\\\",\\\"caption\\\":\\\"\\\",\\\"description\\\":\\\"<div class=\\\\\\\"sp-layer\\\\\\\" data-horizontal=\\\\\\\"0\\\\\\\" data-vertical=\\\\\\\"0\\\\\\\" data-show-duration=\\\\\\\"700\\\\\\\" data-show-delay=\\\\\\\"200\\\\\\\">\\\\n<video class=\\\\\\\"sp-video\\\\\\\" poster=\\\\\\\"images\\/ap-smart-layerslider\\/homepage2\\/layers\\/transparent-234x85.png\\\\\\\" width=\\\\\\\"2340\\\\\\\" height=\\\\\\\"936\\\\\\\" preload=\\\\\\\"none\\\\\\\" autoplay muted>\\\\n    <source src=\\\\\\\"images\\/videos\\/Richard-2-Trailer_hd.mp4\\\\\\\" type=\\\\\\\"video\\/mp4\\\\\\\"\\/>\\\\n<\\/video>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer centered\\\\\\\"\\\\ndata-position=\\\\\\\"leftCenter\\\\\\\"\\\\ndata-horizontal=\\\\\\\"19%\\\\\\\"\\\\ndata-show-offset=\\\\\\\"80\\\\\\\"\\\\ndata-vertical=\\\\\\\"-100\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"2000\\\\\\\"\\\\ndata-show-delay=\\\\\\\"2150\\\\\\\"\\\\ndata-hide-duration=\\\\\\\"800\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\">\\\\n<h2 style=\\\\\\\"font-size:550%;margin-bottom:25px;padding:30px;color:rgba(255,255,255,.8);text-shadow:1px 2px 4px rgba(0,0,0,.2);\\\\\\\">Customize Your Entire Site With Ease<\\/h2>\\\\n<\\/div>\\\\n\\\\n<div class=\\\\\\\"sp-layer centered\\\\\\\"\\\\ndata-position=\\\\\\\"leftCenter\\\\\\\"\\\\ndata-horizontal=\\\\\\\"28%\\\\\\\"\\\\ndata-show-offset=\\\\\\\"120\\\\\\\"\\\\ndata-vertical=\\\\\\\"290\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"2000\\\\\\\"\\\\ndata-show-delay=\\\\\\\"2400\\\\\\\"\\\\ndata-hide-duration=\\\\\\\"1000\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\">\\\\n<h3 class=\\\\\\\"black_bckg-20\\\\\\\" style=\\\\\\\"font-size:250%;margin-bottom:50px;color:rgba(255,255,255,.8);padding:20px 30px;\\\\\\\">Simply amazing and fun to use. Bold, beautiful & brilliant.<\\/h3>\\\\n<a style=\\\\\\\"font-size:200%;padding:15px 60px;line-height:2;letter-spacing:1px;\\\\\\\" href=\\\\\\\"#take-control\\\\\\\" class=\\\\\\\"btn btn-light page-scroll\\\\\\\"><i style=\\\\\\\"margin-left:-10px;margin-right:20px;font-size:160%;font-weight:600;vertical-align:middle;margin-top:-8px;\\\\\\\" class=\\\\\\\"pe-7s-wristwatch\\\\\\\"><\\/i>LEARN MORE<\\/a>\\\\n<\\/div>\\\",\\\"name\\\":\\\"black-234x85-1\\\",\\\"position\\\":1,\\\"imagesrc\\\":\\\"\\/images\\/ap-smart-layerslider\\/homepage2\\/black-234x85-1.png\\\",\\\"image\\\":\\\"black-234x85-1.png\\\"},\\\"slide-1-2340x850\\\":{\\\"name\\\":\\\"slide-1-2340x850\\\",\\\"position\\\":2,\\\"imagesrc\\\":\\\"\\/images\\/ap-smart-layerslider\\/homepage2\\/slide-1-2340x850.jpg\\\",\\\"caption\\\":\\\"\\\",\\\"title\\\":\\\"\\\",\\\"description\\\":\\\"<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"280\\\\\\\"\\\\ndata-width=\\\\\\\"550\\\\\\\"\\\\ndata-show-offset=\\\\\\\"180\\\\\\\"\\\\ndata-vertical=\\\\\\\"0\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1000\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\">\\\\n<img src=\\\\\\\"images\\/ap-smart-layerslider\\/homepage\\/layers\\/iPhone6_mockup_front.png\\\\\\\" \\/>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topRight\\\\\\\"\\\\ndata-width=\\\\\\\"50%\\\\\\\"\\\\ndata-horizontal=\\\\\\\"255\\\\\\\"\\\\ndata-show-offset=\\\\\\\"60\\\\\\\"\\\\ndata-vertical=\\\\\\\"160\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"900\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1000\\\\\\\">\\\\n<div class=\\\\\\\"sppb-addon\\\\\\\">\\\\n<h3 class=\\\\\\\"sppb-addon-title\\\\\\\" style=\\\\\\\"font-size:500%;text-shadow:0 0 40px rgba(255,255,255,.5);\\\\\\\">Creative, adaptive<br \\/>and ever-ready to serve you.<\\/h3><\\/div>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomRight\\\\\\\"\\\\ndata-width=\\\\\\\"45%\\\\\\\"\\\\ndata-show-offset=\\\\\\\"80\\\\\\\"\\\\ndata-horizontal=\\\\\\\"368\\\\\\\"\\\\ndata-vertical=\\\\\\\"250\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"900\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1300\\\\\\\">\\\\n<p style=\\\\\\\"font-size:32px;line-height:1.7;\\\\\\\">\\\\nFlex is an ideal platform for users of all levels, whether beginners or web professionals. The administrative interface is both simple to use, intuitive and highly flexible, allowing for swift and extensive changes.<\\/p>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomRight\\\\\\\"\\\\ndata-horizontal=\\\\\\\"252\\\\\\\"\\\\ndata-width=\\\\\\\"50%\\\\\\\"\\\\ndata-show-offset=\\\\\\\"100\\\\\\\"\\\\ndata-vertical=\\\\\\\"130\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1600\\\\\\\">\\\\n<a href=\\\\\\\"#\\\\\\\" class=\\\\\\\"btn btn-readmore\\\\\\\"><i style=\\\\\\\"margin-left:-4px;margin-right:12px;\\\\\\\" class=\\\\\\\"fa fa-cloud-download\\\\\\\"><\\/i>Download<\\/a> <a href=\\\\\\\"#\\\\\\\" class=\\\\\\\"btn btn-dark\\\\\\\">Learn More <i style=\\\\\\\"margin-left:7px;margin-right:-2px;\\\\\\\" class=\\\\\\\"fa fa-connectdevelop\\\\\\\"><\\/i><\\/a><a href=\\\\\\\"#\\\\\\\" class=\\\\\\\"btn sppb-btn-default\\\\\\\">Exercise<i style=\\\\\\\"margin-left:10px;\\\\\\\" class=\\\\\\\"fa fa-leanpub\\\\\\\"><\\/i><\\/a>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"centerLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"422\\\\\\\"\\\\ndata-show-offset=\\\\\\\"60\\\\\\\"\\\\ndata-vertical=\\\\\\\"60\\\\\\\"\\\\ndata-show-transition=\\\\\\\"down\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1500\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\">\\\\n<h3 style=\\\\\\\"text-align:center;font-size:14px;letter-spacing: 1px;color:#b0b0b0;\\\\\\\">MOST <span style=\\\\\\\"color:#f75846;\\\\\\\">FLEXIBLE<\\/span> JOOMLA TEMPLATE<\\/h3>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"376\\\\\\\"\\\\ndata-show-offset=\\\\\\\"100\\\\\\\"\\\\ndata-vertical=\\\\\\\"65\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"2500\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\">\\\\n<div style=\\\\\\\"width:370px;white-space: pre-wrap;text-align:center;\\\\\\\">\\\\n<h4 style=\\\\\\\"font-size:30px;line-height:25px;letter-spacing: 1px;color:#aaa;margin:0 auto;\\\\\\\">Pursue your passion.<\\/h4>\\\\n<p style=\\\\\\\"font-size:18px;color:#707070;margin:0 auto 2px;\\\\\\\">With continuous heart rate readings, surge keeps you in the zone.<\\/p>\\\\n<a href=\\\\\\\"#\\\\\\\" class=\\\\\\\"btn btn-light\\\\\\\"><i style=\\\\\\\"color:#f75846;margin-left:-5px;margin-right:10px;\\\\\\\" class=\\\\\\\"fa fa-heartbeat\\\\\\\"><\\/i>Heart Rate<\\/a>\\\\n<\\/div>\\\\n<\\/div>\\\",\\\"image\\\":\\\"slide-1-2340x850.jpg\\\"}}\"},\"theme\":\"5\",\"image_width\":\"2340\",\"image_height\":\"850\",\"mainimage_mode\":\"none\",\"use_ratio\":\"1\",\"forceSize\":\"none\",\"visibleSize\":\"auto\",\"slideDistance\":\"10\",\"responsive\":\"1\",\"imageScaleMode\":\"contain\",\"autoHeight\":\"1\",\"autoScaleLayers\":\"1\",\"waitForLayers\":\"0\",\"orientation\":\"horizontal\",\"loop\":\"1\",\"shuffle\":\"0\",\"fullScreen\":\"0\",\"fullscreen_button_color\":\"#000000\",\"fadeEffect\":\"1\",\"fadeOutPreviousSlide\":\"0\",\"fadeDuration\":\"500\",\"autoplay\":\"0\",\"autoplayDelay\":\"5000\",\"autoplayOnHover\":\"pause\",\"show_thumbnails\":\"0\",\"thumbnailWidth\":\"290\",\"thumbnailHeight\":\"105\",\"thumbnailtxt_align\":\"left\",\"show_thumbnail_description\":\"1\",\"thumbnail_description_max_chars\":\"50\",\"selected_thumbnail_txt_color\":\"\",\"thumbnailsPosition\":\"right\",\"thumbnailPointer\":\"1\",\"thumbnailPointer_color\":\"\",\"thumbnailArrows\":\"1\",\"show_arrows\":\"1\",\"arrows_size\":\"50\",\"show_buttons\":\"1\",\"buttons_color\":\"rgba(255,78,78,0.24)\",\"display_caption\":\"0\",\"captiontxt_align\":\"center\",\"description_max_chars\":\"70\",\"load_videojs\":\"0\",\"reachVideoAction\":\"playVideo\",\"leaveVideoAction\":\"stopVideo\",\"playVideoAction\":\"none\",\"pauseVideoAction\":\"none\",\"endVideoAction\":\"replayVideo\",\"load_js\":\"customtag\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(101, 128, 'AP Smart LayerSlider (Homepage 3)', '', '', 1, 'slider', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_ap_smart_layerslider', 1, 0, '{\"display_form\":\"folder_image\",\"sort_order_field\":\"order\",\"count\":\"5\",\"path_folder\":{\"folder\":\"images\\/ap-smart-layerslider\\/homepage3\",\"images\":\"{\\\"slide-8-2340x850\\\":{\\\"title\\\":\\\"\\\",\\\"caption\\\":\\\"\\\",\\\"description\\\":\\\"<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topLeft\\\\\\\"\\\\ndata-width=\\\\\\\"60%\\\\\\\"\\\\ndata-show-offset=\\\\\\\"100\\\\\\\"\\\\ndata-horizontal=\\\\\\\"150\\\\\\\"\\\\ndata-vertical=\\\\\\\"150\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1000\\\\\\\"\\\\ndata-show-delay=\\\\\\\"500\\\\\\\">\\\\n<h2 style=\\\\\\\"font-size:850%;color:#7f7f7f;text-shadow:0 1px 40px rgba(255,255,255,.5), 0 20px 25px rgba(0,0,0,.1);\\\\\\\"><span style=\\\\\\\"font-weight:300;text-shadow:0 1px 35px #fff;\\\\\\\">Unlimited<\\/span> <span style=\\\\\\\"color:#F14833\\\\\\\">C<\\/span><span style=\\\\\\\"color:#FCA224\\\\\\\">o<\\/span><span style=\\\\\\\"color:#F0E95B\\\\\\\">l<\\/span><span style=\\\\\\\"color:#22A9E1\\\\\\\">o<\\/span><span style=\\\\\\\"color:#16B99A\\\\\\\">r<\\/span><span style=\\\\\\\"color:#CC8B60\\\\\\\">s<\\/span><\\/h2>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomLeft\\\\\\\"\\\\ndata-width=\\\\\\\"45%\\\\\\\"\\\\ndata-horizontal=\\\\\\\"160\\\\\\\"\\\\ndata-vertical=\\\\\\\"110\\\\\\\"\\\\ndata-show-transition=\\\\\\\"down\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"2700\\\\\\\">\\\\n<p style=\\\\\\\"font-size:30px;line-height:1.7;color:#595959;\\\\\\\">\\\\nFlex is distributed with six preset styles. Each can be customized in the \\u201cPresets\\u201d Settings to individualize the template text, background and mayor colors, and in the Layout Builder, you can use unlimited color combination for every part of your template!\\\\n<\\/p>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-width=\\\\\\\"100\\\\\\\"\\\\ndata-height=\\\\\\\"100\\\\\\\"\\\\ndata-position=\\\\\\\"centerLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"160\\\\\\\"\\\\ndata-show-offset=\\\\\\\"200\\\\\\\"\\\\ndata-vertical=\\\\\\\"-30\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1300\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1500\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"right\\\\\\\">\\\\n<img style=\\\\\\\"border-radius:6px;\\\\\\\" src=\\\\\\\"images\\/ap-smart-layerslider\\/homepage3\\/colors\\/f14833.png\\\\\\\" \\/>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-width=\\\\\\\"100\\\\\\\"\\\\ndata-height=\\\\\\\"100\\\\\\\"\\\\ndata-position=\\\\\\\"centerLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"270\\\\\\\"\\\\ndata-show-offset=\\\\\\\"100\\\\\\\"\\\\ndata-vertical=\\\\\\\"-30\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1150\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1400\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"right\\\\\\\">\\\\n<img style=\\\\\\\"border-radius:6px;\\\\\\\" src=\\\\\\\"images\\/ap-smart-layerslider\\/homepage3\\/colors\\/fca224.png\\\\\\\" \\/>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-width=\\\\\\\"100\\\\\\\"\\\\ndata-height=\\\\\\\"100\\\\\\\"\\\\ndata-position=\\\\\\\"centerLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"380\\\\\\\"\\\\ndata-vertical=\\\\\\\"-30\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1000\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1300\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"right\\\\\\\">\\\\n<img style=\\\\\\\"border-radius:6px;\\\\\\\" src=\\\\\\\"images\\/ap-smart-layerslider\\/homepage3\\/colors\\/f0e95b.png\\\\\\\" \\/>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-width=\\\\\\\"100\\\\\\\"\\\\ndata-height=\\\\\\\"100\\\\\\\"\\\\ndata-position=\\\\\\\"centerLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"490\\\\\\\"\\\\ndata-vertical=\\\\\\\"-30\\\\\\\"\\\\ndata-show-transition=\\\\\\\"right\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1000\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1300\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"left\\\\\\\">\\\\n<img style=\\\\\\\"border-radius:6px;\\\\\\\" src=\\\\\\\"images\\/ap-smart-layerslider\\/homepage3\\/colors\\/22a9e1.png\\\\\\\" \\/>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-width=\\\\\\\"100\\\\\\\"\\\\ndata-height=\\\\\\\"100\\\\\\\"\\\\ndata-position=\\\\\\\"centerLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"600\\\\\\\"\\\\ndata-vertical=\\\\\\\"-30\\\\\\\"\\\\ndata-show-offset=\\\\\\\"100\\\\\\\"\\\\ndata-show-transition=\\\\\\\"right\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1150\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1400\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"left\\\\\\\">\\\\n<img style=\\\\\\\"border-radius:6px;\\\\\\\" src=\\\\\\\"images\\/ap-smart-layerslider\\/homepage3\\/colors\\/16b99a.png\\\\\\\" \\/>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-width=\\\\\\\"100\\\\\\\"\\\\ndata-height=\\\\\\\"100\\\\\\\"\\\\ndata-position=\\\\\\\"centerLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"710\\\\\\\"\\\\ndata-show-offset=\\\\\\\"200\\\\\\\"\\\\ndata-vertical=\\\\\\\"-30\\\\\\\"\\\\ndata-show-transition=\\\\\\\"right\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1300\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1500\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"left\\\\\\\">\\\\n<img style=\\\\\\\"border-radius:6px;\\\\\\\" src=\\\\\\\"images\\/ap-smart-layerslider\\/homepage3\\/colors\\/cc8b60.png\\\\\\\" \\/>\\\\n<\\/div>\\\\n\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"centerLeft\\\\\\\"\\\\ndata-horizontal=\\\\\\\"830\\\\\\\"\\\\ndata-show-offset=\\\\\\\"100\\\\\\\"\\\\ndata-vertical=\\\\\\\"57\\\\\\\"\\\\ndata-show-transition=\\\\\\\"right\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"2000\\\\\\\">\\\\n<ol class=\\\\\\\"list-inline\\\\\\\">\\\\n<li style=\\\\\\\"width:30px;height:30px;background:#aaa;margin-right:10px;border-radius:3px;\\\\\\\"><\\/li>\\\\n<li style=\\\\\\\"width:30px;height:30px;background:#bbb;margin-right:10px;border-radius:3px;\\\\\\\"><\\/li>\\\\n<li style=\\\\\\\"width:30px;height:30px;background:#ccc;border-radius:3px;\\\\\\\"><\\/li>\\\\n<\\/ol>\\\\n<\\/div>\\\",\\\"name\\\":\\\"slide-8-2340x850\\\",\\\"position\\\":0,\\\"imagesrc\\\":\\\"\\/images\\/ap-smart-layerslider\\/homepage3\\/slide-8-2340x850.jpg\\\",\\\"image\\\":\\\"slide-8-2340x850.jpg\\\"},\\\"white-234x85-1\\\":{\\\"title\\\":\\\"\\\",\\\"caption\\\":\\\"\\\",\\\"description\\\":\\\"<div class=\\\\\\\"sp-layer\\\\\\\" data-horizontal=\\\\\\\"0\\\\\\\" data-vertical=\\\\\\\"0\\\\\\\" data-show-duration=\\\\\\\"1400\\\\\\\" data-show-delay=\\\\\\\"700\\\\\\\">\\\\n<video class=\\\\\\\"sp-video\\\\\\\" poster=\\\\\\\"images\\/ap-smart-layerslider\\/homepage3\\/layers\\/transparent-234x85.png\\\\\\\" width=\\\\\\\"2340\\\\\\\" height=\\\\\\\"878\\\\\\\" preload=\\\\\\\"none\\\\\\\" autoplay muted>\\\\n    <source src=\\\\\\\"images\\/videos\\/sunlight-flare.mp4\\\\\\\" type=\\\\\\\"video\\/mp4\\\\\\\"\\/>\\\\n<\\/video>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topLeft\\\\\\\"\\\\ndata-width=\\\\\\\"38%\\\\\\\"\\\\ndata-horizontal=\\\\\\\"250\\\\\\\"\\\\ndata-show-offset=\\\\\\\"60\\\\\\\"\\\\ndata-vertical=\\\\\\\"230\\\\\\\"\\\\ndata-show-transition=\\\\\\\"left\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1700\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1000\\\\\\\"\\\\ndata-hide-offset=\\\\\\\"40\\\\\\\"\\\\ndata-hide-duration=\\\\\\\"800\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"right\\\\\\\">\\\\n<h4 style=\\\\\\\"font-size:500%;margin-bottom:30px;color:rgba(0,0,0,0.6);\\\\\\\">Self Hosted Videos<\\/h4>\\\\n<h3 style=\\\\\\\"font-size:250%;margin-bottom:50px;line-height:1.5;\\\\\\\">AP Smart LayerSlider supports self hosted, youtube & vimeo videos.<\\/h3>\\\\n<a style=\\\\\\\"font-size:200%;padding:12px 40px;line-height:1.9;letter-spacing:1px;\\\\\\\" href=\\\\\\\"#\\\\\\\" class=\\\\\\\"btn btn-dark\\\\\\\"><i style=\\\\\\\"margin-left:-3px;margin-right:20px;font-size:150%;font-weight:600;vertical-align:middle;margin-top:-7px;\\\\\\\" class=\\\\\\\"pe-7s-door-lock\\\\\\\"><\\/i>LEARN MORE<\\/a>\\\\n<\\/div>\\\",\\\"name\\\":\\\"white-234x85-1\\\",\\\"position\\\":1,\\\"imagesrc\\\":\\\"\\/images\\/ap-smart-layerslider\\/homepage3\\/white-234x85-1.png\\\",\\\"image\\\":\\\"white-234x85-1.png\\\"},\\\"slide-14-2340x850\\\":{\\\"name\\\":\\\"slide-14-2340x850\\\",\\\"position\\\":2,\\\"imagesrc\\\":\\\"\\/images\\/ap-smart-layerslider\\/homepage3\\/slide-14-2340x850.jpg\\\",\\\"caption\\\":\\\"\\\",\\\"title\\\":\\\"\\\",\\\"description\\\":\\\"<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topRight\\\\\\\"\\\\ndata-show-offset=\\\\\\\"50\\\\\\\"\\\\ndata-horizontal=\\\\\\\"70\\\\\\\"\\\\ndata-vertical=\\\\\\\"40\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"2400\\\\\\\"\\\\ndata-show-delay=\\\\\\\"600\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"up\\\\\\\"\\\\ndata-hide-offset=\\\\\\\"50\\\\\\\"\\\\ndata-hide-duration=\\\\\\\"1600\\\\\\\">\\\\n<i style=\\\\\\\"font-size:4400%;color:rgba(216,215,203,.25);text-shadow:1px 0 50px  rgba(255,255,255,.07);\\\\\\\" class=\\\\\\\"fa fa-pencil-square-o\\\\\\\"><\\/i>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topRight\\\\\\\"\\\\ndata-width=\\\\\\\"50%\\\\\\\"\\\\ndata-show-offset=\\\\\\\"100\\\\\\\"\\\\ndata-horizontal=\\\\\\\"280\\\\\\\"\\\\ndata-vertical=\\\\\\\"118\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1200\\\\\\\"\\\\ndata-show-delay=\\\\\\\"700\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"down\\\\\\\">\\\\n<h2 style=\\\\\\\"font-size:900%;color:#fff;text-align:right;text-shadow:1px 1px 30px rgba(255,255,255,.3);\\\\\\\">Blog <span style=\\\\\\\"color:#8D6621;\\\\\\\">smarter.<\\/span><\\/h2>\\\\n<\\/div>\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"topRight\\\\\\\"\\\\ndata-width=\\\\\\\"50%\\\\\\\"\\\\ndata-show-offset=\\\\\\\"140\\\\\\\"\\\\ndata-horizontal=\\\\\\\"180\\\\\\\"\\\\ndata-vertical=\\\\\\\"240\\\\\\\"\\\\ndata-show-transition=\\\\\\\"up\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1600\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1000\\\\\\\"\\\\ndata-hide-transition=\\\\\\\"up\\\\\\\">\\\\n<h2 style=\\\\\\\"font-size:900%;text-align:right;color:#fff;text-shadow:1px 0 40px rgba(255,255,255,.4);\\\\\\\">Go <span style=\\\\\\\"color:#47160D;\\\\\\\">farther.<\\/span><\\/h2>\\\\n<\\/div>\\\\n\\\\n<div class=\\\\\\\"sp-layer\\\\\\\"\\\\ndata-position=\\\\\\\"bottomRight\\\\\\\"\\\\ndata-width=\\\\\\\"38%\\\\\\\"\\\\ndata-show-offset=\\\\\\\"50\\\\\\\"\\\\ndata-horizontal=\\\\\\\"200\\\\\\\"\\\\ndata-vertical=\\\\\\\"130\\\\\\\"\\\\ndata-show-transition=\\\\\\\"down\\\\\\\"\\\\ndata-show-duration=\\\\\\\"1400\\\\\\\"\\\\ndata-show-delay=\\\\\\\"1200\\\\\\\">\\\\n<p style=\\\\\\\"font-size:34px;line-height:1.5;color:#e5e5e5;text-shadow:1px 2px 5px rgba(0,0,0,.2);\\\\\\\">\\\\nFlex is coming with <strong>8 post formats<\\/strong>: standard, video, gallery, audio, link, quote, status and custom (new). Each can be customized in the Article Manager to individualize your feel for blogging.\\\\n<\\/p>\\\\n<\\/div>\\\",\\\"image\\\":\\\"slide-14-2340x850.jpg\\\"}}\"},\"theme\":\"1\",\"image_width\":\"2340\",\"image_height\":\"850\",\"mainimage_mode\":\"none\",\"use_ratio\":\"1\",\"forceSize\":\"none\",\"visibleSize\":\"auto\",\"slideDistance\":\"10\",\"responsive\":\"1\",\"imageScaleMode\":\"contain\",\"autoHeight\":\"0\",\"autoScaleLayers\":\"1\",\"waitForLayers\":\"0\",\"orientation\":\"horizontal\",\"loop\":\"1\",\"shuffle\":\"0\",\"fullScreen\":\"0\",\"fullscreen_button_color\":\"#000000\",\"fadeEffect\":\"1\",\"fadeOutPreviousSlide\":\"0\",\"fadeDuration\":\"700\",\"autoplay\":\"0\",\"autoplayDelay\":\"5000\",\"autoplayOnHover\":\"pause\",\"show_thumbnails\":\"0\",\"thumbnailWidth\":\"230\",\"thumbnailHeight\":\"105\",\"thumbnailtxt_align\":\"left\",\"show_thumbnail_description\":\"1\",\"thumbnail_description_max_chars\":\"50\",\"selected_thumbnail_txt_color\":\"\",\"thumbnailsPosition\":\"bottom\",\"thumbnailPointer\":\"1\",\"thumbnailPointer_color\":\"\",\"thumbnailArrows\":\"1\",\"show_arrows\":\"1\",\"arrows_size\":\"50\",\"show_buttons\":\"0\",\"buttons_color\":\"rgba(110,110,110,0.35)\",\"display_caption\":\"0\",\"captiontxt_align\":\"center\",\"description_max_chars\":\"70\",\"load_videojs\":\"0\",\"reachVideoAction\":\"playVideo\",\"leaveVideoAction\":\"stopVideo\",\"playVideoAction\":\"stopAutoplay\",\"pauseVideoAction\":\"none\",\"endVideoAction\":\"replayVideo\",\"load_js\":\"customtag\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(108, 135, 'Animated iPhone', '', '<p><a href=\"#\"><img src=\"images/blog/iPad-Smart-Keyboard.png\" alt=\"iPad Smart Keyboard\" /></a></p>', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*');
INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(109, 136, 'Vimeo (Custom Module)', '', '<figure style=\"display: block;position: relative;padding-bottom: 56.25%;padding-top: 8px;height: 0;\">\n<iframe style=\"position: absolute;top: 0;left: 0;width: 100%;height: 100%;\" src=\"https://player.vimeo.com/video/99722811?color=F14833&title=0&byline=0&portrait=0\" frameborder=\"0\" width=\"400\" height=\"225\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>\n</figure>\n	\n', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(110, 137, 'SP Page Builder Youtube (Custom Module)', '', '<figure style=\"display:block;position:relative;padding-bottom:56.25%;padding-top:8px;height:0;\">\r\n<iframe style=\"position:absolute;top:0;left:0;width:100%;height:100%;\" src=\"https://www.youtube.com/embed/dqRzj05CySA?rel=0&autohide=1&showinfo=0\" frameborder=\"0\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>\r\n</figure>\r\n	\r\n', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(111, 138, 'Vimeo NYC (Custom Module)', '', '<figure style=\"display: block;position: relative;padding-bottom: 56.25%;padding-top: 8px;height: 0;\">\r\n<iframe style=\"position: absolute;top: 0;left: 0;width: 100%;height: 100%;\" src=\"https://player.vimeo.com/video/118513281?color=F14833&title=0&byline=0&portrait=0\" frameborder=\"0\" width=\"400\" height=\"225\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>\r\n</figure>\r\n	\r\n', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(112, 139, 'Portfolio (Full Width)', '', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_spsimpleportfolio', 1, 0, '{\"category_id\":\"\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"show_filter\":\"0\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\\\"fa fa-diamond\\\"><\\/i>\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_view_button\":\"0\",\"video_width\":\"900\",\"video_height\":\"502\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(113, 144, 'VM - Administrator Module', '', '', 5, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_vmmenu', 3, 1, '', 1, '*'),
(114, 145, 'Currencies Selector', 'VM - Currencies Selector. Convert the price depending on the currency selected in your VirtueMart shop', '', 12, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_currencies', 1, 1, '{\"text_before\":\"\",\"product_currency\":\"\",\"cache\":\"0\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(115, 146, 'Related Products', 'VM - Featured products. Displays: Featured, Best Sales, Random, Latest or recently viewed VirtueMart products.', '', 13, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"list\",\"product_group\":\"topten\",\"max_items\":\"3\",\"products_per_row\":\"1\",\"display_style\":\"list\",\"show_price\":\"1\",\"show_addtocart\":\"0\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"1\",\"virtuemart_category_id\":\"0\",\"vmcache\":\"0\",\"vmcachetime\":\"300\",\"cache\":\"0\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(116, 147, 'Search Products', 'VM - Search in Shop. Module is to search Product on your VirtueMart Shop', '', 9, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_search', 1, 1, '{\"width\":\"200\",\"text\":\"\",\"filter_category\":\"1\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"set_itemid\":\"\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(117, 148, 'VM - Manufacturer', 'Displays manufacturers from VirtueMart', '', 11, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_virtuemart_manufacturer', 1, 1, '{\"show\":\"all\",\"display_style\":\"list\",\"manufacturers_per_row\":\"\",\"headerText\":\"\",\"footerText\":\"\",\"layout\":\"_:default\",\"cache\":\"1\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(118, 149, 'VM - Shopping cart', 'Displays a shopping cart for your VirtueMart customers. ', '', 1, 'shoppingcart', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_cart', 1, 0, '{\"moduleid_sfx\":\"\",\"moduleclass_sfx\":\"\",\"show_price\":\"1\",\"show_product_list\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(119, 150, 'Shop Categories', 'VM - Category. Displays a 2 level categories list for VirtueMart.', '', 10, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_category', 1, 1, '{\"Parent_Category_id\":\"0\",\"level\":\"2\",\"layout\":\"default\",\"cache\":\"1\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(120, 155, 'Portfolio (white transparent Homepage)', '', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_spsimpleportfolio', 1, 0, '{\"category_id\":\"22\",\"layout_type\":\"default\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"column_bg\":\"\",\"show_filter\":\"1\",\"filter_style\":\"simple\",\"show_all_txt\":\"<i class=\'fa fa-clone\'><\\/i>\",\"filter_divider\":\"\\/\",\"filter_margin\":\"\",\"show_zoom_button\":\"1\",\"show_view_button\":\"0\",\"show_tags\":\"1\",\"video_width\":\"700\",\"video_height\":\"400\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(121, 156, 'Our Products', 'VM - Random products viewed on VirtueMart in menu.', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"list\",\"product_group\":\"random\",\"max_items\":\"2\",\"products_per_row\":\"1\",\"display_style\":\"list\",\"show_price\":\"1\",\"show_addtocart\":\"0\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"vmcache\":\"0\",\"vmcachetime\":\"300\",\"cache\":\"0\",\"moduleclass_sfx\":\"vm-menu\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"vm-title\",\"style\":\"0\"}', 0, '*'),
(124, 160, 'Related Products (random products)', 'VM - Featured products. Displays: Random products viewed VirtueMart products.', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 0, '{\"layout\":\"list\",\"product_group\":\"random\",\"max_items\":\"3\",\"products_per_row\":\"1\",\"display_style\":\"list\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"1\",\"virtuemart_category_id\":\"0\",\"vmcache\":\"0\",\"vmcachetime\":\"300\",\"cache\":\"1\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(125, 161, 'Login (Header)', '', '', 1, 'top2', 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', 1, 'mod_login', 1, 0, '{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":1,\"name\":0,\"profilelink\":0,\"usesecure\":0,\"usetext\":0,\"layout\":\"flex:modal\",\"moduleclass_sfx\":\"\",\"cache\":0,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(126, 162, 'My Account', '', '', 1, 'myaccount', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"usermenu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(127, 166, 'Slick Carousel (intro module for Custom Post)', 'Slick Carousel - intro SPPB module for “Custom Post format”', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder', 1, 0, '{\"content\":\"[{\\\"layout\\\":12,\\\"settings\\\":{\\\"title\\\":\\\"\\\",\\\"title_fontsize\\\":\\\"\\\",\\\"title_fontweight\\\":\\\"\\\",\\\"title_text_color\\\":\\\"\\\",\\\"title_margin_top\\\":\\\"\\\",\\\"title_margin_bottom\\\":\\\"\\\",\\\"subtitle\\\":\\\"\\\",\\\"subtitle_fontsize\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_video\\\":0,\\\"background_video_mp4\\\":\\\"\\\",\\\"background_video_ogv\\\":\\\"\\\",\\\"id\\\":\\\"\\\",\\\"class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"0px\\\",\\\"fullscreen\\\":0},\\\"id\\\":1494752383401,\\\"visibility\\\":1,\\\"columns\\\":[{\\\"class_name\\\":\\\"col-sm-12\\\",\\\"settings\\\":{\\\"background\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"animationduration\\\":\\\"\\\",\\\"animationdelay\\\":\\\"\\\",\\\"class\\\":\\\"\\\"},\\\"id\\\":1493901378,\\\"addons\\\":[{\\\"type\\\":\\\"repeatable\\\",\\\"name\\\":\\\"slick_carousel\\\",\\\"title\\\":\\\"Slick Carousel\\\",\\\"id\\\":1493901379,\\\"settings\\\":{\\\"admin_label\\\":\\\"Slick Carousel for Custom Post (intro)\\\",\\\"infiniteloop\\\":\\\"1\\\",\\\"lazyloading\\\":\\\"1\\\",\\\"slidestoshow\\\":\\\"1\\\",\\\"slidestoscroll\\\":\\\"1\\\",\\\"spacing\\\":\\\"0\\\",\\\"fade_effect\\\":\\\"0\\\",\\\"autoplay\\\":\\\"1\\\",\\\"autoplay_interval\\\":\\\"5000\\\",\\\"speed\\\":\\\"700\\\",\\\"arrows\\\":\\\"1\\\",\\\"arrows_size\\\":\\\"50\\\",\\\"arrows_color\\\":\\\"#5fa810\\\",\\\"arrows_background_color\\\":\\\"\\\",\\\"arrows_class\\\":\\\"transparent\\\",\\\"counter\\\":\\\"0\\\",\\\"counter_color\\\":\\\"\\\",\\\"dots\\\":\\\"0\\\",\\\"autoheight\\\":\\\"0\\\",\\\"rtl_support\\\":\\\"0\\\",\\\"breakpoint1\\\":\\\"992\\\",\\\"slidestoshow_break1\\\":\\\"1\\\",\\\"breakpoint2\\\":\\\"768\\\",\\\"slidestoshow_break2\\\":\\\"1\\\",\\\"breakpoint3\\\":\\\"480\\\",\\\"slidestoshow_break3\\\":\\\"1\\\",\\\"title\\\":\\\"\\\",\\\"heading_selector\\\":\\\"h3\\\",\\\"title_fontsize\\\":\\\"\\\",\\\"title_fontweight\\\":\\\"\\\",\\\"title_text_color\\\":\\\"\\\",\\\"title_margin_top\\\":\\\"\\\",\\\"title_margin_bottom\\\":\\\"\\\",\\\"class\\\":\\\"flex\\\",\\\"sp_slick_carousel_item\\\":[{\\\"title\\\":\\\"Custom Post 1\\\",\\\"thumb\\\":\\\"images\\/posts\\/custom-post\\/custom-post-01.jpg\\\",\\\"thumb_url\\\":\\\"\\\",\\\"description\\\":\\\"\\\\t\\\"},{\\\"title\\\":\\\"Custom Post 2\\\",\\\"thumb\\\":\\\"images\\/posts\\/custom-post\\/custom-post-02.jpg\\\",\\\"thumb_url\\\":\\\"\\\",\\\"description\\\":\\\"\\\\t\\\"},{\\\"title\\\":\\\"Custom Post 3\\\",\\\"thumb\\\":\\\"images\\/posts\\/custom-post\\/custom-post-03.jpg\\\",\\\"thumb_url\\\":\\\"\\\",\\\"description\\\":\\\"\\\\t\\\"}],\\\"global_text_color\\\":\\\"\\\",\\\"global_link_color\\\":\\\"\\\",\\\"global_link_hover_color\\\":\\\"\\\",\\\"global_use_background\\\":\\\"0\\\",\\\"global_background_color\\\":\\\"\\\",\\\"global_background_image\\\":\\\"\\\",\\\"global_background_repeat\\\":\\\"no-repeat\\\",\\\"global_background_size\\\":\\\"cover\\\",\\\"global_background_attachment\\\":\\\"inherit\\\",\\\"global_user_border\\\":\\\"0\\\",\\\"global_border_width\\\":\\\"\\\",\\\"global_border_color\\\":\\\"\\\",\\\"global_boder_style\\\":\\\"none\\\",\\\"global_border_radius\\\":\\\"\\\",\\\"global_margin\\\":\\\"\\\",\\\"global_padding\\\":\\\"\\\",\\\"global_use_animation\\\":\\\"0\\\",\\\"global_animation\\\":\\\"\\\",\\\"global_animationduration\\\":\\\"300\\\",\\\"global_animationdelay\\\":\\\"0\\\",\\\"hidden_md\\\":\\\"0\\\",\\\"hidden_sm\\\":\\\"0\\\",\\\"hidden_xs\\\":\\\"0\\\",\\\"acl\\\":null},\\\"visibility\\\":1}],\\\"visibility\\\":1}],\\\"collapse\\\":\\\"\\\",\\\"title\\\":\\\"Row\\\"}]\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(128, 167, 'Recent Posts', '', '', 3, 'right', 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 1, '{\"catid\":[\"\"],\"count\":\"4\",\"show_featured\":\"\",\"ordering\":\"random\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(129, 168, 'Top Search', '', '', 1, 'topsearch', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 0, '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"1\",\"button_pos\":\"bottom\",\"imagebutton\":\"1\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"flex:topsearch\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(132, 173, 'Accordion Menu', 'New Accordion menu module, now for all positions', '', 2, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"mainmenu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"flex:accordion\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(140, 219, 'Masonry Grid with Ajax Loading', 'Masonry with Ajax Loading Category - 3 Columns. Ajax Intro Articles Module used for Category', '', 1, '', 0, '0000-00-00 00:00:00', '2019-03-17 13:31:23', '0000-00-00 00:00:00', 1, 'mod_ajax_intro_articles', 1, 0, '{\"catid\":[\"27\",\"28\",\"29\",\"30\",\"31\"],\"count\":\"3\",\"ajax_limit\":\"3\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"columns\":\"3\",\"intro_alignment\":\"intro-center\",\"intro_width\":\"50\",\"cols_spacing\":\"15\",\"inner_spacing\":\"0\",\"cols_color\":\"\",\"equal_heights\":\"0\",\"rtl_enable\":\"0\",\"intro_format\":\"1\",\"image_intro_link\":\"0\",\"loadmore_effect\":\"appear-in\",\"loadmore_button\":\"default\",\"loadmore_btn_text\":\"Load More Posts\",\"loadmore_color\":\"\",\"article_style\":\"3\",\"overlay_effects\":[\"blur\"],\"overlay_color\":\"rgba(179,39,22,0.4)\",\"show_title\":\"1\",\"title_size\":\"22\",\"show_introtext\":\"1\",\"limit_words\":\"25\",\"strip_tags\":\"1\",\"introtext_size\":\"15\",\"show_author\":\"0\",\"show_category\":\"1\",\"show_date\":\"0\",\"show_date_format\":\"DATE_FORMAT_LC3\",\"show_hits\":\"0\",\"show_rating\":\"1\",\"show_readmore\":\"0\",\"readmore_button\":\"default\",\"readmore_btn_text\":\"\",\"align_readmore_button\":\"left\",\"show_social_share\":\"0\",\"show_tags\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(141, 267, 'Equal Heights Grid with Ajax Loading', 'Equal Heights with Ajax Loading Category - 4 Columns. Ajax Intro Articles Module used for Category', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_ajax_intro_articles', 1, 0, '{\"catid\":[\"27\",\"28\",\"29\",\"30\",\"31\"],\"count\":\"4\",\"ajax_limit\":\"4\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"columns\":\"4\",\"intro_alignment\":\"intro-center\",\"intro_width\":\"50\",\"cols_spacing\":\"15\",\"inner_spacing\":\"15\",\"cols_color\":\"#f7f5f2\",\"equal_heights\":\"1\",\"rtl_enable\":\"0\",\"intro_format\":\"2\",\"image_intro_link\":\"1\",\"loadmore_effect\":\"fade-in-down\",\"loadmore_button\":\"light\",\"loadmore_btn_text\":\"Load More Posts\",\"loadmore_color\":\"\",\"article_style\":\"1\",\"overlay_color\":\"\",\"show_title\":\"1\",\"title_size\":\"20\",\"show_introtext\":\"1\",\"limit_words\":\"20\",\"strip_tags\":\"1\",\"introtext_size\":\"14\",\"show_author\":\"0\",\"show_category\":\"1\",\"show_date\":\"1\",\"show_date_format\":\"DATE_FORMAT_LC2\",\"show_hits\":\"1\",\"show_rating\":\"1\",\"show_readmore\":\"0\",\"readmore_button\":\"default\",\"readmore_btn_text\":\"\",\"align_readmore_button\":\"left\",\"show_social_share\":\"1\",\"show_tags\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(142, 268, '2 Columns Masonry No Space', '2 Columns (No Space). Ajax Intro Articles Module used for Category', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_ajax_intro_articles', 1, 0, '{\"catid\":[\"27\",\"28\",\"29\"],\"count\":\"4\",\"ajax_limit\":\"4\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"columns\":\"2\",\"intro_alignment\":\"intro-center\",\"intro_width\":\"50\",\"cols_spacing\":\"0\",\"inner_spacing\":\"0\",\"cols_color\":\"\",\"equal_heights\":\"0\",\"rtl_enable\":\"0\",\"intro_format\":\"2\",\"image_intro_link\":\"0\",\"loadmore_effect\":\"intro-zoom-in\",\"loadmore_button\":\"dark\",\"loadmore_btn_text\":\"Load More Posts\",\"loadmore_color\":\"\",\"article_style\":\"3\",\"overlay_effects\":[\"zoom\",\"blur\"],\"overlay_color\":\"rgba(0,0,0,0.1)\",\"show_title\":\"0\",\"title_size\":\"22\",\"show_introtext\":\"0\",\"limit_words\":\"25\",\"strip_tags\":\"1\",\"introtext_size\":\"15\",\"show_author\":\"0\",\"show_category\":\"0\",\"show_date\":\"0\",\"show_date_format\":\"DATE_FORMAT_LC3\",\"show_hits\":\"0\",\"show_rating\":\"0\",\"show_readmore\":\"0\",\"readmore_button\":\"default\",\"readmore_btn_text\":\"\",\"align_readmore_button\":\"left\",\"show_social_share\":\"0\",\"show_tags\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(143, 269, 'One Column with Ajax Loading', 'One Column with Ajax Loading. Ajax Intro Articles Module used for Category', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_ajax_intro_articles', 1, 1, '{\"catid\":[\"2\",\"30\",\"31\",\"18\"],\"count\":\"3\",\"ajax_limit\":\"3\",\"show_featured\":\"\",\"ordering\":\"mc_dsc\",\"user_id\":\"0\",\"columns\":\"1\",\"intro_alignment\":\"intro-left\",\"intro_width\":\"30\",\"cols_spacing\":\"8\",\"inner_spacing\":\"12\",\"cols_color\":\"#f5f5f5\",\"equal_heights\":\"0\",\"rtl_enable\":\"0\",\"intro_format\":\"2\",\"image_intro_link\":\"1\",\"loadmore_effect\":\"fade-in-down\",\"loadmore_button\":\"link\",\"loadmore_btn_text\":\"~  MORE POSTS  ~\",\"loadmore_color\":\"#424242\",\"article_style\":\"1\",\"overlay_color\":\"\",\"show_title\":\"1\",\"title_size\":\"16\",\"show_introtext\":\"0\",\"limit_words\":\"25\",\"strip_tags\":\"1\",\"introtext_size\":\"15\",\"show_author\":\"0\",\"show_category\":\"0\",\"show_date\":\"0\",\"show_date_format\":\"DATE_FORMAT_LC3\",\"show_hits\":\"0\",\"show_rating\":\"0\",\"show_readmore\":\"0\",\"readmore_button\":\"default\",\"readmore_btn_text\":\"\",\"align_readmore_button\":\"left\",\"show_social_share\":\"0\",\"show_tags\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(144, 272, 'Latest Posts From Our Blog (Ajax Intro Articles)', 'Ajax intro Articles with Equal Heights (4 columns)', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_ajax_intro_articles', 1, 0, '{\"catid\":[\"27\",\"28\",\"29\",\"30\",\"31\"],\"count\":\"4\",\"ajax_limit\":\"4\",\"show_featured\":\"\",\"ordering\":\"m_dsc\",\"user_id\":\"0\",\"columns\":\"4\",\"intro_alignment\":\"intro-center\",\"intro_width\":\"50\",\"cols_spacing\":\"15\",\"inner_spacing\":\"15\",\"cols_color\":\"#ffffff\",\"equal_heights\":\"0\",\"rtl_enable\":\"0\",\"intro_format\":\"2\",\"image_intro_link\":\"1\",\"loadmore_effect\":\"appear-in\",\"loadmore_button\":\"dark\",\"loadmore_btn_text\":\"LOAD MORE POSTS\",\"loadmore_color\":\"\",\"article_style\":\"3\",\"overlay_effects\":[\"blur\"],\"overlay_color\":\"rgba(0,0,0,0.3)\",\"show_title\":\"1\",\"title_size\":\"20\",\"show_introtext\":\"1\",\"limit_words\":\"22\",\"strip_tags\":\"1\",\"introtext_size\":\"14\",\"show_author\":\"0\",\"show_category\":\"1\",\"show_date\":\"0\",\"show_date_format\":\"DATE_FORMAT_LC3\",\"show_hits\":\"1\",\"show_rating\":\"1\",\"show_readmore\":\"0\",\"readmore_button\":\"default\",\"readmore_btn_text\":\"\",\"align_readmore_button\":\"left\",\"show_social_share\":\"0\",\"show_tags\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(150, 289, 'Newsletter Subscribe', 'AcyMailing Module (Acymailing version 6.x): Subscribe / Unsubscribe', '', 5, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_acym', 1, 1, '{\"mode\":\"tableless\",\"listposition\":\"after\",\"textmode\":\"1\",\"subtext\":\"\",\"subtextlogged\":\"\",\"termscontent\":\"0\",\"privacypolicy\":\"0\",\"articlepopup\":\"1\",\"unsub\":\"0\",\"unsubtext\":\"\",\"unsubredirect\":\"\",\"redirect\":\"\",\"introtext\":\"\",\"posttext\":\"\",\"userinfo\":\"1\",\"formclass\":\"\",\"alignment\":\"center\",\"source\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*');

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE IF NOT EXISTS `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(1, 0),
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(16, 0),
(17, 0),
(79, 0),
(86, 0),
(87, 0),
(88, 0),
(89, 0),
(90, 0),
(92, 0),
(94, 298),
(95, 298),
(96, 109),
(96, 112),
(96, 113),
(96, 114),
(96, 115),
(96, 116),
(96, 117),
(96, 118),
(96, 119),
(96, 298),
(97, 109),
(97, 298),
(98, 109),
(98, 112),
(98, 113),
(98, 114),
(98, 115),
(98, 116),
(98, 117),
(98, 118),
(98, 119),
(98, 298),
(100, 165),
(101, 166),
(108, 0),
(109, 0),
(110, 0),
(111, 0),
(112, 0),
(113, 0),
(114, 215),
(114, 219),
(114, 220),
(115, 215),
(115, 219),
(115, 220),
(116, 215),
(116, 219),
(116, 220),
(118, 0),
(119, 215),
(119, 219),
(119, 220),
(120, 0),
(121, 0),
(124, 0),
(125, 0),
(126, 0),
(128, 109),
(128, 112),
(128, 113),
(128, 114),
(128, 115),
(128, 116),
(128, 117),
(128, 118),
(128, 119),
(128, 298),
(129, 0),
(132, 109),
(132, 112),
(132, 113),
(132, 114),
(132, 115),
(132, 116),
(132, 117),
(132, 118),
(132, 119),
(132, 298),
(140, 0),
(141, 0),
(142, 0),
(143, 0),
(144, 0),
(150, 109),
(150, 112),
(150, 113),
(150, 114),
(150, 115),
(150, 116),
(150, 117),
(150, 118),
(150, 119),
(150, 298);

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE IF NOT EXISTS `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `cache_time` int(10) UNSIGNED NOT NULL DEFAULT '3600',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `images` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE IF NOT EXISTS `#__overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__postinstall_messages`;
CREATE TABLE IF NOT EXISTS `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`postinstall_message_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO `#__postinstall_messages` (`postinstall_message_id`, `extension_id`, `title_key`, `description_key`, `action_key`, `language_extension`, `language_client_id`, `type`, `action_file`, `action`, `condition_file`, `condition_method`, `version_introduced`, `enabled`) VALUES
(1, 700, 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', 1, 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', 1),
(2, 700, 'COM_CPANEL_WELCOME_BEGINNERS_TITLE', 'COM_CPANEL_WELCOME_BEGINNERS_MESSAGE', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.2.0', 1),
(3, 700, 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', 1),
(4, 700, 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION', 'plg_system_updatenotification', 1, 'action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_condition', '3.6.3', 1),
(5, 700, 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/joomla40checks.php', 'admin_postinstall_joomla40checks_condition', '3.7.0', 1),
(6, 700, 'TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE', 'TPL_HATHOR_MESSAGE_POSTINSTALL_BODY', 'TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION', 'tpl_hathor', 1, 'action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_condition', '3.7.0', 1),
(7, 700, 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_TITLE', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_BODY', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_ACTION', 'plg_captcha_recaptcha', 1, 'action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_condition', '3.8.6', 1),
(8, 700, 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_TITLE', 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/updatedefaultsettings.php', 'admin_postinstall_updatedefaultsettings_condition', '3.8.8', 1),
(9, 700, 'COM_ACTIONLOGS_POSTINSTALL_TITLE', 'COM_ACTIONLOGS_POSTINSTALL_BODY', '', 'com_actionlogs', 1, 'message', '', '', '', '', '3.9.0', 1),
(10, 700, 'COM_PRIVACY_POSTINSTALL_TITLE', 'COM_PRIVACY_POSTINSTALL_BODY', '', 'com_privacy', 1, 'message', '', '', '', '', '3.9.0', 1),
(11, 700, 'COM_CPANEL_MSG_ADDNOSNIFF_TITLE', 'COM_CPANEL_MSG_ADDNOSNIFF_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/addnosniff.php', 'admin_postinstall_addnosniff_condition', '3.9.3', 1);

DROP TABLE IF EXISTS `#__privacy_consents`;
CREATE TABLE IF NOT EXISTS `#__privacy_consents` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `state` int(10) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT '0',
  `token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__privacy_requests`;
CREATE TABLE IF NOT EXISTS `#__privacy_requests` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `request_type` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__redirect_links`;
CREATE TABLE IF NOT EXISTS `#__redirect_links` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `old_url` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_url` varchar(2048) DEFAULT NULL,
  `referer` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` varchar(255) NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `header` smallint(3) NOT NULL DEFAULT '301',
  PRIMARY KEY (`id`),
  KEY `idx_link_modifed` (`modified_date`),
  KEY `idx_old_url` (`old_url`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE IF NOT EXISTS `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES
(700, '3.9.3-2019-02-07'),
(10015, '3.3-2018-06-28'),
(10020, '1.5-2017-14-09');

DROP TABLE IF EXISTS `#__session`;
CREATE TABLE IF NOT EXISTS `#__session` (
  `session_id` varbinary(192) NOT NULL,
  `client_id` tinyint(3) UNSIGNED DEFAULT NULL,
  `guest` tinyint(3) UNSIGNED DEFAULT '1',
  `time` int(11) NOT NULL DEFAULT '0',
  `data` mediumtext,
  `userid` int(11) DEFAULT '0',
  `username` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `userid` (`userid`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__session` (`session_id`, `client_id`, `guest`, `time`, `data`, `userid`, `username`) VALUES
(0x73746d73626868627363733373366a387537333067383937726f, 1, 0, 1552829613, 'joomla|s:1228:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjE6e3M6OToiX19kZWZhdWx0IjtPOjg6InN0ZENsYXNzIjo0OntzOjc6InNlc3Npb24iO086ODoic3RkQ2xhc3MiOjM6e3M6NzoiY291bnRlciI7aToxNDtzOjU6InRpbWVyIjtPOjg6InN0ZENsYXNzIjozOntzOjU6InN0YXJ0IjtpOjE1NTI4Mjk1MDM7czo0OiJsYXN0IjtpOjE1NTI4Mjk1OTI7czozOiJub3ciO2k6MTU1MjgyOTYxMjt9czo1OiJ0b2tlbiI7czozMjoibHI1OUR2Q1pVUnlFNjNvYWJTYVJGUUduRmU3RXRpdnIiO31zOjg6InJlZ2lzdHJ5IjtPOjI0OiJKb29tbGFcUmVnaXN0cnlcUmVnaXN0cnkiOjM6e3M6NzoiACoAZGF0YSI7Tzo4OiJzdGRDbGFzcyI6Mzp7czoxMzoiY29tX2luc3RhbGxlciI7Tzo4OiJzdGRDbGFzcyI6Mjp7czo3OiJtZXNzYWdlIjtzOjA6IiI7czoxNzoiZXh0ZW5zaW9uX21lc3NhZ2UiO3M6MDoiIjt9czoxMDoiY29tX2NvbmZpZyI7Tzo4OiJzdGRDbGFzcyI6MTp7czo2OiJjb25maWciO086ODoic3RkQ2xhc3MiOjE6e3M6NjoiZ2xvYmFsIjtPOjg6InN0ZENsYXNzIjoxOntzOjQ6ImRhdGEiO047fX19czoxNzoiY29tX3NwcGFnZWJ1aWxkZXIiO086ODoic3RkQ2xhc3MiOjE6e3M6MTI6ImludGVncmF0aW9ucyI7Tzo4OiJzdGRDbGFzcyI6MTp7czo4OiJvcmRlcmNvbCI7Tjt9fX1zOjE0OiIAKgBpbml0aWFsaXplZCI7YjowO3M6OToic2VwYXJhdG9yIjtzOjE6Ii4iO31zOjQ6InVzZXIiO086MjA6Ikpvb21sYVxDTVNcVXNlclxVc2VyIjoxOntzOjI6ImlkIjtzOjM6IjE3MSI7fXM6MTE6ImFwcGxpY2F0aW9uIjtPOjg6InN0ZENsYXNzIjoxOntzOjU6InF1ZXVlIjthOjA6e319fX1zOjE0OiIAKgBpbml0aWFsaXplZCI7YjowO3M6OToic2VwYXJhdG9yIjtzOjE6Ii4iO30=\";', 171, 'admin');

DROP TABLE IF EXISTS `#__spmedia`;
CREATE TABLE IF NOT EXISTS `#__spmedia` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `thumb` varchar(255) NOT NULL,
  `alt` varchar(255) NOT NULL,
  `caption` varchar(2048) NOT NULL,
  `description` mediumtext NOT NULL,
  `type` varchar(100) NOT NULL DEFAULT 'image',
  `extension` varchar(100) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__sppagebuilder`;
CREATE TABLE IF NOT EXISTS `#__sppagebuilder` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `catid` int(10) NOT NULL,
  `access` int(10) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `checked_out` int(10) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL,
  `og_image` varchar(255) NOT NULL,
  `og_description` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `hits` bigint(20) NOT NULL DEFAULT '0',
  `css` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=75 DEFAULT CHARSET=utf8;

INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `attribs`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(1, 179, 'Homepage (default)', '[{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"1\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"id\":1481572479,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1481572480,\"addons\":[{\"type\":\"content\",\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1481572481,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"91\",\"position\":\"\",\"class\":\"\"},\"visibility\":true}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":0,\"no_gutter\":0,\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"20px 0 40px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_align_center\":0,\"background_parallax\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481572482,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":{\"md\":\"20px 20px 20px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animation\":\"fadeInLeft\",\"animationduration\":\"\",\"animationdelay\":\"\",\"items_align_center\":0},\"id\":1481572483,\"addons\":[{\"type\":\"\",\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481572484,\"settings\":{\"admin_label\":\"\",\"title\":\"Beautiful Design\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"title_text_color\":\"\",\"feature_type\":\"icon\",\"title_position\":\"after\",\"feature_image\":\"\",\"peicon_name\":\"pe-7s-diamond\",\"icon_name\":\"\",\"icon_size\":\"87\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_padding\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"text\":\"Beautifully designed template <span class=\\\"hidden-tablet\\\">to give your site a stunning and unique look</span>with incredible functionality.\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\" white_bckg-70 border-radius\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"fadeInUp\",\"padding\":{\"md\":\"20px 20px 20px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572485,\"addons\":[{\"type\":\"\",\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481572486,\"settings\":{\"admin_label\":\"\",\"title\":\"Awesome Features\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"title_text_color\":\"\",\"feature_type\":\"icon\",\"title_position\":\"after\",\"feature_image\":\"\",\"peicon_name\":\"pe-7s-loop\",\"icon_name\":\"\",\"icon_size\":\"87\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_padding\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"text\":\"Flex is a visually rich template design with seamlessly integrated interactive and animated elements.\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"id\":1483818834853,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":\"20\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null}}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":{\"md\":\"20px 20px 20px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animation\":\"fadeInRight\",\"animationduration\":\"\",\"animationdelay\":\"\",\"items_align_center\":0},\"id\":1481572487,\"addons\":[{\"type\":\"\",\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481572488,\"settings\":{\"admin_label\":\"\",\"title\":\"Powerful Admin\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"title_text_color\":\"\",\"feature_type\":\"icon\",\"title_position\":\"after\",\"feature_image\":\"\",\"peicon_name\":\"pe-7s-science\",\"icon_name\":\"\",\"icon_size\":\"87\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_padding\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"10\",\"text\":\"Ultimate control with the intuitive template manager and a highly user friendly interface, drag & drop functionality.\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"background_attachment\":\"fixed\",\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"35px 20px 20px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"white-inset-shadow-50\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"https://picsum.photos/g/800/640?image=251\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_position\":\"50% 0\",\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":1,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#fff8f8\",\"color2\":\"#bf9e9c\",\"type\":\"radial\",\"radialPos\":\"top center\",\"deg\":\"45\",\"pos\":\"0\",\"pos2\":\"87\"},\"overlay\":\"rgba(246, 246, 246, 0.6)\",\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"shape_name\":\"slope-opacity\",\"shape_color\":\"rgba(255, 255, 255, 0.39)\",\"shape_width\":{\"md\":\"600\",\"sm\":\"\",\"xs\":\"\"},\"shape_height\":{\"md\":\"25\",\"sm\":\"\",\"xs\":\"\"}},\"id\":1481572489,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"30px 10px 10px 10px\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572490,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481572491,\"settings\":{\"admin_label\":\"\",\"title\":\"LATEST <span class=\'major_color\'>POSTS</span> FROM OUR BLOG\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"30\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"type\":\"inner_row\",\"layout\":\"5,2,5\",\"disable\":false,\"settings\":{},\"id\":1481572492,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-5\",\"settings\":{},\"id\":1481572493,\"addons\":[],\"visibility\":1},{\"class_name\":\"col-sm-2\",\"settings\":{},\"id\":1481572494,\"addons\":[{\"type\":\"\",\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1481572495,\"settings\":{\"admin_label\":\"\",\"type\":\"sppb-progress-bar-default\",\"custom_color\":\"\",\"custom_height\":\"2\",\"progress\":\"100\",\"text\":\"\",\"text_color\":\"\",\"stripped\":\"\",\"active\":\"\",\"animation_duration\":\"3\",\"animation_delay\":\"1\",\"class\":\"major_color\"},\"visibility\":1},{\"type\":\"content\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481572496,\"settings\":{\"admin_label\":\"\",\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-5\",\"settings\":{},\"id\":1481572497,\"addons\":[],\"visibility\":1}]},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481572498,\"settings\":{\"admin_label\":\"\",\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"id\":1525084339965,\"name\":\"module\",\"visibility\":true,\"settings\":{\"admin_label\":\"Ajax Intro Articles (Module)\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"module_type\":\"module\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0 0 35px 0\",\"sm\":\"0 0 20px 0\",\"xs\":\"0 0 10px 0\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\".tags a.label{color:#fff;}\\n.ajax-posts .ajax-post > .inner{box-shadow:0 3px 3px rgba(30,30,30,0.15);}\\n.ajax-posts .article_style .caption-content > span{font-size:18px;}\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"id\":\"144\",\"global_link_color\":\"#555\",\"global_link_hover_color\":\"#f14833\",\"global_text_color\":\"\"}}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"#ffffff\",\"background_image\":\"images/pagebuilder/backgrounds/bckg-4.jpg\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"50% 50%\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"take-control\",\"class\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":1,\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":1,\"show_bottom_shape\":1,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"bottom_shape_flip\":1,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":1,\"bottom_shape_name\":\"slope-opacity\",\"bottom_shape_width\":{\"md\":\"600\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_height\":{\"md\":\"50\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_color\":\"#ffffff\",\"shape_flip\":1,\"shape_invert\":0,\"shape_to_front\":1,\"shape_width\":{\"md\":\"600\",\"sm\":\"\",\"xs\":\"\"},\"shape_height\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"\"},\"shape_name\":\"slope-opacity\",\"shape_color\":\"rgba(220, 220, 220, 0.25)\"},\"id\":1481572500,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12 active-column-parent\",\"settings\":{\"class\":\" black_bckg-50 text-shadow\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":{\"md\":\"120px 100px 150px 100px\",\"sm\":\"90px 70px 120px 70px\",\"xs\":\"80px 50px 110px 50px\"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572501,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481572502,\"settings\":{\"admin_label\":\"\",\"title\":\"Take Control of Your Website With Ease,<br />with No Coding Experience Required!\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"40\",\"sm\":\"35\",\"xs\":\"30\"},\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"Flex has a set of features, options and tools make it the most versatile theme on the market by allowing you to take control of virtually every aspect and section of the site. The powerful customization options & features give you flexibility to create the site you want.\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"dropcap\":0,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"title_lineheight\":{\"md\":\"46\",\"sm\":\"42\",\"xs\":\"37\"}},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"7,5\",\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"external_background_video\":\"0\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"10px 10px 10px 10px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"20px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"background_parallax\":0,\"background_video\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572506,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-7\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"0 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"fadeInRight\",\"animationduration\":\"\",\"animationdelay\":200,\"class\":\"\",\"items_align_center\":1,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"sm_col\":\"col-sm-7\",\"xs_col\":\"col-xs-7\"},\"id\":1481572507,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481572508,\"settings\":{\"admin_label\":\"\",\"title\":\"AT <span class=\'major_color\'>YOUR</span> SERVICE\",\"heading_selector\":\"h2\",\"title_fontsize\":\"38\",\"title_fontweight\":\"\",\"title_text_color\":\"#707070\",\"title_margin_top\":\"23\",\"title_margin_bottom\":\"\",\"text\":\"\",\"alignment\":\"sppb-text-right\",\"class\":\"pull-right\",\"dropcap\":0,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-5\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"0 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"flipInX\",\"animationduration\":1400,\"animationdelay\":250,\"class\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"sm_col\":\"col-sm-5\",\"xs_col\":\"col-xs-5\"},\"id\":1481572509,\"addons\":[{\"type\":\"\",\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481572510,\"settings\":{\"admin_label\":\"\",\"number\":\"24\",\"number_addtext\":\"/7\",\"duration\":\"3000\",\"counter_title\":\"\",\"alignment\":\"sppb-text-left\",\"font_size\":\"39\",\"color\":\"\",\"title_font_size\":\"\",\"counter_color\":\"\",\"background\":\"\",\"border_color\":\"#e3e3e3\",\"border_width\":\"1\",\"border_radius\":\"7\",\"class\":\"major_color\",\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"0px\",\"fullscreen\":0},\"id\":1481572511,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1481572512,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481572513,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h2\",\"title_fontsize\":\"40\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"15\",\"text\":\"<em style=\\\"color: #999;\\\">Flex has everything you need to get your new website up and running in no time!</em>\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"5,2,5\",\"settings\":{},\"id\":1481572514,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-5\",\"settings\":{},\"id\":1481572515,\"addons\":[],\"visibility\":1},{\"class_name\":\"col-sm-2\",\"settings\":{\"class\":\"\",\"animationdelay\":3000,\"animationduration\":\"\",\"animation\":\"\",\"padding\":{\"md\":\"5px 30px 5px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572516,\"addons\":[{\"id\":1513524015719,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":\"20\",\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0}},{\"type\":\"\",\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1481572517,\"settings\":{\"admin_label\":\"\",\"type\":\"sppb-progress-bar-default\",\"custom_color\":\"\",\"custom_height\":\"2\",\"progress\":\"100\",\"text\":\"\",\"text_color\":\"\",\"stripped\":\"\",\"active\":\"\",\"animation_duration\":\"3\",\"animation_delay\":\"1\",\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"20px 0 20px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0},\"visibility\":1},{\"id\":1513524015722,\"name\":\"empty_space\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"gap\":\"30\",\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0}}],\"visibility\":1},{\"class_name\":\"col-sm-5\",\"settings\":{},\"id\":1481572518,\"addons\":[],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"6,6\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"15px 0 25px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572519,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"0px 30px 20px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"fadeInUp\",\"animationduration\":900,\"animationdelay\":300,\"class\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572520,\"addons\":[{\"type\":\"\",\"name\":\"image\",\"title\":\"Image\",\"id\":1481572521,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/blog/flex-mac-right.jpg\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link_image\":\"0\",\"link_url\":\"\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"40px 10px 20px 10px\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"fadeInDown\",\"animationduration\":900,\"animationdelay\":300,\"class\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572522,\"addons\":[{\"type\":\"\",\"name\":\"tab\",\"title\":\"Tabs\",\"id\":1481572523,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h4\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#808080\",\"title_margin_top\":\"30\",\"title_margin_bottom\":\"30\",\"style\":\"tabs\",\"class\":\"flex\",\"sp_tab_item\":[{\"title\":\"CLEAN\",\"peicon_name\":\"pe-7s-diamond\",\"icon\":\"\",\"content\":\"<strong>FLEX</strong> is a flexible, multi-purpose Joomla template. It is built on helix3 framework which, together with integrated page builder, incorporates predefined features and options that you can use for faster template development. You can use it for Corporate, Creative, Fashion, Photo Studio, Freelancers, Portfolio Theme, Agency, etc.\"},{\"title\":\"RESPONSIVE\",\"peicon_name\":\"pe-7s-photo-gallery\",\"icon\":\"\",\"content\":[{\"id\":1517217519546,\"name\":\"animated_headlines\",\"settings\":{\"admin_label\":\"\",\"effect\":\"letters rotate-3\",\"loading_bar\":3,\"before_text\":\"\",\"after_text\":\"\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"md\":\"26\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"1px\",\"title_text_transform\":\"\",\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false},\"class\":\"\",\"sp_animated_headlines_item\":[{\"title\":\"Creative and Dynamic\",\"headline_fontstyle\":\"\",\"headline_color\":\"\",\"headline_class\":\"\"},{\"title\":\"Adaptive and Flexible\"},{\"title\":\"Ever-ready to serve you.\"}],\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false}}},{\"id\":1517217519547,\"name\":\"text_block\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Dynamically innovate resource-leveling customer service for state of the art customer service. Objectively innovate empowered manufactured products whereas parallel platforms.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false}}}]},{\"title\":\"VERSITALE\",\"peicon_name\":\"pe-7s-way\",\"icon\":\"\",\"content\":\"<p>Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications. Quickly drive clicks-and-mortar catalysts for change before vertical architectures. Credibly reintermediate backend ideas for cross-platform models. Continually reintermediate integrated processes through technically ntellectual capital.</p>\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{},\"id\":1481572524,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1481572525,\"addons\":[{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481572526,\"settings\":{\"admin_label\":\"\",\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"#ffffff\",\"background_image\":\"images/svg/section-background-stripes2.svg\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"major_color_bckg-90\",\"padding\":\"40px 0px\",\"margin\":\"0px\",\"fullscreen\":1},\"id\":1481572527,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"40px 130px 60px 130px\",\"sm\":\"40px 40px 40px 40px\",\"xs\":\"30px 30px 30px 30px\"},\"animation\":\"fadeIn\",\"animationduration\":800,\"animationdelay\":300,\"class\":\" black_bckg-20\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0,\"boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false}},\"id\":1481572528,\"addons\":[{\"type\":\"\",\"name\":\"icon\",\"title\":\"Icon\",\"id\":1481572529,\"settings\":{\"admin_label\":\"\",\"peicon_name\":\"pe-7s-comment\",\"icon_name\":\"\",\"size\":\"120\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"text-shadow\"},\"visibility\":1},{\"id\":1517217519489,\"name\":\"animated_headlines\",\"visibility\":true,\"settings\":{\"admin_label\":\"What They Say\",\"effect\":\"clip is-full-width\",\"loading_bar\":3,\"before_text\":\"\",\"after_text\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"30\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"md\":\"42\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"1px\",\"title_text_transform\":\"\",\"title_margin\":{\"md\":\"0 auto 25px auto\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"title_text_shadow\":{\"ho\":\"1\",\"vo\":\"2\",\"blur\":\"3\",\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.2)\",\"inset\":false},\"class\":\"\",\"sp_animated_headlines_item\":[{\"title\":\"WHAT THEY SAY\",\"headline_fontstyle\":\"\",\"headline_color\":\"\",\"headline_class\":\"\"},{\"title\":\"TESTIMONIALS\"},{\"title\":\"OUR GREAT CLIENTS\"}]}},{\"id\":1517741514944,\"name\":\"slick_carousel\",\"visibility\":true,\"settings\":{\"admin_label\":\"Testimonials (Slick Slider)\",\"infiniteloop\":1,\"lazyloading\":0,\"slidestoshow\":\"1\",\"slidestoscroll\":\"1\",\"spacing\":0,\"fade_effect\":0,\"autoplay\":1,\"autoplay_interval\":\"7000\",\"speed\":\"1000\",\"arrows\":1,\"arrows_size\":44,\"arrows_class\":\"\",\"counter\":0,\"dots\":1,\"autoheight\":1,\"rtl_support\":0,\"breakpoint1\":992,\"slidestoshow_break1\":\"1\",\"breakpoint2\":768,\"slidestoshow_break2\":\"1\",\"breakpoint3\":480,\"slidestoshow_break3\":1,\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"class\":\"flex\",\"sp_slick_carousel_item\":[{\"title\":\"\",\"thumb_url\":\"\",\"description\":\"<p>&ldquo;A great deal of effort and preparation has already gone into this year and I would really like to thank all the volunteers for their efforts. One of the most important aspects of that trust is the recognition. Very quick and high quality professional service.&rdquo;</p>\\n<h5 style=\\\"margin: 5px auto 20px;\\\">John C. Teflon</h5>\"},{\"description\":\"<p>&ldquo;A great deal of effort and preparation has already gone into this year and I would really like to thank all the volunteers for their efforts. One of the most important aspects of that trust is the recognition. Very quick and high quality professional service.&rdquo;</p>\\n<h5 style=\\\"margin: 5px auto 20px;\\\">Joanna Betton</h5>\"},{\"description\":\"<p>&ldquo;A great deal of effort and preparation has already gone into this year and I would really like to thank all the volunteers for their efforts. One of the most important aspects of that trust is the recognition. Very quick and high quality professional service.&rdquo;</p>\\n<h5 style=\\\"margin: 5px auto 20px;\\\">John Plafon</h5>\"}]}}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"background_position\":\"100% 50%\",\"background_size\":\"contain\",\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"30px 0px 0px \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"background_repeat\":\"no-repeat\",\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572532,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"60px 0 10px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"fadeInDown\",\"animationduration\":900,\"animationdelay\":300,\"class\":\" match-height\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572533,\"addons\":[{\"type\":\"\",\"name\":\"tab\",\"title\":\"Tabs\",\"id\":1481572534,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h4\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#808080\",\"title_margin_top\":\"30\",\"title_margin_bottom\":\"30\",\"style\":\"pills\",\"class\":\"flex\",\"sp_tab_item\":[{\"title\":\"GREAT\",\"peicon_name\":\"\",\"icon\":\"fa-connectdevelop\",\"content\":\"<p>Completely synergize resource sucking relationships via premier niche markets. Professionally cultivate one-to-one customer service with robust ideas. Dynamically innovate resource-leveling customer service for state of the art customer service. Objectively innovate empowered manufactured products whereas parallel platforms. Holisticly predominate extensible testing procedures.</p>\"},{\"title\":\"FLEXIBLE\",\"peicon_name\":\"\",\"icon\":\"fa-diamond\",\"content\":\"<p>Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications. Quickly drive clicks-and-mortar catalysts for change before vertical architectures. Credibly reintermediate backend ideas for cross-platform models. Continually reintermediate integrated processes through technically sound intellectual capital.</p>\"},{\"title\":\"UNIQUE\",\"peicon_name\":\"\",\"icon\":\"fa-skyatlas\",\"content\":\"<p>Phosfluorescently engage worldwide methodologies with web-enabled technology. Interactively coordinate proactive e-commerce via process-centric \\\"outside the box\\\" thinking. Completely pursue scalable customer service through sustainable potentialities. Collaboratively administrate turnkey channels whereas virtual e-tailers. Objectively seize scalable metrics whereas proactive e-services.</p>\"}]},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\" match-height\",\"animationdelay\":400,\"animationduration\":1000,\"animation\":\"fadeIn\",\"padding\":{\"md\":\"30px 20px 30px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572535,\"addons\":[{\"type\":\"\",\"name\":\"pie_progress\",\"title\":\"Pie Progress\",\"id\":1481572536,\"settings\":{\"admin_label\":\"\",\"percentage\":\"100\",\"size\":\"160\",\"duration\":\"4\",\"border_color\":\"#fff2f0\",\"border_active_color\":\"#ffb2b2\",\"border_width\":\"2\",\"peicon_name\":\"pe-7s-rocket\",\"icon_name\":\"\",\"icon_color\":\"#e35656\",\"icon_size\":\"100\",\"title\":\"\",\"title_margin_top\":\"25\",\"title_margin_bottom\":\"20\",\"text\":\"\",\"class\":\"\"},\"visibility\":1},{\"id\":1517213251022,\"name\":\"animated_headlines\",\"visibility\":true,\"settings\":{\"admin_label\":\"Flex is Awesome (Animated Headlines)\",\"effect\":\"slide reset-width\",\"loading_bar\":3,\"before_text\":\"Flex is\",\"after_text\":\"\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"md\":\"26\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"md\":\"40\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"\",\"title_text_transform\":\"\",\"title_margin\":{\"md\":\"10px auto 10px auto\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false},\"class\":\"\",\"sp_animated_headlines_item\":[{\"title\":\"Awesome\",\"headline_fontstyle\":\"\",\"headline_color\":\"#555\",\"headline_class\":\"\"},{\"title\":\"Unique\"},{\"title\":\"Dynamic\"}]}},{\"id\":1517217519478,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"A fully flexible, intuitive and highly flexible, allowing for swift and extensive changes. An excellent, advanced and versatile, next-generation design with a fresh approach for the ever-changing Web.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\"}}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\" match-height\",\"animationdelay\":800,\"animationduration\":\"1400\",\"animation\":\"fadeInUp\",\"padding\":{\"md\":\"20px 20px 0 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572537,\"addons\":[{\"type\":\"\",\"name\":\"image\",\"title\":\"Image\",\"id\":1481572538,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/blog/flex-iPhone6-hand-FrontView-2.png\",\"alt_text\":\"\",\"position\":\"sppb-text-left\",\"link_image\":\"0\",\"link_url\":\"\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"images/svg/background-white-85.svg\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"40px 20px 60px\",\"margin\":\"0px\",\"fullscreen\":0},\"id\":1481572539,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":800,\"animation\":\"fadeIn\",\"padding\":{\"md\":\"10px 10px 10px 10px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572540,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481572541,\"settings\":{\"admin_label\":\"\",\"title\":\"OUR BEST PARTNERS\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"10\",\"title_margin_bottom\":\"30\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"slick_carousel\",\"title\":\"Slick Carousel\",\"id\":1481572542,\"settings\":{\"admin_label\":\"\",\"infiniteloop\":\"1\",\"lazyloading\":\"1\",\"slidestoshow\":\"5\",\"slidestoscroll\":\"1\",\"spacing\":\"30\",\"fade_effect\":\"0\",\"autoplay\":\"1\",\"autoplay_interval\":\"7000\",\"speed\":\"700\",\"arrows\":\"1\",\"arrows_size\":\"44\",\"arrows_color\":\"\",\"arrows_background_color\":\"\",\"arrows_class\":\"\",\"counter\":\"0\",\"counter_color\":\"\",\"dots\":\"0\",\"autoheight\":\"1\",\"rtl_support\":\"0\",\"breakpoint1\":\"992\",\"slidestoshow_break1\":\"4\",\"breakpoint2\":\"768\",\"slidestoshow_break2\":\"3\",\"breakpoint3\":\"480\",\"slidestoshow_break3\":\"2\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"class\":\"flex desaturate\",\"sp_slick_carousel_item\":[{\"title\":\"Item 1\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-1.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 2\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-7.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 3\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-2.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 4\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-4.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 5\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-3.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 6\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-12.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 7\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-16.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 8\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-8.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 9\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-15.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 10\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-13.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 11\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-9.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 12\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-6.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 13\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-14.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 14\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-10.png\",\"thumb_url\":\"#\",\"description\":\"\"},{\"title\":\"Item 15\",\"thumb\":\"images/pagebuilder/our-partners/our-partners-17.png\",\"thumb_url\":\"#\",\"description\":\"\"}]},\"visibility\":true}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"#303030\",\"color\":\"#ffffff\",\"background_image\":\"images/svg/section-background-stripes.svg\",\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1481572543,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":{\"md\":\"40px 100px 50px 100px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#b8b8b8\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0},\"id\":1481572544,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481572545,\"settings\":{\"admin_label\":\"\",\"title\":\"FACTS & FIGURES\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#e0978f\",\"title_margin_top\":\"10\",\"title_margin_bottom\":\"20\",\"text\":\"An approach to web design aimed at crafting sites to provide an optimal viewing experience and engage worldwide methodologies with web-enabled technology. Method of support, a technique used to make inferences from high standards in web-readiness.\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,6,3\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"#404040\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":1,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"background_type\":\"color\",\"background_parallax\":0},\"id\":1481572546,\"visibility\":true,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0,\"boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false}},\"id\":1481572547,\"addons\":[],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{\"default\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"items_align_center\":0,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0,\"background_type\":\"none\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572548,\"addons\":[{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1481572549,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"2\",\"border_color\":\"#a85858\",\"border_style\":\"solid\",\"border_width\":\"\",\"margin_top\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin_bottom\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"container_div_width\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"divider_position\":\"\"},\"visibility\":true}],\"visibility\":true},{\"class_name\":\"col-sm-3\",\"settings\":{\"default\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"items_align_center\":0,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0,\"background_type\":\"none\",\"boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false}},\"id\":1481572550,\"addons\":[],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"50px 20px 40px 20px\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"50% 50%\",\"background_attachment\":\"inherit\",\"background_size\":\"contain\",\"background_repeat\":\"inherit\",\"background_image\":\"images/svg/section-background-stripes2.svg\",\"color\":\"\",\"background_color\":\"#363839\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":0,\"title_margin_top\":0,\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"heading_selector\":\"h3\",\"title\":\"\",\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1481572551,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"color\":\"#b3b3b3\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":\"\",\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\"},\"id\":1481572552,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481572553,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<p style=\\\"margin-top: 20px;\\\"><img class=\\\"floatleft\\\" src=\\\"images/logos/logo@2x.png\\\" alt=\\\"Flex\\\" width=\\\"120\\\" height=\\\"40\\\" /></p>\\n<p style=\\\"font-size: 90%; margin-top: 30px; clear: both;\\\"><br />Method of support, a technique used to make inferences from high standards in web-readiness without backward-compatible data. Seamlessly visualize quality intellectual capital without superior collaboration and idea-sharing. Holistically pontificate installed base portals after maintainable products.</p>\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"type\":\"inner_row\",\"layout\":12,\"disable\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\"},\"id\":1481572554,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":\"0px\",\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\"},\"id\":1481572555,\"addons\":[{\"type\":\"content\",\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1481572556,\"settings\":{\"admin_label\":\"\",\"title\":\"Join Our Community\",\"heading_selector\":\"h3\",\"title_fontsize\":\"22\",\"title_fontweight\":\"\",\"title_text_color\":\"#e0978f\",\"title_margin_top\":\"5\",\"title_margin_bottom\":\"25\",\"module_type\":\"module\",\"id\":\"150\",\"position\":\"\",\"class\":\"dark\"},\"visibility\":1}],\"visibility\":1}]}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"#9e9e9e\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":500,\"animationdelay\":\"\",\"class\":\"\"},\"id\":1481572557,\"addons\":[{\"type\":\"\",\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1481572558,\"settings\":{\"admin_label\":\"\",\"title\":\"Articles - Category\",\"heading_selector\":\"h3\",\"title_fontsize\":\"25\",\"title_fontweight\":\"\",\"title_text_color\":\"#e0978f\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"95\",\"position\":\"\",\"class\":\"dark\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"#9e9e9e\",\"padding\":\"\",\"animation\":\"fadeInUp\",\"animationduration\":500,\"animationdelay\":\"\",\"class\":\"centered\"},\"id\":1481572559,\"addons\":[{\"type\":\"\",\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1481572560,\"settings\":{\"admin_label\":\"\",\"title\":\"Popular Tags\",\"heading_selector\":\"h3\",\"title_fontsize\":\"25\",\"title_fontweight\":\"\",\"title_text_color\":\"#e0978f\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"module_type\":\"module\",\"id\":\"98\",\"position\":\"\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1481572561,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#878787\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"30\",\"margin_bottom\":\"30\",\"class\":\"\"},\"visibility\":1},{\"type\":\"content\",\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1481572562,\"settings\":{\"admin_label\":\"\",\"title\":\"Flex it Now!\",\"heading_selector\":\"h4\",\"title_position\":\"left\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"peicon_name\":\"pe-7s-paint\",\"icon_name\":\"\",\"icon_size\":\"60\",\"icon_color\":\"#ff7575\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"-3\",\"icon_margin_bottom\":\"22\",\"icon_padding\":\"3\",\"text\":\"\\tSeamlessly the best.\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1},{\"type\":\"\",\"name\":\"button\",\"title\":\"Button\",\"id\":1481572563,\"settings\":{\"admin_label\":\"\",\"text\":\"Download Now!\",\"fontstyle\":null,\"letterspace\":\"0\",\"url\":\"#\",\"target\":\"\",\"type\":\"\",\"alignment\":\"sppb-text-center\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#ffffff\",\"background_color_hover\":\"#222222\",\"color_hover\":\"#ffffff\",\"size\":\"lg\",\"shape\":\"rounded\",\"block\":\"\",\"button_peicon\":\"pe-7s-cloud-download\",\"icon\":\"\",\"icon_position\":\"right\",\"class\":\"btn-light centered\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":500,\"animation\":\"fadeInLeft\",\"padding\":\"25px 0px\",\"color\":\"#b3b3b3\",\"background\":\"\"},\"id\":1481572564,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1481572565,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<p style=\\\"font-size: 90%; margin-top: 30px;\\\">Interactively procrastinate high-payoff content without backward-compatible data. Seamlessly concept of agency has become widely used in learning research, especially in studies addressing professional and workplace learning.</p>\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1481572566,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#878787\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"32\",\"margin_bottom\":\"32\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"pie_progress\",\"title\":\"Pie Progress\",\"id\":1481572567,\"settings\":{\"admin_label\":\"\",\"percentage\":\"100\",\"size\":\"110\",\"duration\":\"4\",\"border_color\":\"#ffded9\",\"border_active_color\":\"#964f4f\",\"border_width\":\"2\",\"peicon_name\":\"pe-7s-coffee\",\"icon_name\":\"\",\"icon_color\":\"#ff9494\",\"icon_size\":\"56\",\"title\":\"Flex is Awesome\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"0\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"\",\"padding\":\"50px 20px 60px\",\"margin\":\"0px\",\"color\":\"\",\"background_color\":\"#2e2e2e\",\"background_image\":\"images/svg/section-background-stripes2.svg\",\"overlay\":\"\",\"background_repeat\":\"inherit\",\"background_size\":\"contain\",\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\"},\"id\":1481572568,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":\"\",\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\"},\"id\":1481572569,\"addons\":[{\"type\":\"\",\"name\":\"pie_progress\",\"title\":\"Pie Progress\",\"id\":1481572570,\"settings\":{\"admin_label\":\"\",\"percentage\":\"100\",\"size\":\"90\",\"duration\":\"3\",\"border_color\":\"#ffded9\",\"border_active_color\":\"#964f4f\",\"border_width\":\"2\",\"peicon_name\":\"\",\"icon_name\":\"fa-area-chart\",\"icon_color\":\"#d16b6b\",\"icon_size\":\"36\",\"title\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481572571,\"settings\":{\"admin_label\":\"\",\"gap\":\"10\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481572572,\"settings\":{\"admin_label\":\"\",\"number\":\"100\",\"number_addtext\":\"%\",\"duration\":\"2000\",\"counter_title\":\"EFFECTIVE INCREASE\",\"alignment\":\"sppb-text-center\",\"font_size\":\"40\",\"color\":\"#ffafa3\",\"title_font_size\":\"18\",\"counter_color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"items_align_center\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"35px 0 0 0\"},\"use_border\":0,\"background_type\":\"none\"},\"id\":1481572573,\"addons\":[{\"type\":\"\",\"name\":\"pie_progress\",\"title\":\"Pie Progress\",\"id\":1481572574,\"settings\":{\"admin_label\":\"\",\"percentage\":\"100\",\"size\":\"90\",\"duration\":\"3\",\"border_color\":\"#ffded9\",\"border_active_color\":\"#964f4f\",\"border_width\":\"2\",\"peicon_name\":\"\",\"icon_name\":\"fa-dollar\",\"icon_color\":\"#d16b6b\",\"icon_size\":\"42\",\"title\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481572575,\"settings\":{\"admin_label\":\"\",\"gap\":\"10\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481572576,\"settings\":{\"admin_label\":\"\",\"number\":\"85\",\"number_addtext\":\",750\",\"duration\":\"2200\",\"counter_title\":\"SECURED PAYMENTS\",\"alignment\":\"sppb-text-center\",\"font_size\":\"42\",\"color\":\"#ffafa3\",\"title_font_size\":\"18\",\"counter_color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"35px 0 0 0\"}},\"id\":1481572577,\"addons\":[{\"type\":\"\",\"name\":\"pie_progress\",\"title\":\"Pie Progress\",\"id\":1481572578,\"settings\":{\"admin_label\":\"\",\"percentage\":\"100\",\"size\":\"90\",\"duration\":\"3\",\"border_color\":\"#ffded9\",\"border_active_color\":\"#964f4f\",\"border_width\":\"2\",\"peicon_name\":\"\",\"icon_name\":\"fa-thumbs-o-up\",\"icon_color\":\"#d16b6b\",\"icon_size\":\"42\",\"title\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481572579,\"settings\":{\"admin_label\":\"\",\"gap\":\"10\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481572580,\"settings\":{\"admin_label\":\"\",\"number\":\"8712\",\"number_addtext\":\"+\",\"duration\":\"2000\",\"counter_title\":\"PROJECTS CAPITALIZED\",\"alignment\":\"sppb-text-center\",\"font_size\":\"40\",\"color\":\"#ffafa3\",\"title_font_size\":\"18\",\"counter_color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"color\":\"\",\"background\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":\"\",\"animationdelay\":\"\",\"items_align_center\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"35px 0 0 0\"},\"use_border\":0},\"id\":1481572581,\"addons\":[{\"type\":\"\",\"name\":\"pie_progress\",\"title\":\"Pie Progress\",\"id\":1481572582,\"settings\":{\"admin_label\":\"\",\"percentage\":\"-100\",\"size\":\"90\",\"duration\":\"3\",\"border_color\":\"#ffded9\",\"border_active_color\":\"#964f4f\",\"border_width\":\"2\",\"peicon_name\":\"\",\"icon_name\":\"fa-smile-o\",\"icon_color\":\"#d16b6b\",\"icon_size\":\"46\",\"title\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1481572583,\"settings\":{\"admin_label\":\"\",\"gap\":\"10\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1481572584,\"settings\":{\"admin_label\":\"\",\"number\":\"52\",\"number_addtext\":\"W/Y\",\"duration\":\"2400\",\"counter_title\":\"DEDICATED SUPPORT\",\"alignment\":\"sppb-text-center\",\"font_size\":\"40\",\"color\":\"#ffafa3\",\"title_font_size\":\"18\",\"counter_color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 23, 1, -41, '2018-01-10 17:03:39', 0, '2019-03-16 11:13:09', 0, 0, '0000-00-00 00:00:00', '[]', '', '', '', '*', 2, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `attribs`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(2, 188, 'Homepage 1', '[{\"layout\":\"4,8\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":1,\"no_gutter\":0,\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"0 10px 0 10px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background_color\":\"\",\"background_image\":\"images/videos/screenshots/with-colors-720p.jpg\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_video\":1,\"background_video_mp4\":\"images/videos/with-colors-720p.mp4\",\"background_video_ogv\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_align_center\":0,\"background_parallax\":0,\"external_background_video\":0,\"show_top_shape\":0,\"show_bottom_shape\":1,\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":1,\"bottom_shape_name\":\"waves3-opacity\",\"bottom_shape_color\":\"#ffffff\",\"bottom_shape_width\":{\"md\":\"250\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_height\":{\"md\":\"70\",\"sm\":\"\",\"xs\":\"\"},\"background_type\":\"video\",\"video_loop\":1},\"id\":1482796521,\"visibility\":true,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"#ffffff\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" centered\"},\"id\":1482796522,\"addons\":[{\"type\":\"content\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482796523,\"settings\":{\"admin_label\":\"\",\"gap\":\"203\",\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0},\"visibility\":1},{\"type\":\"content\",\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1482796524,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<svg style=\\\"margin:0 auto;max-width: 300px;\\\" class=\\\"flex-logo-light delayed\\\" xmlns=\\\"http://www.w3.org/2000/svg\\\" width=\\\"100%\\\" height=\\\"100%\\\" viewBox=\\\"0 0 1703 567.6\\\">\\n  <g id=\\\"Background\\\">\\n    <path id=\\\"flex_rectangle\\\" fill=\\\"none\\\" stroke=\\\"none\\\" d=\\\"M677.5 511.1c0 18.2-14.8 33-33 33h-476c-18.2 0-33-14.8-33-33v-451c0-18.2 14.8-33 33-33h476c18.2 0 33 14.8 33 33V511.1z\\\"/>\\n    <path id=\\\"flex_rectangle_fill\\\" fill=\\\"none\\\" stroke=\\\"#444\\\" d=\\\"M677.5 511.1c0 18.2-14.8 33-33 33h-476c-18.2 0-33-14.8-33-33v-451c0-18.2 14.8-33 33-33h476c18.2 0 33 14.8 33 33V511.1z\\\"/>\\n  </g>\\n  <g id=\\\"flex_logo\\\">\\n    <linearGradient id=\\\"gradient_1\\\" gradientUnits=\\\"userSpaceOnUse\\\" x1=\\\"408.9635\\\" y1=\\\"237.4535\\\" x2=\\\"404.6931\\\" y2=\\\"-7.3191\\\" gradientTransform=\\\"matrix(8.579812e-04 1 -1 8.579812e-04 581.9316 -124.7311)\\\">\\n      <stop offset=\\\"0\\\" style=\\\"stop-color:#FFFFFF;stop-opacity:0.7\\\"/>\\n      <stop offset=\\\"1\\\" stop-color=\\\"#FFFFFF\\\"/>\\n    </linearGradient>\\n    <polygon id=\\\"gradient_1\\\" fill=\\\"url(#gradient_1)\\\" points=\\\"527.3 316.8 280.7 317 279.9 316.3 311.4 249.3 527.2 249.2\\\"/>\\n    <path id=\\\"logo_top\\\" fill=\\\"none\\\" stroke-width=\\\"4.5\\\" stroke=\\\"#B2B2B2\\\" d=\\\"M529.5 212.2l-251.8 0 0-71.4 251.8 0L529.5 212.2zM281.7\\\"/>\\n    <path id=\\\"logo_main1\\\" fill=\\\"none\\\" stroke-width=\\\"4.5\\\" stroke=\\\"#B2B2B2\\\" d=\\\"M279.9 319l-2.4-2.2 32.6-69.4 219.1-0.2 0.1 71.7L279.9 319zM312.6 251.3L282.8\\\"/>\\n    <path id=\\\"logo_main2\\\" fill=\\\"none\\\" stroke-width=\\\"14.5\\\" stroke=\\\"#B2B2B2\\\" d=\\\"M436.4 463.2L277.5 316.8l33.2-70.8 178.8 164.7L436.4 463.2zM282.4 315.8l153.9\\\"/>\\n    <linearGradient id=\\\"gradient_2\\\" gradientUnits=\\\"userSpaceOnUse\\\" x1=\\\"322.2522\\\" y1=\\\"344.1754\\\" x2=\\\"560.4815\\\" y2=\\\"344.1754\\\" gradientTransform=\\\"matrix(0.7346 0.6785 -0.6785 0.7346 284.3563 -196.3653)\\\">\\n      <stop offset=\\\"0\\\" stop-color=\\\"#FFFFFF\\\"/>\\n      <stop offset=\\\"1\\\" style=\\\"stop-color:#FFFFFF;stop-opacity:0.8\\\"/>\\n    </linearGradient>\\n    <polygon id=\\\"gradient_2\\\" fill=\\\"url(#gradient_2)\\\" points=\\\"436.3 460.5 280.7 317 279.9 316.3 311.4 249.3 384.8 316.9 486.6 410.7\\\"/>\\n    <rect id=\\\"logo_top_bckg\\\" x=\\\"279.7\\\" y=\\\"142.8\\\" fill=\\\"#FFFFFF\\\" width=\\\"247.8\\\" height=\\\"67.4\\\"/>\\n  </g>\\n  <g id=\\\"flex\\\">\\n    <path id=\\\"f_top\\\" fill=\\\"none\\\" stroke=\\\"#F14833\\\" stroke-width=\\\"4.5\\\" d=\\\"M950.8 201.5H760v-44.9h190.8V201.5zM760.3\\\"/>\\n    <path id=\\\"f\\\" fill=\\\"none\\\" stroke-width=\\\"4.5\\\" stroke=\\\"#B2B2B2\\\" d=\\\"M760.4 281.2c0 0 0-41 0-41h189.4v40.7l-133.2-0.1c0 0 63.9 88.4 64 88.6 6.7 9.1 14.7 18.1 22.7 18.1 2.4 0 4.7-0.8 7-2.5 4.5-3.3 11.2-11 11.2-11l0.4-0.5 19.4 29.2 -0.3 0.3c-0.1 0.1-11.2 12.6-20.9 19.7 -8 5.9-16.6 8.8-25.6 8.8 -16 0-31.8-9.6-44.6-27l-89.8-123.7M761.9 281.2\\\"/>\\n    <path id=\\\"l\\\" fill=\\\"none\\\" stroke=\\\"#B2B2B2\\\" stroke-width=\\\"4.5\\\" d=\\\"M993.6 377.7V156.9h40.8v209.4c0 15.1 6.8 22.7 20.4 22.7 5.7 0 11-1.1 15.5-3.8v35.2c-7.9 4.2-18.1 6-30.2 6C1013.3 426.5 993.6 412.9 993.6 377.7z\\\"/>\\n    <path id=\\\"e\\\" fill=\\\"none\\\" stroke=\\\"#B2B2B2\\\" stroke-width=\\\"4.5\\\" d=\\\"M1126.5 259c17.8-18.5 40.4-28 68.8-28 18.9 0 35.2 4.9 48.8 15.1 27.6 19.7 39.3 50.3 39.3 83.9v10.6h-142.1c4.9 31.4 32.1 49.9 69.9 49.9 21.5 0 41.2-5.7 59.7-16.6v34.4c-17 12.1-39.7 18.1-68.4 18.1 -28.7 0-52.9-9.1-73-27.2 -19.7-18.1-29.5-41.6-29.5-70.7C1100.1 301 1108.8 277.5 1126.5 259zM1242.2 309.7c-0.4-11.3-4.5-21.5-13.2-30.6 -8.7-9.1-20.4-13.6-35.5-13.6 -29.9 0-49.1 20-51.8 44.2H1242.2z\\\"/>\\n    <path id=\\\"x\\\" fill=\\\"none\\\" stroke=\\\"#B2B2B2\\\" stroke-width=\\\"4.5\\\" d=\\\"M1354.4 236l43.8 57.5 44.2-57.5h46.5l-67.3 87.7 74.8 97.9h-47.2l-51.8-67.7 -51.8 67.7h-46.1l74.8-97.1 -67.3-88.5H1354.4z\\\"/>\\n  </g>\\n  <g id=\\\"flex_after\\\">\\n    <path id=\\\"f_top\\\" fill=\\\"none\\\" stroke-width=\\\"4.5\\\" stroke=\\\"#F14833\\\" d=\\\"M950.8 201.5H760v-44.9h190.8V201.5zM760.3\\\"/>\\n    <path fill=\\\"none\\\" stroke-width=\\\"4.5\\\" stroke=\\\"#B2B2B2\\\" d=\\\"M760.4 281.2c0 0 0-41 0-41h189.4v40.7l-133.2-0.1c0 0 63.9 88.4 64 88.6 6.7 9.1 14.7 18.1 22.7 18.1 2.4 0 4.7-0.8 7-2.5 4.5-3.3 11.2-11 11.2-11l0.4-0.5 19.4 29.2 -0.3 0.3c-0.1 0.1-11.2 12.6-20.9 19.7 -8 5.9-16.6 8.8-25.6 8.8 -16 0-31.8-9.6-44.6-27l-89.8-123.7M761.9 281.2\\\"/>\\n    <path fill=\\\"none\\\" stroke=\\\"#B2B2B2\\\" stroke-width=\\\"4.5\\\" d=\\\"M993.6 377.7V156.9h40.8v209.4c0 15.1 6.8 22.7 20.4 22.7 5.7 0 11-1.1 15.5-3.8v35.2c-7.9 4.2-18.1 6-30.2 6C1013.3 426.5 993.6 412.9 993.6 377.7z\\\"/>\\n    <path fill=\\\"none\\\" stroke=\\\"#B2B2B2\\\" stroke-width=\\\"4.5\\\" d=\\\"M1126.5 259c17.8-18.5 40.4-28 68.8-28 18.9 0 35.2 4.9 48.8 15.1 27.6 19.7 39.3 50.3 39.3 83.9v10.6h-142.1c4.9 31.4 32.1 49.9 69.9 49.9 21.5 0 41.2-5.7 59.7-16.6v34.4c-17 12.1-39.7 18.1-68.4 18.1 -28.7 0-52.9-9.1-73-27.2 -19.7-18.1-29.5-41.6-29.5-70.7C1100.1 301 1108.8 277.5 1126.5 259zM1242.2 309.7c-0.4-11.3-4.5-21.5-13.2-30.6 -8.7-9.1-20.4-13.6-35.5-13.6 -29.9 0-49.1 20-51.8 44.2H1242.2z\\\"/>\\n    <path fill=\\\"none\\\" stroke=\\\"#B2B2B2\\\" stroke-width=\\\"4.5\\\" d=\\\"M1354.4 236l43.8 57.5 44.2-57.5h46.5l-67.3 87.7 74.8 97.9h-47.2l-51.8-67.7 -51.8 67.7h-46.1l74.8-97.1 -67.3-88.5H1354.4z\\\"/>\\n\\n  </g>\\n</svg>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-8 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":1100,\"animationdelay\":8500,\"class\":\" white_bckg-10 text-shadow shadow centered\"},\"id\":1482796525,\"addons\":[{\"type\":\"content\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482796526,\"settings\":{\"admin_label\":\"\",\"gap\":\"190\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0},\"visibility\":1},{\"type\":\"content\",\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1482796527,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<h2 style=\\\"color:#fff;margin:0 auto 140px;padding:20px 5px;line-height:1.4;\\\"><span style=\\\"font-weight:500;\\\">Your connection</span> to creation<br />just in a few clicks.</h2>\",\"class\":\"major_color_bckg-80\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0},\"visibility\":1},{\"type\":\"content\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482796528,\"settings\":{\"admin_label\":\"\",\"gap\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":1,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"20px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482796531,\"visibility\":true,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1482796532,\"addons\":[{\"type\":\"content\",\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1482796533,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"120\",\"position\":\"\",\"class\":\"\"},\"visibility\":true}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{},\"id\":1482796534,\"visibility\":true,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1482796535,\"addons\":[{\"type\":\"content\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482796536,\"settings\":{\"admin_label\":\"\",\"gap\":\"40\",\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0},\"visibility\":true}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":1,\"show_top_shape\":1,\"shape_flip\":1,\"shape_invert\":0,\"shape_to_front\":1,\"shape_name\":\"waves3-opacity\",\"shape_color\":\"#ffffff\",\"shape_width\":{\"md\":\"180\",\"sm\":\"\",\"xs\":\"\"},\"shape_height\":{\"md\":\"60\",\"sm\":\"\",\"xs\":\"\"},\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482796537,\"visibility\":true,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1482796538,\"addons\":[{\"type\":\"content\",\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1482796539,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"101\",\"position\":\"\",\"class\":\"\"},\"visibility\":true}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"id\":1513524874685,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"Shape Divider - Drip style\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"padding\":{\"md\":\"0 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0 0 90px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"background_image\":\"\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"external_background_video\":\"0\",\"show_top_shape\":1,\"shape_name\":\"drip\",\"shape_color\":\"rgba(255, 174, 155, 0.29)\",\"shape_width\":{\"md\":\"100\",\"sm\":100,\"xs\":100},\"shape_height\":{\"md\":\"50\",\"sm\":\"\",\"xs\":\"\"},\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"show_bottom_shape\":0,\"bottom_shape_name\":\"drip\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":{\"md\":\"30\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"major_color_bckg-20\",\"animation\":\"\"},\"layout\":\"12\",\"columns\":[{\"id\":1513524874728,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1513524874729,\"name\":\"progress_bar\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"type\":\"sppb-progress-bar-default\",\"custom_height\":\"1\",\"progress\":\"100\",\"text\":\"\",\"text_color\":\"\",\"animation_duration\":\"3\",\"animation_delay\":\"1\",\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"-1px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"custom_color\":\"#fbb2a7\"}}]}]},{\"layout\":\"4,4,4\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":1,\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482796543,\"visibility\":true,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":100,\"animationduration\":1000,\"animation\":\"fadeInUp\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1482796544,\"addons\":[{\"type\":\"repeatable\",\"name\":\"lightbox\",\"title\":\"Lightbox Gallery\",\"id\":1482796545,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"width\":\"720\",\"spacing\":\"\",\"class\":\"\",\"sp_lightbox_item\":[{\"title\":\"Artistic Creation #1\",\"show_caption\":\"1\",\"thumb\":\"images/portfolio/arts/thumbs/painting-720x405-1.jpg\",\"full\":\"images/portfolio/arts/painting-1280x720-1.jpg\"}],\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":true},{\"type\":\"content\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482796546,\"settings\":{\"admin_label\":\"\",\"gap\":\"30\",\"hidden_md\":\"1\",\"hidden_sm\":\"1\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":300,\"animationduration\":1000,\"animation\":\"fadeInUp\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1482796547,\"addons\":[{\"type\":\"repeatable\",\"name\":\"lightbox\",\"title\":\"Lightbox Gallery\",\"id\":1482796548,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"width\":\"720\",\"spacing\":\"\",\"class\":\"\",\"sp_lightbox_item\":[{\"title\":\"Artistic Creation #2\",\"show_caption\":\"1\",\"thumb\":\"images/portfolio/arts/thumbs/painting-720x405-2.jpg\",\"full\":\"images/portfolio/arts/painting-1280x720-2.jpg\"}],\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":true},{\"type\":\"content\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482796549,\"settings\":{\"admin_label\":\"\",\"gap\":\"30\",\"hidden_md\":\"1\",\"hidden_sm\":\"1\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":500,\"animationduration\":1000,\"animation\":\"fadeInUp\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1482796550,\"addons\":[{\"type\":\"repeatable\",\"name\":\"lightbox\",\"title\":\"Lightbox Gallery\",\"id\":1482796551,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"width\":\"720\",\"spacing\":\"\",\"class\":\"\",\"sp_lightbox_item\":[{\"title\":\"Artistic Creation #3\",\"show_caption\":\"1\",\"thumb\":\"images/portfolio/arts/thumbs/painting-720x405-3.jpg\",\"full\":\"images/portfolio/arts/painting-1280x720-3.jpg\"}],\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":true},{\"type\":\"content\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482796552,\"settings\":{\"admin_label\":\"\",\"gap\":\"30\",\"hidden_md\":\"1\",\"hidden_sm\":\"1\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{},\"id\":1482796553,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1482796554,\"addons\":[],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"inherit\",\"background_size\":\"cover\",\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"40px 10px 40px 10px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"show_bottom_shape\":1,\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":1,\"bottom_shape_name\":\"rocky-mountain\",\"bottom_shape_color\":\"rgba(156, 156, 156, 0.28)\",\"bottom_shape_width\":{\"md\":\"110\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_height\":{\"md\":\"80\",\"sm\":\"\",\"xs\":\"\"},\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482796555,\"visibility\":true,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1482796556,\"addons\":[{\"id\":1517224111020,\"name\":\"animated_headlines\",\"visibility\":true,\"settings\":{\"admin_label\":\"Welcome to our Passage\",\"effect\":\"slide reset-width\",\"loading_bar\":3,\"before_text\":\"Welcome to our\",\"after_text\":\"Passage\",\"heading_selector\":\"h2\",\"title_fontsize\":{\"md\":\"36\",\"sm\":\"32\",\"xs\":\"32\"},\"title_lineheight\":{\"md\":\"45\",\"sm\":\"40\",\"xs\":\"40\"},\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false},\"class\":\"\",\"sp_animated_headlines_item\":[{\"title\":\"Art\",\"headline_fontstyle\":\"\",\"headline_color\":\"\",\"headline_class\":\"\",\"headline_font_family\":\"Parisienne\"},{\"title\":\"Design\",\"headline_font_family\":\"Cabin Sketch\",\"headline_class\":\"major_color\"},{\"title\":\"Web\",\"headline_class\":\"major_color\",\"headline_font_family\":\"Macondo\"}]}},{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482796557,\"settings\":{\"admin_label\":\"Subtitle\",\"title\":\"\",\"heading_selector\":\"h2\",\"title_fontsize\":\"40\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"15\",\"text\":\"<em style=\\\"color: #777;\\\">The very are part of the creative process and together we “make art.”</em>\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"dropcap\":0},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482796558,\"settings\":{\"admin_label\":\"\",\"gap\":\"40\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":1,\"margin\":{\"md\":\"0px   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"show_bottom_shape\":0,\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":0,\"bottom_shape_name\":\"\",\"bottom_shape_color\":\"\",\"bottom_shape_width\":{\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_height\":{\"md\":\"60\",\"sm\":\"\",\"xs\":\"\"},\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482796559,\"visibility\":true,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1482796560,\"addons\":[{\"type\":\"\",\"name\":\"gmap\",\"title\":\"Google Map\",\"id\":1482796561,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h1\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator_addon_options\":\"\",\"api_key\":\"\",\"map\":\"48.860395, 2.337599\",\"infowindow\":\"<div class=\\\"col-md-12\\\">\\n<div class=\\\"col-md-5\\\">\\n<h5>Yes, using Info-window in Google maps!</h5>\\nThe Louvre or the Louvre Museum is the world\'s largest museum and a historic monument in Paris, France.\\n<div class=\\\"clearfix\\\"></div>\\n<a style=\\\"margin-top:12px;\\\" class=\\\"sppb-btn sppb-btn-default sppb-btn-xs sppb-btn-rounded\\\" href=\\\"https://en.wikipedia.org/wiki/Louvre\\\" target=\\\"_blank\\\"><i style=\\\"margin-right:7px;\\\" class=\\\"fa fa-wikipedia-w\\\"></i>More on Wikipedia</a>\\n</div>\\n<img style=\\\"margin-top:8px;\\\" class=\\\"col-md-7 img-responsive\\\" src=\\\"https://upload.wikimedia.org/wikipedia/commons/thumb/6/66/Louvre_Museum_Wikimedia_Commons.jpg/800px-Louvre_Museum_Wikimedia_Commons.jpg\\\" />\\n</div>\",\"height\":\"270\",\"type\":\"ROADMAP\",\"zoom\":\"14\",\"mousescroll\":\"false\",\"street_view_control\":\"false\",\"map_type_control\":\"false\",\"fullscreen_control\":\"false\",\"class\":\"\",\"separator\":\"\",\"water_color\":\"#c2c2c2\",\"highway_stroke_color\":\"#8f8f8f\",\"highway_fill_color\":\"#ababab\",\"local_stroke_color\":\"#ffffff\",\"local_fill_color\":\"#ffffff\",\"poi_fill_color\":\"#d4d4d4\",\"administrative_color\":\"#a3a3a3\",\"landscape_color\":\"#efefef\",\"road_text_color\":\"#666666\",\"road_arterial_fill_color\":\"#d9d9d9\",\"road_arterial_stroke_color\":\"#c2c2c2\",\"global_options\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_boxshadow\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1},{\"type\":\"\",\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1482796562,\"settings\":{\"admin_label\":\"\",\"type\":\"sppb-progress-bar-default\",\"custom_color\":\"#ffabab\",\"custom_height\":\"2\",\"progress\":\"100\",\"text\":\"\",\"text_color\":\"\",\"stripped\":\"\",\"active\":\"\",\"animation_duration\":\"2\",\"animation_delay\":\"1\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"fullscreen\":0,\"margin\":\"0px\",\"padding\":\"40px 20px 50px\",\"class\":\"\",\"id\":\"contact-us\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"50% 50%\",\"background_attachment\":\"inherit\",\"background_size\":\"contain\",\"background_repeat\":\"inherit\",\"background_image\":\"images/svg/section-background-stripes2.svg\",\"color\":\"\",\"background_color\":\"#2e2e2e\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":0,\"title_margin_top\":0,\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"heading_selector\":\"h3\",\"title\":\"\"},\"id\":1482796563,\"visibility\":true,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"#b3b3b3\",\"padding\":\"0px 15px 30px\",\"animation\":\"fadeInLeft\",\"animationduration\":500,\"animationdelay\":200,\"class\":\"\"},\"id\":1482796564,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482796565,\"settings\":{\"admin_label\":\"\",\"title\":\"Find Us\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#e0978f\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"<p>All demo content is for sample purposes only, intended to represent a live site.</p>\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1482796566,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#575151\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"32\",\"margin_bottom\":\"32\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1482796567,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"title_text_color\":\"\",\"feature_type\":\"icon\",\"title_position\":\"left\",\"feature_image\":\"\",\"peicon_name\":\"pe-7s-sun\",\"icon_name\":\"\",\"icon_size\":\"36\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_padding\":\"10\",\"icon_margin_top\":\"10\",\"icon_margin_bottom\":\"10\",\"text\":\"<blockquote style=\\\"border-left-width: 1px;\\\"><span style=\\\"color: #676767; font-weight: 200;\\\">MONDAY - FRIDAY</span><br /><strong>08:00 - 18:00</strong></blockquote>\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1482796568,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"title_text_color\":\"\",\"feature_type\":\"icon\",\"title_position\":\"left\",\"feature_image\":\"\",\"peicon_name\":\"pe-7s-moon\",\"icon_name\":\"\",\"icon_size\":\"36\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_padding\":\"10\",\"icon_margin_top\":\"10\",\"icon_margin_bottom\":\"10\",\"text\":\"<blockquote style=\\\"border-left-width: 1px;\\\"><span style=\\\"color: #676767; font-weight: 200;\\\">SATURDAY - SUNDAY</span><br /><strong>18:00 - 22:00</strong></blockquote>\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":200,\"animationduration\":500,\"animation\":\"fadeInRight\",\"padding\":\"30px 20px\",\"color\":\"#b3b3b3\",\"background\":\"\"},\"id\":1482796569,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482796570,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"<p style=\\\"font-size: 90%; margin-top: 30px;\\\">Interactively procrastinate high-payoff content without backward-compatible data. Seamlessly concept of agency has become widely used in learning research, especially in studies addressing professional and workplace learning.</p>\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1482796571,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#878787\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"32\",\"margin_bottom\":\"32\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"pie_progress\",\"title\":\"Pie Progress\",\"id\":1482796572,\"settings\":{\"admin_label\":\"\",\"percentage\":\"100\",\"size\":\"110\",\"duration\":\"4\",\"border_color\":\"#ffded9\",\"border_active_color\":\"#964f4f\",\"border_width\":\"2\",\"peicon_name\":\"pe-7s-coffee\",\"icon_name\":\"\",\"icon_color\":\"#ff9494\",\"icon_size\":\"56\",\"title\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"\",\"class\":\"\"},\"visibility\":1},{\"id\":1517224111037,\"name\":\"animated_headlines\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"effect\":\"push reset-width\",\"loading_bar\":3,\"before_text\":\"Flex is\",\"after_text\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"26\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"\",\"inset\":false},\"class\":\"\",\"sp_animated_headlines_item\":[{\"title\":\"Awesome!\",\"headline_fontstyle\":\"\",\"headline_color\":\"#f3f3f3\",\"headline_class\":\"\"},{\"title\":\"Just Great!\",\"headline_class\":\"major_color-lighten-20\"},{\"title\":\"Unique!\",\"headline_class\":\"major_color-lighten-10\"}]}}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"#9e9e9e\",\"padding\":\"0px 15px 30px\",\"animation\":\"fadeInUp\",\"animationduration\":500,\"animationdelay\":\"\",\"class\":\"centered\"},\"id\":1482796573,\"addons\":[{\"type\":\"\",\"name\":\"ajax_contact\",\"title\":\"Contact Form\",\"id\":1482796574,\"settings\":{\"admin_label\":\"\",\"title\":\"Contact Us\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#e0978f\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"styles\":\"dark\",\"recipient_email\":\"email@yourdomain.com\",\"formcaptcha\":\"0\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"button_type\":\"light\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 23, 1, -40, '2015-12-31 14:31:07', 0, '2018-10-20 10:11:51', 0, 0, '0000-00-00 00:00:00', '[]', '', '', '', '*', 0, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `attribs`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(3, 210, 'Homepage 2', '[{\"layout\":\"4,8\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"0 0 30px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"30px 0  \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":0,\"shape_name\":\"\",\"shape_color\":\"\",\"shape_width\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"shape_height\":{\"md\":\"40\",\"sm\":\"\",\"xs\":\"\"}},\"id\":1482794521,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-8\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"30px 0 30px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794522,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482794523,\"settings\":{\"admin_label\":\"\",\"title\":\"Responsive & Retina Perfect\",\"heading_selector\":\"h3\",\"title_fontsize\":\"30\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"32\",\"text\":\"Flex is clean, super flexible, responsive, includes Page Builder and comes packed with powerful options! Flex ensures that your website will be adjustable to the most popular screen resolutions, whether you watch it on laptop, tablet or phone devices, without the need for a separate layout or content. Get the sharp and crystal clear images across all devices.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482794524,\"settings\":{\"admin_label\":\"\",\"gap\":\"41\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"image\",\"title\":\"Image\",\"id\":1482794525,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/blog/iphone6-flex-1.jpg\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link_image\":\"0\",\"link_url\":\"\",\"target\":\"\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1482794526,\"settings\":{\"admin_label\":\"\",\"type\":\"sppb-progress-bar-default\",\"custom_color\":\"\",\"custom_height\":\"3\",\"progress\":\"100\",\"text\":\"\",\"text_color\":\"\",\"stripped\":\"\",\"active\":\"\",\"animation_duration\":\"3\",\"animation_delay\":\"1\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":{\"md\":\"20px 0 20px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794527,\"addons\":[{\"type\":\"content\",\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1482794528,\"settings\":{\"admin_label\":\"\",\"title\":\"Join Our Community\",\"heading_selector\":\"h3\",\"title_fontsize\":\"28\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"150\",\"position\":\"\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482794529,\"settings\":{\"admin_label\":\"\",\"gap\":\"40\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"accordion\",\"title\":\"Accordion\",\"id\":1482794530,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h4\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"style\":\"panel-flex\",\"class\":\"\",\"sp_accordion_item\":[{\"title\":\"Flexible Headers\",\"peicon_name\":\"\",\"icon\":\"fa-motorcycle\",\"content\":\"You can have classic header with navigation, centered or inline, or something more complex and place your ads and banners inside header.\"},{\"title\":\"An Exquisitely Designed\",\"peicon_name\":\"\",\"icon\":\"fa-bicycle\",\"content\":\"Flex is a vibrant design with various integrated elements to provide a seamless and versatile template environment. A visually rich template design with seamlessly integrated interactive and animated elements.\"},{\"title\":\"Well Documented\",\"peicon_name\":\"\",\"icon\":\"fa-automobile\",\"content\":\"Using powerful template\'s drag’n’drop layout builder, you can switch positions LTR or RTL (left-to-right or right-to-left).\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"background_position\":\"50% 0\",\"background_attachment\":\"inherit\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"fullscreen\":1,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"take-control\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"images/pagebuilder/backgrounds/bckg-3-bw.jpg\",\"color\":\"#ffffff\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":1,\"show_top_shape\":0,\"show_bottom_shape\":1,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":1,\"bottom_shape_name\":\"paper-torn\",\"bottom_shape_color\":\"#ffffff\",\"bottom_shape_height\":{\"md\":\"60\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_width\":{\"md\":\"280\",\"sm\":\"\",\"xs\":\"\"}},\"id\":1482794531,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"70px 100px 130px 100px\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" major_color_bckg-50\",\"items_align_center\":1,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794532,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482794533,\"settings\":{\"admin_label\":\"\",\"title\":\"Take Control of Your Website With Ease,<br />with No Coding Experience Required!\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"Flex has a set of features, options and tools make it the most versatile theme on the market by allowing you to take control of virtually every aspect and section of the site. The powerful customization options & features give you flexibility to create the site you want.\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{},\"id\":1482794534,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"40px 90px 50px 90px\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\",\"items_align_center\":1,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794535,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482794536,\"settings\":{\"admin_label\":\"\",\"title\":\"It\'s Time for Flex!\",\"heading_selector\":\"h2\",\"title_fontsize\":\"40\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"15\",\"text\":\"<em style=\\\"color: #999;\\\">Flex gives you power to create something beautiful!</em>\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"6,6\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"10px 0 20px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794537,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"0px 30px 20px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"fadeInUp\",\"animationduration\":900,\"animationdelay\":300,\"class\":\"\"},\"id\":1482794538,\"addons\":[{\"type\":\"\",\"name\":\"image\",\"title\":\"Image\",\"id\":1482794539,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/blog/Apple-MacBook-Angled_03.jpg\",\"alt_text\":\"\",\"position\":\"sppb-text-center\",\"link_image\":\"0\",\"link_url\":\"\",\"target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":{\"md\":\"40px 10px 20px 10px\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"fadeInDown\",\"animationduration\":900,\"animationdelay\":300,\"class\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794540,\"addons\":[{\"type\":\"\",\"name\":\"tab\",\"title\":\"Tabs\",\"id\":1482794541,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h4\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#808080\",\"title_margin_top\":\"30\",\"title_margin_bottom\":\"30\",\"style\":\"tabs\",\"class\":\"flex\",\"sp_tab_item\":[{\"title\":\"RESPONSIVE\",\"peicon_name\":\"\",\"icon\":\"fa-tv\",\"content\":\"Completely synergize resource sucking relationships via premier niche markets. Professionally cultivate one-to-one customer service with robust ideas. Dynamically innovate resource-leveling customer service for state of the art customer service. Objectively innovate empowered manufactured products whereas parallel platforms. Holisticly predominate extensible testing procedures.\"},{\"title\":\"VERSITALE\",\"peicon_name\":\"\",\"icon\":\"fa-clone\",\"content\":\"<img class=\\\"pull-left\\\" src=\\\"images/logos/logo@2x.png\\\" alt=\\\"flex\\\" width=\\\"150\\\" height=\\\"50\\\" /><strong>FLEX</strong> is a flexible, multi-purpose Joomla template. It is built on helix3 framework which, together with integrated page builder, incorporates predefined features and options that you can use for faster template development. You can use it for Corporate, Creative, Fashion, Photo Studio, Freelancers, Portfolio Theme, Agency, etc.\"},{\"title\":\"EXQUISITE\",\"peicon_name\":\"\",\"icon\":\"fa-expeditedssl\",\"content\":\"Globally incubate standards compliant channels before scalable benefits. Quickly disseminate superior deliverables whereas web-enabled applications. Quickly drive clicks-and-mortar catalysts for change before vertical architectures. Credibly reintermediate backend ideas for cross-platform models. Continually reintermediate integrated processes through technically ntellectual capital.\"}]},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"background_position\":\"50% 50%\",\"background_attachment\":\"inherit\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"fullscreen\":0,\"margin\":{\"md\":\"20px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"70px 30px 70px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"#913030\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":1,\"show_bottom_shape\":1,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"shape_flip\":0,\"shape_invert\":0,\"shape_to_front\":1,\"shape_name\":\"slope-opacity\",\"shape_width\":{\"md\":\"160\",\"sm\":\"\",\"xs\":\"\"},\"shape_height\":{\"md\":\"40\",\"sm\":\"\",\"xs\":\"\"},\"shape_color\":\"#ffffff\",\"bottom_shape_flip\":0,\"bottom_shape_invert\":0,\"bottom_shape_to_front\":1,\"bottom_shape_name\":\"slope-opacity\",\"bottom_shape_width\":{\"md\":\"140\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_height\":{\"md\":\"40\",\"sm\":\"\",\"xs\":\"\"},\"bottom_shape_color\":\"#ffffff\"},\"id\":1482794542,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1482794543,\"addons\":[{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1482794544,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#a65a5a\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"30\",\"margin_bottom\":\"30\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"5px\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1482794545,\"addons\":[{\"type\":\"\",\"name\":\"modal\",\"title\":\"Modal Popup\",\"id\":1482794546,\"settings\":{\"admin_label\":\"\",\"modal_selector\":\"button\",\"button_text\":\"GET STARTED!\",\"button_size\":\"lg\",\"button_type\":\"light\",\"button_peicon\":\"\",\"button_icon\":\"\",\"button_block\":\"\",\"selector_image\":\"\",\"peicon_name\":\"\",\"selector_icon_name\":\"\",\"selector_icon_size\":\"36\",\"selector_icon_color\":\"\",\"selector_icon_background\":\"\",\"selector_icon_border_color\":\"\",\"selector_icon_border_width\":\"\",\"selector_icon_border_radius\":\"\",\"selector_icon_padding\":\"\",\"selector_margin_top\":\"\",\"selector_margin_bottom\":\"\",\"alignment\":\"sppb-text-center\",\"modal_unique_id\":\"mymodal\",\"modal_content_type\":\"image\",\"modal_content_text\":\"\",\"modal_content_image\":\"images/blog/iphone6-flex-1.jpg\",\"modal_content_video_url\":\"\",\"modal_popup_width\":\"800\",\"modal_popup_height\":\"440\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{},\"id\":1482794547,\"addons\":[{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1482794548,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#a65a5a\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"30\",\"margin_bottom\":\"30\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"40px 0 60px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"images/svg/section-background-stripes.svg\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794549,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"20px 0\",\"color\":\"\",\"background\":\"\"},\"id\":1482794550,\"addons\":[{\"type\":\"\",\"name\":\"pie_progress\",\"title\":\"Pie Progress\",\"id\":1482794551,\"settings\":{\"admin_label\":\"\",\"percentage\":\"30\",\"size\":\"110\",\"duration\":\"2\",\"border_color\":\"#f5f5f5\",\"border_active_color\":\"#6798bd\",\"border_width\":\"5\",\"peicon_name\":\"\",\"icon_name\":\"fa-comments-o\",\"icon_color\":\"#6798bd\",\"icon_size\":\"35\",\"title\":\"1. MEETING\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"text\":\"<p>Agency has become a topic to an audienceused in learning research in studies addressing professional.</p>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"20px 0\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1482794552,\"addons\":[{\"type\":\"\",\"name\":\"pie_progress\",\"title\":\"Pie Progress\",\"id\":1482794553,\"settings\":{\"admin_label\":\"\",\"percentage\":\"44\",\"size\":\"110\",\"duration\":\"3\",\"border_color\":\"#f5f5f5\",\"border_active_color\":\"#cea96c\",\"border_width\":\"5\",\"peicon_name\":\"\",\"icon_name\":\"fa-briefcase\",\"icon_color\":\"#cea96c\",\"icon_size\":\"32\",\"title\":\"2. PLANNING\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"text\":\"<p>The suggested conceptualization of seven conceptualizations of professional agency at work.</p>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"20px 0\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1482794554,\"addons\":[{\"type\":\"\",\"name\":\"pie_progress\",\"title\":\"Pie Progress\",\"id\":1482794555,\"settings\":{\"admin_label\":\"\",\"percentage\":\"67\",\"size\":\"110\",\"duration\":\"4\",\"border_color\":\"#f5f5f5\",\"border_active_color\":\"#b7c289\",\"border_width\":\"5\",\"peicon_name\":\"\",\"icon_name\":\"fa-puzzle-piece\",\"icon_color\":\"#b7c289\",\"icon_size\":\"35\",\"title\":\"3. TESTING\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"text\":\"<p>Data computing is a computing term or metaphor that is based on utility of computer resources.</p>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"20px 0\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1482794556,\"addons\":[{\"type\":\"\",\"name\":\"pie_progress\",\"title\":\"Pie Progress\",\"id\":1482794557,\"settings\":{\"admin_label\":\"\",\"percentage\":\"88\",\"size\":\"110\",\"duration\":\"5\",\"border_color\":\"#f5f5f5\",\"border_active_color\":\"#e6685c\",\"border_width\":\"5\",\"peicon_name\":\"\",\"icon_name\":\"fa-diamond\",\"icon_color\":\"#e6685c\",\"icon_size\":\"32\",\"title\":\"4. DELIVERY\",\"title_margin_top\":\"20\",\"title_margin_bottom\":\"20\",\"text\":\"<p>An approach to web design a technique aimed at crafting an optimal viewing experience.</p>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"8,4\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"images/pagebuilder/backgrounds/bckg-5-bw.jpg\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"40px\",\"margin\":\"\",\"fullscreen\":0},\"id\":1482794558,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-8\",\"settings\":{\"class\":\"\",\"animationdelay\":400,\"animationduration\":1100,\"animation\":\"fadeInDown\",\"padding\":{\"md\":\"20px 15px 15px 15px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794559,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482794560,\"settings\":{\"admin_label\":\"\",\"title\":\"Pretty Nice Stuff, Anything Else You Got?\",\"heading_selector\":\"h4\",\"title_fontsize\":\"36\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4 active-column-parent\",\"settings\":{\"class\":\"\",\"animationdelay\":300,\"animationduration\":700,\"animation\":\"\",\"padding\":{\"md\":\"25px 5px 25px 5px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794561,\"addons\":[{\"type\":\"\",\"name\":\"modal\",\"title\":\"Modal Popup\",\"id\":1482794562,\"settings\":{\"admin_label\":\"\",\"modal_selector\":\"button\",\"button_text\":\"Click Here to Find Out!\",\"button_size\":\"lg\",\"button_type\":\"dark\",\"button_peicon\":\"\",\"button_icon\":\"\",\"button_block\":\"\",\"selector_image\":\"\",\"peicon_name\":\"\",\"selector_icon_name\":\"\",\"selector_icon_size\":\"36\",\"selector_icon_color\":\"\",\"selector_icon_background\":\"\",\"selector_icon_border_color\":\"\",\"selector_icon_border_width\":\"\",\"selector_icon_border_radius\":\"\",\"selector_icon_padding\":\"\",\"selector_margin_top\":\"\",\"selector_margin_bottom\":\"\",\"alignment\":\"sppb-text-center\",\"modal_unique_id\":\"flexmodal\",\"modal_content_type\":\"text\",\"modal_content_text\":\"<img class=\\\"pull-left\\\" src=\\\"images/logos/logo@2x.png\\\" alt=\\\"\\\" width=\\\"150\\\" height=\\\"50\\\" />Flex is clean, super flexible, responsive, includes Page Builder and comes packed with powerful options! Flex ensures that your website will be adjustable to the most popular screen resolutions, whether you watch it on laptop, tablet or phone devices, without the need for a separate layout or content. Get the sharp and crystal clear images across all devices.\",\"modal_content_image\":\"\",\"modal_content_video_url\":\"https://www.youtube.com/watch?v=QuEfo0n0VX8\",\"modal_popup_width\":\"760\",\"modal_popup_height\":\"440\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":\"50px 0 0 0\",\"padding\":\"0px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"images/svg/section-background-stripes.svg\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"id\":1482794563,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0,\"background_type\":\"none\"},\"id\":1482794564,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482794565,\"settings\":{\"admin_label\":\"\",\"title\":\"Our Amazing Team Produces Results\",\"heading_selector\":\"h2\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#707070\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"5,2,5\",\"settings\":{},\"id\":1482794566,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-5\",\"settings\":{},\"id\":1482794567,\"addons\":[],\"visibility\":1},{\"class_name\":\"col-sm-2\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":{\"md\":\"5px 30px 5px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":1,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794568,\"addons\":[{\"type\":\"\",\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1482794569,\"settings\":{\"admin_label\":\"\",\"type\":\"sppb-progress-bar-default\",\"custom_color\":\"\",\"custom_height\":\"2\",\"progress\":\"100\",\"text\":\"\",\"text_color\":\"\",\"stripped\":\"\",\"active\":\"\",\"animation_duration\":\"3\",\"animation_delay\":\"1\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-5\",\"settings\":{},\"id\":1482794570,\"addons\":[],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"sortable.preventclickevent\":1,\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"30px 0 20px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_parallax\":0,\"background_video\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794571,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":300,\"animationduration\":\"\",\"animation\":\"fadeInUp\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1482794572,\"addons\":[{\"type\":\"\",\"name\":\"person\",\"title\":\"Person\",\"id\":1482794573,\"settings\":{\"admin_label\":\"\",\"type\":\"default\",\"image\":\"images/pagebuilder/our-team/person6.jpg\",\"name\":\"John C. Teflon\",\"designation\":\"/ Super Admin & Boss /\",\"introtext\":\"Teflon while the lovely valley teems with trickling stream.\",\"facebook\":\"http://aplikko.com\",\"twitter\":\"#\",\"google_plus\":\"#\",\"youtube\":\"#\",\"linkedin\":\"#\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482794574,\"settings\":{\"admin_label\":\"\",\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":\"\",\"animationdelay\":600,\"class\":\"\"},\"id\":1482794575,\"addons\":[{\"type\":\"\",\"name\":\"person\",\"title\":\"Person\",\"id\":1482794576,\"settings\":{\"admin_label\":\"\",\"type\":\"default\",\"image\":\"images/pagebuilder/our-team/person2.jpg\",\"name\":\"Joanna Betton\",\"designation\":\"/ Senior Manager & Brainstormer /\",\"introtext\":\"Betton with her grace valley likeness life midst good.\",\"facebook\":\"#\",\"twitter\":\"#\",\"google_plus\":\"#\",\"youtube\":\"\",\"linkedin\":\"#\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482794577,\"settings\":{\"admin_label\":\"\",\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInUp\",\"animationduration\":\"\",\"animationdelay\":900,\"class\":\"\"},\"id\":1482794578,\"addons\":[{\"type\":\"\",\"name\":\"person\",\"title\":\"Person\",\"id\":1482794579,\"settings\":{\"admin_label\":\"\",\"type\":\"default\",\"image\":\"images/pagebuilder/our-team/person1.jpg\",\"name\":\"John Plafon\",\"designation\":\"/ Senior Developer & Author /\",\"introtext\":\"Plafon under seasons for over he forth upon multiply.\",\"facebook\":\"#\",\"twitter\":\"#\",\"google_plus\":\"#\",\"youtube\":\"\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"#\",\"dribbble\":\"\",\"behance\":\"#\",\"instagram\":\"\",\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482794580,\"settings\":{\"admin_label\":\"\",\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":1200,\"animationduration\":\"\",\"animation\":\"fadeInDown\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1482794581,\"addons\":[{\"type\":\"\",\"name\":\"person\",\"title\":\"Person\",\"id\":1482794582,\"settings\":{\"admin_label\":\"\",\"type\":\"default\",\"image\":\"images/pagebuilder/our-team/person3.jpg\",\"name\":\"Gloria Xenofon\",\"designation\":\"/ PR Manager & Instructor /\",\"introtext\":\"Xenofon years from good after every so blessed.\",\"facebook\":\"#\",\"twitter\":\"#\",\"google_plus\":\"\",\"youtube\":\"\",\"linkedin\":\"\",\"pinterest\":\"#\",\"flickr\":\"#\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"#\",\"social_position\":\"after\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482794583,\"settings\":{\"admin_label\":\"\",\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{},\"id\":1482794584,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1482794585,\"addons\":[{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1482794586,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#eeeeee\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"10\",\"margin_bottom\":\"10\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{},\"id\":1482794587,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1482794588,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482794589,\"settings\":{\"admin_label\":\"\",\"title\":\"PRICING\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"0\",\"text\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"10px\",\"margin\":0,\"fullscreen\":0},\"id\":1482794590,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":500,\"animationduration\":500,\"animation\":\"fadeInUp\",\"padding\":{\"md\":\"20px 10px 20px 10px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794591,\"addons\":[{\"type\":\"\",\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1482794592,\"settings\":{\"admin_label\":\"\",\"title\":\"PERSONAL\",\"price\":\"29\",\"currency\":\"$\",\"duration\":\"/Month\",\"pricing_content\":\"<strong>Superb for personal use</strong>\\n10 Users\\n20 GB Storage\\n<a href=\\\"#_\\\" data-toggle=\\\"tooltip\\\" data-placement=\\\"top\\\" title=\\\"Where it came from it would have been rewritten a thousand times and everything that was left\\\">Limited Functionality</a>\\n256-bit SSL security\\n7/7 Support\",\"button_text\":\"SIGN UP\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"peicon_name\":\"\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"header_color\":\"#f14833\",\"features_color\":\"\",\"border_radius\":\"5\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":800,\"animationduration\":500,\"animation\":\"fadeInUp\",\"padding\":{\"md\":\"20px 10px 20px 10px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794593,\"addons\":[{\"type\":\"\",\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1482794594,\"settings\":{\"admin_label\":\"\",\"title\":\"BUSINESS\",\"price\":\"59\",\"currency\":\"$\",\"duration\":\"/Month\",\"pricing_content\":\"<strong>Superb for small business</strong>\\n20 Users\\n50 GB Storage\\n<a href=\\\"#_\\\" data-toggle=\\\"tooltip\\\" data-placement=\\\"top\\\" title=\\\"Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.\\\">Full Functionality</a>\\n256-bit SSL security\\n14/7 Support\",\"button_text\":\"SIGN UP\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"primary\",\"peicon_name\":\"\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"\",\"header_color\":\"\",\"features_color\":\"\",\"border_radius\":\"5\",\"featured\":\"sppb-pricing-featured\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":1100,\"animationduration\":500,\"animation\":\"fadeInUp\",\"padding\":{\"md\":\"20px 10px 20px 10px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"\",\"background\":\"\",\"items_align_center\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794595,\"addons\":[{\"type\":\"\",\"name\":\"pricing\",\"title\":\"Pricing Table\",\"id\":1482794596,\"settings\":{\"admin_label\":\"\",\"title\":\"ENTERPRISE\",\"price\":\"89\",\"currency\":\"$\",\"duration\":\"/Month\",\"pricing_content\":\"<strong>Superb for enterprise solution</strong>\\n120 Users\\n2 TB Storage\\n<a href=\\\"#_\\\" data-toggle=\\\"tooltip\\\" data-placement=\\\"top\\\" title=\\\"Longe and Parole and dragged her into their agency\\\">Full Functionality</a>\\n256-bit SSL security\\n24/7 Support\",\"button_text\":\"SIGN UP\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"peicon_name\":\"\",\"button_icon\":\"\",\"button_block\":\"\",\"background\":\"#f7f7f7\",\"header_color\":\"\",\"features_color\":\"\",\"border_radius\":\"5\",\"featured\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"20px 0 0 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"70px 30px 70px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"images/svg/section-background-stripes.svg\",\"color\":\"\",\"background_color\":\"#913030\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"columns_align_center\":0,\"no_gutter\":0,\"background_parallax\":0,\"show_top_shape\":0,\"show_bottom_shape\":0,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794597,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1482794598,\"addons\":[{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1482794599,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#a65a5a\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"30\",\"margin_bottom\":\"30\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1482794600,\"addons\":[{\"type\":\"\",\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1482794601,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<p style=\\\"text-align:center;margin:5px auto 0;\\\"><a href=\\\"#take-control\\\" style=\\\"padding:12px 50px;font-size:135%;text-align:center;margin:0 auto;float:none;\\\" class=\\\"btn btn-light responsive page-scroll\\\">FLEX IT NOW!</a></p>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{},\"id\":1482794602,\"addons\":[{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1482794603,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#a65a5a\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"30\",\"margin_bottom\":\"30\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"5,7\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"50px 20px\",\"margin\":\"\",\"fullscreen\":0},\"id\":1482794604,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-5\",\"settings\":{\"class\":\"\",\"animationdelay\":600,\"animationduration\":\"\",\"animation\":\"fadeInRight\",\"padding\":\"0 0 20px\",\"color\":\"\",\"background\":\"\"},\"id\":1482794605,\"addons\":[{\"type\":\"\",\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1482794606,\"settings\":{\"admin_label\":\"\",\"title\":\"Some Highlights\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"html\":\"<p>Flex is an exquisitely designed template with Helix3 framework. Easy to style, configure and customize through an advanced, user friendly and modern interface.</p>\\n<br />\\n<ul style=\\\"padding-left:30px\\\" class=\\\"site-list\\\">\\n<li><i class=\\\"fa fa-check\\\"></i>100% Fully responsive layout</li>\\n<li><i class=\\\"fa fa-check\\\"></i>Article Post Formats</li>\\n<li><i class=\\\"fa fa-check\\\"></i>Drag and Drop Page Builder</li>\\n<li><i class=\\\"fa fa-check\\\"></i>Awesome Portfolio</li>\\n<li><i class=\\\"fa fa-check\\\"></i>AP Smart LayerSlider</li>\\n<li><i class=\\\"fa fa-check\\\"></i>Image Lightbox</li>\\n<li><i class=\\\"fa fa-check\\\"></i>Slick Slider</li>\\n</ul>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-7\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"20px\",\"animation\":\"fadeIn\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1482794607,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482794608,\"settings\":{\"admin_label\":\"\",\"title\":\"Our Skills\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"40\",\"text\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1482794609,\"settings\":{\"admin_label\":\"\",\"type\":\"sppb-progress-bar-default\",\"custom_color\":\"#ff6b6b\",\"custom_height\":\"25\",\"progress\":\"90\",\"text\":\"Powerful Admin\",\"text_color\":\"\",\"stripped\":\"\",\"active\":\"\",\"animation_duration\":\"2\",\"animation_delay\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482794610,\"settings\":{\"admin_label\":\"\",\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1482794611,\"settings\":{\"admin_label\":\"\",\"type\":\"sppb-progress-bar-default\",\"custom_color\":\"#ff4f4f\",\"custom_height\":\"25\",\"progress\":\"64\",\"text\":\"Built-in Animation\",\"text_color\":\"\",\"stripped\":\"\",\"active\":\"\",\"animation_duration\":\"2\",\"animation_delay\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1482794612,\"settings\":{\"admin_label\":\"\",\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1482794613,\"settings\":{\"admin_label\":\"\",\"type\":\"sppb-progress-bar-default\",\"custom_color\":\"#e02020\",\"custom_height\":\"25\",\"progress\":\"55\",\"text\":\"Parallax Effect\",\"text_color\":\"\",\"stripped\":\"\",\"active\":\"\",\"animation_duration\":\"2\",\"animation_delay\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1482794614,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#eeeeee\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"30\",\"margin_bottom\":\"20\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1482794615,\"settings\":{\"admin_label\":\"\",\"type\":\"flex\",\"custom_color\":\"#bbd162\",\"custom_height\":\"20\",\"progress\":\"81\",\"text\":\"User Friendly\",\"text_color\":\"\",\"stripped\":\"sppb-progress-bar-striped\",\"active\":\"active\",\"animation_duration\":\"2\",\"animation_delay\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1482794616,\"settings\":{\"admin_label\":\"\",\"type\":\"flex\",\"custom_color\":\"#c7ab4d\",\"custom_height\":\"20\",\"progress\":\"86\",\"text\":\"HTML Skills\",\"text_color\":\"\",\"stripped\":\"sppb-progress-bar-striped\",\"active\":\"active\",\"animation_duration\":\"2\",\"animation_delay\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1482794617,\"settings\":{\"admin_label\":\"\",\"type\":\"flex\",\"custom_color\":\"#f58b27\",\"custom_height\":\"20\",\"progress\":\"93\",\"text\":\"Joomla Development\",\"text_color\":\"\",\"stripped\":\"sppb-progress-bar-striped\",\"active\":\"active\",\"animation_duration\":\"2\",\"animation_delay\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"#303030\",\"color\":\"#ffffff\",\"background_image\":\"images/svg/section-background-stripes.svg\",\"background_repeat\":\"repeat\",\"background_size\":\"inherit\",\"background_attachment\":\"inherit\",\"background_position\":\"50% 50%\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"0px\",\"fullscreen\":0},\"id\":1482794618,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":{\"md\":\"40px 100px 50px 100px\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#b8b8b8\",\"background\":\"\",\"items_align_center\":1,\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0},\"id\":1482794619,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482794620,\"settings\":{\"admin_label\":\"\",\"title\":\"FEATURED STORY\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#e0978f\",\"title_margin_top\":\"10\",\"title_margin_bottom\":\"30\",\"text\":\"Flex is an ideal platform for users of all levels, whether beginners or web professionals. The administrative interface is both simple to use, intuitive and highly flexible, allowing for swift and extensive changes. An approach to web design aimed at crafting sites to provide an optimal viewing experience and engage worldwide methodologies with web-enabled technology.\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,6,3\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"#404040\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"0px\",\"fullscreen\":1},\"id\":1482794621,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1482794622,\"addons\":[],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{},\"id\":1482794623,\"addons\":[{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1482794624,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"2\",\"border_color\":\"#a85858\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"0\",\"margin_bottom\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1482794625,\"addons\":[],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"fullscreen\":0,\"margin\":\"0px\",\"padding\":\"40px 20px 50px\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"50% 50%\",\"background_attachment\":\"inherit\",\"background_size\":\"contain\",\"background_repeat\":\"inherit\",\"background_image\":\"images/svg/section-background-stripes2.svg\",\"color\":\"\",\"background_color\":\"#363839\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":0,\"title_margin_top\":0,\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"heading_selector\":\"h3\",\"title\":\"\"},\"id\":1482794626,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"#b3b3b3\",\"padding\":\"\",\"animation\":\"fadeInLeft\",\"animationduration\":500,\"animationdelay\":200,\"class\":\"\"},\"id\":1482794627,\"addons\":[{\"type\":\"\",\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1482794628,\"settings\":{\"admin_label\":\"\",\"title\":\"Our Concept\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#e0978f\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"text\":\"<p>Interactively procrastinate high-payoff content without backward-compatible data. Seamlessly concept of agency has become widely used in learning research, especially in studies addressing professional and workplace learning.</p>\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1482794629,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#737373\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"32\",\"margin_bottom\":\"32\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"flickr\",\"title\":\"Flickr Gallery\",\"id\":1482794630,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"separator_addon_options\":\"\",\"id\":\"37651393@N04\",\"count\":\"10\",\"thumb_per_row\":\"5\",\"height\":\"\",\"class\":\"\",\"global_options\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_boxshadow\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"#9e9e9e\",\"padding\":\"\",\"animation\":\"fadeInUp\",\"animationduration\":500,\"animationdelay\":\"\",\"class\":\"centered\"},\"id\":1482794631,\"addons\":[{\"type\":\"\",\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1482794632,\"settings\":{\"admin_label\":\"\",\"title\":\"Popular Tags\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"#e0978f\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"30\",\"module_type\":\"module\",\"id\":\"98\",\"position\":\"\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"divider\",\"title\":\"Divider\",\"id\":1482794633,\"settings\":{\"admin_label\":\"\",\"divider_type\":\"border\",\"divider_image\":\"\",\"background_repeat\":\"no-repeat\",\"divider_height\":\"10\",\"border_color\":\"#737373\",\"border_style\":\"solid\",\"border_width\":\"1\",\"margin_top\":\"30\",\"margin_bottom\":\"30\",\"class\":\"\"},\"visibility\":1},{\"type\":\"content\",\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1482794634,\"settings\":{\"admin_label\":\"\",\"title\":\"Flex it Now!\",\"heading_selector\":\"h4\",\"title_position\":\"left\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"peicon_name\":\"pe-7s-way\",\"icon_name\":\"\",\"icon_size\":\"65\",\"icon_color\":\"#ff8a8a\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"-3\",\"icon_margin_bottom\":\"32\",\"icon_padding\":\"3\",\"text\":\"\\t\\tReintermediate superior methodologies&nbsp;best.\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1},{\"type\":\"\",\"name\":\"button\",\"title\":\"Button\",\"id\":1482794635,\"settings\":{\"admin_label\":\"\",\"text\":\"Download Now!\",\"fontstyle\":null,\"letterspace\":\"0\",\"url\":\"#take-control\",\"target\":\"\",\"type\":\"default\",\"alignment\":\"sppb-text-center\",\"appearance\":\"\",\"background_color\":\"#444444\",\"color\":\"#ffffff\",\"background_color_hover\":\"#222222\",\"color_hover\":\"#ffffff\",\"size\":\"lg\",\"shape\":\"rounded\",\"block\":\"\",\"button_peicon\":\"pe-7s-cloud-uplo